/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.printing.Printer;
import dotty.tools.dotc.printing.Showable;
import dotty.tools.dotc.printing.Texts;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition$;
import dotty.tools.dotc.util.Spans;
import dotty.tools.dotc.util.Spans$Span$;
import dotty.tools.dotc.util.SrcPos;
import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.hashing.MurmurHash3$;

public class SourcePosition
implements SrcPos,
dotty.tools.dotc.interfaces.SourcePosition,
Showable,
Product,
Serializable {
    private final SourceFile source;
    private final long span;
    private final SourcePosition outer;

    public static SourcePosition apply(SourceFile sourceFile, long l, SourcePosition sourcePosition) {
        return SourcePosition$.MODULE$.apply(sourceFile, l, sourcePosition);
    }

    public static SourcePosition fromProduct(Product product) {
        return SourcePosition$.MODULE$.fromProduct(product);
    }

    public static SourcePosition unapply(SourcePosition sourcePosition) {
        return SourcePosition$.MODULE$.unapply(sourcePosition);
    }

    public static SourcePosition $lessinit$greater$default$3() {
        return SourcePosition$.MODULE$.$lessinit$greater$default$3();
    }

    public SourcePosition(SourceFile source, long span, SourcePosition outer) {
        this.source = source;
        this.span = span;
        this.outer = outer;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash(this, -904377970, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        SourcePosition sourcePosition;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SourcePosition)) return false;
        SourcePosition sourcePosition2 = sourcePosition = (SourcePosition)object;
        SourceFile sourceFile = this.source();
        SourceFile sourceFile2 = sourcePosition2.source();
        if (sourceFile == null) {
            if (sourceFile2 != null) {
                return false;
            }
        } else if (!((Object)sourceFile).equals(sourceFile2)) return false;
        if (!Spans$Span$.MODULE$.$eq$eq$extension(this.span(), sourcePosition2.span())) return false;
        SourcePosition sourcePosition3 = this.outer();
        SourcePosition sourcePosition4 = sourcePosition2.outer();
        if (sourcePosition3 == null) {
            if (sourcePosition4 != null) {
                return false;
            }
        } else if (!((Object)sourcePosition3).equals(sourcePosition4)) return false;
        if (!sourcePosition2.canEqual(this)) return false;
        return true;
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof SourcePosition;
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public String productPrefix() {
        return "SourcePosition";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return new Spans.Span(this._2());
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "source";
            }
            case 1: {
                return "span";
            }
            case 2: {
                return "outer";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public SourceFile source() {
        return this.source;
    }

    @Override
    public long span() {
        return this.span;
    }

    public SourcePosition outer() {
        return this.outer;
    }

    @Override
    public SourcePosition sourcePos(Contexts.Context x$1) {
        return this;
    }

    public boolean contains(SourcePosition that) {
        SourceFile sourceFile = this.source();
        SourceFile sourceFile2 = that.source();
        return !(sourceFile != null ? !((Object)sourceFile).equals(sourceFile2) : sourceFile2 != null) && Spans$Span$.MODULE$.contains$extension(this.span(), that.span());
    }

    public boolean exists() {
        return Spans$Span$.MODULE$.exists$extension(this.span());
    }

    @Override
    public String lineContent() {
        return this.source().lineContent(this.point());
    }

    @Override
    public int point() {
        return Spans$Span$.MODULE$.point$extension(this.span());
    }

    @Override
    public int line() {
        return this.source().offsetToLine(this.point());
    }

    public char[] linesSlice() {
        Object object = Predef$.MODULE$.charArrayOps(this.source().content());
        return (char[])ArrayOps$.MODULE$.slice$extension(object, this.source().startOfLine(this.start()), this.source().nextLine(this.end()));
    }

    public Range lines() {
        int endOffset;
        int startOffset = this.source().offsetToLine(this.start());
        if (startOffset >= (endOffset = this.source().offsetToLine(this.end() - 1))) {
            return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.line()), this.line());
        }
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(startOffset), endOffset);
    }

    public List<Object> lineOffsets() {
        return this.lines().toList().map(_$1 -> this.source().lineToOffset(_$1));
    }

    public Tuple2<List<Object>, List<Object>> beforeAndAfterPoint() {
        return this.lineOffsets().partition(_$2 -> _$2 <= this.point());
    }

    @Override
    public int column() {
        return this.source().column(this.point());
    }

    @Override
    public int start() {
        return Spans$Span$.MODULE$.start$extension(this.span());
    }

    @Override
    public int startLine() {
        return this.source().offsetToLine(this.start());
    }

    @Override
    public int startColumn() {
        return this.source().column(this.start());
    }

    public String startColumnPadding() {
        return this.source().startColumnPadding(this.start());
    }

    @Override
    public int end() {
        return Spans$Span$.MODULE$.end$extension(this.span());
    }

    @Override
    public int endLine() {
        return this.source().offsetToLine(this.end());
    }

    @Override
    public int endColumn() {
        return this.source().column(this.end());
    }

    public SourcePosition withOuter(SourcePosition outer) {
        return SourcePosition$.MODULE$.apply(this.source(), this.span(), outer);
    }

    public SourcePosition withSpan(long range) {
        return SourcePosition$.MODULE$.apply(this.source(), range, this.outer());
    }

    public SourcePosition startPos() {
        return this.withSpan(Spans$Span$.MODULE$.startPos$extension(this.span()));
    }

    public SourcePosition endPos() {
        return this.withSpan(Spans$Span$.MODULE$.endPos$extension(this.span()));
    }

    public SourcePosition focus() {
        return this.withSpan(Spans$Span$.MODULE$.focus$extension(this.span()));
    }

    public SourcePosition toSynthetic() {
        return this.withSpan(Spans$Span$.MODULE$.toSynthetic$extension(this.span()));
    }

    public SourcePosition outermost() {
        block3: {
            block2: {
                if (this.outer() == null) break block2;
                SourcePosition sourcePosition = this.outer();
                NoSourcePosition$ noSourcePosition$ = NoSourcePosition$.MODULE$;
                if (sourcePosition != null ? !((Object)sourcePosition).equals(noSourcePosition$) : noSourcePosition$ != null) break block3;
            }
            return this;
        }
        return this.outer().outermost();
    }

    public SourcePosition nonInlined() {
        SourcePosition om = this.outermost();
        return SourcePosition.rec$1(om, this);
    }

    public String toString() {
        return new StringBuilder(1).append(this.source().exists() ? this.source().file().toString() : "(no source)").append(":").append(new Spans.Span(this.span())).toString();
    }

    @Override
    public Texts.Text toText(Printer printer) {
        return printer.toText(this);
    }

    public SourcePosition copy(SourceFile source, long span, SourcePosition outer) {
        return new SourcePosition(source, span, outer);
    }

    public SourceFile copy$default$1() {
        return this.source();
    }

    public long copy$default$2() {
        return this.span();
    }

    public SourcePosition copy$default$3() {
        return this.outer();
    }

    public SourceFile _1() {
        return this.source();
    }

    public long _2() {
        return this.span();
    }

    public SourcePosition _3() {
        return this.outer();
    }

    private static final SourcePosition rec$1(SourcePosition om$1, SourcePosition self) {
        while (!om$1.contains(self)) {
            self = self.outer();
        }
        return self;
    }
}

