/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.AbstractFile$;
import dotty.tools.io.File;
import dotty.tools.io.FileExtension;
import dotty.tools.io.Path;
import dotty.tools.io.Path$;
import dotty.tools.io.PlainFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import scala.Char$;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public abstract class AbstractFile
implements Iterable<AbstractFile> {
    private final FileExtension ext;

    public static AbstractFile getDirectory(java.nio.file.Path path2) {
        return AbstractFile$.MODULE$.getDirectory(path2);
    }

    public static AbstractFile getDirectory(Path path2) {
        return AbstractFile$.MODULE$.getDirectory(path2);
    }

    public static AbstractFile getDirectory(String string2) {
        return AbstractFile$.MODULE$.getDirectory(string2);
    }

    public static AbstractFile getFile(java.nio.file.Path path2) {
        return AbstractFile$.MODULE$.getFile(path2);
    }

    public static AbstractFile getFile(Path path2) {
        return AbstractFile$.MODULE$.getFile(path2);
    }

    public static AbstractFile getFile(String string2) {
        return AbstractFile$.MODULE$.getFile(string2);
    }

    public static AbstractFile getResources(URL uRL) {
        return AbstractFile$.MODULE$.getResources(uRL);
    }

    public static AbstractFile getURL(URL uRL) {
        return AbstractFile$.MODULE$.getURL(uRL);
    }

    public AbstractFile() {
        IterableOnce.$init$(this);
        IterableOnceOps.$init$(this);
        IterableOps.$init$(this);
        IterableFactoryDefaults.$init$(this);
        Iterable.$init$(this);
        this.ext = Path$.MODULE$.fileExtension(this.name());
    }

    public abstract String name();

    public abstract String path();

    public String absolutePath() {
        return this.path();
    }

    public String canonicalPath() {
        if (this.jpath() == null) {
            return this.path();
        }
        return this.jpath().normalize().toString();
    }

    public boolean hasExtension(String other) {
        return this.ext().toLowerCase().equalsIgnoreCase(other);
    }

    public FileExtension ext() {
        return this.ext;
    }

    public String extension() {
        return this.ext().toLowerCase();
    }

    public abstract AbstractFile absolute();

    public abstract AbstractFile container();

    public java.io.File file() {
        java.io.File file;
        block3: {
            try {
                if (this.jpath() == null) {
                    file = null;
                    break block3;
                }
                file = this.jpath().toFile();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                file = null;
            }
        }
        return file;
    }

    public abstract java.nio.file.Path jpath();

    public Option<AbstractFile> underlyingSource() {
        return None$.MODULE$;
    }

    public boolean exists() {
        return this.jpath() == null || Files.exists(this.jpath(), new LinkOption[0]);
    }

    public boolean isClassContainer() {
        return this.isDirectory() || this.jpath() != null && this.ext().isJarOrZip();
    }

    public abstract boolean isDirectory();

    public boolean isVirtual() {
        return false;
    }

    public abstract long lastModified();

    public abstract InputStream input();

    public abstract OutputStream output();

    public BufferedOutputStream bufferedOutput() {
        return new BufferedOutputStream(this.output());
    }

    public Option<Object> sizeOption() {
        return None$.MODULE$;
    }

    public URL toURL() {
        if (this.jpath() == null) {
            return null;
        }
        return this.jpath().toUri().toURL();
    }

    public char[] toCharArray() throws IOException {
        return new String(this.toByteArray()).toCharArray();
    }

    public byte[] toByteArray() throws IOException {
        InputStream in = this.input();
        Option<Object> option = this.sizeOption();
        if (option instanceof Some) {
            int size;
            int res;
            int rest;
            Some some = (Some)option;
            byte[] arr = new byte[rest];
            for (rest = size = BoxesRunTime.unboxToInt(some.value()); rest > 0; rest -= res) {
                res = in.read(arr, arr.length - rest, rest);
                if (res != -1) continue;
                throw new IOException("read error");
            }
            in.close();
            return arr;
        }
        if (None$.MODULE$.equals(option)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = in.read();
            while (c != -1) {
                out.write(c);
                c = in.read();
            }
            in.close();
            return out.toByteArray();
        }
        throw new MatchError(option);
    }

    @Override
    public abstract Iterator<AbstractFile> iterator();

    public final AbstractFile lookupPath(Seq<String> parts, boolean directory) {
        int i;
        AbstractFile file = this;
        int n = parts.length() - 1;
        for (i = 0; file != null && i < n; file = file.lookupName((String)parts.apply(i), true), ++i) {
        }
        if (file == null) {
            return null;
        }
        return file.lookupName((String)parts.apply(i), directory);
    }

    public abstract AbstractFile lookupName(String var1, boolean var2);

    public abstract AbstractFile lookupNameUnchecked(String var1, boolean var2);

    public AbstractFile lookupPathUnchecked(String path2, boolean directory) {
        return this.lookup((Function3<AbstractFile, String, Object, AbstractFile>)(Function3<Object, Object, Object, AbstractFile> & Serializable)(f, p, dir) -> ((AbstractFile)f).lookupNameUnchecked((String)p, BoxesRunTime.unboxToBoolean(dir)), path2, directory);
    }

    private AbstractFile lookup(Function3<AbstractFile, String, Object, AbstractFile> getFile, String path0, boolean directory) {
        char separator = java.io.File.separatorChar;
        String path2 = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(path0)) == separator ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(path0), 1) : path0;
        int length = path2.length();
        if (length <= 0 || StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(path2)) == separator) {
            throw Scala3RunTime$.MODULE$.assertFailed(path2);
        }
        AbstractFile file = this;
        int start = 0;
        while (true) {
            int index = path2.indexOf(Char$.MODULE$.char2int(separator), start);
            if (index >= 0 && start >= index) {
                throw Scala3RunTime$.MODULE$.assertFailed(Tuple4$.MODULE$.apply(path2, BoxesRunTime.boxToBoolean(directory), BoxesRunTime.boxToInteger(start), BoxesRunTime.boxToInteger(index)));
            }
            String name = path2.substring(start, index < 0 ? length : index);
            if ((file = getFile.apply(file, name, index < 0 ? BoxesRunTime.boxToBoolean(directory) : BoxesRunTime.boxToBoolean(true))) == null || index < 0) {
                return file;
            }
            start = index + 1;
        }
        return file;
    }

    public final AbstractFile resolveSibling(String name) {
        return this.container().lookupName(name, false);
    }

    public final AbstractFile resolveSiblingWithExtension(FileExtension extension2) {
        return this.resolveSibling(new StringBuilder(1).append(Path$.MODULE$.fileName(this.name())).append(".").append(extension2).toString());
    }

    private AbstractFile fileOrSubdirectoryNamed(String name, boolean isDir) {
        AbstractFile abstractFile;
        block7: {
            Object object;
            Object object2;
            abstractFile = this.lookupName(name, isDir);
            if (abstractFile != null) break block7;
            try {
                object2 = Files.createDirectories(this.jpath(), new FileAttribute[0]);
            }
            catch (Throwable throwable) {
                block9: {
                    block8: {
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof FileAlreadyExistsException)) break block8;
                        FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                        if (Files.isDirectory(this.jpath(), new LinkOption[0])) break block9;
                    }
                    throw throwable;
                }
                object2 = BoxedUnit.UNIT;
            }
            java.nio.file.Path path2 = this.jpath().resolve(name);
            try {
                object = isDir ? Files.createDirectory(path2, new FileAttribute[0]) : Files.createFile(path2, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                object = BoxedUnit.UNIT;
            }
            return new PlainFile(new File(path2, Codec$.MODULE$.fallbackSystemCodec()));
        }
        AbstractFile lookup = abstractFile;
        return lookup;
    }

    public AbstractFile fileNamed(String name) {
        if (!this.isDirectory()) {
            throw Scala3RunTime$.MODULE$.assertFailed(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tried to find '%s' in '%s' but it is not a directory"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name, this.path()})));
        }
        return this.fileOrSubdirectoryNamed(name, false);
    }

    public AbstractFile subdirectoryNamed(String name) {
        if (!this.isDirectory()) {
            throw Scala3RunTime$.MODULE$.assertFailed(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tried to find '%s' in '%s' but it is not a directory"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name, this.path()})));
        }
        return this.fileOrSubdirectoryNamed(name, true);
    }

    public Nothing$ unsupported() {
        return this.unsupported(null);
    }

    public Nothing$ unsupported(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String toString() {
        return this.path();
    }
}

