/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.Directory;
import dotty.tools.io.File;
import dotty.tools.io.File$;
import dotty.tools.io.Jar$;
import dotty.tools.io.Jar$WManifest$;
import dotty.tools.io.JarWriter;
import dotty.tools.io.Path;
import java.io.InputStream;
import java.io.Serializable;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.io.Codec$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;

public class Jar {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Jar.class.getDeclaredField("manifest$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Jar.class.getDeclaredField("jarFile$lzy1"));
    private final File file;
    private volatile Object jarFile$lzy1;
    private volatile Object manifest$lzy1;

    public static WManifest WManifest(Manifest manifest) {
        return Jar$.MODULE$.WManifest(manifest);
    }

    public static void create(File file, Directory directory, String string2) {
        Jar$.MODULE$.create(file, directory, string2);
    }

    public static boolean isJarOrZip(Path path2) {
        return Jar$.MODULE$.isJarOrZip(path2);
    }

    public static boolean isJarOrZip(Path path2, boolean bl) {
        return Jar$.MODULE$.isJarOrZip(path2, bl);
    }

    public Jar(File file) {
        this.file = file;
    }

    public Jar(java.io.File jfile) {
        this(File$.MODULE$.apply(jfile.toPath(), Codec$.MODULE$.fallbackSystemCodec()));
    }

    public Jar(String path2) {
        this(File$.MODULE$.apply(path2, Codec$.MODULE$.fallbackSystemCodec()));
    }

    public void errorFn(String msg) {
        Console$.MODULE$.println(msg);
    }

    public JarFile jarFile() {
        Object object = this.jarFile$lzy1;
        if (object instanceof JarFile) {
            return (JarFile)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (JarFile)this.jarFile$lzyINIT1();
    }

    private Object jarFile$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.jarFile$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(this.file.jpath().toFile());
                        object2 = jarFile == null ? LazyVals$NullValue$.MODULE$ : jarFile;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jarFile$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jarFile;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<Manifest> manifest() {
        Object object = this.manifest$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.manifest$lzyINIT1();
    }

    private Object manifest$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.manifest$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    Option option = null;
                    try {
                        option = (Option)this.withJarInput((Function1<JarInputStream, Option> & Serializable)s -> Option$.MODULE$.apply(s.getManifest()));
                        serializable = option == null ? LazyVals$NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.manifest$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<String> mainClass() {
        return this.manifest().map((Function1<Manifest, String> & Serializable)_$1 -> Jar$.MODULE$.WManifest((Manifest)_$1).apply(Attributes.Name.MAIN_CLASS));
    }

    public Option<String> classPathString() {
        return this.manifest().flatMap((Function1<Manifest, Option> & Serializable)m -> Jar$.MODULE$.WManifest((Manifest)m).attrs().get(Attributes.Name.CLASS_PATH).withFilter((Function1<String, Boolean> & Serializable)cp -> !cp.trim().isEmpty()).map((Function1<String, String> & Serializable)cp -> cp));
    }

    public List<String> classPathElements() {
        Option<String> option = this.classPathString();
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            return Predef$.MODULE$.wrapRefArray(s.split("\\s+")).toList();
        }
        return package$.MODULE$.Nil();
    }

    public <T> T withJarInput(Function1<JarInputStream, T> f) {
        T t;
        try (JarInputStream in = new JarInputStream(this.file.inputStream());){
            t = f.apply(in);
        }
        return t;
    }

    public JarWriter jarWriter(Seq<Tuple2<Attributes.Name, String>> mainAttrs) {
        return new JarWriter(this.file, Jar$WManifest$.MODULE$.apply(mainAttrs).underlying());
    }

    public List<JarEntry> toList() {
        return (List)this.withJarInput((Function1<JarInputStream, List> & Serializable)in -> package$.MODULE$.Iterator().continually(() -> Jar.toList$$anonfun$1$$anonfun$1(in)).takeWhile((Function1<JarEntry, Boolean> & Serializable)_$2 -> _$2 != null).toList());
    }

    public InputStream getEntryStream(JarEntry entry) {
        InputStream inputStream = this.jarFile().getInputStream(entry);
        if (inputStream == null) {
            this.errorFn(new StringBuilder(15).append("No such entry: ").append(entry).toString());
            return null;
        }
        InputStream x = inputStream;
        return x;
    }

    public String toString() {
        return String.valueOf(this.file);
    }

    private static final JarEntry toList$$anonfun$1$$anonfun$1(JarInputStream in$1) {
        return in$1.getNextJarEntry();
    }

    public static class WManifest {
        private final Manifest manifest;

        public WManifest(Manifest manifest) {
            this.manifest = manifest;
            this.initialMainAttrs().withFilter((Function1<Tuple2<Attributes.Name, String>, Object>)(Function1<Tuple2, Boolean> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Attributes.Name k = (Attributes.Name)tuple2._1();
                    String v = (String)tuple2._2();
                    return true;
                }
                return false;
            }).foreach((Function1<Tuple2, Option> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Attributes.Name k = (Attributes.Name)tuple2._1();
                    String v = (String)tuple2._2();
                    return this.update(k, v);
                }
                throw new MatchError(tuple2);
            });
        }

        public Manifest manifest() {
            return this.manifest;
        }

        public Manifest underlying() {
            return this.manifest();
        }

        public Map<Attributes.Name, String> attrs() {
            return CollectionConverters$.MODULE$.MapHasAsScala(this.manifest().getMainAttributes()).asScala().withDefaultValue(null);
        }

        public scala.collection.immutable.Map<Attributes.Name, String> initialMainAttrs() {
            Tuple2[] tuple2Array = new Tuple2[2];
            Attributes.Name name = Predef$.MODULE$.ArrowAssoc(Attributes.Name.MANIFEST_VERSION);
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(name, "1.0");
            Attributes.Name name2 = Predef$.MODULE$.ArrowAssoc(Properties$.MODULE$.ScalaCompilerVersion());
            tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(name2, Properties$.MODULE$.versionNumberString());
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        }

        public String apply(Attributes.Name name) {
            return (String)this.attrs().apply(name);
        }

        public String apply(String name) {
            return this.apply(new Attributes.Name(name));
        }

        public Option<String> update(Attributes.Name key, String value) {
            return this.attrs().put(key, value);
        }

        public Option<String> update(String key, String value) {
            return this.attrs().put(new Attributes.Name(key), value);
        }

        public String mainClass() {
            return this.apply(Attributes.Name.MAIN_CLASS);
        }

        public Option<String> mainClass_$eq(String value) {
            return this.update(Attributes.Name.MAIN_CLASS, value);
        }
    }
}

