/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.Directory;
import dotty.tools.io.Directory$;
import dotty.tools.io.File;
import dotty.tools.io.FileExtension;
import dotty.tools.io.Path$;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class Path {
    private final java.nio.file.Path jpath;
    private final char separator;
    private final String separatorStr;

    public static Path apply(java.nio.file.Path path2) {
        return Path$.MODULE$.apply(path2);
    }

    public static Path apply(String string2) {
        return Path$.MODULE$.apply(string2);
    }

    public static Nothing$ fail(String string2) {
        return Path$.MODULE$.fail(string2);
    }

    public static FileExtension fileExtension(String string2) {
        return Path$.MODULE$.fileExtension(string2);
    }

    public static String fileName(String string2) {
        return Path$.MODULE$.fileName(string2);
    }

    public static boolean isExtensionJarOrZip(java.nio.file.Path path2) {
        return Path$.MODULE$.isExtensionJarOrZip(path2);
    }

    public static boolean isExtensionJarOrZip(String string2) {
        return Path$.MODULE$.isExtensionJarOrZip(string2);
    }

    public static Iterator<Directory> onlyDirs(Iterator<Path> iterator) {
        return Path$.MODULE$.onlyDirs(iterator);
    }

    public static List<Directory> onlyDirs(List<Path> list) {
        return Path$.MODULE$.onlyDirs(list);
    }

    public static Iterator<File> onlyFiles(Iterator<Path> iterator) {
        return Path$.MODULE$.onlyFiles(iterator);
    }

    public static String randomPrefix() {
        return Path$.MODULE$.randomPrefix();
    }

    public static List<Path> roots() {
        return Path$.MODULE$.roots();
    }

    public Path(java.nio.file.Path jpath) {
        this.jpath = jpath;
        this.separator = java.io.File.separatorChar;
        this.separatorStr = java.io.File.separator;
    }

    public java.nio.file.Path jpath() {
        return this.jpath;
    }

    public char separator() {
        return this.separator;
    }

    public String separatorStr() {
        return this.separatorStr;
    }

    public File toFile() {
        return new File(this.jpath(), Codec$.MODULE$.fallbackSystemCodec());
    }

    public Directory toDirectory() {
        return new Directory(this.jpath());
    }

    public Path toAbsolute() {
        if (this.isAbsolute()) {
            return this;
        }
        return new Path(this.jpath().toAbsolutePath());
    }

    public Path toCanonical() {
        return this.normalize().toAbsolute();
    }

    public URI toURI() {
        return this.jpath().toUri();
    }

    public URL toURL() {
        return this.toURI().toURL();
    }

    public Path toAbsoluteWithRoot(Path root2) {
        if (this.isAbsolute()) {
            return this;
        }
        return root2.toAbsolute().$div(this);
    }

    public Path $div(String child) {
        return new Path(this.jpath().resolve(child));
    }

    public Path $div(Path child) {
        return this.resolve(child);
    }

    public Directory $div(Directory child) {
        return this.$div((Path)child).toDirectory();
    }

    public File $div(File child) {
        return this.$div((Path)child).toFile();
    }

    public Iterator<Path> walkFilter(Function1<Path, Object> cond) {
        if (this.isFile()) {
            return this.toFile().walkFilter(cond);
        }
        if (this.isDirectory()) {
            return this.toDirectory().walkFilter(cond);
        }
        return package$.MODULE$.Iterator().empty();
    }

    public Iterator<Path> walk() {
        return this.walkFilter((Function1<Path, Object>)(Function1<Path, Boolean> & Serializable)_$7 -> true);
    }

    public String name() {
        java.nio.file.Path path2 = this.jpath().getFileName();
        if (path2 == null) {
            return "";
        }
        java.nio.file.Path name = path2;
        return name.toString();
    }

    public String path() {
        return this.jpath().toString();
    }

    public Path normalize() {
        return new Path(this.jpath().normalize());
    }

    public Path resolve(Path other) {
        return new Path(this.jpath().resolve(other.jpath()));
    }

    public Path relativize(Path other) {
        return new Path(this.jpath().relativize(other.jpath()));
    }

    public List<String> segments() {
        return Predef$.MODULE$.wrapRefArray(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.path()), this.separator())).toList().filterNot((Function1<String, Boolean> & Serializable)_$8 -> _$8.length() == 0);
    }

    public Directory parent() {
        if (this.path().isEmpty()) {
            return Directory$.MODULE$.apply("..");
        }
        if (this.jpath().endsWith("..")) {
            return this.$div("..").toDirectory();
        }
        if (this.jpath().endsWith(".")) {
            java.nio.file.Path path2 = this.jpath().getParent();
            if (path2 == null) {
                return Directory$.MODULE$.apply("..");
            }
            java.nio.file.Path p = path2;
            return new Path(p).parent();
        }
        java.nio.file.Path path3 = this.jpath().getParent();
        if (path3 == null) {
            if (this.isAbsolute()) {
                return this.toDirectory();
            }
            return Directory$.MODULE$.apply(".");
        }
        java.nio.file.Path x = path3;
        return Directory$.MODULE$.apply(x);
    }

    public List<Directory> parents() {
        Directory p = this.parent();
        if (p.isSame(this)) {
            return package$.MODULE$.Nil();
        }
        return p.parents().$colon$colon(p);
    }

    public FileExtension ext() {
        return Path$.MODULE$.fileExtension(this.name());
    }

    public String extension() {
        return this.ext().toLowerCase();
    }

    public boolean hasExtension(String ext, Seq<String> exts) {
        String lower = ext.toLowerCase();
        return lower.equalsIgnoreCase(ext) || exts.exists((Function1<String, Boolean> & Serializable)x$0 -> lower.equalsIgnoreCase((String)x$0));
    }

    public String stripExtension() {
        return Path$.MODULE$.fileName(this.name());
    }

    public Path addExtension(String ext) {
        return new Path(this.jpath().resolveSibling(new StringBuilder(0).append(this.name()).append(ext).toString()));
    }

    public Path changeExtension(FileExtension ext) {
        return this.changeExtension(ext.toLowerCase());
    }

    public Path changeExtension(String ext) {
        String name0 = this.name();
        String dropExtension = Path$.MODULE$.fileName(name0);
        if (dropExtension == name0) {
            return this.addExtension(ext);
        }
        return new Path(this.jpath().resolveSibling(new StringBuilder(1).append(dropExtension).append(".").append(ext).toString()));
    }

    public <T> Option<T> ifFile(Function1<File, T> f) {
        if (this.isFile()) {
            return Some$.MODULE$.apply(f.apply(this.toFile()));
        }
        return None$.MODULE$;
    }

    public <T> Option<T> ifDirectory(Function1<Directory, T> f) {
        if (this.isDirectory()) {
            return Some$.MODULE$.apply(f.apply(this.toDirectory()));
        }
        return None$.MODULE$;
    }

    public boolean canRead() {
        return Files.isReadable(this.jpath());
    }

    public boolean canWrite() {
        return Files.isWritable(this.jpath());
    }

    public boolean exists() {
        boolean bl;
        try {
            bl = Files.exists(this.jpath(), new LinkOption[0]);
        }
        catch (SecurityException ex) {
            bl = false;
        }
        return bl;
    }

    public boolean isFile() {
        boolean bl;
        try {
            bl = Files.isRegularFile(this.jpath(), new LinkOption[0]);
        }
        catch (SecurityException ex) {
            bl = false;
        }
        return bl;
    }

    public boolean isDirectory() {
        boolean bl;
        block3: {
            try {
                bl = Files.isDirectory(this.jpath(), new LinkOption[0]);
            }
            catch (SecurityException ex) {
                String string2 = this.jpath().toString();
                String string3 = ".";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isAbsolute() {
        return this.jpath().isAbsolute();
    }

    public boolean isEmpty() {
        return this.path().length() == 0;
    }

    public FileTime lastModified() {
        return Files.getLastModifiedTime(this.jpath(), new LinkOption[0]);
    }

    public long length() {
        return Files.size(this.jpath());
    }

    public boolean endsWith(Path other) {
        return this.segments().endsWith(other.segments());
    }

    public boolean isSame(Path other) {
        Path path2 = this.toCanonical();
        Path path3 = other.toCanonical();
        return !(path2 != null ? !((Object)path2).equals(path3) : path3 != null);
    }

    public boolean isFresher(Path other) {
        return this.lastModified().compareTo(other.lastModified()) > 0;
    }

    public Directory createDirectory(boolean force, boolean failIfExists) {
        boolean res = this.tryCreate(() -> this.$anonfun$1(force));
        if (!res && failIfExists && this.exists()) {
            throw Path$.MODULE$.fail(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Directory '%s' already exists."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.name()})));
        }
        if (this.isDirectory()) {
            return this.toDirectory();
        }
        return new Directory(this.jpath());
    }

    public boolean createDirectory$default$1() {
        return true;
    }

    public boolean createDirectory$default$2() {
        return false;
    }

    public File createFile(boolean failIfExists) {
        boolean res = this.tryCreate(this::$anonfun$2);
        Files.createFile(this.jpath(), new FileAttribute[0]);
        if (!res && failIfExists && this.exists()) {
            throw Path$.MODULE$.fail(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("File '%s' already exists."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.name()})));
        }
        if (this.isFile()) {
            return this.toFile();
        }
        return new File(this.jpath(), Codec$.MODULE$.fallbackSystemCodec());
    }

    public boolean createFile$default$1() {
        return false;
    }

    private boolean tryCreate(Function0<java.nio.file.Path> create) {
        boolean bl;
        try {
            create.apply();
            bl = true;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            bl = false;
        }
        return bl;
    }

    public void delete() {
        try {
            Files.deleteIfExists(this.jpath());
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {}
    }

    public boolean deleteRecursively() {
        if (!this.exists()) {
            return false;
        }
        Files.walkFileTree(this.jpath(), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean truncate() {
        if (!this.isFile()) return false;
        RandomAccessFile raf = new RandomAccessFile(this.jpath().toFile(), "rw");
        raf.setLength(0L);
        raf.close();
        if (this.length() != 0L) return false;
        return true;
    }

    public String toString() {
        return this.path();
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof Path) {
            Path path2;
            Path x = path2 = (Path)object;
            String string2 = this.path();
            String string3 = x.path();
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    private final java.nio.file.Path $anonfun$1(boolean force$1) {
        if (force$1) {
            return Files.createDirectories(this.jpath(), new FileAttribute[0]);
        }
        return Files.createDirectory(this.jpath(), new FileAttribute[0]);
    }

    private final java.nio.file.Path $anonfun$2() {
        return Files.createFile(this.jpath(), new FileAttribute[0]);
    }
}

