/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.Hashing$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.MapFactory;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedMapOps;
import scala.collection.immutable.AbstractMap;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.OldHashMap$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.TrieIterator;
import scala.collection.mutable.Builder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public abstract class OldHashMap<K, V>
extends AbstractMap<K, V>
implements StrictOptimizedMapOps<K, V, OldHashMap, OldHashMap<K, V>>,
Serializable {
    public static <K, V> OldHashMap<K, V> from(IterableOnce<Tuple2<K, V>> iterableOnce) {
        return OldHashMap$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static <K, V> Builder<Tuple2<K, V>, OldHashMap<K, V>> newBuilder() {
        return OldHashMap$.MODULE$.newBuilder();
    }

    public OldHashMap() {
        StrictOptimizedIterableOps.$init$(this);
        StrictOptimizedMapOps.$init$(this);
    }

    @Override
    public MapFactory<OldHashMap> mapFactory() {
        return OldHashMap$.MODULE$;
    }

    @Override
    public final OldHashMap<K, V> removed(K key) {
        return this.removed0(key, Hashing$.MODULE$.computeHash(key), 0);
    }

    @Override
    public final <V1> OldHashMap<K, V1> updated(K key, V1 value) {
        return this.updated0(key, Hashing$.MODULE$.computeHash(key), 0, value, null, null);
    }

    @Override
    public final <V1> OldHashMap<K, V1> $plus(Tuple2<K, V1> kv) {
        return this.updated((Object)kv._1(), (Object)kv._2());
    }

    @Override
    public Option<V> get(K key) {
        return this.get0(key, Hashing$.MODULE$.computeHash(key), 0);
    }

    public Seq<OldHashMap<K, V>> split() {
        return (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new OldHashMap[]{this}));
    }

    public <V1> OldHashMap<K, V1> merged(OldHashMap<K, V1> that, Function2<Tuple2<K, V1>, Tuple2<K, V1>, Tuple2<K, V1>> mergef) {
        return this.merge0(that, 0, OldHashMap$.MODULE$.scala$collection$immutable$OldHashMap$$$liftMerger(mergef));
    }

    public abstract <V1> OldHashMap<K, V1> updated0(K var1, int var2, int var3, V1 var4, Tuple2<K, V1> var5, Merger<K, V1> var6);

    public abstract OldHashMap<K, V> removed0(K var1, int var2, int var3);

    public abstract Option<V> get0(K var1, int var2, int var3);

    public abstract <V1> OldHashMap<K, V1> merge0(OldHashMap<K, V1> var1, int var2, Merger<K, V1> var3);

    public abstract OldHashMap<K, V> filter0(Function1<Tuple2<K, V>, Object> var1, boolean var2, int var3, OldHashMap<K, V>[] var4, int var5);

    public abstract boolean contains0(K var1, int var2, int var3);

    @Override
    public final boolean contains(K key) {
        return this.contains0(key, Hashing$.MODULE$.computeHash(key), 0);
    }

    @Override
    public OldHashMap<K, V> tail() {
        return (OldHashMap)this.$minus(((Tuple2)this.head())._1());
    }

    @Override
    public OldHashMap<K, V> init() {
        return (OldHashMap)this.$minus(((Tuple2)this.last())._1());
    }

    @Override
    public OldHashMap<K, V> filter(Function1<Tuple2<K, V>, Object> pred) {
        OldHashMap[] buffer = new OldHashMap[OldHashMap$.MODULE$.scala$collection$immutable$OldHashMap$$$bufferSize(this.size())];
        return OldHashMap$.MODULE$.scala$collection$immutable$OldHashMap$$$nullToEmpty(this.filter0(pred, false, 0, buffer, 0));
    }

    @Override
    public OldHashMap<K, V> filterNot(Function1<Tuple2<K, V>, Object> pred) {
        OldHashMap[] buffer = new OldHashMap[OldHashMap$.MODULE$.scala$collection$immutable$OldHashMap$$$bufferSize(this.size())];
        return OldHashMap$.MODULE$.scala$collection$immutable$OldHashMap$$$nullToEmpty(this.filter0(pred, true, 0, buffer, 0));
    }

    @Override
    public String className() {
        return "OldHashMap";
    }

    public static final class HashTrieMap<K, V>
    extends OldHashMap<K, V> {
        private final int bitmap;
        private final OldHashMap[] elems;
        private final int size0;

        public HashTrieMap(int bitmap, OldHashMap<K, V>[] elems, int size0) {
            this.bitmap = bitmap;
            this.elems = elems;
            this.size0 = size0;
        }

        public int bitmap() {
            return this.bitmap;
        }

        public OldHashMap<K, V>[] elems() {
            return this.elems;
        }

        public int size0() {
            return this.size0;
        }

        @Override
        public int size() {
            return this.size0();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int knownSize() {
            return this.size();
        }

        @Override
        public Option<V> get0(K key, int hash, int level) {
            Option option;
            int index = hash >>> level & 0x1F;
            if (this.bitmap() == -1) {
                option = this.elems()[index].get0(key, hash, level + 5);
            } else {
                int mask = 1 << index;
                if ((this.bitmap() & mask) != 0) {
                    int offset = Integer.bitCount(this.bitmap() & mask - 1);
                    option = this.elems()[offset].get0(key, hash, level + 5);
                } else {
                    option = None$.MODULE$;
                }
            }
            return option;
        }

        @Override
        public boolean contains0(K key, int hash, int level) {
            boolean bl;
            int index = hash >>> level & 0x1F;
            if (this.bitmap() == -1) {
                bl = this.elems()[index].contains0(key, hash, level + 5);
            } else {
                int mask = 1 << index;
                if ((this.bitmap() & mask) != 0) {
                    int offset = Integer.bitCount(this.bitmap() & mask - 1);
                    bl = this.elems()[offset].contains0(key, hash, level + 5);
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public <V1> OldHashMap<K, V1> updated0(K key, int hash, int level, V1 value, Tuple2<K, V1> kv, Merger<K, V1> merger) {
            HashTrieMap hashTrieMap;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                OldHashMap<K, V> sub = this.elems()[offset];
                OldHashMap<K, V1> subNew = sub.updated0(key, hash, level + 5, value, kv, merger);
                if (subNew == sub) {
                    hashTrieMap = this;
                } else {
                    OldHashMap[] elemsNew = new OldHashMap[this.elems().length];
                    Array$.MODULE$.copy(this.elems(), 0, elemsNew, 0, this.elems().length);
                    elemsNew[offset] = subNew;
                    hashTrieMap = new HashTrieMap<K, V>(this.bitmap(), elemsNew, this.size() + (subNew.size() - sub.size()));
                }
            } else {
                OldHashMap[] elemsNew = new OldHashMap[this.elems().length + 1];
                Array$.MODULE$.copy(this.elems(), 0, elemsNew, 0, offset);
                elemsNew[offset] = new OldHashMap1<K, V1>(key, hash, value, kv);
                Array$.MODULE$.copy(this.elems(), offset, elemsNew, offset + 1, this.elems().length - offset);
                hashTrieMap = new HashTrieMap<K, V>(this.bitmap() | mask, elemsNew, this.size() + 1);
            }
            return hashTrieMap;
        }

        @Override
        public OldHashMap<K, V> removed0(K key, int hash, int level) {
            OldHashMap oldHashMap;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                OldHashMap<K, V> sub = this.elems()[offset];
                OldHashMap<K, V> subNew = sub.removed0(key, hash, level + 5);
                if (subNew == sub) {
                    oldHashMap = this;
                } else if (subNew.isEmpty()) {
                    int bitmapNew = this.bitmap() ^ mask;
                    if (bitmapNew != 0) {
                        OldHashMap[] elemsNew = new OldHashMap[this.elems().length - 1];
                        Array$.MODULE$.copy(this.elems(), 0, elemsNew, 0, offset);
                        Array$.MODULE$.copy(this.elems(), offset + 1, elemsNew, offset, this.elems().length - offset - 1);
                        int sizeNew = this.size() - sub.size();
                        oldHashMap = elemsNew.length == 1 && !(elemsNew[0] instanceof HashTrieMap) ? elemsNew[0] : new HashTrieMap<K, V>(bitmapNew, elemsNew, sizeNew);
                    } else {
                        oldHashMap = OldHashMap$.MODULE$.empty();
                    }
                } else if (this.elems().length == 1 && !(subNew instanceof HashTrieMap)) {
                    oldHashMap = subNew;
                } else {
                    OldHashMap<K, V>[] elemsNew = Arrays.copyOf(this.elems(), this.elems().length);
                    elemsNew[offset] = subNew;
                    int sizeNew = this.size() + (subNew.size() - sub.size());
                    oldHashMap = new HashTrieMap<K, V>(this.bitmap(), elemsNew, sizeNew);
                }
            } else {
                oldHashMap = this;
            }
            return oldHashMap;
        }

        @Override
        public OldHashMap<K, V> filter0(Function1<Tuple2<K, V>, Object> p, boolean negate, int level, OldHashMap<K, V>[] buffer, int offset0) {
            OldHashMap oldHashMap;
            int offset = offset0;
            int rs = 0;
            int kept = 0;
            for (int i = 0; i < this.elems().length; ++i) {
                OldHashMap<K, V> result = this.elems()[i].filter0(p, negate, level + 5, buffer, offset);
                if (result == null) continue;
                buffer[offset] = result;
                ++offset;
                rs += result.size();
                kept |= 1 << i;
            }
            if (offset == offset0) {
                oldHashMap = null;
            } else if (rs == this.size0()) {
                oldHashMap = this;
            } else if (offset == offset0 + 1 && !(buffer[offset0] instanceof HashTrieMap)) {
                oldHashMap = buffer[offset0];
            } else {
                int length = offset - offset0;
                OldHashMap[] elems1 = new OldHashMap[length];
                System.arraycopy(buffer, offset0, elems1, 0, length);
                int bitmap1 = length == this.elems().length ? this.bitmap() : Hashing$.MODULE$.keepBits(this.bitmap(), kept);
                oldHashMap = new HashTrieMap<K, V>(bitmap1, elems1, rs);
            }
            return oldHashMap;
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return new TrieIterator<Tuple2<K, V>>(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer.scala$collection$immutable$OldHashMap$HashTrieMap$$_$$anon$superArg$1$1());
                }

                public final Tuple2 getElem(Object cc) {
                    return ((OldHashMap1)cc).ensurePair();
                }
            };
        }

        @Override
        public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
            for (int i = 0; i < this.elems().length; ++i) {
                this.elems()[i].foreach(f);
            }
        }

        private int posOf(int n, int bm) {
            int left = n;
            int i = -1;
            int b = bm;
            while (left >= 0) {
                ++i;
                if ((b & 1) != 0) {
                    --left;
                }
                b >>>= 1;
            }
            return i;
        }

        @Override
        public Seq<OldHashMap<K, V>> split() {
            Seq seq;
            if (this.size() == 1) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new HashTrieMap[]{this}));
            } else {
                int nodesize = Integer.bitCount(this.bitmap());
                if (nodesize > 1) {
                    int splitpoint = nodesize / 2;
                    int bitsplitpoint = this.posOf(nodesize / 2, this.bitmap());
                    int bm1 = this.bitmap() & -1 << bitsplitpoint;
                    int bm2 = this.bitmap() & -1 >>> 32 - bitsplitpoint;
                    Object object = Predef$.MODULE$.refArrayOps(this.elems());
                    Tuple2<Object, Object> tuple2 = ArrayOps$.MODULE$.splitAt$extension(object, splitpoint);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    OldHashMap[] e1 = (OldHashMap[])tuple2._1();
                    OldHashMap[] e2 = (OldHashMap[])tuple2._2();
                    Tuple2<OldHashMap[], OldHashMap[]> tuple22 = Tuple2$.MODULE$.apply(e1, e2);
                    Object[] e12 = tuple22._1();
                    Object[] e22 = tuple22._2();
                    Object object2 = Predef$.MODULE$.refArrayOps(e12);
                    HashTrieMap<K, V> hm1 = new HashTrieMap<K, V>(bm1, (OldHashMap<K, V>[])e12, BoxesRunTime.unboxToInt(ArrayOps$.MODULE$.foldLeft$extension(object2, BoxesRunTime.boxToInteger(0), (Function2<Object, Object, int> & Serializable)(_$1, _$2) -> this.$anonfun$1(BoxesRunTime.unboxToInt(_$1), (OldHashMap)_$2))));
                    Object object3 = Predef$.MODULE$.refArrayOps(e22);
                    HashTrieMap<K, V> hm2 = new HashTrieMap<K, V>(bm2, (OldHashMap<K, V>[])e22, BoxesRunTime.unboxToInt(ArrayOps$.MODULE$.foldLeft$extension(object3, BoxesRunTime.boxToInteger(0), (Function2<Object, Object, int> & Serializable)(_$3, _$4) -> this.$anonfun$2(BoxesRunTime.unboxToInt(_$3), (OldHashMap)_$4))));
                    seq = (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new HashTrieMap[]{hm1, hm2}));
                } else {
                    seq = this.elems()[0].split();
                }
            }
            return seq;
        }

        @Override
        public <V1> OldHashMap<K, V1> merge0(OldHashMap<K, V1> that, int level, Merger<K, V1> merger) {
            OldHashMap oldHashMap;
            OldHashMap<K, V1> oldHashMap2 = that;
            if (oldHashMap2 instanceof OldHashMap1) {
                OldHashMap1 hm = (OldHashMap1)oldHashMap2;
                oldHashMap = this.updated0(hm.key(), hm.hash(), level, hm.value(), hm.kv(), merger);
            } else if (oldHashMap2 instanceof HashTrieMap) {
                HashTrieMap hm;
                HashTrieMap that2 = hm = (HashTrieMap)oldHashMap2;
                OldHashMap<K, V>[] thiselems = this.elems();
                OldHashMap<K, V>[] thatelems = that2.elems();
                int thisbm = this.bitmap();
                int thatbm = that2.bitmap();
                int subcount = Integer.bitCount(thisbm | thatbm);
                OldHashMap[] merged = new OldHashMap[subcount];
                int thisi = 0;
                int thati = 0;
                int totalelems = 0;
                for (int i = 0; i < subcount; ++i) {
                    int thislsb = thisbm ^ thisbm & thisbm - 1;
                    int thatlsb = thatbm ^ thatbm & thatbm - 1;
                    if (thislsb == thatlsb) {
                        OldHashMap<K, V> m = thiselems[thisi].merge0(thatelems[thati], level + 5, merger);
                        totalelems += m.size();
                        merged[i] = m;
                        thisbm &= ~thislsb;
                        thatbm &= ~thatlsb;
                        ++thati;
                        ++thisi;
                        continue;
                    }
                    if (Integer.compareUnsigned(thislsb - 1, thatlsb - 1) < 0) {
                        OldHashMap<K, V> m = thiselems[thisi];
                        totalelems += m.size();
                        merged[i] = m;
                        thisbm &= ~thislsb;
                        ++thisi;
                        continue;
                    }
                    OldHashMap<K, V> m = thatelems[thati];
                    totalelems += m.size();
                    merged[i] = m;
                    thatbm &= ~thatlsb;
                    ++thati;
                }
                oldHashMap = new HashTrieMap<K, V>(this.bitmap() | that2.bitmap(), merged, totalelems);
            } else if (oldHashMap2 instanceof OldHashMapCollision1) {
                OldHashMapCollision1 hm = (OldHashMapCollision1)oldHashMap2;
                oldHashMap = that.merge0(this, level, merger.invert());
            } else if (oldHashMap2 instanceof OldHashMap) {
                OldHashMap<K, V1> hm = oldHashMap2;
                oldHashMap = this;
            } else {
                throw new MatchError(oldHashMap2);
            }
            return oldHashMap;
        }

        public final Iterable[] scala$collection$immutable$OldHashMap$HashTrieMap$$_$$anon$superArg$1$1() {
            return this.elems();
        }

        private final /* synthetic */ int $anonfun$1(int _$1, OldHashMap _$2) {
            return _$1 + _$2.size();
        }

        private final /* synthetic */ int $anonfun$2(int _$3, OldHashMap _$4) {
            return _$3 + _$4.size();
        }
    }

    public static abstract class Merger<A, B> {
        public abstract Tuple2<A, B> apply(Tuple2<A, B> var1, Tuple2<A, B> var2);

        public abstract Merger<A, B> invert();
    }

    public static final class OldHashMap1<K, V>
    extends OldHashMap<K, V> {
        private final Object key;
        private final int hash;
        private final Object value;
        private Tuple2 kv;

        public OldHashMap1(K key, int hash, V value, Tuple2<K, V> kv) {
            this.key = key;
            this.hash = hash;
            this.value = value;
            this.kv = kv;
        }

        public K key() {
            return (K)this.key;
        }

        public int hash() {
            return this.hash;
        }

        public V value() {
            return (V)this.value;
        }

        public Tuple2<K, V> kv() {
            return this.kv;
        }

        public void kv_$eq(Tuple2<K, V> x$1) {
            this.kv = x$1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return Iterator$.MODULE$.single(this.ensurePair());
        }

        @Override
        public Option<V> get0(K key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key()) ? Some$.MODULE$.apply(this.value()) : None$.MODULE$;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int knownSize() {
            return 1;
        }

        public K getKey() {
            return this.key();
        }

        public int getHash() {
            return this.hash();
        }

        public int computeHashFor(K k) {
            return Hashing$.MODULE$.computeHash(k);
        }

        @Override
        public boolean contains0(K key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key());
        }

        @Override
        public <V1> OldHashMap<K, V1> updated0(K key, int hash, int level, V1 value, Tuple2<K, V1> kv, Merger<K, V1> merger) {
            OldHashMap oldHashMap;
            if (hash == this.hash() && BoxesRunTime.equals(key, this.key())) {
                if (merger == null) {
                    oldHashMap = this.value() == value ? this : new OldHashMap1<K, V1>(key, hash, value, kv);
                } else {
                    Tuple2<K, V1> nkv = merger.apply(this.ensurePair(), kv != null ? kv : Tuple2$.MODULE$.apply(key, value));
                    oldHashMap = new OldHashMap1<K, V1>(nkv._1(), hash, nkv._2(), nkv);
                }
            } else if (hash != this.hash()) {
                OldHashMap1<K, V1> that = new OldHashMap1<K, V1>(key, hash, value, kv);
                oldHashMap = OldHashMap$.MODULE$.scala$collection$immutable$OldHashMap$$$makeHashTrieMap(this.hash(), this, hash, that, level, 2);
            } else {
                oldHashMap = new OldHashMapCollision1(hash, ((ListMap)((ListMap)ListMap$.MODULE$.empty()).updated((Object)this.key(), this.value())).updated((Object)key, (Object)value));
            }
            return oldHashMap;
        }

        @Override
        public OldHashMap<K, V> removed0(K key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key()) ? OldHashMap$.MODULE$.empty() : this;
        }

        @Override
        public OldHashMap<K, V> filter0(Function1<Tuple2<K, V>, Object> p, boolean negate, int level, OldHashMap<K, V>[] buffer, int offset0) {
            return negate ^ BoxesRunTime.unboxToBoolean(p.apply(this.ensurePair())) ? this : null;
        }

        @Override
        public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
            f.apply(this.ensurePair());
        }

        public Tuple2<K, V> ensurePair() {
            Tuple2<K, V> tuple2;
            if (this.kv() != null) {
                tuple2 = this.kv();
            } else {
                this.kv_$eq(Tuple2$.MODULE$.apply(this.key(), this.value()));
                tuple2 = this.kv();
            }
            return tuple2;
        }

        @Override
        public <V1> OldHashMap<K, V1> merge0(OldHashMap<K, V1> that, int level, Merger<K, V1> merger) {
            return that.updated0(this.key(), this.hash(), level, this.value(), this.kv(), merger.invert());
        }
    }

    public static class OldHashMapCollision1<K, V>
    extends OldHashMap<K, V> {
        private final int hash;
        private final ListMap kvs;

        public OldHashMapCollision1(int hash, ListMap<K, V> kvs) {
            this.hash = hash;
            this.kvs = kvs;
        }

        public int hash() {
            return this.hash;
        }

        public ListMap<K, V> kvs() {
            return this.kvs;
        }

        @Override
        public int size() {
            return this.kvs().size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Option<V> get0(K key, int hash, int level) {
            return hash == this.hash() ? this.kvs().get(key) : None$.MODULE$;
        }

        @Override
        public boolean contains0(K key, int hash, int level) {
            return hash == this.hash() && this.kvs().contains(key);
        }

        @Override
        public <B1> OldHashMap<K, B1> updated0(K key, int hash, int level, B1 value, Tuple2<K, B1> kv, Merger<K, B1> merger) {
            OldHashMap oldHashMap;
            if (hash == this.hash()) {
                oldHashMap = merger == null || !this.kvs().contains(key) ? new OldHashMapCollision1<K, V>(hash, this.kvs().updated((Object)key, value)) : new OldHashMapCollision1<K, V>(hash, (ListMap)this.kvs().$plus(merger.apply(Tuple2$.MODULE$.apply(key, this.kvs().apply(key)), kv)));
            } else {
                OldHashMap1<K, B1> that = new OldHashMap1<K, B1>(key, hash, value, kv);
                oldHashMap = OldHashMap$.MODULE$.scala$collection$immutable$OldHashMap$$$makeHashTrieMap(this.hash(), this, hash, that, level, this.size() + 1);
            }
            return oldHashMap;
        }

        @Override
        public OldHashMap<K, V> removed0(K key, int hash, int level) {
            OldHashMapCollision1<K, V> oldHashMapCollision1;
            if (hash == this.hash()) {
                ListMap kvs1 = (ListMap)this.kvs().$minus((Object)key);
                int n = kvs1.size();
                if (0 == n) {
                    oldHashMapCollision1 = OldHashMap$.MODULE$.empty();
                } else if (1 == n) {
                    Tuple2 kv = (Tuple2)kvs1.head();
                    oldHashMapCollision1 = new OldHashMap1(kv._1(), hash, kv._2(), kv);
                } else {
                    int x = n;
                    oldHashMapCollision1 = x == this.kvs().size() ? this : new OldHashMapCollision1<K, V>(hash, kvs1);
                }
            } else {
                oldHashMapCollision1 = this;
            }
            return oldHashMapCollision1;
        }

        @Override
        public OldHashMap<K, V> filter0(Function1<Tuple2<K, V>, Object> p, boolean negate, int level, OldHashMap<K, V>[] buffer, int offset0) {
            OldHashMap oldHashMap;
            ListMap kvs1 = negate ? (ListMap)this.kvs().filterNot(p) : (ListMap)this.kvs().filter(p);
            int n = kvs1.size();
            if (0 == n) {
                oldHashMap = null;
            } else if (1 == n) {
                Tuple2 tuple2 = (Tuple2)kvs1.head();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                Tuple2 kv = tuple2;
                Tuple3 tuple3 = Tuple3$.MODULE$.apply(kv, k, v);
                Tuple2 kv2 = tuple3._1();
                Object k2 = tuple3._2();
                Object v2 = tuple3._3();
                oldHashMap = new OldHashMap1(k2, this.hash(), v2, kv2);
            } else {
                int x = n;
                oldHashMap = x == this.kvs().size() ? this : new OldHashMapCollision1<K, V>(this.hash(), kvs1);
            }
            return oldHashMap;
        }

        @Override
        public <V1> OldHashMap<K, V1> merge0(OldHashMap<K, V1> that, int level, Merger<K, V1> merger) {
            ObjectRef<OldHashMap<K, V1>> m = ObjectRef.create(that);
            this.kvs().foreach((A p) -> {
                OldHashMap oldHashMap = ((OldHashMap)m$1.elem).updated0(p._1(), this.hash(), level, p._2(), p, merger.invert());
                m$1.elem = oldHashMap;
            });
            return (OldHashMap)m.elem;
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return this.kvs().iterator();
        }

        @Override
        public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
            this.kvs().foreach(f);
        }

        @Override
        public Seq<OldHashMap<K, V>> split() {
            Tuple2 tuple2 = this.kvs().splitAt(this.kvs().size() / 2);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ListMap x = (ListMap)tuple2._1();
            ListMap y = (ListMap)tuple2._2();
            Tuple2<ListMap, ListMap> tuple22 = Tuple2$.MODULE$.apply(x, y);
            ListMap x2 = tuple22._1();
            ListMap y2 = tuple22._2();
            return (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new OldHashMapCollision1[]{this.newhm$1(x2), this.newhm$1(y2)}));
        }

        private final OldHashMapCollision1 newhm$1(ListMap lm) {
            return new OldHashMapCollision1<K, V>(this.hash(), lm);
        }
    }
}

