/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.parallel;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.generic.DelegatedSignalling;
import scala.collection.generic.IdleSignalling$;
import scala.collection.generic.Signalling;
import scala.collection.immutable.Seq;
import scala.collection.parallel.AugmentedIterableIterator;
import scala.collection.parallel.ParIterable;
import scala.collection.parallel.SeqSplitter;
import scala.collection.parallel.Splitter;
import scala.collection.parallel.immutable.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public interface IterableSplitter<T>
extends AugmentedIterableIterator<T>,
Splitter<T>,
DelegatedSignalling {
    public static void $init$(IterableSplitter $this) {
        $this.signalDelegate_$eq(IdleSignalling$.MODULE$);
    }

    @Override
    public Signalling signalDelegate();

    @Override
    public void signalDelegate_$eq(Signalling var1);

    public IterableSplitter<T> dup();

    @Override
    public Seq<IterableSplitter<T>> split();

    public static Seq splitWithSignalling$(IterableSplitter $this) {
        return $this.splitWithSignalling();
    }

    /*
     * WARNING - void declaration
     */
    default public Seq<IterableSplitter<T>> splitWithSignalling() {
        void var1_1;
        Seq<IterableSplitter<T>> pits = this.split();
        pits.foreach(_$2 -> _$2.signalDelegate_$eq(this.signalDelegate()));
        return var1_1;
    }

    public static boolean shouldSplitFurther$(IterableSplitter $this, ParIterable coll, int parallelismLevel) {
        return $this.shouldSplitFurther(coll, parallelismLevel);
    }

    default public <S> boolean shouldSplitFurther(ParIterable<S> coll, int parallelismLevel) {
        return this.remaining() > scala.collection.parallel.package$.MODULE$.thresholdFromSize(coll.size(), parallelismLevel);
    }

    @Override
    public int remaining();

    public static String buildString$(IterableSplitter $this, Function1 closure) {
        return $this.buildString(closure);
    }

    default public String buildString(Function1<Function1<String, BoxedUnit>, BoxedUnit> closure) {
        ObjectRef<String> output = ObjectRef.create("");
        closure.apply(s -> IterableSplitter.appendln$1(output, s));
        return (String)output.elem;
    }

    public static String debugInformation$(IterableSplitter $this) {
        return $this.debugInformation();
    }

    default public String debugInformation() {
        return "Parallel iterator: " + this.getClass();
    }

    public static Taken newTaken$(IterableSplitter $this, int until) {
        return $this.newTaken(until);
    }

    default public Taken newTaken(int until) {
        return new Taken(this, until);
    }

    public static Taken newSliceInternal$(IterableSplitter $this, Taken it, int from1) {
        return $this.newSliceInternal(it, from1);
    }

    default public <U extends Taken> U newSliceInternal(U it, int from1) {
        for (int count = from1; count > 0 && it.hasNext(); --count) {
            it.next();
        }
        return it;
    }

    public static IterableSplitter drop$(IterableSplitter $this, int n) {
        return $this.drop(n);
    }

    @Override
    default public IterableSplitter<T> drop(int n) {
        for (int i = 0; i < n && this.hasNext(); ++i) {
            this.next();
        }
        return this;
    }

    public static IterableSplitter take$(IterableSplitter $this, int n) {
        return $this.take(n);
    }

    @Override
    default public IterableSplitter<T> take(int n) {
        return this.newTaken(n);
    }

    public static IterableSplitter slice$(IterableSplitter $this, int from1, int until1) {
        return $this.slice(from1, until1);
    }

    @Override
    default public IterableSplitter<T> slice(int from1, int until1) {
        return this.newSliceInternal(this.newTaken(until1), from1);
    }

    public static IterableSplitter map$(IterableSplitter $this, Function1 f) {
        return $this.map(f);
    }

    @Override
    default public <S> IterableSplitter<S> map(Function1<T, S> f) {
        return new Mapped<S>(this, f);
    }

    public static Appended appendParIterable$(IterableSplitter $this, IterableSplitter that) {
        return $this.appendParIterable(that);
    }

    default public <U, PI extends IterableSplitter<U>> Appended<U, PI> appendParIterable(PI that) {
        return new Appended(this, that);
    }

    public static IterableSplitter zipParSeq$(IterableSplitter $this, SeqSplitter that) {
        return $this.zipParSeq(that);
    }

    default public <S> IterableSplitter<Tuple2<T, S>> zipParSeq(SeqSplitter<S> that) {
        return new Zipped<S>(this, that);
    }

    public static ZippedAll zipAllParSeq$(IterableSplitter $this, SeqSplitter that, Object thisElem, Object thatElem) {
        return $this.zipAllParSeq(that, thisElem, thatElem);
    }

    default public <S, U, R> ZippedAll<U, R> zipAllParSeq(SeqSplitter<S> that, U thisElem, R thatElem) {
        return new ZippedAll<U, S>(this, that, thisElem, thatElem);
    }

    private static void appendln$1(ObjectRef output$1, String s) {
        String string2 = (String)output$1.elem + (s + "\n");
        output$1.elem = string2;
    }

    public static /* bridge */ /* synthetic */ IterableSplitter scala$collection$parallel$IterableSplitter$Taken$$_$split$$anonfun$adapted$1(Object p, Object n) {
        return ((IterableSplitter)p).take(BoxesRunTime.unboxToInt(n));
    }

    private static /* synthetic */ int $anonfun$3(int _$3, IterableSplitter _$4) {
        return _$3 + _$4.remaining();
    }

    public static /* bridge */ /* synthetic */ int scala$collection$parallel$IterableSplitter$Taken$$_$_$$anonfun$adapted$1(Object _$3, Object _$4) {
        return IterableSplitter.$anonfun$3(BoxesRunTime.unboxToInt(_$3), (IterableSplitter)_$4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static /* synthetic */ boolean scala$collection$parallel$IterableSplitter$Taken$$_$_$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) return false;
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        IterableSplitter it = (IterableSplitter)tuple2._1();
        if (tuple22 == null) return false;
        int from = BoxesRunTime.unboxToInt(tuple22._1());
        int until = BoxesRunTime.unboxToInt(tuple22._2());
        return true;
    }

    public static /* synthetic */ boolean scala$collection$parallel$IterableSplitter$Taken$$_$takeSeq$$anonfun$1(IterableSplitter _$5) {
        return _$5.remaining() > 0;
    }

    public static /* synthetic */ int scala$collection$parallel$IterableSplitter$Zipped$$_$_$$anonfun$2(IterableSplitter _$7) {
        return _$7.remaining();
    }

    public static /* synthetic */ IterableSplitter scala$collection$parallel$IterableSplitter$Zipped$$_$split$$anonfun$1(Tuple2 p) {
        return ((IterableSplitter)p._1()).zipParSeq((SeqSplitter)p._2());
    }

    public class Appended<U, PI extends IterableSplitter<U>>
    implements IterableSplitter<U> {
        private Signalling signalDelegate;
        private final IterableSplitter that;
        private IterableSplitter curr;
        private final IterableSplitter<T> $outer;

        public Appended(PI that) {
            this.that = that;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$(this);
            IterableOnceOps.$init$(this);
            Iterator.$init$(this);
            IterableSplitter.$init$(this);
            this.signalDelegate_$eq($outer.signalDelegate());
            this.curr = $outer;
        }

        @Override
        public Signalling signalDelegate() {
            return this.signalDelegate;
        }

        @Override
        public void signalDelegate_$eq(Signalling x$1) {
            this.signalDelegate = x$1;
        }

        public PI that() {
            return (PI)this.that;
        }

        public IterableSplitter<U> curr() {
            return this.curr;
        }

        public void curr_$eq(IterableSplitter<U> x$1) {
            this.curr = x$1;
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            if (this.curr().hasNext()) {
                bl = true;
            } else if (this.curr() == this.$outer) {
                this.curr_$eq((IterableSplitter<U>)this.that());
                bl = this.curr().hasNext();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public U next() {
            Object a;
            if (this.curr() == this.$outer) {
                this.hasNext();
                a = this.curr().next();
            } else {
                a = this.curr().next();
            }
            return (U)a;
        }

        @Override
        public int remaining() {
            return this.curr() == this.$outer ? this.curr().remaining() + this.that().remaining() : this.curr().remaining();
        }

        public boolean firstNonEmpty() {
            return this.curr() == this.$outer && this.curr().hasNext();
        }

        @Override
        public IterableSplitter<U> dup() {
            return this.$outer.dup().appendParIterable(this.that());
        }

        @Override
        public Seq<IterableSplitter<U>> split() {
            return this.firstNonEmpty() ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new IterableSplitter[]{this.curr(), this.that()})) : this.curr().split();
        }

        public final IterableSplitter<T> scala$collection$parallel$IterableSplitter$Appended$$$outer() {
            return this.$outer;
        }
    }

    public class Mapped<S>
    implements IterableSplitter<S> {
        private Signalling signalDelegate;
        private final Function1<T, S> f;
        private final IterableSplitter<T> $outer;

        public Mapped(IterableSplitter $outer, Function1<T, S> f) {
            this.f = f;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$(this);
            IterableOnceOps.$init$(this);
            Iterator.$init$(this);
            IterableSplitter.$init$(this);
            this.signalDelegate_$eq($outer.signalDelegate());
        }

        @Override
        public Signalling signalDelegate() {
            return this.signalDelegate;
        }

        @Override
        public void signalDelegate_$eq(Signalling x$1) {
            this.signalDelegate = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.$outer.hasNext();
        }

        @Override
        public S next() {
            return this.f.apply(this.$outer.next());
        }

        @Override
        public int remaining() {
            return this.$outer.remaining();
        }

        @Override
        public IterableSplitter<S> dup() {
            return this.$outer.dup().map(this.f);
        }

        @Override
        public Seq<IterableSplitter<S>> split() {
            return (Seq)this.$outer.split().map((Function1<IterableSplitter, IterableSplitter> & Serializable)(A _$6) -> _$6.map(this.f));
        }

        public final IterableSplitter<T> scala$collection$parallel$IterableSplitter$Mapped$$$outer() {
            return this.$outer;
        }
    }

    public class Taken
    implements IterableSplitter<T> {
        private Signalling signalDelegate;
        private final int taken;
        private int remaining;
        private final IterableSplitter<T> $outer;

        public Taken(IterableSplitter $outer, int taken) {
            this.taken = taken;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$(this);
            IterableOnceOps.$init$(this);
            Iterator.$init$(this);
            IterableSplitter.$init$(this);
            this.remaining = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(taken), $outer.remaining());
        }

        @Override
        public Signalling signalDelegate() {
            return this.signalDelegate;
        }

        @Override
        public void signalDelegate_$eq(Signalling x$1) {
            this.signalDelegate = x$1;
        }

        @Override
        public int remaining() {
            return this.remaining;
        }

        public void remaining_$eq(int x$1) {
            this.remaining = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.remaining() > 0;
        }

        @Override
        public T next() {
            this.remaining_$eq(this.remaining() - 1);
            return this.$outer.next();
        }

        @Override
        public IterableSplitter<T> dup() {
            return this.$outer.dup().take(this.taken);
        }

        @Override
        public Seq<IterableSplitter<T>> split() {
            return this.takeSeq(this.$outer.split(), IterableSplitter::scala$collection$parallel$IterableSplitter$Taken$$_$split$$anonfun$adapted$1);
        }

        public <PI extends IterableSplitter<T>> Seq<PI> takeSeq(Seq<PI> sq, Function2<PI, Object, PI> taker) {
            Seq sizes = (Seq)sq.scanLeft(BoxesRunTime.boxToInteger(0), IterableSplitter::scala$collection$parallel$IterableSplitter$Taken$$_$_$$anonfun$adapted$1);
            Seq shortened = (Seq)((IterableOps)sq.zip((IterableOnce)((IterableOps)sizes.init()).zip((IterableOnce)sizes.tail()))).withFilter(IterableSplitter::scala$collection$parallel$IterableSplitter$Taken$$_$_$$anonfun$1).map((Function1<Tuple2, IterableSplitter> & Serializable)(A x$1) -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) throw new MatchError(tuple2);
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                IterableSplitter it = (IterableSplitter)tuple2._1();
                if (tuple22 == null) throw new MatchError(tuple2);
                int from = BoxesRunTime.unboxToInt(tuple22._1());
                int until = BoxesRunTime.unboxToInt(tuple22._2());
                return until < this.remaining() ? it : (IterableSplitter)taker.apply(it, BoxesRunTime.boxToInteger(this.remaining() - from));
            });
            return (Seq)shortened.filter(IterableSplitter::scala$collection$parallel$IterableSplitter$Taken$$_$takeSeq$$anonfun$1);
        }

        public final IterableSplitter<T> scala$collection$parallel$IterableSplitter$Taken$$$outer() {
            return this.$outer;
        }
    }

    public class Zipped<S>
    implements IterableSplitter<Tuple2<T, S>> {
        private Signalling signalDelegate;
        private final SeqSplitter that;
        private final IterableSplitter<T> $outer;

        public Zipped(IterableSplitter $outer, SeqSplitter<S> that) {
            this.that = that;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$(this);
            IterableOnceOps.$init$(this);
            Iterator.$init$(this);
            IterableSplitter.$init$(this);
            this.signalDelegate_$eq($outer.signalDelegate());
        }

        @Override
        public Signalling signalDelegate() {
            return this.signalDelegate;
        }

        @Override
        public void signalDelegate_$eq(Signalling x$1) {
            this.signalDelegate = x$1;
        }

        public SeqSplitter<S> that() {
            return this.that;
        }

        @Override
        public boolean hasNext() {
            return this.$outer.hasNext() && this.that().hasNext();
        }

        @Override
        public Tuple2<T, S> next() {
            return Tuple2$.MODULE$.apply(this.$outer.next(), this.that().next());
        }

        @Override
        public int remaining() {
            return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.$outer.remaining()), this.that().remaining());
        }

        @Override
        public IterableSplitter<Tuple2<T, S>> dup() {
            return this.$outer.dup().zipParSeq(this.that());
        }

        @Override
        public Seq<IterableSplitter<Tuple2<T, S>>> split() {
            Seq selfs = this.$outer.split();
            Seq sizes = (Seq)selfs.map(IterableSplitter::scala$collection$parallel$IterableSplitter$Zipped$$_$_$$anonfun$2);
            Seq<SeqSplitter<S>> thats = this.that().psplit(sizes);
            return (Seq)((IterableOps)selfs.zip(thats)).map(IterableSplitter::scala$collection$parallel$IterableSplitter$Zipped$$_$split$$anonfun$1);
        }

        public final IterableSplitter<T> scala$collection$parallel$IterableSplitter$Zipped$$$outer() {
            return this.$outer;
        }
    }

    public class ZippedAll<U, S>
    implements IterableSplitter<Tuple2<U, S>> {
        private Signalling signalDelegate;
        private final SeqSplitter that;
        private final Object thiselem;
        private final Object thatelem;
        private final IterableSplitter<T> $outer;

        public ZippedAll(IterableSplitter $outer, SeqSplitter<S> that, U thiselem, S thatelem) {
            this.that = that;
            this.thiselem = thiselem;
            this.thatelem = thatelem;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$(this);
            IterableOnceOps.$init$(this);
            Iterator.$init$(this);
            IterableSplitter.$init$(this);
            this.signalDelegate_$eq($outer.signalDelegate());
        }

        @Override
        public Signalling signalDelegate() {
            return this.signalDelegate;
        }

        @Override
        public void signalDelegate_$eq(Signalling x$1) {
            this.signalDelegate = x$1;
        }

        public SeqSplitter<S> that() {
            return this.that;
        }

        public U thiselem() {
            return (U)this.thiselem;
        }

        public S thatelem() {
            return (S)this.thatelem;
        }

        @Override
        public boolean hasNext() {
            return this.$outer.hasNext() || this.that().hasNext();
        }

        @Override
        public Tuple2<U, S> next() {
            return this.$outer.hasNext() ? (this.that().hasNext() ? Tuple2$.MODULE$.apply(this.$outer.next(), this.that().next()) : Tuple2$.MODULE$.apply(this.$outer.next(), this.thatelem())) : Tuple2$.MODULE$.apply(this.thiselem(), this.that().next());
        }

        @Override
        public int remaining() {
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.$outer.remaining()), this.that().remaining());
        }

        @Override
        public IterableSplitter<Tuple2<U, S>> dup() {
            return this.$outer.dup().zipAllParSeq(this.that(), this.thiselem(), this.thatelem());
        }

        @Override
        public Seq<IterableSplitter<Tuple2<U, S>>> split() {
            int thatrem;
            int selfrem = this.$outer.remaining();
            IterableSplitter thisit = selfrem < (thatrem = this.that().remaining()) ? this.$outer.appendParIterable(package$.MODULE$.repetition(this.thiselem(), thatrem - selfrem).splitter()) : this.$outer;
            SeqSplitter<S> thatit = selfrem > thatrem ? this.that().appendParSeq(package$.MODULE$.repetition(this.thatelem(), selfrem - thatrem).splitter()) : this.that();
            IterableSplitter zipped = thisit.zipParSeq(thatit);
            return zipped.split();
        }

        public final IterableSplitter<T> scala$collection$parallel$IterableSplitter$ZippedAll$$$outer() {
            return this.$outer;
        }
    }
}

