/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.parallel.mutable;

import scala.collection.DebugUtils$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.generic.Signalling;
import scala.collection.immutable.Seq;
import scala.collection.mutable.FlatHashTable;
import scala.collection.parallel.IterableSplitter;
import scala.collection.parallel.mutable.SizeMapUtils;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public interface ParFlatHashTable<T>
extends FlatHashTable<T> {
    public static boolean alwaysInitSizeMap$(ParFlatHashTable $this) {
        return $this.alwaysInitSizeMap();
    }

    @Override
    default public boolean alwaysInitSizeMap() {
        return true;
    }

    public abstract class ParFlatHashTableIterator
    implements IterableSplitter<T>,
    SizeMapUtils {
        private Signalling signalDelegate;
        private int idx;
        private final int until;
        private final int totalsize;
        private int traversed;
        private final Object[] itertable;
        private final ParFlatHashTable<T> $outer;

        public ParFlatHashTableIterator(ParFlatHashTable $outer, int idx, int until, int totalsize) {
            this.idx = idx;
            this.until = until;
            this.totalsize = totalsize;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$(this);
            IterableOnceOps.$init$(this);
            Iterator.$init$(this);
            IterableSplitter.$init$(this);
            this.traversed = 0;
            this.itertable = $outer.table();
            if (this.hasNext()) {
                this.scan();
            }
        }

        @Override
        public Signalling signalDelegate() {
            return this.signalDelegate;
        }

        @Override
        public void signalDelegate_$eq(Signalling x$1) {
            this.signalDelegate = x$1;
        }

        public int idx() {
            return this.idx;
        }

        public void idx_$eq(int x$1) {
            this.idx = x$1;
        }

        public int until() {
            return this.until;
        }

        public int totalsize() {
            return this.totalsize;
        }

        private void scan() {
            while (this.itertable[this.idx()] == null) {
                this.idx_$eq(this.idx() + 1);
            }
        }

        public abstract IterableSplitter<T> newIterator(int var1, int var2, int var3);

        @Override
        public int remaining() {
            return this.totalsize() - this.traversed;
        }

        @Override
        public boolean hasNext() {
            return this.traversed < this.totalsize();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            Object a;
            if (this.hasNext()) {
                void var1_1;
                Object r = this.$outer.entryToElem(this.itertable[this.idx()]);
                ++this.traversed;
                this.idx_$eq(this.idx() + 1);
                if (this.hasNext()) {
                    this.scan();
                }
                a = var1_1;
            } else {
                a = Iterator$.MODULE$.empty().next();
            }
            return a;
        }

        @Override
        public IterableSplitter<T> dup() {
            return this.newIterator(this.idx(), this.until(), this.totalsize());
        }

        @Override
        public Seq<IterableSplitter<T>> split() {
            Seq seq;
            if (this.remaining() > 1) {
                int divpt = (this.until() + this.idx()) / 2;
                int fstidx = this.idx();
                int fstuntil = divpt;
                int fsttotal = this.calcNumElems(this.idx(), divpt, this.itertable.length, this.$outer.sizeMapBucketSize());
                IterableSplitter fstit = this.newIterator(fstidx, fstuntil, fsttotal);
                int sndidx = divpt;
                int snduntil = this.until();
                int sndtotal = this.remaining() - fsttotal;
                IterableSplitter sndit = this.newIterator(sndidx, snduntil, sndtotal);
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new IterableSplitter[]{fstit, sndit}));
            } else {
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new ParFlatHashTableIterator[]{this}));
            }
            return seq;
        }

        @Override
        public String debugInformation() {
            return this.buildString((T1 append) -> {
                append.apply("Parallel flat hash table iterator");
                append.apply("---------------------------------");
                append.apply("Traversed/total: " + this.traversed + " / " + this.totalsize());
                append.apply("Table idx/until: " + this.idx() + " / " + this.until());
                append.apply("Table length: " + this.itertable.length);
                append.apply("Table: ");
                append.apply(DebugUtils$.MODULE$.arrayString(this.itertable, 0, this.itertable.length));
                append.apply("Sizemap: ");
                append.apply(DebugUtils$.MODULE$.arrayString(this.$outer.sizemap(), 0, this.$outer.sizemap().length));
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int countElems(int from, int until) {
            void var3_3;
            int count = 0;
            for (int i = from; i < until; ++i) {
                if (this.itertable[i] == null) continue;
                ++count;
            }
            return (int)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int countBucketSizes(int frombucket, int untilbucket) {
            void var3_3;
            int count = 0;
            for (int i = frombucket; i < untilbucket; ++i) {
                count += this.$outer.sizemap()[i];
            }
            return (int)var3_3;
        }

        public final ParFlatHashTable<T> scala$collection$parallel$mutable$ParFlatHashTable$ParFlatHashTableIterator$$$outer() {
            return this.$outer;
        }
    }
}

