/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.parallel.mutable;

import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable;
import scala.collection.mutable.HashTable$;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.parallel.BucketCombiner;
import scala.collection.parallel.Task;
import scala.collection.parallel.mutable.ParHashMap;
import scala.collection.parallel.mutable.ParHashMapCombiner$;
import scala.collection.parallel.mutable.ParHashMapCombiner$newTable$1$;
import scala.collection.parallel.mutable.ParHashTable;
import scala.collection.parallel.mutable.WithContents;
import scala.collection.parallel.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public abstract class ParHashMapCombiner<K, V>
extends BucketCombiner<Tuple2<K, V>, ParHashMap<K, V>, ParHashMap.DefaultEntry<K, V>, ParHashMapCombiner<K, V>>
implements HashTable.HashUtils<K> {
    private final int tableLoadFactor;
    private final int nonmasklen;
    private final int seedvalue;

    public static <K, V> ParHashMapCombiner<K, V> apply() {
        return ParHashMapCombiner$.MODULE$.apply();
    }

    public static int discriminantbits() {
        return ParHashMapCombiner$.MODULE$.discriminantbits();
    }

    public static int discriminantmask() {
        return ParHashMapCombiner$.MODULE$.discriminantmask();
    }

    public static int nonmasklength() {
        return ParHashMapCombiner$.MODULE$.nonmasklength();
    }

    public static int numblocks() {
        return ParHashMapCombiner$.MODULE$.numblocks();
    }

    public ParHashMapCombiner(int tableLoadFactor) {
        this.tableLoadFactor = tableLoadFactor;
        super(ParHashMapCombiner$.MODULE$.numblocks());
        HashTable.HashUtils.$init$(this);
        this.nonmasklen = ParHashMapCombiner$.MODULE$.nonmasklength();
        this.seedvalue = 27;
    }

    private int tableLoadFactor() {
        return this.tableLoadFactor;
    }

    public ParHashMapCombiner addOne(Tuple2<K, V> elem) {
        this.sz_$eq(this.sz() + 1);
        int hc = this.improve(this.elemHashCode(elem._1()), this.seedvalue);
        int pos = hc >>> this.nonmasklen;
        if (this.buckets()[pos] == null) {
            this.buckets()[pos] = new UnrolledBuffer(ClassTag$.MODULE$.apply(ParHashMap.DefaultEntry.class));
        }
        this.buckets()[pos].$plus$eq(new ParHashMap.DefaultEntry<K, V>(elem._1(), elem._2()));
        return this;
    }

    @Override
    public ParHashMap<K, V> result() {
        ParHashMap parHashMap;
        if (this.size() >= ParHashMapCombiner$.MODULE$.numblocks() * this.sizeMapBucketSize()) {
            AddingHashTable table = new AddingHashTable(this, this.size(), this.tableLoadFactor(), this.seedvalue);
            Object object = Predef$.MODULE$.refArrayOps(this.buckets());
            UnrolledBuffer.Unrolled[] bucks = (UnrolledBuffer.Unrolled[])ArrayOps$.MODULE$.map$extension(object, (Function1<UnrolledBuffer, UnrolledBuffer.Unrolled> & Serializable)b -> b != null ? b.headPtr() : null, ClassTag$.MODULE$.apply(UnrolledBuffer.Unrolled.class));
            int insertcount = BoxesRunTime.unboxToInt(this.combinerTaskSupport().executeAndWaitResult(new FillBlocks(this, bucks, table, 0, bucks.length)));
            table.setSize(insertcount);
            ParHashTable.Contents c = table.hashTableContents();
            parHashMap = new ParHashMap(c);
        } else {
            LazyRef lazyRef = new LazyRef();
            for (int i = 0; i < ParHashMapCombiner$.MODULE$.numblocks(); ++i) {
                if (this.buckets()[i] == null) continue;
                this.buckets()[i].foreach(elem -> ParHashMapCombiner.newTable$1(lazyRef).insertEntry((ParHashMap.DefaultEntry)elem));
            }
            parHashMap = new ParHashMap(ParHashMapCombiner.newTable$1(lazyRef).hashTableContents());
        }
        return parHashMap;
    }

    private static final ParHashMapCombiner$newTable$1$ newTable$lzyINIT1$1(LazyRef newTable$lzy1$1) {
        ParHashMapCombiner$newTable$1$ parHashMapCombiner$newTable$1$;
        LazyRef lazyRef = newTable$lzy1$1;
        synchronized (lazyRef) {
            parHashMapCombiner$newTable$1$ = (ParHashMapCombiner$newTable$1$)(newTable$lzy1$1.initialized() ? newTable$lzy1$1.value() : newTable$lzy1$1.initialize(new ParHashMapCombiner$newTable$1$()));
        }
        return parHashMapCombiner$newTable$1$;
    }

    private static final ParHashMapCombiner$newTable$1$ newTable$1(LazyRef newTable$lzy1$2) {
        return (ParHashMapCombiner$newTable$1$)(newTable$lzy1$2.initialized() ? newTable$lzy1$2.value() : ParHashMapCombiner.newTable$lzyINIT1$1(newTable$lzy1$2));
    }

    public class AddingHashTable
    implements HashTable<K, V, ParHashMap.DefaultEntry<K, V>>,
    WithContents<K, V, ParHashMap.DefaultEntry<K, V>> {
        private int _loadFactor;
        private HashEntry[] table;
        private int tableSize;
        private int threshold;
        private int[] sizemap;
        private int seedvalue;
        private final ParHashMapCombiner<K, V> $outer;

        public AddingHashTable(ParHashMapCombiner $outer, int numelems, int lf, int _seedvalue) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            HashTable.HashUtils.$init$(this);
            HashTable.$init$(this);
            this._loadFactor_$eq(lf);
            this.table_$eq(new HashEntry[HashTable$.MODULE$.capacity(HashTable$.MODULE$.sizeForThreshold(this._loadFactor(), numelems))]);
            this.tableSize_$eq(0);
            this.seedvalue_$eq(_seedvalue);
            this.threshold_$eq(HashTable$.MODULE$.newThreshold(this._loadFactor(), this.table().length));
            this.sizeMapInit(this.table().length);
        }

        @Override
        public int _loadFactor() {
            return this._loadFactor;
        }

        @Override
        public HashEntry[] table() {
            return this.table;
        }

        @Override
        public int tableSize() {
            return this.tableSize;
        }

        @Override
        public int threshold() {
            return this.threshold;
        }

        @Override
        public int[] sizemap() {
            return this.sizemap;
        }

        @Override
        public int seedvalue() {
            return this.seedvalue;
        }

        @Override
        public void _loadFactor_$eq(int x$1) {
            this._loadFactor = x$1;
        }

        @Override
        public void table_$eq(HashEntry[] x$1) {
            this.table = x$1;
        }

        @Override
        public void tableSize_$eq(int x$1) {
            this.tableSize = x$1;
        }

        @Override
        public void threshold_$eq(int x$1) {
            this.threshold = x$1;
        }

        @Override
        public void sizemap_$eq(int[] x$1) {
            this.sizemap = x$1;
        }

        @Override
        public void seedvalue_$eq(int x$1) {
            this.seedvalue = x$1;
        }

        public void setSize(int sz) {
            this.tableSize_$eq(sz);
        }

        public boolean insertEntry(ParHashMap.DefaultEntry<K, V> e) {
            boolean bl;
            ParHashMap.DefaultEntry olde;
            int h = this.index(this.elemHashCode(e.key()));
            ParHashMap.DefaultEntry ce = olde = (ParHashMap.DefaultEntry)this.table()[h];
            while (ce != null) {
                if (BoxesRunTime.equals(ce.key(), e.key())) {
                    h = -1;
                    ce = null;
                    continue;
                }
                ce = (ParHashMap.DefaultEntry)ce.next();
            }
            if (h != -1) {
                e.next_$eq(olde);
                this.table()[h] = e;
                this.nnSizeMapAdd(h);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public ParHashMap.DefaultEntry<K, V> createNewEntry(K key, V x) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        public final ParHashMapCombiner<K, V> scala$collection$parallel$mutable$ParHashMapCombiner$AddingHashTable$$$outer() {
            return this.$outer;
        }
    }

    public class FillBlocks
    implements Task<Object, FillBlocks> {
        private volatile Throwable throwable;
        private final UnrolledBuffer.Unrolled<ParHashMap.DefaultEntry<K, V>>[] buckets;
        private final AddingHashTable table;
        private final int offset;
        private final int howmany;
        private int result;
        private final ParHashMapCombiner<K, V> $outer;

        public FillBlocks(ParHashMapCombiner $outer, UnrolledBuffer.Unrolled<ParHashMap.DefaultEntry<K, V>>[] buckets, AddingHashTable table, int offset, int howmany) {
            this.buckets = buckets;
            this.table = table;
            this.offset = offset;
            this.howmany = howmany;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Task.$init$(this);
            this.result = Integer.MIN_VALUE;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public void throwable_$eq(Throwable x$1) {
            this.throwable = x$1;
        }

        @Override
        public int result() {
            return this.result;
        }

        @Override
        public void result_$eq(int x$1) {
            this.result = x$1;
        }

        @Override
        public void leaf(Option<Object> prev) {
            int until = this.offset + this.howmany;
            this.result_$eq(0);
            for (int i = this.offset; i < until; ++i) {
                this.result_$eq(this.result() + this.fillBlock(i, this.buckets[i]));
            }
        }

        /*
         * WARNING - void declaration
         */
        private int fillBlock(int block, UnrolledBuffer.Unrolled<ParHashMap.DefaultEntry<K, V>> elems) {
            void var3_3;
            int insertcount = 0;
            int i = 0;
            AddingHashTable t = this.table;
            for (UnrolledBuffer.Unrolled unrolled = elems; unrolled != null; unrolled = unrolled.next()) {
                ParHashMap.DefaultEntry[] chunkarr = (ParHashMap.DefaultEntry[])unrolled.array();
                int chunksz = unrolled.size();
                while (i < chunksz) {
                    ParHashMap.DefaultEntry elem = chunkarr[i];
                    if (t.insertEntry(elem)) {
                        ++insertcount;
                    }
                    ++i;
                }
                i = 0;
            }
            return (int)var3_3;
        }

        @Override
        public Seq<Task<Object, FillBlocks>> split() {
            int fp = this.howmany / 2;
            return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new FillBlocks[]{new FillBlocks(this.$outer, this.buckets, this.table, this.offset, fp), new FillBlocks(this.$outer, this.buckets, this.table, this.offset + fp, this.howmany - fp)}));
        }

        public void merge(FillBlocks that) {
            this.result_$eq(this.result() + that.result());
        }

        @Override
        public boolean shouldSplitFurther() {
            return this.howmany > package$.MODULE$.thresholdFromSize(ParHashMapCombiner$.MODULE$.numblocks(), this.$outer.combinerTaskSupport().parallelismLevel());
        }

        public final ParHashMapCombiner<K, V> scala$collection$parallel$mutable$ParHashMapCombiner$FillBlocks$$$outer() {
            return this.$outer;
        }
    }
}

