/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.networkservice;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.openmole.core.exception.InternalProcessingError;
import org.openmole.core.exception.InternalProcessingError$;
import org.openmole.core.networkservice.NetworkService;
import org.openmole.core.networkservice.NetworkService$HttpHost$;
import org.openmole.core.preference.ClearPreferenceLocation;
import org.openmole.core.preference.ConfigurationString;
import org.openmole.core.preference.Preference;
import org.openmole.core.preference.PreferenceLocation$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class NetworkService$
implements Serializable {
    private static final ClearPreferenceLocation<Object> httpProxyEnabled;
    private static final ClearPreferenceLocation<String> httpProxyURI;
    public static final NetworkService$HttpHost$ HttpHost;
    public static final NetworkService$ MODULE$;

    private NetworkService$() {
    }

    static {
        MODULE$ = new NetworkService$();
        httpProxyEnabled = PreferenceLocation$.MODULE$.apply("NetworkService", "HttpProxyEnabled", MODULE$::$init$$$anonfun$1);
        httpProxyURI = PreferenceLocation$.MODULE$.apply("NetworkService", "httpProxyURI", MODULE$::$init$$$anonfun$2);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NetworkService$.class);
    }

    public ClearPreferenceLocation<Object> httpProxyEnabled() {
        return httpProxyEnabled;
    }

    public ClearPreferenceLocation<String> httpProxyURI() {
        return httpProxyURI;
    }

    public Option<NetworkService.HttpHost> httpHostFromPreferences(Preference preference) {
        Option hostURIOpt;
        Option isEnabledOpt = preference.preferenceOption(this.httpProxyEnabled(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Boolean$.MODULE$);
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)isEnabledOpt, (Object)(hostURIOpt = preference.preferenceOption(this.httpProxyURI(), (ConfigurationString)ConfigurationString.given_ConfigurationString_String$.MODULE$)));
        if (tuple2 != null) {
            Some some;
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some && !BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()) || None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                String string;
                String hostURI;
                Some some2 = (Some)option2;
                String string2 = (String)some2.value();
                if (string2 != null && (hostURI = (string = string2)).trim().isEmpty()) {
                    return None$.MODULE$;
                }
                String hostURI2 = string2;
                return Some$.MODULE$.apply((Object)NetworkService$HttpHost$.MODULE$.apply(hostURI2));
            }
        }
        return None$.MODULE$;
    }

    public NetworkService apply(Option<String> hostURI, Preference preference) {
        return new NetworkService((Option<NetworkService.HttpHost>)hostURI.map((Function1 & Serializable)_$1 -> NetworkService$HttpHost$.MODULE$.apply((String)_$1)).orElse(() -> NetworkService$.apply$$anonfun$2(preference)));
    }

    public String get(String url, Seq<Tuple2<String, String>> headers, NetworkService networkService) {
        InputStream is = this.getInputStream(url, headers, networkService);
        String res = Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
        is.close();
        return res;
    }

    public Seq<Tuple2<String, String>> get$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private CloseableHttpClient newClient(NetworkService networkService) {
        Some some;
        NetworkService.HttpHost httpHost;
        Option<NetworkService.HttpHost> option = networkService.httpProxy();
        if (option instanceof Some && (httpHost = (NetworkService.HttpHost)(some = (Some)option).value()) != null) {
            NetworkService.HttpHost httpHost2;
            NetworkService.HttpHost httpHost3 = httpHost2 = httpHost;
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager()).setProxy(httpHost3.toHost()).build();
        }
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager()).build();
    }

    public <T> T withResponse(String url, Seq<Tuple2<String, String>> headers, Function1<CloseableHttpResponse, T> f, NetworkService x$4) {
        Object object;
        CloseableHttpClient client = this.newClient(x$4);
        HttpGet getReq = new HttpGet(url);
        headers.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            String k = (String)x$1._1();
            String v = (String)x$1._2();
            getReq.setHeader((Header)new BasicHeader(k, v));
        });
        try {
            try (CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)getReq);){
                object = f.apply((Object)httpResponse);
            }
            catch (Throwable t) {
                throw new InternalProcessingError("HTTP GET for " + url + " failed", t);
            }
        }
        finally {
            client.close();
        }
        return (T)object;
    }

    public <T> Seq<Tuple2<String, String>> withResponse$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public InputStream getInputStream(String url, Seq<Tuple2<String, String>> headers, NetworkService x$3) {
        InputStream inputStream;
        CloseableHttpClient client = this.newClient(x$3);
        HttpGet getReq = new HttpGet(url);
        headers.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            String k = (String)x$1._1();
            String v = (String)x$1._2();
            getReq.setHeader((Header)new BasicHeader(k, v));
        });
        try {
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)getReq);
            if (httpResponse.getStatusLine().getStatusCode() >= 300) {
                throw new InternalProcessingError("HTTP GET for " + url + " responded with " + httpResponse, InternalProcessingError$.MODULE$.$lessinit$greater$default$2());
            }
            inputStream = httpResponse.getEntity().getContent();
        }
        catch (Throwable t) {
            throw new InternalProcessingError("HTTP GET for " + url + " failed", t);
        }
        return inputStream;
    }

    public Seq<Tuple2<String, String>> getInputStream$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public String urlProtocol(String url) {
        return new URI(url).getScheme();
    }

    public Seq<Tuple2<String, String>> proxyVariables(NetworkService networkService) {
        Option<NetworkService.HttpHost> option = networkService.httpProxy();
        if (option instanceof Some) {
            Some some = (Some)option;
            NetworkService.HttpHost proxy = (NetworkService.HttpHost)some.value();
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"http_proxy");
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"HTTP_PROXY");
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"https_proxy");
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"HTTPS_PROXY");
            return (Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)proxy.hostURI()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)proxy.hostURI()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)proxy.hostURI()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)proxy.hostURI()), (List)Nil$.MODULE$)))));
        }
        if (None$.MODULE$.equals(option)) {
            return (Seq)((SeqOps)Nil$.MODULE$);
        }
        throw new MatchError(option);
    }

    private final Option $init$$$anonfun$1() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    private final Option $init$$$anonfun$2() {
        return Option$.MODULE$.empty();
    }

    private static final Option apply$$anonfun$2(Preference preference$1) {
        return MODULE$.httpHostFromPreferences(preference$1);
    }
}

