/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.launcher;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class Launcher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        File file = null;
        String string = null;
        String string2 = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        String[] stringArray2 = new String[]{};
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].contentEquals("--plugins")) {
                file = new File(stringArray[++n]);
                ++n;
                continue;
            }
            if (stringArray[n].contentEquals("--run")) {
                string = stringArray[++n];
                ++n;
                continue;
            }
            if (stringArray[n].contentEquals("--osgi-directory")) {
                string2 = stringArray[++n];
                ++n;
                continue;
            }
            if (stringArray[n].contentEquals("--priority")) {
                linkedList.add(stringArray[++n]);
                ++n;
                continue;
            }
            if (stringArray[n].contentEquals("--")) {
                stringArray2 = Arrays.copyOfRange(stringArray, ++n, stringArray.length);
                break;
            }
            ++n;
        }
        FrameworkFactory frameworkFactory = ServiceLoader.load(FrameworkFactory.class).iterator().next();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("org.osgi.framework.storage", "");
        hashMap.put("org.osgi.framework.storage.clean", "true");
        hashMap.put("org.osgi.framework.bootdelegation", "*");
        hashMap.put("felix.cache.locking", "false");
        hashMap.put("felix.resolver.parallelism", "1");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 50;
        for (int i = 0; i <= n2; ++i) {
            stringBuffer.append("1." + i + ",");
            stringBuffer.append("1." + i + ".0,");
            stringBuffer.append(i);
            stringBuffer2.append("J2SE-1." + i + ",");
            stringBuffer2.append("JavaSE-1." + i + ",");
            stringBuffer2.append("JavaSE-1." + i + ".0");
            if (i == n2) continue;
            stringBuffer.append(",");
            stringBuffer2.append(",");
        }
        hashMap.put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"JavaSE\";version:List=\"" + stringBuffer.toString() + "\"");
        hashMap.put("org.osgi.framework.executionenvironment", stringBuffer2.toString() + "CDC-1.1/Foundation-1.1,CDC-1.0/Foundation-1.0,J2ME,OSGi/Minimum-1.1,OSGi/Minimum-1.0");
        if (string2 != null) {
            hashMap.put("org.osgi.framework.storage", string2);
        }
        Framework framework = frameworkFactory.newFramework(hashMap);
        int n3 = 127;
        try {
            if (string == null) {
                throw new RuntimeException("Missing run class argument");
            }
            if (file == null) {
                throw new RuntimeException("Missing plugin directory argument");
            }
            if (!file.exists()) {
                throw new RuntimeException("Plugin directory does not exist");
            }
            framework.init();
            BundleContext bundleContext = framework.getBundleContext();
            LinkedList<Bundle> linkedList2 = new LinkedList<Bundle>();
            for (File serializable : file.listFiles()) {
                Bundle bundle = bundleContext.installBundle(serializable.toURI().toString());
                if (bundle.getSymbolicName() == null) {
                    throw new RuntimeException("Bundle " + String.valueOf(serializable) + " has no symbolic name");
                }
                linkedList2.add(bundle);
            }
            for (String string3 : linkedList) {
                for (Bundle bundle : linkedList2) {
                    if (!bundle.getSymbolicName().contains(string3)) continue;
                    bundle.start();
                }
            }
            framework.start();
            for (Bundle bundle : linkedList2) {
                bundle.start();
            }
            Object object = null;
            for (Bundle bundle : linkedList2) {
                try {
                    Class clazz = bundle.loadClass(string);
                    object = clazz;
                }
                catch (Exception exception) {}
            }
            if (object == null) {
                throw new RuntimeException("Class " + string + " has not been found");
            }
            Method method = ((Class)object).getDeclaredMethod("run", String[].class);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new RuntimeException("Run method should be static");
            }
            if (!Integer.TYPE.isAssignableFrom(method.getReturnType())) {
                throw new RuntimeException("Run method " + String.valueOf(method) + " returns " + String.valueOf(method.getReturnType()) + ", it should return int");
            }
            n3 = (Integer)method.invoke(null, new Object[]{stringArray2});
            framework.stop();
            framework.waitForStop(0L);
        }
        catch (Throwable throwable) {
            Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, "Error in osgi launcher", throwable);
        }
        finally {
            if (string2 != null) {
                try {
                    Launcher.deleteDir(new File(string2).toPath());
                }
                catch (IOException iOException) {
                    Logger.getLogger(Launcher.class.getName()).log(Level.WARNING, "Error cleaning the osgi directory", iOException);
                }
            }
        }
        System.exit(n3);
    }

    static void deleteDir(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

