/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.batch.storage;

import gridscale.package;
import java.io.Serializable;
import java.util.UUID;
import org.openmole.core.exception.InternalProcessingError;
import org.openmole.core.preference.ClearPreferenceLocation;
import org.openmole.core.preference.ConfigurationString;
import org.openmole.core.preference.Preference;
import org.openmole.core.preference.Preference$;
import org.openmole.core.preference.PreferenceLocation$;
import org.openmole.core.replication.ReplicaCatalog$;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment;
import org.openmole.plugin.environment.batch.storage.HierarchicalStorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageService$;
import org.openmole.plugin.environment.batch.storage.StorageSpace;
import org.openmole.plugin.environment.batch.storage.StorageSpace$;
import org.openmole.tool.encoding.Base36$;
import org.openmole.tool.logger.JavaLogger;
import org.openmole.tool.logger.JavaLogger$Log$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import squants.time.Time;
import squants.time.TimeConversions$;

public final class HierarchicalStorageSpace$
implements JavaLogger,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(HierarchicalStorageSpace$.class.getDeclaredField("Log$lzy1"));
    private volatile Object Log$lzy1;
    private static final ClearPreferenceLocation<Time> TmpDirRemoval;
    private static final ClearPreferenceLocation<Time> TmpDirCreation;
    public static final HierarchicalStorageSpace$ MODULE$;

    private HierarchicalStorageSpace$() {
    }

    static {
        MODULE$ = new HierarchicalStorageSpace$();
        TmpDirRemoval = PreferenceLocation$.MODULE$.apply("StorageService", "TmpDirRemoval", MODULE$::$init$$$anonfun$1);
        TmpDirCreation = PreferenceLocation$.MODULE$.apply("StorageService", "TmpDirCreation", MODULE$::$init$$$anonfun$2);
    }

    public final JavaLogger$Log$ Log() {
        Object object = this.Log$lzy1;
        if (object instanceof JavaLogger$Log$) {
            return (JavaLogger$Log$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JavaLogger$Log$)this.Log$lzyINIT1();
    }

    private Object Log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JavaLogger$Log$ javaLogger$Log$ = null;
                    try {
                        javaLogger$Log$ = new JavaLogger$Log$((JavaLogger)this);
                        object2 = javaLogger$Log$ == null ? LazyVals.NullValue$.MODULE$ : javaLogger$Log$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return javaLogger$Log$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HierarchicalStorageSpace$.class);
    }

    public ClearPreferenceLocation<Time> TmpDirRemoval() {
        return TmpDirRemoval;
    }

    public ClearPreferenceLocation<Time> TmpDirCreation() {
        return TmpDirCreation;
    }

    public <S> StorageSpace create(S s, String root, Function1<Throwable, Object> isConnectionError, HierarchicalStorageInterface<S> storageInterface, Preference preference, Object priority) {
        String string;
        String persistent = "persistent/";
        String tmp = "tmp/";
        try {
            string = this.createBasePath(s, root, isConnectionError, storageInterface, storageInterface, preference, priority);
        }
        catch (Throwable e) {
            throw new InternalProcessingError("Error creating base directory " + root + " on storage " + s, e);
        }
        String baseDirectory = string;
        String replicaDirectory = storageInterface.child(s, baseDirectory, persistent, priority);
        try {
            if (!storageInterface.exists(s, replicaDirectory, priority)) {
                storageInterface.makeDir(s, replicaDirectory, priority);
            }
        }
        catch (Throwable e) {
            throw new InternalProcessingError("Error creating replica directory " + replicaDirectory + " on storage " + s, e);
        }
        String tmpDirectory = storageInterface.child(s, baseDirectory, tmp, priority);
        try {
            if (!storageInterface.exists(s, tmpDirectory, priority)) {
                storageInterface.makeDir(s, tmpDirectory, priority);
            }
        }
        catch (Throwable e) {
            throw new InternalProcessingError("Error creating tmp directory " + tmpDirectory + " on storage " + s, e);
        }
        return StorageSpace$.MODULE$.apply(baseDirectory, replicaDirectory, tmpDirectory);
    }

    public <S> void clean(S s, StorageSpace storageSpace, boolean background, HierarchicalStorageInterface<S> hierarchicalStorageInterface, BatchEnvironment.Services services, Object priority) {
        services.replicaCatalog().clean(hierarchicalStorageInterface.id(s), (Function1)(JProcedure1 & Serializable)_$1 -> StorageService$.MODULE$.rmFile(s, (String)_$1, hierarchicalStorageInterface, priority));
        this.cleanReplicaDirectory(s, storageSpace.replicaDirectory(), hierarchicalStorageInterface.id(s), background, services, hierarchicalStorageInterface, hierarchicalStorageInterface, priority);
        this.cleanTmpDirectory(s, storageSpace.tmpDirectory(), background, hierarchicalStorageInterface, services, priority);
    }

    public <T> void ignoreErrors(Function0<T> f) {
        Try$.MODULE$.apply(f);
    }

    public <S> void cleanTmpDirectory(S s, String tmpDirectory, boolean background, HierarchicalStorageInterface<S> hierarchicalStorageInterface, BatchEnvironment.Services services, Object priority) {
        Seq<package.ListEntry> entries = hierarchicalStorageInterface.list(s, tmpDirectory, priority);
        long removalDate = System.currentTimeMillis() - TimeConversions$.MODULE$.timeToScalaDuration((Time)services.preference().apply(this.TmpDirRemoval(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Time$.MODULE$)).toMillis();
        entries.withFilter((Function1 & Serializable)entry -> this.remove$1(removalDate, entry.name())).foreach((Function1)(JProcedure1 & Serializable)entry -> {
            String path = StorageService$.MODULE$.child(s, tmpDirectory, entry.name(), hierarchicalStorageInterface, priority);
            package.FileType fileType = entry.type();
            package.FileType fileType2 = package.FileType$.Directory;
            if (!(fileType != null ? !fileType.equals(fileType2) : fileType2 != null)) {
                MODULE$.ignoreErrors((Function0 & Serializable)() -> {
                    HierarchicalStorageSpace$.cleanTmpDirectory$$anonfun$2$$anonfun$1(s, path, background, services, hierarchicalStorageInterface, priority);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            MODULE$.ignoreErrors((Function0 & Serializable)() -> {
                HierarchicalStorageSpace$.cleanTmpDirectory$$anonfun$2$$anonfun$2(s, path, background, hierarchicalStorageInterface, services, priority);
                return BoxedUnit.UNIT;
            });
        });
    }

    public <S> void cleanReplicaDirectory(S s, String persistentPath, String storageId, boolean background, BatchEnvironment.Services services, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface, Object priority) {
        Seq<package.ListEntry> entries = hierarchicalStorageInterface.list(s, persistentPath, priority);
        Set inReplica = ((IterableOnceOps)services.replicaCatalog().forPaths((Seq)entries.map((Function1 & Serializable)e -> StorageService$.MODULE$.child(s, persistentPath, e.name(), hierarchicalStorageInterface, priority)), (Seq)((SeqOps)new .colon.colon((Object)storageId, (List)Nil$.MODULE$))).map((Function1 & Serializable)_$2 -> _$2.path())).toSet();
        entries.withFilter((Function1 & Serializable)e -> this.graceIsOver$1(services, e.name())).foreach((Function1)(JProcedure1 & Serializable)e -> {
            String path = StorageService$.MODULE$.child(s, persistentPath, e.name(), hierarchicalStorageInterface, priority);
            if (!inReplica.contains((Object)path)) {
                package.FileType fileType = e.type();
                package.FileType fileType2 = package.FileType$.Directory;
                if (!(fileType != null ? !fileType.equals(fileType2) : fileType2 != null)) {
                    MODULE$.ignoreErrors((Function0 & Serializable)() -> {
                        HierarchicalStorageSpace$.cleanReplicaDirectory$$anonfun$2$$anonfun$1(s, path, background, services, hierarchicalStorageInterface, priority);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
                MODULE$.ignoreErrors((Function0 & Serializable)() -> {
                    HierarchicalStorageSpace$.cleanReplicaDirectory$$anonfun$2$$anonfun$2(s, path, background, storageInterface, services, priority);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    public <S> String createBasePath(S s, String root, Function1<Throwable, Object> isConnectionError, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface, Preference preference, Object priority) {
        String rootPath = this.mkRootDir$1(root, hierarchicalStorageInterface, s, priority, isConnectionError);
        String basePath = StorageService$.MODULE$.child(s, rootPath, this.baseDirName$1(preference), hierarchicalStorageInterface, priority);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            HierarchicalStorageSpace$.createBasePath$$anonfun$1(hierarchicalStorageInterface, s, basePath, priority);
            return BoxedUnit.UNIT;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            return basePath;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (BoxesRunTime.unboxToBoolean((Object)isConnectionError.apply((Object)e))) {
                throw e;
            }
            if (storageInterface.exists(s, basePath, priority)) {
                return basePath;
            }
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public <S> String createJobDirectory(S s, StorageSpace storageSpace, HierarchicalStorageInterface<S> hierarchicalStorageInterface, Preference preference, Object priority) {
        String intervalDirectory = hierarchicalStorageInterface.child(s, storageSpace.tmpDirectory(), StorageSpace$.MODULE$.lastBegining((Time)preference.apply(this.TmpDirCreation(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Time$.MODULE$)), priority);
        this.ignoreErrors((Function0 & Serializable)() -> {
            HierarchicalStorageSpace$.createJobDirectory$$anonfun$1(hierarchicalStorageInterface, s, intervalDirectory, priority);
            return BoxedUnit.UNIT;
        });
        String communicationPath = hierarchicalStorageInterface.child(s, intervalDirectory, StorageSpace$.MODULE$.timedUniqName(), priority);
        hierarchicalStorageInterface.makeDir(s, communicationPath, priority);
        return communicationPath;
    }

    private final Option $init$$$anonfun$1() {
        return Some$.MODULE$.apply((Object)TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)15), (Numeric)Numeric.IntIsIntegral$.MODULE$).days());
    }

    private final Option $init$$$anonfun$2() {
        return Some$.MODULE$.apply((Object)TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).hours());
    }

    private final boolean remove$1(long removalDate$1, String name) {
        Option<Object> option = StorageSpace$.MODULE$.extractTimeFromName(name);
        if (option instanceof Some) {
            Some some = (Some)option;
            long t = BoxesRunTime.unboxToLong((Object)some.value());
            return t < removalDate$1;
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    private static final void cleanTmpDirectory$$anonfun$2$$anonfun$1(Object s$3, String path$1, boolean background$2, BatchEnvironment.Services services$2, HierarchicalStorageInterface hierarchicalStorageInterface$3, Object priority$3) {
        StorageService$.MODULE$.rmDirectory(s$3, path$1, background$2, services$2, hierarchicalStorageInterface$3, priority$3);
    }

    private static final void cleanTmpDirectory$$anonfun$2$$anonfun$2(Object s$4, String path$2, boolean background$3, HierarchicalStorageInterface hierarchicalStorageInterface$4, BatchEnvironment.Services services$3, Object priority$4) {
        StorageService$.MODULE$.rmFile(s$4, path$2, background$3, hierarchicalStorageInterface$4, services$3, priority$4);
    }

    private final boolean graceIsOver$1(BatchEnvironment.Services services$4, String name) {
        Option<Object> option = StorageSpace$.MODULE$.extractTimeFromName(name);
        if (option instanceof Some) {
            Some some = (Some)option;
            long t = BoxesRunTime.unboxToLong((Object)some.value());
            return t + TimeConversions$.MODULE$.timeToScalaDuration((Time)services$4.preference().apply(ReplicaCatalog$.MODULE$.ReplicaGraceTime(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Time$.MODULE$)).toMillis() < System.currentTimeMillis();
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    private static final void cleanReplicaDirectory$$anonfun$2$$anonfun$1(Object s$7, String path$3, boolean background$5, BatchEnvironment.Services services$6, HierarchicalStorageInterface hierarchicalStorageInterface$7, Object priority$7) {
        StorageService$.MODULE$.rmDirectory(s$7, path$3, background$5, services$6, hierarchicalStorageInterface$7, priority$7);
    }

    private static final void cleanReplicaDirectory$$anonfun$2$$anonfun$2(Object s$8, String path$4, boolean background$6, StorageInterface storageInterface$2, BatchEnvironment.Services services$7, Object priority$8) {
        StorageService$.MODULE$.rmFile(s$8, path$4, background$6, storageInterface$2, services$7, priority$8);
    }

    private final String baseDirName$1(Preference preference$1) {
        return "openmole-" + Base36$.MODULE$.uuidToString((UUID)preference$1.apply(Preference$.MODULE$.uniqueID(), (ConfigurationString)ConfigurationString.given_ConfigurationString_UUID$.MODULE$)) + '/';
    }

    private final String mkRootDir$1(String root$1, HierarchicalStorageInterface hierarchicalStorageInterface$8, Object s$9, Object priority$9, Function1 isConnectionError$1) {
        String string;
        HierarchicalStorageSpace$ hierarchicalStorageSpace$ = this;
        synchronized (hierarchicalStorageSpace$) {
            Seq paths = (Seq)((IterableOps)package$.MODULE$.Iterator().iterate((Object)Some$.MODULE$.apply((Object)root$1), (Function1 & Serializable)p -> p.flatMap((Function1 & Serializable)_$3 -> hierarchicalStorageInterface$8.parent(s$9, (String)_$3, priority$9))).takeWhile((Function1 & Serializable)_$4 -> _$4.isDefined()).toSeq().reverse()).flatten(Predef$.MODULE$.$conforms());
            string = (String)((IterableOnceOps)paths.tail()).foldLeft(paths.head(), (Function2 & Serializable)(path, file) -> {
                String childPath = StorageService$.MODULE$.child(s$9, (String)path, hierarchicalStorageInterface$8.name(s$9, (String)file), hierarchicalStorageInterface$8, priority$9);
                try {
                    hierarchicalStorageInterface$8.makeDir(s$9, childPath, priority$9);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        Throwable e = throwable3;
                        if (BoxesRunTime.unboxToBoolean((Object)isConnectionError$1.apply((Object)e))) {
                            throw e;
                        }
                        Throwable e2 = throwable3;
                        MODULE$.Log().logger().log(MODULE$.Log().FINE(), "Error creating base directory " + root$1, e2);
                    }
                    throw throwable;
                }
                return childPath;
            });
        }
        return string;
    }

    private static final void createBasePath$$anonfun$1(HierarchicalStorageInterface hierarchicalStorageInterface$12, Object s$13, String basePath$1, Object priority$13) {
        hierarchicalStorageInterface$12.makeDir(s$13, basePath$1, priority$13);
    }

    private static final void createJobDirectory$$anonfun$1(HierarchicalStorageInterface hierarchicalStorageInterface$13, Object s$14, String intervalDirectory$1, Object priority$14) {
        hierarchicalStorageInterface$13.makeDir(s$14, intervalDirectory$1, priority$14);
    }
}

