/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.egi;

import gridscale.dirac.package;
import gridscale.package;
import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import org.openmole.core.dsl.extension.package$;
import org.openmole.core.exception.InternalProcessingError;
import org.openmole.core.exception.InternalProcessingError$;
import org.openmole.core.preference.ConfigurationString;
import org.openmole.core.preference.Preference;
import org.openmole.plugin.environment.batch.environment.AccessControl;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment$;
import org.openmole.plugin.environment.batch.environment.SerializedJob;
import org.openmole.plugin.environment.egi.EGIEnvironment;
import org.openmole.plugin.environment.egi.EGIEnvironment$;
import org.openmole.plugin.environment.egi.EGIJobService$;
import org.openmole.plugin.environment.egi.JobScript$;
import org.openmole.plugin.environment.gridscale.GridScaleJobService$;
import org.openmole.tool.cache.TimeCache;
import org.openmole.tool.cache.TimeCache$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class EGIJobService {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(EGIJobService.class.getDeclaredField("jobStateCache$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(EGIJobService.class.getDeclaredField("diracJobGroup$lzy1"));
    private final package.DIRACServer diracService;
    private final EGIEnvironment<?> environment;
    private final AccessControl accessControl;
    private volatile Object diracJobGroup$lzy1;
    private volatile Object jobStateCache$lzy1;

    public static EGIJobService apply(package.DIRACServer dIRACServer, EGIEnvironment<?> eGIEnvironment, Preference preference) {
        return EGIJobService$.MODULE$.apply(dIRACServer, eGIEnvironment, preference);
    }

    public EGIJobService(package.DIRACServer diracService, EGIEnvironment<?> environment, AccessControl accessControl) {
        this.diracService = diracService;
        this.environment = environment;
        this.accessControl = accessControl;
    }

    public String diracJobGroup() {
        Object object = this.diracJobGroup$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.diracJobGroup$lzyINIT1();
    }

    private Object diracJobGroup$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.diracJobGroup$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(UUID.randomUUID().toString()), (Function1 & Serializable)_$1 -> EGIJobService.diracJobGroup$lzyINIT1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)));
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.diracJobGroup$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public package.JobID submit(SerializedJob serializedJob, String outputPath, String storageLocation, Object x$4) {
        return (package.JobID)this.environment.services().newFile().withTmpFile("script", ".sh", (Function1 & Serializable)script -> {
            org.openmole.tool.file.package$.MODULE$.FileDecorator(script).content_$eq(JobScript$.MODULE$.create(serializedJob, outputPath, storageLocation, this.environment.voName(), (int)BatchEnvironment$.MODULE$.openMOLEMemoryValue(this.environment.openMOLEMemory(), this.environment.services().preference()).toMegabytes(), this.environment.debug(), JobScript$.MODULE$.create$default$7(), this.environment.services().preference()));
            String string = "-x " + script.getName() + " -- --unique-id " + this.environment.services().preference().apply(package$.MODULE$.Preference().uniqueID(), (ConfigurationString)ConfigurationString.given_ConfigurationString_UUID$.MODULE$);
            Seq seq = (Seq)((SeqOps)new .colon.colon(script, (List)Nil$.MODULE$));
            Some some = Some$.MODULE$.apply((Object)EGIEnvironment$.MODULE$.stdOutFileName());
            Some some2 = Some$.MODULE$.apply((Object)EGIEnvironment$.MODULE$.stdErrFileName());
            Seq seq2 = (Seq)((SeqOps)new .colon.colon((Object)EGIEnvironment$.MODULE$.stdOutFileName(), (List)new .colon.colon((Object)EGIEnvironment$.MODULE$.stdErrFileName(), (List)Nil$.MODULE$)));
            Seq seq3 = package.JobDescription$.MODULE$.$lessinit$greater$default$7();
            Option option = package.JobDescription$.MODULE$.$lessinit$greater$default$9();
            Option option2 = package.JobDescription$.MODULE$.$lessinit$greater$default$10();
            package.JobDescription jobDescription = package.JobDescription$.MODULE$.apply("/bin/bash", string, (Option)some, (Option)some2, seq, seq2, seq3, this.environment.cpuTime(), option, option2);
            return (package.JobID)this.accessControl.apply((Function1 & Serializable)contextual$1 -> gridscale.dirac.package$.MODULE$.submit(this.diracService, jobDescription, (package.Token)this.environment.tokenCache().apply(), (Option)Some$.MODULE$.apply((Object)this.diracJobGroup()), this.environment.given_HTTP()), x$4);
        }, this.environment.services().newFile());
    }

    public TimeCache<Map<String, package.JobState>> jobStateCache() {
        Object object = this.jobStateCache$lzy1;
        if (object instanceof TimeCache) {
            return (TimeCache)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (TimeCache)this.jobStateCache$lzyINIT1();
    }

    private Object jobStateCache$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.jobStateCache$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    TimeCache timeCache = null;
                    try {
                        timeCache = TimeCache$.MODULE$.apply((Function0 & Serializable)() -> {
                            Vector states = gridscale.dirac.package$.MODULE$.queryState(this.diracService, (package.Token)this.environment.tokenCache().apply(), (Option)Some$.MODULE$.apply((Object)this.diracJobGroup()), gridscale.dirac.package$.MODULE$.queryState$default$4(), gridscale.dirac.package$.MODULE$.queryState$default$5(), this.environment.given_HTTP());
                            Map map = (Map)Predef$.MODULE$.ArrowAssoc((Object)states.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)map, this.environment.services().preference().apply(EGIEnvironment$.MODULE$.JobGroupRefreshInterval(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Time$.MODULE$));
                        });
                        object2 = timeCache == null ? LazyVals.NullValue$.MODULE$ : timeCache;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jobStateCache$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return timeCache;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public byte state(package.JobID id, Object priority) {
        package.JobState state = (package.JobState)((MapOps)this.jobStateCache().apply()).getOrElse((Object)id.id(), () -> this.$anonfun$1(id));
        return GridScaleJobService$.MODULE$.translateStatus(state);
    }

    public IndexedSeq<BoxedUnit> delete(package.JobID id, Object priority) {
        return (IndexedSeq)this.accessControl.apply((Function1 & Serializable)contextual$2 -> gridscale.dirac.package$.MODULE$.delete(this.diracService, (package.Token)this.environment.tokenCache().apply(), id, this.environment.given_HTTP()), EGIJobService.given_Priority$1(priority));
    }

    public Tuple2<String, String> stdOutErr(package.JobID id, Object priority) {
        return (Tuple2)this.environment.services().newFile().withTmpDir((Function1 & Serializable)tmpDir -> {
            tmpDir.mkdirs();
            this.accessControl.apply((Function1)(JProcedure1 & Serializable)contextual$3 -> gridscale.dirac.package$.MODULE$.downloadOutputSandbox(this.diracService, (package.Token)this.environment.tokenCache().apply(), id, tmpDir, this.environment.given_HTTP()), EGIJobService.given_Priority$2(priority));
            return Tuple2$.MODULE$.apply((Object)EGIJobService.stdOut$2(tmpDir), (Object)EGIJobService.stdErr$2(tmpDir));
        }, this.environment.services().newFile());
    }

    private static final /* synthetic */ boolean diracJobGroup$lzyINIT1$$anonfun$1(char _$1) {
        return _$1 != '-';
    }

    private final package.JobState $anonfun$1(package.JobID id$1) {
        throw new InternalProcessingError("Job " + id$1.id() + " not found in group " + this.diracJobGroup() + " of DIRAC server.", InternalProcessingError$.MODULE$.$lessinit$greater$default$2());
    }

    private static final Object given_Priority$1(Object priority$1) {
        return priority$1;
    }

    private static final Object given_Priority$2(Object priority$2) {
        return priority$2;
    }

    private static final String stdOut$2(File tmpDir$2) {
        if (org.openmole.tool.file.package$.MODULE$.FileDecorator(tmpDir$2).$div(EGIEnvironment$.MODULE$.stdOutFileName()).exists()) {
            return org.openmole.tool.file.package$.MODULE$.FileDecorator(org.openmole.tool.file.package$.MODULE$.FileDecorator(tmpDir$2).$div(EGIEnvironment$.MODULE$.stdOutFileName())).content();
        }
        return "";
    }

    private static final String stdErr$2(File tmpDir$3) {
        if (org.openmole.tool.file.package$.MODULE$.FileDecorator(tmpDir$3).$div(EGIEnvironment$.MODULE$.stdErrFileName()).exists()) {
            return org.openmole.tool.file.package$.MODULE$.FileDecorator(org.openmole.tool.file.package$.MODULE$.FileDecorator(tmpDir$3).$div(EGIEnvironment$.MODULE$.stdErrFileName())).content();
        }
        return "";
    }
}

