/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.collection;

import java.io.Serializable;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import org.openmole.tool.collection.BlockingPriorityQueue$;
import org.openmole.tool.collection.PriorityQueue;
import org.openmole.tool.collection.PriorityQueue$;
import org.openmole.tool.collection.PriorityQueue$FIFO$;
import org.openmole.tool.collection.PriorityQueue$FILO$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public class BlockingPriorityQueue<T> {
    private final boolean fifo;
    private final Semaphore inQueue;
    private final Map<Object, PriorityQueue.InnerQueue<T>> queues;

    public static <T> BlockingPriorityQueue<T> apply(boolean bl) {
        return BlockingPriorityQueue$.MODULE$.apply(bl);
    }

    public static <T> boolean apply$default$1() {
        return BlockingPriorityQueue$.MODULE$.apply$default$1();
    }

    public BlockingPriorityQueue(boolean fifo) {
        this.fifo = fifo;
        this.inQueue = new Semaphore(0);
        this.queues = CollectionConverters$.MODULE$.MapHasAsScala(new TreeMap()).asScala();
    }

    public Map<Object, PriorityQueue.InnerQueue<T>> queues() {
        return this.queues;
    }

    public int size() {
        return this.inQueue.availablePermits();
    }

    public void enqueue(T e, int priority) {
        BlockingPriorityQueue blockingPriorityQueue = this;
        synchronized (blockingPriorityQueue) {
            Option option = this.queues().get((Object)BoxesRunTime.boxToInteger((int)priority));
            if (option instanceof Some) {
                Some some = (Some)option;
                PriorityQueue.InnerQueue queue = (PriorityQueue.InnerQueue)some.value();
                v0 = PriorityQueue$.MODULE$.add(queue, e);
            } else if (None$.MODULE$.equals(option)) {
                PriorityQueue.InnerQueue q = (PriorityQueue.InnerQueue)(!this.fifo ? PriorityQueue$FILO$.MODULE$.apply(PriorityQueue$FILO$.MODULE$.$lessinit$greater$default$1()) : PriorityQueue$FIFO$.MODULE$.apply(PriorityQueue$FIFO$.MODULE$.$lessinit$greater$default$1()));
                PriorityQueue$.MODULE$.add(q, e);
                v0 = this.queues().put((Object)BoxesRunTime.boxToInteger((int)priority), (Object)q);
            } else {
                throw new MatchError((Object)option);
            }
        }
        this.inQueue.release();
    }

    public T dequeue() {
        Object t;
        this.inQueue.acquire();
        BlockingPriorityQueue blockingPriorityQueue = this;
        synchronized (blockingPriorityQueue) {
            Tuple2 tuple2 = (Tuple2)this.queues().last();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 $1$ = tuple2;
            Tuple2 tuple22 = $1$;
            int p = BoxesRunTime.unboxToInt((Object)tuple22._1());
            PriorityQueue.InnerQueue q = (PriorityQueue.InnerQueue)tuple22._2();
            Object job = PriorityQueue$.MODULE$.pool(q);
            if (PriorityQueue$.MODULE$.isEmpty(q)) {
                this.queues().remove((Object)BoxesRunTime.boxToInteger((int)p));
            }
            t = job;
        }
        return t;
    }

    public Vector<T> all() {
        Vector vector;
        BlockingPriorityQueue blockingPriorityQueue = this;
        synchronized (blockingPriorityQueue) {
            vector = (Vector)this.queues().values().toVector().flatMap((Function1 & Serializable)innerQueue -> PriorityQueue$.MODULE$.toVector(innerQueue));
        }
        return vector;
    }

    public int clear() {
        BlockingPriorityQueue blockingPriorityQueue = this;
        synchronized (blockingPriorityQueue) {
            this.queues().clear();
        }
        return this.inQueue.drainPermits();
    }

    public boolean isEmpty() {
        boolean bl;
        BlockingPriorityQueue blockingPriorityQueue = this;
        synchronized (blockingPriorityQueue) {
            bl = this.size() == 0;
        }
        return bl;
    }
}

