/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import com.hierynomus.asn1.ASN1InputStream;
import com.hierynomus.asn1.encodingrules.ASN1Decoder;
import com.hierynomus.asn1.encodingrules.der.DERDecoder;
import com.hierynomus.asn1.types.ASN1Tag;
import com.hierynomus.asn1.types.constructed.ASN1Sequence;
import com.hierynomus.asn1.types.constructed.ASN1TaggedObject;
import com.hierynomus.asn1.types.primitive.ASN1Integer;
import com.hierynomus.asn1.types.primitive.ASN1ObjectIdentifier;
import com.hierynomus.asn1.types.string.ASN1BitString;
import com.hierynomus.asn1.types.string.ASN1OctetString;
import com.hierynomus.sshj.common.KeyDecryptionFailedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECField;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import net.schmizz.sshj.common.ECDSACurve;
import net.schmizz.sshj.common.ECDSAKeyFactory;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.userauth.keyprovider.BaseFileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.EncryptedPEMKeyReader;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.PEMKey;
import net.schmizz.sshj.userauth.keyprovider.StandardPEMKeyReader;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS8KeyFile
extends BaseFileKeyProvider {
    private static final String BOUNCY_CASTLE_CLASS = "org.bouncycastle.openssl.PEMDecryptor";
    private static final boolean HISTORICAL_DECRYPTION_SUPPORTED = PKCS8KeyFile.isHistoricalDecryptionSupported();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected KeyPair readKeyPair() throws IOException {
        StandardPEMKeyReader pemKeyReader = HISTORICAL_DECRYPTION_SUPPORTED ? (this.pwdf == null ? new StandardPEMKeyReader() : new EncryptedPEMKeyReader(this.pwdf, this.resource)) : new StandardPEMKeyReader();
        try (BufferedReader bufferedReader = new BufferedReader(this.resource.getReader());){
            PEMKey pemKey = pemKeyReader.readPemKey(bufferedReader);
            KeyPair keyPair = this.readKeyPair(pemKey);
            return keyPair;
        }
    }

    private KeyPair readKeyPair(PEMKey pemKey) throws IOException {
        KeyPair keyPair;
        PEMKey.PEMKeyType pemKeyType = pemKey.getPemKeyType();
        byte[] pemKeyBody = pemKey.getBody();
        if (PEMKey.PEMKeyType.DSA == pemKeyType) {
            keyPair = this.readDsaKeyPair(pemKeyBody);
        } else if (PEMKey.PEMKeyType.EC == pemKeyType) {
            keyPair = this.readEcKeyPair(pemKeyBody);
        } else if (PEMKey.PEMKeyType.PKCS8 == pemKeyType) {
            keyPair = this.getPkcs8KeyPair(pemKeyBody);
        } else if (PEMKey.PEMKeyType.PKCS8_ENCRYPTED == pemKeyType) {
            keyPair = this.readEncryptedPkcs8KeyPair(pemKeyBody);
        } else if (PEMKey.PEMKeyType.RSA == pemKeyType) {
            keyPair = this.readRsaKeyPair(pemKeyBody);
        } else {
            throw new IOException(String.format("PEM Key Type [%s] not supported", new Object[]{pemKeyType}));
        }
        return keyPair;
    }

    public String toString() {
        return "PKCS8KeyFile{resource=" + this.resource + "}";
    }

    private KeyPair readDsaKeyPair(byte[] pemKeyBody) throws IOException {
        KeyPair keyPair;
        ASN1InputStream inputStream = new ASN1InputStream((ASN1Decoder)new DERDecoder(), pemKeyBody);
        try {
            ASN1Sequence sequence = (ASN1Sequence)inputStream.readObject();
            BigInteger p = this.getBigInteger(sequence, 1);
            BigInteger q = this.getBigInteger(sequence, 2);
            BigInteger g = this.getBigInteger(sequence, 3);
            BigInteger y = this.getBigInteger(sequence, 4);
            BigInteger x = this.getBigInteger(sequence, 5);
            DSAPrivateKeySpec privateKeySpec = new DSAPrivateKeySpec(x, p, q, g);
            DSAPublicKeySpec publicKeySpec = new DSAPublicKeySpec(y, p, q, g);
            KeyFactory keyFactory = SecurityUtils.getKeyFactory("DSA");
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
            keyPair = new KeyPair(publicKey, privateKey);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IOException("PEM Key [DSA] processing failed", e);
            }
        }
        inputStream.close();
        return keyPair;
    }

    private KeyPair readRsaKeyPair(byte[] pemKeyBody) throws IOException {
        KeyPair keyPair;
        ASN1InputStream inputStream = new ASN1InputStream((ASN1Decoder)new DERDecoder(), pemKeyBody);
        try {
            ASN1Sequence sequence = (ASN1Sequence)inputStream.readObject();
            BigInteger modulus = this.getBigInteger(sequence, 1);
            BigInteger publicExponent = this.getBigInteger(sequence, 2);
            BigInteger privateExponent = this.getBigInteger(sequence, 3);
            BigInteger prime1 = this.getBigInteger(sequence, 4);
            BigInteger prime2 = this.getBigInteger(sequence, 5);
            BigInteger exponent1 = this.getBigInteger(sequence, 6);
            BigInteger exponent2 = this.getBigInteger(sequence, 7);
            BigInteger coefficient = this.getBigInteger(sequence, 8);
            RSAPrivateCrtKeySpec privateKeySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient);
            KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            keyPair = new KeyPair(publicKey, privateKey);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IOException("PEM Key [RSA] processing failed", e);
            }
        }
        inputStream.close();
        return keyPair;
    }

    private KeyPair readEcKeyPair(byte[] pemKeyBody) throws IOException {
        KeyPair keyPair;
        ASN1InputStream inputStream = new ASN1InputStream((ASN1Decoder)new DERDecoder(), pemKeyBody);
        try {
            ASN1Sequence sequence = (ASN1Sequence)inputStream.readObject();
            ASN1TaggedObject taggedObjectParameters = (ASN1TaggedObject)sequence.get(2);
            ASN1ObjectIdentifier objectIdentifier = (ASN1ObjectIdentifier)taggedObjectParameters.getObject();
            String objectId = objectIdentifier.getValue();
            ECNamedCurveObjectIdentifier ecNamedCurveObjectIdentifier = this.getEcNamedCurve(objectId);
            ASN1OctetString privateKeyOctetString = (ASN1OctetString)sequence.get(1);
            BigInteger privateKeyInteger = new BigInteger(1, privateKeyOctetString.getValue());
            ECPrivateKey privateKey = (ECPrivateKey)ECDSAKeyFactory.getPrivateKey(privateKeyInteger, ecNamedCurveObjectIdentifier.ecdsaCurve);
            ECParameterSpec ecParameterSpec = privateKey.getParams();
            ASN1TaggedObject taggedBitString = (ASN1TaggedObject)sequence.get(3);
            ASN1BitString publicKeyBitString = (ASN1BitString)taggedBitString.getObject();
            byte[] bitString = publicKeyBitString.getValueBytes();
            PublicKey publicKey = this.getEcPublicKey(bitString, ecParameterSpec);
            keyPair = new KeyPair(publicKey, privateKey);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IOException("PEM Key [EC] processing failed", e);
            }
        }
        inputStream.close();
        return keyPair;
    }

    private ECNamedCurveObjectIdentifier getEcNamedCurve(String objectId) {
        ECNamedCurveObjectIdentifier objectIdentifierFound = null;
        for (ECNamedCurveObjectIdentifier objectIdentifier : ECNamedCurveObjectIdentifier.values()) {
            if (!objectIdentifier.objectId.equals(objectId)) continue;
            objectIdentifierFound = objectIdentifier;
        }
        if (objectIdentifierFound == null) {
            throw new IllegalArgumentException(String.format("ECDSA Key Algorithm [%s] not supported", objectId));
        }
        return objectIdentifierFound;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyPair readEncryptedPkcs8KeyPair(byte[] pemKeyBody) throws IOException {
        if (this.pwdf == null) {
            throw new KeyDecryptionFailedException("Password not provided for encrypted PKCS8 key");
        }
        KeyPair keyPair = null;
        try {
            char[] password = this.pwdf.reqPassword(this.resource);
            while (password != null) {
                try {
                    PKCS8EncodedKeySpec encodedKeySpec = this.getPkcs8DecryptedKeySpec(password, pemKeyBody);
                    keyPair = this.getPkcs8KeyPair(encodedKeySpec.getEncoded());
                    break;
                }
                catch (KeyDecryptionFailedException e) {
                    if (!this.pwdf.shouldRetry(this.resource)) {
                        throw e;
                    }
                    password = this.pwdf.reqPassword(this.resource);
                }
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException("PEM Key [PKCS8] processing failed", e);
        }
        if (keyPair == null) {
            throw new KeyDecryptionFailedException("PEM Key [PKCS8] decryption failed");
        }
        return keyPair;
    }

    private PKCS8EncodedKeySpec getPkcs8DecryptedKeySpec(char[] password, byte[] encoded) throws IOException, GeneralSecurityException {
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(encoded);
            AlgorithmParameters algorithmParameters = encryptedPrivateKeyInfo.getAlgParameters();
            String secretKeyAlgorithm = algorithmParameters.toString();
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(secretKeyAlgorithm);
            PBEKeySpec secretKeySpec = new PBEKeySpec(password);
            SecretKey secretKey = secretKeyFactory.generateSecret(secretKeySpec);
            Cipher cipher = Cipher.getInstance(secretKeyAlgorithm);
            cipher.init(2, (Key)secretKey, algorithmParameters);
            try {
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
                return pKCS8EncodedKeySpec;
            }
            catch (GeneralSecurityException e) {
                throw new KeyDecryptionFailedException(String.format("PKCS8 Key Decryption failed for algorithm [%s]", secretKeyAlgorithm), e);
            }
        }
        finally {
            PasswordUtils.blankOut(password);
        }
    }

    private KeyPair getPkcs8KeyPair(byte[] encoded) throws IOException {
        KeyPair keyPair;
        ASN1InputStream inputStream = new ASN1InputStream((ASN1Decoder)new DERDecoder(), encoded);
        try {
            ASN1Sequence sequence = (ASN1Sequence)inputStream.readObject();
            ASN1Sequence privateKeyAlgorithmSequence = (ASN1Sequence)sequence.get(1);
            ASN1ObjectIdentifier privateKeyAlgorithm = (ASN1ObjectIdentifier)privateKeyAlgorithmSequence.get(0);
            String privateKeyAlgorithmObjectId = privateKeyAlgorithm.getValue();
            KeyAlgorithmObjectIdentifier keyAlgorithmObjectIdentifier = this.getKeyAlgorithmObjectIdentifier(privateKeyAlgorithmObjectId);
            keyPair = this.getPkcs8KeyPair(keyAlgorithmObjectIdentifier, encoded);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IOException("PEM Key [PKCS8] processing failed", e);
            }
        }
        inputStream.close();
        return keyPair;
    }

    private KeyPair getPkcs8KeyPair(KeyAlgorithmObjectIdentifier objectIdentifier, byte[] privateKeyInfo) throws GeneralSecurityException {
        PublicKey publicKey;
        PrivateKey privateKey;
        block17: {
            privateKey = this.getPkcs8PrivateKey(objectIdentifier, privateKeyInfo);
            if (privateKey instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rsaPrivateKey = (RSAPrivateCrtKey)privateKey;
                BigInteger modulus = rsaPrivateKey.getModulus();
                BigInteger publicExponent = rsaPrivateKey.getPublicExponent();
                RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
                KeyFactory keyFactory = SecurityUtils.getKeyFactory(privateKey.getAlgorithm());
                publicKey = keyFactory.generatePublic(publicKeySpec);
            } else if (privateKey instanceof DSAPrivateKey) {
                DSAPrivateKey dsaPrivateKey = (DSAPrivateKey)privateKey;
                DSAParams dsaParams = dsaPrivateKey.getParams();
                BigInteger p = dsaParams.getP();
                BigInteger g = dsaParams.getG();
                BigInteger q = dsaParams.getQ();
                BigInteger x = dsaPrivateKey.getX();
                BigInteger y = g.modPow(x, p);
                DSAPublicKeySpec publicKeySpec = new DSAPublicKeySpec(y, p, q, g);
                KeyFactory keyFactory = SecurityUtils.getKeyFactory(privateKey.getAlgorithm());
                publicKey = keyFactory.generatePublic(publicKeySpec);
            } else {
                if (privateKey instanceof ECPrivateKey) {
                    ECPrivateKey ecPrivateKey = (ECPrivateKey)privateKey;
                    ECParameterSpec ecParameterSpec = ecPrivateKey.getParams();
                    try (ASN1InputStream inputStream = new ASN1InputStream((ASN1Decoder)new DERDecoder(), privateKeyInfo);){
                        ASN1Sequence sequence = (ASN1Sequence)inputStream.readObject();
                        ASN1OctetString keyOctetString = (ASN1OctetString)sequence.get(2);
                        byte[] keyBytes = keyOctetString.getValue();
                        try (ASN1InputStream keyInputStream = new ASN1InputStream((ASN1Decoder)new DERDecoder(), keyBytes);){
                            ASN1Sequence keySequence = (ASN1Sequence)keyInputStream.readObject();
                            ASN1TaggedObject taggedObject = (ASN1TaggedObject)keySequence.get(2);
                            ASN1BitString publicKeyBitString = taggedObject.getObject(ASN1Tag.BIT_STRING);
                            byte[] bitString = publicKeyBitString.getValueBytes();
                            publicKey = this.getEcPublicKey(bitString, ecParameterSpec);
                            break block17;
                        }
                    }
                    catch (IOException e) {
                        throw new GeneralSecurityException("ECDSA Private Key Info parsing failed", e);
                    }
                }
                throw new GeneralSecurityException(String.format("PEM Key [PKCS8] algorithm [%s] Key Pair derivation not supported", privateKey.getAlgorithm()));
            }
        }
        return new KeyPair(publicKey, privateKey);
    }

    private PrivateKey getPkcs8PrivateKey(KeyAlgorithmObjectIdentifier objectIdentifier, byte[] privateKeyInfo) throws GeneralSecurityException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyInfo);
        KeyFactory keyFactory = SecurityUtils.getKeyFactory(objectIdentifier.name());
        return keyFactory.generatePrivate(keySpec);
    }

    private PublicKey getEcPublicKey(byte[] bitString, ECParameterSpec ecParameterSpec) throws GeneralSecurityException {
        EllipticCurve ellipticCurve = ecParameterSpec.getCurve();
        ECField ecField = ellipticCurve.getField();
        int fieldSize = (ecField.getFieldSize() + 7) / 8;
        int publicKeyPointSize = fieldSize * 2;
        byte[] x = new byte[fieldSize];
        byte[] y = new byte[fieldSize];
        int pointOffset = bitString.length - publicKeyPointSize;
        System.arraycopy(bitString, pointOffset, x, 0, x.length);
        System.arraycopy(bitString, pointOffset + y.length, y, 0, y.length);
        BigInteger pointX = new BigInteger(1, x);
        BigInteger pointY = new BigInteger(1, y);
        ECPoint point = new ECPoint(pointX, pointY);
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(point, ecParameterSpec);
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EC");
        return keyFactory.generatePublic(publicKeySpec);
    }

    private KeyAlgorithmObjectIdentifier getKeyAlgorithmObjectIdentifier(String objectId) {
        KeyAlgorithmObjectIdentifier keyAlgorithmObjectIdentifier = null;
        for (KeyAlgorithmObjectIdentifier objectIdentifier : KeyAlgorithmObjectIdentifier.values()) {
            if (!objectIdentifier.getObjectId().equals(objectId)) continue;
            keyAlgorithmObjectIdentifier = objectIdentifier;
        }
        if (keyAlgorithmObjectIdentifier == null) {
            throw new IllegalArgumentException(String.format("PKCS8 Private Key Algorithm [%s] not supported", objectId));
        }
        return keyAlgorithmObjectIdentifier;
    }

    private BigInteger getBigInteger(ASN1Sequence sequence, int index) {
        ASN1Integer integer = (ASN1Integer)sequence.get(index);
        return integer.getValue();
    }

    private static boolean isHistoricalDecryptionSupported() {
        try {
            Class.forName(BOUNCY_CASTLE_CLASS);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static enum KeyAlgorithmObjectIdentifier {
        DSA("1.2.840.10040.4.1"),
        EC("1.2.840.10045.2.1"),
        RSA("1.2.840.113549.1.1.1");

        private final String objectId;

        private KeyAlgorithmObjectIdentifier(String objectId) {
            this.objectId = objectId;
        }

        String getObjectId() {
            return this.objectId;
        }
    }

    private static enum ECNamedCurveObjectIdentifier {
        SECP256R1("1.2.840.10045.3.1.7", ECDSACurve.SECP256R1),
        SECP384R1("1.3.132.0.34", ECDSACurve.SECP384R1),
        SECP521R1("1.3.132.0.35", ECDSACurve.SECP521R1);

        private final String objectId;
        private final ECDSACurve ecdsaCurve;

        private ECNamedCurveObjectIdentifier(String objectId, ECDSACurve ecdsaCurve) {
            this.objectId = objectId;
            this.ecdsaCurve = ecdsaCurve;
        }
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new PKCS8KeyFile();
        }

        @Override
        public String getName() {
            return "PKCS8";
        }
    }
}

