/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.LongDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class SHA512Digest
extends LongDigest {
    private static final int DIGEST_LENGTH = 64;

    public SHA512Digest() {
        this(CryptoServicePurpose.ANY);
    }

    public SHA512Digest(CryptoServicePurpose cryptoServicePurpose) {
        super(cryptoServicePurpose);
        CryptoServicesRegistrar.checkConstraints((CryptoServiceProperties)this.cryptoServiceProperties());
        this.reset();
    }

    public SHA512Digest(SHA512Digest sHA512Digest) {
        super((LongDigest)sHA512Digest);
        CryptoServicesRegistrar.checkConstraints((CryptoServiceProperties)this.cryptoServiceProperties());
    }

    public SHA512Digest(byte[] byArray) {
        super(CryptoServicePurpose.values()[byArray[byArray.length - 1]]);
        this.restoreState(byArray);
        CryptoServicesRegistrar.checkConstraints((CryptoServiceProperties)this.cryptoServiceProperties());
    }

    public String getAlgorithmName() {
        return "SHA-512";
    }

    public int getDigestSize() {
        return 64;
    }

    public int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.longToBigEndian((long)this.H1, (byte[])byArray, (int)n);
        Pack.longToBigEndian((long)this.H2, (byte[])byArray, (int)(n + 8));
        Pack.longToBigEndian((long)this.H3, (byte[])byArray, (int)(n + 16));
        Pack.longToBigEndian((long)this.H4, (byte[])byArray, (int)(n + 24));
        Pack.longToBigEndian((long)this.H5, (byte[])byArray, (int)(n + 32));
        Pack.longToBigEndian((long)this.H6, (byte[])byArray, (int)(n + 40));
        Pack.longToBigEndian((long)this.H7, (byte[])byArray, (int)(n + 48));
        Pack.longToBigEndian((long)this.H8, (byte[])byArray, (int)(n + 56));
        this.reset();
        return 64;
    }

    public void reset() {
        super.reset();
        this.H1 = 7640891576956012808L;
        this.H2 = -4942790177534073029L;
        this.H3 = 4354685564936845355L;
        this.H4 = -6534734903238641935L;
        this.H5 = 5840696475078001361L;
        this.H6 = -7276294671716946913L;
        this.H7 = 2270897969802886507L;
        this.H8 = 6620516959819538809L;
    }

    public Memoable copy() {
        return new SHA512Digest(this);
    }

    public void reset(Memoable memoable) {
        SHA512Digest sHA512Digest = (SHA512Digest)memoable;
        this.copyIn((LongDigest)sHA512Digest);
    }

    public byte[] getEncodedState() {
        byte[] byArray = new byte[this.getEncodedStateSize() + 1];
        super.populateState(byArray);
        byArray[byArray.length - 1] = (byte)this.purpose.ordinal();
        return byArray;
    }

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties((Digest)this, (int)256, (CryptoServicePurpose)this.purpose);
    }
}

