/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.PreCompCallback;
import org.bouncycastle.math.ec.ValidityPrecompInfo;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ECPoint {
    protected static final ECFieldElement[] EMPTY_ZS = new ECFieldElement[0];
    protected ECCurve curve;
    protected ECFieldElement x;
    protected ECFieldElement y;
    protected ECFieldElement[] zs;
    protected Hashtable preCompTable = null;

    protected static ECFieldElement[] getInitialZCoords(ECCurve eCCurve) {
        int n = null == eCCurve ? 0 : eCCurve.getCoordinateSystem();
        switch (n) {
            case 0: 
            case 5: {
                return EMPTY_ZS;
            }
        }
        ECFieldElement eCFieldElement = eCCurve.fromBigInteger(ECConstants.ONE);
        switch (n) {
            case 1: 
            case 2: 
            case 6: {
                return new ECFieldElement[]{eCFieldElement};
            }
            case 3: {
                return new ECFieldElement[]{eCFieldElement, eCFieldElement, eCFieldElement};
            }
            case 4: {
                return new ECFieldElement[]{eCFieldElement, eCCurve.getA()};
            }
        }
        throw new IllegalArgumentException("unknown coordinate system");
    }

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this(eCCurve, eCFieldElement, eCFieldElement2, ECPoint.getInitialZCoords((ECCurve)eCCurve));
    }

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        this.curve = eCCurve;
        this.x = eCFieldElement;
        this.y = eCFieldElement2;
        this.zs = eCFieldElementArray;
    }

    protected abstract boolean satisfiesCurveEquation();

    protected boolean satisfiesOrder() {
        if (ECConstants.ONE.equals(this.curve.getCofactor())) {
            return true;
        }
        BigInteger bigInteger = this.curve.getOrder();
        return bigInteger == null || ECAlgorithms.referenceMultiply((ECPoint)this, (BigInteger)bigInteger).isInfinity();
    }

    public final ECPoint getDetachedPoint() {
        return this.normalize().detach();
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    protected abstract ECPoint detach();

    protected int getCurveCoordinateSystem() {
        return null == this.curve ? 0 : this.curve.getCoordinateSystem();
    }

    public ECFieldElement getAffineXCoord() {
        this.checkNormalized();
        return this.getXCoord();
    }

    public ECFieldElement getAffineYCoord() {
        this.checkNormalized();
        return this.getYCoord();
    }

    public ECFieldElement getXCoord() {
        return this.x;
    }

    public ECFieldElement getYCoord() {
        return this.y;
    }

    public ECFieldElement getZCoord(int n) {
        return n < 0 || n >= this.zs.length ? null : this.zs[n];
    }

    public ECFieldElement[] getZCoords() {
        int n = this.zs.length;
        if (n == 0) {
            return EMPTY_ZS;
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[n];
        System.arraycopy(this.zs, 0, eCFieldElementArray, 0, n);
        return eCFieldElementArray;
    }

    public final ECFieldElement getRawXCoord() {
        return this.x;
    }

    public final ECFieldElement getRawYCoord() {
        return this.y;
    }

    protected final ECFieldElement[] getRawZCoords() {
        return this.zs;
    }

    protected void checkNormalized() {
        if (!this.isNormalized()) {
            throw new IllegalStateException("point not in normal form");
        }
    }

    public boolean isNormalized() {
        int n = this.getCurveCoordinateSystem();
        return n == 0 || n == 5 || this.isInfinity() || this.zs[0].isOne();
    }

    public ECPoint normalize() {
        if (this.isInfinity()) {
            return this;
        }
        switch (this.getCurveCoordinateSystem()) {
            case 0: 
            case 5: {
                return this;
            }
        }
        ECFieldElement eCFieldElement = this.getZCoord(0);
        if (eCFieldElement.isOne()) {
            return this;
        }
        if (null == this.curve) {
            throw new IllegalStateException("Detached points must be in affine coordinates");
        }
        SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandom();
        ECFieldElement eCFieldElement2 = this.curve.randomFieldElementMult(secureRandom);
        ECFieldElement eCFieldElement3 = eCFieldElement.multiply(eCFieldElement2).invert().multiply(eCFieldElement2);
        return this.normalize(eCFieldElement3);
    }

    ECPoint normalize(ECFieldElement eCFieldElement) {
        switch (this.getCurveCoordinateSystem()) {
            case 1: 
            case 6: {
                return this.createScaledPoint(eCFieldElement, eCFieldElement);
            }
            case 2: 
            case 3: 
            case 4: {
                ECFieldElement eCFieldElement2 = eCFieldElement.square();
                ECFieldElement eCFieldElement3 = eCFieldElement2.multiply(eCFieldElement);
                return this.createScaledPoint(eCFieldElement2, eCFieldElement3);
            }
        }
        throw new IllegalStateException("not a projective coordinate system");
    }

    protected ECPoint createScaledPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.getCurve().createRawPoint(this.getRawXCoord().multiply(eCFieldElement), this.getRawYCoord().multiply(eCFieldElement2));
    }

    public boolean isInfinity() {
        return this.x == null || this.y == null || this.zs.length > 0 && this.zs[0].isZero();
    }

    public boolean isValid() {
        return this.implIsValid(false, true);
    }

    boolean isValidPartial() {
        return this.implIsValid(false, false);
    }

    boolean implIsValid(boolean bl, boolean bl2) {
        if (this.isInfinity()) {
            return true;
        }
        ValidityPrecompInfo validityPrecompInfo = (ValidityPrecompInfo)this.getCurve().precompute(this, "bc_validity", (PreCompCallback)new /* Unavailable Anonymous Inner Class!! */);
        return !validityPrecompInfo.hasFailed();
    }

    public ECPoint scaleX(ECFieldElement eCFieldElement) {
        return this.isInfinity() ? this : this.getCurve().createRawPoint(this.getRawXCoord().multiply(eCFieldElement), this.getRawYCoord(), this.getRawZCoords());
    }

    public ECPoint scaleXNegateY(ECFieldElement eCFieldElement) {
        return this.isInfinity() ? this : this.getCurve().createRawPoint(this.getRawXCoord().multiply(eCFieldElement), this.getRawYCoord().negate(), this.getRawZCoords());
    }

    public ECPoint scaleY(ECFieldElement eCFieldElement) {
        return this.isInfinity() ? this : this.getCurve().createRawPoint(this.getRawXCoord(), this.getRawYCoord().multiply(eCFieldElement), this.getRawZCoords());
    }

    public ECPoint scaleYNegateX(ECFieldElement eCFieldElement) {
        return this.isInfinity() ? this : this.getCurve().createRawPoint(this.getRawXCoord().negate(), this.getRawYCoord().multiply(eCFieldElement), this.getRawZCoords());
    }

    public boolean equals(ECPoint eCPoint) {
        if (null == eCPoint) {
            return false;
        }
        ECCurve eCCurve = this.getCurve();
        ECCurve eCCurve2 = eCPoint.getCurve();
        boolean bl = null == eCCurve;
        boolean bl2 = null == eCCurve2;
        boolean bl3 = this.isInfinity();
        boolean bl4 = eCPoint.isInfinity();
        if (bl3 || bl4) {
            return bl3 && bl4 && (bl || bl2 || eCCurve.equals(eCCurve2));
        }
        ECPoint eCPoint2 = this;
        ECPoint eCPoint3 = eCPoint;
        if (!bl || !bl2) {
            if (bl) {
                eCPoint3 = eCPoint3.normalize();
            } else if (bl2) {
                eCPoint2 = eCPoint2.normalize();
            } else {
                if (!eCCurve.equals(eCCurve2)) {
                    return false;
                }
                ECPoint[] eCPointArray = new ECPoint[]{this, eCCurve.importPoint(eCPoint3)};
                eCCurve.normalizeAll(eCPointArray);
                eCPoint2 = eCPointArray[0];
                eCPoint3 = eCPointArray[1];
            }
        }
        return eCPoint2.getXCoord().equals(eCPoint3.getXCoord()) && eCPoint2.getYCoord().equals(eCPoint3.getYCoord());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPoint)) {
            return false;
        }
        return this.equals((ECPoint)object);
    }

    public int hashCode() {
        int n;
        ECCurve eCCurve = this.getCurve();
        int n2 = n = null == eCCurve ? 0 : ~eCCurve.hashCode();
        if (!this.isInfinity()) {
            ECPoint eCPoint = this.normalize();
            n ^= eCPoint.getXCoord().hashCode() * 17;
            n ^= eCPoint.getYCoord().hashCode() * 257;
        }
        return n;
    }

    public String toString() {
        if (this.isInfinity()) {
            return "INF";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.getRawXCoord());
        stringBuffer.append(',');
        stringBuffer.append(this.getRawYCoord());
        for (int i = 0; i < this.zs.length; ++i) {
            stringBuffer.append(',');
            stringBuffer.append(this.zs[i]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public byte[] getEncoded(boolean bl) {
        if (this.isInfinity()) {
            return new byte[1];
        }
        ECPoint eCPoint = this.normalize();
        byte[] byArray = eCPoint.getXCoord().getEncoded();
        if (bl) {
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = (byte)(eCPoint.getCompressionYTilde() ? 3 : 2);
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            return byArray2;
        }
        byte[] byArray3 = eCPoint.getYCoord().getEncoded();
        byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
        byArray4[0] = 4;
        System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
        return byArray4;
    }

    public int getEncodedLength(boolean bl) {
        if (this.isInfinity()) {
            return 1;
        }
        if (bl) {
            return 1 + this.getXCoord().getEncodedLength();
        }
        return 1 + this.getXCoord().getEncodedLength() + this.getYCoord().getEncodedLength();
    }

    public void encodeTo(boolean bl, byte[] byArray, int n) {
        if (this.isInfinity()) {
            byArray[n] = 0;
            return;
        }
        ECPoint eCPoint = this.normalize();
        ECFieldElement eCFieldElement = eCPoint.getXCoord();
        ECFieldElement eCFieldElement2 = eCPoint.getYCoord();
        if (bl) {
            byArray[n] = (byte)(eCPoint.getCompressionYTilde() ? 3 : 2);
            eCFieldElement.encodeTo(byArray, n + 1);
            return;
        }
        byArray[n] = 4;
        eCFieldElement.encodeTo(byArray, n + 1);
        eCFieldElement2.encodeTo(byArray, n + 1 + eCFieldElement.getEncodedLength());
    }

    protected abstract boolean getCompressionYTilde();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint negate();

    public abstract ECPoint subtract(ECPoint var1);

    public ECPoint timesPow2(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("'e' cannot be negative");
        }
        ECPoint eCPoint = this;
        while (--n >= 0) {
            eCPoint = eCPoint.twice();
        }
        return eCPoint;
    }

    public abstract ECPoint twice();

    public ECPoint twicePlus(ECPoint eCPoint) {
        return this.twice().add(eCPoint);
    }

    public ECPoint threeTimes() {
        return this.twicePlus(this);
    }

    public ECPoint multiply(BigInteger bigInteger) {
        return this.getCurve().getMultiplier().multiply(this, bigInteger);
    }
}

