/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.custom.sec.SecP128R1Field;
import org.bouncycastle.math.raw.Nat128;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class SecP128R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict((String)"FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFF"));
    protected int[] x;

    public SecP128R1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP128R1FieldElement");
        }
        this.x = SecP128R1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP128R1FieldElement() {
        this.x = Nat128.create();
    }

    protected SecP128R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    public boolean isZero() {
        return Nat128.isZero((int[])this.x);
    }

    public boolean isOne() {
        return Nat128.isOne((int[])this.x);
    }

    public boolean testBitZero() {
        return Nat128.getBit((int[])this.x, (int)0) == 1;
    }

    public BigInteger toBigInteger() {
        return Nat128.toBigInteger((int[])this.x);
    }

    public String getFieldName() {
        return "SecP128R1Field";
    }

    public int getFieldSize() {
        return Q.bitLength();
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat128.create();
        SecP128R1Field.add((int[])this.x, (int[])((SecP128R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP128R1FieldElement(nArray);
    }

    public ECFieldElement addOne() {
        int[] nArray = Nat128.create();
        SecP128R1Field.addOne((int[])this.x, (int[])nArray);
        return new SecP128R1FieldElement(nArray);
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat128.create();
        SecP128R1Field.subtract((int[])this.x, (int[])((SecP128R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP128R1FieldElement(nArray);
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat128.create();
        SecP128R1Field.multiply((int[])this.x, (int[])((SecP128R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP128R1FieldElement(nArray);
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat128.create();
        SecP128R1Field.inv((int[])((SecP128R1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP128R1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP128R1FieldElement(nArray);
    }

    public ECFieldElement negate() {
        int[] nArray = Nat128.create();
        SecP128R1Field.negate((int[])this.x, (int[])nArray);
        return new SecP128R1FieldElement(nArray);
    }

    public ECFieldElement square() {
        int[] nArray = Nat128.create();
        SecP128R1Field.square((int[])this.x, (int[])nArray);
        return new SecP128R1FieldElement(nArray);
    }

    public ECFieldElement invert() {
        int[] nArray = Nat128.create();
        SecP128R1Field.inv((int[])this.x, (int[])nArray);
        return new SecP128R1FieldElement(nArray);
    }

    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat128.isZero((int[])nArray) || Nat128.isOne((int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat128.create();
        SecP128R1Field.square((int[])nArray, (int[])nArray2);
        SecP128R1Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        int[] nArray3 = Nat128.create();
        SecP128R1Field.squareN((int[])nArray2, (int)2, (int[])nArray3);
        SecP128R1Field.multiply((int[])nArray3, (int[])nArray2, (int[])nArray3);
        int[] nArray4 = Nat128.create();
        SecP128R1Field.squareN((int[])nArray3, (int)4, (int[])nArray4);
        SecP128R1Field.multiply((int[])nArray4, (int[])nArray3, (int[])nArray4);
        int[] nArray5 = nArray3;
        SecP128R1Field.squareN((int[])nArray4, (int)2, (int[])nArray5);
        SecP128R1Field.multiply((int[])nArray5, (int[])nArray2, (int[])nArray5);
        int[] nArray6 = nArray2;
        SecP128R1Field.squareN((int[])nArray5, (int)10, (int[])nArray6);
        SecP128R1Field.multiply((int[])nArray6, (int[])nArray5, (int[])nArray6);
        int[] nArray7 = nArray4;
        SecP128R1Field.squareN((int[])nArray6, (int)10, (int[])nArray7);
        SecP128R1Field.multiply((int[])nArray7, (int[])nArray5, (int[])nArray7);
        int[] nArray8 = nArray5;
        SecP128R1Field.square((int[])nArray7, (int[])nArray8);
        SecP128R1Field.multiply((int[])nArray8, (int[])nArray, (int[])nArray8);
        int[] nArray9 = nArray8;
        SecP128R1Field.squareN((int[])nArray9, (int)95, (int[])nArray9);
        int[] nArray10 = nArray7;
        SecP128R1Field.square((int[])nArray9, (int[])nArray10);
        return Nat128.eq((int[])nArray, (int[])nArray10) ? new SecP128R1FieldElement(nArray9) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP128R1FieldElement)) {
            return false;
        }
        SecP128R1FieldElement secP128R1FieldElement = (SecP128R1FieldElement)object;
        return Nat128.eq((int[])this.x, (int[])secP128R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode((int[])this.x, (int)0, (int)4);
    }
}

