/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

public class SPHINCSPLUSPublicKey
extends ASN1Object {
    private byte[] pkseed;
    private byte[] pkroot;

    public SPHINCSPLUSPublicKey(byte[] byArray, byte[] byArray2) {
        this.pkseed = byArray;
        this.pkroot = byArray2;
    }

    public SPHINCSPLUSPublicKey(ASN1Sequence aSN1Sequence) {
        this.pkseed = Arrays.clone((byte[])ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(0)).getOctets());
        this.pkroot = Arrays.clone((byte[])ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(1)).getOctets());
    }

    public byte[] getPkseed() {
        return Arrays.clone((byte[])this.pkseed);
    }

    public byte[] getPkroot() {
        return Arrays.clone((byte[])this.pkroot);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.pkseed));
        aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.pkroot));
        return new DERSequence(aSN1EncodableVector);
    }

    public static SPHINCSPLUSPublicKey getInstance(Object object) {
        if (object instanceof SPHINCSPLUSPublicKey) {
            return (SPHINCSPLUSPublicKey)object;
        }
        if (object != null) {
            return new SPHINCSPLUSPublicKey(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }
}

