/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import org.bouncycastle.util.Arrays;

public class DilithiumPrivateKeyParameters
extends DilithiumKeyParameters {
    final byte[] rho;
    final byte[] k;
    final byte[] tr;
    final byte[] s1;
    final byte[] s2;
    final byte[] t0;
    private final byte[] t1;

    public DilithiumPrivateKeyParameters(DilithiumParameters dilithiumParameters, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7) {
        super(true, dilithiumParameters);
        this.rho = Arrays.clone((byte[])byArray);
        this.k = Arrays.clone((byte[])byArray2);
        this.tr = Arrays.clone((byte[])byArray3);
        this.s1 = Arrays.clone((byte[])byArray4);
        this.s2 = Arrays.clone((byte[])byArray5);
        this.t0 = Arrays.clone((byte[])byArray6);
        this.t1 = Arrays.clone((byte[])byArray7);
    }

    public DilithiumPrivateKeyParameters(DilithiumParameters dilithiumParameters, byte[] byArray, DilithiumPublicKeyParameters dilithiumPublicKeyParameters) {
        super(true, dilithiumParameters);
        DilithiumEngine dilithiumEngine = dilithiumParameters.getEngine(null);
        int n = 0;
        this.rho = Arrays.copyOfRange((byte[])byArray, (int)0, (int)32);
        this.k = Arrays.copyOfRange((byte[])byArray, (int)(n += 32), (int)(n + 32));
        this.tr = Arrays.copyOfRange((byte[])byArray, (int)(n += 32), (int)(n + 64));
        int n2 = dilithiumEngine.getDilithiumL() * dilithiumEngine.getDilithiumPolyEtaPackedBytes();
        this.s1 = Arrays.copyOfRange((byte[])byArray, (int)(n += 64), (int)(n + n2));
        n += n2;
        n2 = dilithiumEngine.getDilithiumK() * dilithiumEngine.getDilithiumPolyEtaPackedBytes();
        this.s2 = Arrays.copyOfRange((byte[])byArray, (int)n, (int)(n + n2));
        n += n2;
        n2 = dilithiumEngine.getDilithiumK() * 416;
        this.t0 = Arrays.copyOfRange((byte[])byArray, (int)n, (int)(n + n2));
        n += n2;
        this.t1 = (byte[])(dilithiumPublicKeyParameters != null ? dilithiumPublicKeyParameters.getT1() : null);
    }

    public byte[] getEncoded() {
        return Arrays.concatenate((byte[][])new byte[][]{this.rho, this.k, this.tr, this.s1, this.s2, this.t0});
    }

    public byte[] getK() {
        return Arrays.clone((byte[])this.k);
    }

    public byte[] getPrivateKey() {
        return this.getEncoded();
    }

    public byte[] getPublicKey() {
        return DilithiumPublicKeyParameters.getEncoded((byte[])this.rho, (byte[])this.t1);
    }

    public DilithiumPublicKeyParameters getPublicKeyParameters() {
        return new DilithiumPublicKeyParameters(this.getParameters(), this.rho, this.t1);
    }

    public byte[] getRho() {
        return Arrays.clone((byte[])this.rho);
    }

    public byte[] getS1() {
        return Arrays.clone((byte[])this.s1);
    }

    public byte[] getS2() {
        return Arrays.clone((byte[])this.s2);
    }

    public byte[] getT0() {
        return Arrays.clone((byte[])this.t0);
    }

    public byte[] getT1() {
        return Arrays.clone((byte[])this.t1);
    }

    public byte[] getTr() {
        return Arrays.clone((byte[])this.tr);
    }
}

