/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.transport;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitSshdSessionProcess
extends Process {
    public static final Set<ClientChannelEvent> CLOSE_WAIT_EVENTS = Collections.unmodifiableSet(EnumSet.of(ClientChannelEvent.CLOSED));
    protected final ChannelExec channel;
    protected final String commandName;
    protected final long waitTimeout;
    protected final Logger log;

    public GitSshdSessionProcess(ChannelExec channel, String commandName, int timeoutSec) {
        this.channel = Objects.requireNonNull(channel, "No exec channel");
        this.commandName = commandName;
        this.waitTimeout = timeoutSec > 0 ? TimeUnit.SECONDS.toMillis(timeoutSec) : Long.MAX_VALUE;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public OutputStream getOutputStream() {
        return this.channel.getInvertedIn();
    }

    @Override
    public InputStream getInputStream() {
        return this.channel.getInvertedOut();
    }

    @Override
    public InputStream getErrorStream() {
        return this.channel.getInvertedErr();
    }

    @Override
    public int waitFor() throws InterruptedException {
        boolean traceEnabled = this.log.isTraceEnabled();
        if (traceEnabled) {
            this.log.trace("waitFor({}) channel={} waiting {} millis", new Object[]{this.commandName, this.channel, this.waitTimeout});
        }
        Set<ClientChannelEvent> res = this.channel.waitFor(CLOSE_WAIT_EVENTS, this.waitTimeout);
        if (traceEnabled) {
            this.log.trace("waitFor({}) channel={} events={}", new Object[]{this.commandName, this.channel, res});
        }
        if (res.contains((Object)ClientChannelEvent.CLOSED)) {
            return 0;
        }
        return -1;
    }

    @Override
    public int exitValue() {
        Integer status = this.channel.getExitStatus();
        if (status == null) {
            throw new IllegalThreadStateException("No channel status available");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("exitValue({}) channel={}, timeout={} millis.: {}", new Object[]{this.commandName, this.channel, this.waitTimeout, status});
        }
        return status;
    }

    @Override
    public void destroy() {
        if (this.channel.isOpen()) {
            this.channel.close(true);
        }
    }

    public String toString() {
        return "channel=" + this.channel + ", cmd=" + this.commandName + ", timeout=" + this.waitTimeout;
    }
}

