/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw.timeseries;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;

public class TimeSeriesPoint {
    private double[] measurements;
    private int hashCode;

    public TimeSeriesPoint(double[] dArray) {
        this.hashCode = 0;
        this.measurements = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.hashCode += new Double(dArray[i]).hashCode();
            this.measurements[i] = dArray[i];
        }
    }

    public TimeSeriesPoint(Collection collection) {
        this.measurements = new double[collection.size()];
        this.hashCode = 0;
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Double) {
                this.measurements[n] = (Double)e;
            } else if (e instanceof Integer) {
                this.measurements[n] = ((Integer)e).doubleValue();
            } else if (e instanceof BigInteger) {
                this.measurements[n] = ((BigInteger)e).doubleValue();
            } else {
                throw new InternalError("ERROR:  The element " + String.valueOf(e) + " is not a valid numeric type");
            }
            this.hashCode += new Double(this.measurements[n]).hashCode();
            ++n;
        }
    }

    public double get(int n) {
        return this.measurements[n];
    }

    public void set(int n, double d) {
        this.hashCode -= new Double(this.measurements[n]).hashCode();
        this.measurements[n] = d;
        this.hashCode += new Double(d).hashCode();
    }

    public double[] toArray() {
        return this.measurements;
    }

    public int size() {
        return this.measurements.length;
    }

    public String toString() {
        Object object = "(";
        for (int i = 0; i < this.measurements.length; ++i) {
            object = (String)object + this.measurements[i];
            if (i >= this.measurements.length - 1) continue;
            object = (String)object + ",";
        }
        object = (String)object + ")";
        return object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TimeSeriesPoint) {
            double[] dArray = ((TimeSeriesPoint)object).toArray();
            if (dArray.length == this.measurements.length) {
                for (int i = 0; i < this.measurements.length; ++i) {
                    if (this.measurements[i] == dArray[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

