/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4;

import scala.Function0;
import scala.Function1;
import scala.Option;
import sttp.client4.GenericRequest;
import sttp.client4.ResponseException;
import sttp.client4.SttpClientException$;
import sttp.model.Method;
import sttp.monad.MonadError;

public abstract class SttpClientException
extends Exception {
    private final GenericRequest request;
    private final Exception cause;

    public static <F, T> Object adjustExceptions(MonadError<F> monadError, Function0<Object> function0, Function1<Exception, Option<Exception>> function1) {
        return SttpClientException$.MODULE$.adjustExceptions(monadError, function0, function1);
    }

    public static Option<Exception> defaultExceptionToSttpClientException(GenericRequest<?, ?> genericRequest, Exception exception) {
        return SttpClientException$.MODULE$.defaultExceptionToSttpClientException((GenericRequest)genericRequest, exception);
    }

    public SttpClientException(GenericRequest<?, ?> request, Exception cause) {
        this.request = request;
        this.cause = cause;
        super(new StringBuilder(33).append("Exception when sending request: ").append(new Method(request.method())).append(" ").append(request.uri()).toString(), cause);
    }

    public GenericRequest<?, ?> request() {
        return this.request;
    }

    public Exception cause() {
        return this.cause;
    }

    public static class ConnectException
    extends SttpClientException {
        public ConnectException(GenericRequest<?, ?> request, Exception cause) {
            super(request, cause);
        }

        private GenericRequest<?, ?> request$accessor() {
            return super.request();
        }

        private Exception cause$accessor() {
            return super.cause();
        }
    }

    public static class ReadException
    extends SttpClientException {
        public ReadException(GenericRequest<?, ?> request, Exception cause) {
            super(request, cause);
        }

        private GenericRequest<?, ?> request$accessor() {
            return super.request();
        }

        private Exception cause$accessor() {
            return super.cause();
        }
    }

    public static class ResponseHandlingException<HE>
    extends ReadException {
        private final ResponseException responseException;

        public ResponseHandlingException(GenericRequest<?, ?> request, ResponseException<HE> responseException) {
            this.responseException = responseException;
            super(request, responseException);
        }

        private GenericRequest<?, ?> request$accessor() {
            return super.request();
        }

        public ResponseException<HE> responseException() {
            return this.responseException;
        }
    }

    public static class TimeoutException
    extends ReadException {
        public TimeoutException(GenericRequest<?, ?> request, Exception cause) {
            super(request, cause);
        }

        private GenericRequest<?, ?> request$accessor() {
            return super.request();
        }

        private Exception cause$accessor() {
            return super.cause();
        }
    }

    public static class TooManyRedirectsException
    extends ReadException {
        private final int redirects;

        public TooManyRedirectsException(GenericRequest<?, ?> request, int redirects) {
            this.redirects = redirects;
            super(request, null);
        }

        private GenericRequest<?, ?> request$accessor() {
            return super.request();
        }

        public int redirects() {
            return this.redirects;
        }
    }
}

