/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.compression;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import sttp.client4.BasicBodyPart;
import sttp.client4.BasicMultipartBody;
import sttp.client4.BasicMultipartBody$;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteArrayBody$;
import sttp.client4.ByteBufferBody;
import sttp.client4.ByteBufferBody$;
import sttp.client4.FileBody;
import sttp.client4.FileBody$;
import sttp.client4.GenericRequest;
import sttp.client4.GenericRequestBody;
import sttp.client4.InputStreamBody;
import sttp.client4.InputStreamBody$;
import sttp.client4.MultipartStreamBody;
import sttp.client4.MultipartStreamBody$;
import sttp.client4.NoBody$;
import sttp.client4.StreamBody;
import sttp.client4.StreamBody$;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.client4.compression.Compressor;
import sttp.client4.compression.CompressorExtensions;
import sttp.client4.internal.SttpFile;
import sttp.model.MediaType;
import sttp.model.Part;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Compressor$
implements CompressorExtensions,
Serializable {
    public static final Compressor$ MODULE$ = new Compressor$();

    private Compressor$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Compressor$.class);
    }

    public <T, R> Tuple2<GenericRequestBody<R>, Option<Object>> compressIfNeeded(GenericRequest<T, R> request, List<Compressor<R>> compressors) {
        Option<String> option = request.options().compressRequestBody();
        if (option instanceof Some) {
            String encoding = (String)((Some)option).value();
            Option option2 = compressors.find((Function1 & Serializable)_$1 -> _$1.encoding().equalsIgnoreCase(encoding));
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported encoding: ").append(encoding).toString());
                }
                throw new MatchError((Object)option2);
            }
            Compressor compressor = (Compressor)((Some)option2).value();
            GenericRequestBody compressedBody = compressor.apply(request.body());
            Option<Object> contentLength = this.calculateContentLength(compressedBody);
            return Tuple2$.MODULE$.apply(compressedBody, contentLength);
        }
        if (None$.MODULE$.equals(option)) {
            return Tuple2$.MODULE$.apply(request.body(), request.contentLength());
        }
        throw new MatchError(option);
    }

    private <R> Option<Object> calculateContentLength(GenericRequestBody<R> body2) {
        GenericRequestBody<R> genericRequestBody = body2;
        if (NoBody$.MODULE$.equals(genericRequestBody)) {
            return None$.MODULE$;
        }
        if (genericRequestBody instanceof StringBody) {
            StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)genericRequestBody);
            String string = stringBody._1();
            String string2 = stringBody._2();
            MediaType mediaType = stringBody._3();
            String b = string;
            String e = string2;
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)b.getBytes(e).length));
        }
        if (genericRequestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody2 = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)genericRequestBody);
            byte[] byArray = byteArrayBody2._1();
            MediaType mediaType = byteArrayBody2._2();
            byte[] b = byArray;
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)b.length));
        }
        if (genericRequestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody2 = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)genericRequestBody);
            ByteBuffer byteBuffer = byteBufferBody2._1();
            MediaType mediaType = byteBufferBody2._2();
            ByteBuffer b = byteBuffer;
            return None$.MODULE$;
        }
        if (genericRequestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody2 = InputStreamBody$.MODULE$.unapply((InputStreamBody)genericRequestBody);
            InputStream inputStream = inputStreamBody2._1();
            MediaType mediaType = inputStreamBody2._2();
            InputStream b = inputStream;
            return None$.MODULE$;
        }
        if (genericRequestBody instanceof FileBody) {
            FileBody fileBody2 = FileBody$.MODULE$.unapply((FileBody)genericRequestBody);
            SttpFile sttpFile = fileBody2._1();
            MediaType mediaType = fileBody2._2();
            SttpFile f = sttpFile;
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)f.length()));
        }
        if (genericRequestBody instanceof StreamBody) {
            StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)genericRequestBody);
            Object BinaryStream = streamBody._1();
            return None$.MODULE$;
        }
        if (genericRequestBody instanceof MultipartStreamBody) {
            Seq seq;
            MultipartStreamBody multipartStreamBody = MultipartStreamBody$.MODULE$.unapply((MultipartStreamBody)genericRequestBody);
            Seq parts = seq = multipartStreamBody._1();
            return None$.MODULE$;
        }
        if (genericRequestBody instanceof BasicMultipartBody) {
            Seq<Part<BasicBodyPart>> seq;
            BasicMultipartBody basicMultipartBody = BasicMultipartBody$.MODULE$.unapply((BasicMultipartBody)genericRequestBody);
            Seq<Part<BasicBodyPart>> parts = seq = basicMultipartBody._1();
            return None$.MODULE$;
        }
        throw new MatchError(genericRequestBody);
    }

    public Nothing$ compressingMultipartBodiesNotSupported() {
        throw new IllegalArgumentException("Multipart bodies cannot be compressed");
    }

    public Nothing$ streamsNotSupported() {
        throw new IllegalArgumentException("Streams are not supported");
    }

    public byte[] byteBufferToArray(ByteBuffer inputBuffer) {
        if (inputBuffer.hasArray()) {
            return inputBuffer.array();
        }
        byte[] inputBytes = new byte[inputBuffer.remaining()];
        inputBuffer.get(inputBytes);
        return inputBytes;
    }
}

