/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.internal;

import java.io.InputStream;
import scala.Function0;
import scala.runtime.BoxedUnit;

public class OnEndInputStream
extends InputStream {
    private final InputStream delegate;
    private final Function0<BoxedUnit> callback;
    private boolean callbackCalled;

    public OnEndInputStream(InputStream delegate, Function0<BoxedUnit> callback) {
        this.delegate = delegate;
        this.callback = callback;
        this.callbackCalled = false;
    }

    @Override
    public int read() {
        int result = this.delegate.read();
        if (result == -1) {
            this.onEnd();
        }
        return result;
    }

    @Override
    public int read(byte[] b) {
        int result = this.delegate.read(b);
        if (result == -1) {
            this.onEnd();
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int result = this.delegate.read(b, off, len);
        if (result == -1) {
            this.onEnd();
        }
        return result;
    }

    @Override
    public void close() {
        this.onEnd();
        this.delegate.close();
    }

    private void onEnd() {
        if (!this.callbackCalled) {
            this.callbackCalled = true;
            this.callback.apply();
            return;
        }
    }
}

