/*
 * Decompiled with CFR 0.152.
 */
package sttp.model;

import java.io.Serializable;
import java.net.URI;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sttp.model.QueryParams;
import sttp.model.QueryParams$;
import sttp.model.Uri;
import sttp.model.Uri$;
import sttp.model.Uri$AbsolutePath$;
import sttp.model.Uri$Authority$;
import sttp.model.Uri$EmptyPath$;
import sttp.model.Uri$FragmentSegment$;
import sttp.model.Uri$HostSegment$;
import sttp.model.Uri$PathSegment$;
import sttp.model.Uri$PathSegments$;
import sttp.model.Uri$QuerySegment$;
import sttp.model.Uri$QuerySegment$KeyValue$;
import sttp.model.Uri$QuerySegment$Plain$;
import sttp.model.Uri$QuerySegment$Value$;
import sttp.model.Uri$RelativePath$;
import sttp.model.Uri$Segment$;
import sttp.model.Uri$UserInfo$;
import sttp.model.UriInterpolator;
import sttp.model.internal.Rfc3986$;

public class Uri
implements Product,
Serializable {
    private final Option scheme;
    private final Option authority;
    private final PathSegments pathSegments;
    private final scala.collection.immutable.Seq querySegments;
    private final Option fragmentSegment;

    public static UriInterpolator.UriContext UriContext(StringContext stringContext) {
        return Uri$.MODULE$.UriContext(stringContext);
    }

    public static Uri apply(Option<String> option, Option<Authority> option2, PathSegments pathSegments, scala.collection.immutable.Seq<QuerySegment> seq, Option<Segment> option3) {
        return Uri$.MODULE$.apply(option, option2, pathSegments, seq, option3);
    }

    public static Uri apply(String string) {
        return Uri$.MODULE$.apply(string);
    }

    public static Uri apply(String string, int n) {
        return Uri$.MODULE$.apply(string, n);
    }

    public static Uri apply(String string, int n, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.apply(string, n, seq);
    }

    public static Uri apply(String string, Option<Authority> option, scala.collection.immutable.Seq<Segment> seq, scala.collection.immutable.Seq<QuerySegment> seq2, Option<Segment> option2) {
        return Uri$.MODULE$.apply(string, option, seq, seq2, option2);
    }

    public static Uri apply(String string, Option<UserInfo> option, String string2, Option<Object> option2, scala.collection.immutable.Seq<String> seq, scala.collection.immutable.Seq<QuerySegment> seq2, Option<String> option3) {
        return Uri$.MODULE$.apply(string, option, string2, option2, seq, seq2, option3);
    }

    public static Uri apply(String string, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.apply(string, seq);
    }

    public static Uri apply(String string, String string2) {
        return Uri$.MODULE$.apply(string, string2);
    }

    public static Uri apply(String string, String string2, int n) {
        return Uri$.MODULE$.apply(string, string2, n);
    }

    public static Uri apply(String string, String string2, int n, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.apply(string, string2, n, seq);
    }

    public static Uri apply(String string, String string2, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.apply(string, string2, seq);
    }

    public static Uri apply(String string, String string2, scala.collection.immutable.Seq<String> seq, Option<String> option) {
        return Uri$.MODULE$.apply(string, string2, seq, option);
    }

    public static Uri apply(URI uRI) {
        return Uri$.MODULE$.apply(uRI);
    }

    public static Uri fromProduct(Product product) {
        return Uri$.MODULE$.fromProduct(product);
    }

    public static Either<String, Uri> parse(String string) {
        return Uri$.MODULE$.parse(string);
    }

    public static Uri pathRelative(scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.pathRelative(seq);
    }

    public static Uri pathRelative(scala.collection.immutable.Seq<String> seq, Option<String> option) {
        return Uri$.MODULE$.pathRelative(seq, option);
    }

    public static Uri pathRelative(scala.collection.immutable.Seq<String> seq, scala.collection.immutable.Seq<QuerySegment> seq2, Option<String> option) {
        return Uri$.MODULE$.pathRelative(seq, seq2, option);
    }

    public static Uri relative(scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.relative(seq);
    }

    public static Uri relative(scala.collection.immutable.Seq<String> seq, Option<String> option) {
        return Uri$.MODULE$.relative(seq, option);
    }

    public static Uri relative(scala.collection.immutable.Seq<String> seq, scala.collection.immutable.Seq<QuerySegment> seq2, Option<String> option) {
        return Uri$.MODULE$.relative(seq, seq2, option);
    }

    public static Either<String, Uri> safeApply(String string) {
        return Uri$.MODULE$.safeApply(string);
    }

    public static Either<String, Uri> safeApply(String string, int n) {
        return Uri$.MODULE$.safeApply(string, n);
    }

    public static Either<String, Uri> safeApply(String string, int n, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.safeApply(string, n, seq);
    }

    public static Either<String, Uri> safeApply(String string, Option<Authority> option, scala.collection.immutable.Seq<Segment> seq, scala.collection.immutable.Seq<QuerySegment> seq2, Option<Segment> option2) {
        return Uri$.MODULE$.safeApply(string, option, seq, seq2, option2);
    }

    public static Either<String, Uri> safeApply(String string, Option<UserInfo> option, String string2, Option<Object> option2, scala.collection.immutable.Seq<String> seq, scala.collection.immutable.Seq<QuerySegment> seq2, Option<String> option3) {
        return Uri$.MODULE$.safeApply(string, option, string2, option2, seq, seq2, option3);
    }

    public static Either<String, Uri> safeApply(String string, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.safeApply(string, seq);
    }

    public static Either<String, Uri> safeApply(String string, String string2) {
        return Uri$.MODULE$.safeApply(string, string2);
    }

    public static Either<String, Uri> safeApply(String string, String string2, int n) {
        return Uri$.MODULE$.safeApply(string, string2, n);
    }

    public static Either<String, Uri> safeApply(String string, String string2, int n, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.safeApply(string, string2, n, seq);
    }

    public static Either<String, Uri> safeApply(String string, String string2, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.safeApply(string, string2, seq);
    }

    public static Either<String, Uri> safeApply(String string, String string2, scala.collection.immutable.Seq<String> seq, Option<String> option) {
        return Uri$.MODULE$.safeApply(string, string2, seq, option);
    }

    public static Uri unapply(Uri uri) {
        return Uri$.MODULE$.unapply(uri);
    }

    public static Uri unsafeApply(String string) {
        return Uri$.MODULE$.unsafeApply(string);
    }

    public static Uri unsafeApply(String string, int n) {
        return Uri$.MODULE$.unsafeApply(string, n);
    }

    public static Uri unsafeApply(String string, int n, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.unsafeApply(string, n, seq);
    }

    public static Uri unsafeApply(String string, Option<Authority> option, scala.collection.immutable.Seq<Segment> seq, scala.collection.immutable.Seq<QuerySegment> seq2, Option<Segment> option2) {
        return Uri$.MODULE$.unsafeApply(string, option, seq, seq2, option2);
    }

    public static Uri unsafeApply(String string, Option<UserInfo> option, String string2, Option<Object> option2, scala.collection.immutable.Seq<String> seq, scala.collection.immutable.Seq<QuerySegment> seq2, Option<String> option3) {
        return Uri$.MODULE$.unsafeApply(string, option, string2, option2, seq, seq2, option3);
    }

    public static Uri unsafeApply(String string, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.unsafeApply(string, seq);
    }

    public static Uri unsafeApply(String string, String string2) {
        return Uri$.MODULE$.unsafeApply(string, string2);
    }

    public static Uri unsafeApply(String string, String string2, int n) {
        return Uri$.MODULE$.unsafeApply(string, string2, n);
    }

    public static Uri unsafeApply(String string, String string2, int n, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.unsafeApply(string, string2, n, seq);
    }

    public static Uri unsafeApply(String string, String string2, scala.collection.immutable.Seq<String> seq) {
        return Uri$.MODULE$.unsafeApply(string, string2, seq);
    }

    public static Uri unsafeApply(String string, String string2, scala.collection.immutable.Seq<String> seq, Option<String> option) {
        return Uri$.MODULE$.unsafeApply(string, string2, seq, option);
    }

    public static Uri unsafeParse(String string) {
        return Uri$.MODULE$.unsafeParse(string);
    }

    public Uri(Option<String> scheme, Option<Authority> authority, PathSegments pathSegments, scala.collection.immutable.Seq<QuerySegment> querySegments, Option<Segment> fragmentSegment) {
        this.scheme = scheme;
        this.authority = authority;
        this.pathSegments = pathSegments;
        this.querySegments = querySegments;
        this.fragmentSegment = fragmentSegment;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Uri)) return false;
        Uri uri = (Uri)object;
        Option<String> option = this.scheme();
        Option<String> option2 = uri.scheme();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Authority> option3 = this.authority();
        Option<Authority> option4 = uri.authority();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        PathSegments pathSegments = this.pathSegments();
        PathSegments pathSegments2 = uri.pathSegments();
        if (pathSegments == null) {
            if (pathSegments2 != null) {
                return false;
            }
        } else if (!pathSegments.equals(pathSegments2)) return false;
        scala.collection.immutable.Seq<QuerySegment> seq = this.querySegments();
        scala.collection.immutable.Seq<QuerySegment> seq2 = uri.querySegments();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Segment> option5 = this.fragmentSegment();
        Option<Segment> option6 = uri.fragmentSegment();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!uri.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Uri;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "Uri";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "scheme";
            }
            case 1: {
                return "authority";
            }
            case 2: {
                return "pathSegments";
            }
            case 3: {
                return "querySegments";
            }
            case 4: {
                return "fragmentSegment";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Option<String> scheme() {
        return this.scheme;
    }

    public Option<Authority> authority() {
        return this.authority;
    }

    public PathSegments pathSegments() {
        return this.pathSegments;
    }

    public scala.collection.immutable.Seq<QuerySegment> querySegments() {
        return this.querySegments;
    }

    public Option<Segment> fragmentSegment() {
        return this.fragmentSegment;
    }

    public Uri scheme(String s) {
        return this.copy((Option<String>)Some$.MODULE$.apply((Object)s), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public Uri scheme(Option<String> s) {
        return this.copy(s, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public Uri userInfo(String username) {
        return this.userInfo((Option<UserInfo>)Some$.MODULE$.apply((Object)Uri$UserInfo$.MODULE$.apply(username, (Option<String>)None$.MODULE$)));
    }

    public Uri userInfo(String username, String password) {
        return this.userInfo((Option<UserInfo>)Some$.MODULE$.apply((Object)Uri$UserInfo$.MODULE$.apply(username, (Option<String>)Some$.MODULE$.apply((Object)password))));
    }

    public Uri userInfo(Option<UserInfo> ui) {
        Option<UserInfo> option = ui;
        if (option instanceof Some) {
            UserInfo v = (UserInfo)((Some)option).value();
            Some some = Some$.MODULE$.apply((Object)((Authority)this.authority().getOrElse(Uri::$anonfun$1)).userInfo((Option<UserInfo>)Some$.MODULE$.apply((Object)v)));
            Option<String> option2 = this.copy$default$1();
            PathSegments pathSegments = this.copy$default$3();
            scala.collection.immutable.Seq<QuerySegment> seq = this.copy$default$4();
            Option<Segment> option3 = this.copy$default$5();
            return this.copy(option2, (Option<Authority>)some, pathSegments, seq, option3);
        }
        if (None$.MODULE$.equals(option)) {
            Option option4 = this.authority().map((Function1 & Serializable)_$1 -> _$1.userInfo((Option<UserInfo>)None$.MODULE$));
            Option<String> option5 = this.copy$default$1();
            PathSegments pathSegments = this.copy$default$3();
            scala.collection.immutable.Seq<QuerySegment> seq = this.copy$default$4();
            Option<Segment> option6 = this.copy$default$5();
            return this.copy(option5, (Option<Authority>)option4, pathSegments, seq, option6);
        }
        throw new MatchError(option);
    }

    public Option<UserInfo> userInfo() {
        return this.authority().flatMap((Function1 & Serializable)_$2 -> _$2.userInfo());
    }

    public Uri host(String h) {
        return this.hostSegment(Uri$HostSegment$.MODULE$.apply(h));
    }

    public Uri hostSegment(Segment s) {
        return this.hostSegment((Option<Segment>)Some$.MODULE$.apply((Object)s));
    }

    public Uri hostSegment(Option<Segment> s) {
        Option option;
        Option<Authority> option2 = this.authority();
        if (option2 instanceof Some) {
            Authority a = (Authority)((Some)option2).value();
            option = s.map((Function1 & Serializable)_$3 -> a.hostSegment((Segment)_$3));
        } else if (None$.MODULE$.equals(option2)) {
            option = s.map((Function1 & Serializable)_$4 -> Uri$Authority$.MODULE$.apply((Option<UserInfo>)None$.MODULE$, (Segment)_$4, (Option<Object>)None$.MODULE$));
        } else {
            throw new MatchError(option2);
        }
        Option option3 = option;
        Option<String> option4 = this.copy$default$1();
        PathSegments pathSegments = this.copy$default$3();
        scala.collection.immutable.Seq<QuerySegment> seq = this.copy$default$4();
        Option<Segment> option5 = this.copy$default$5();
        return this.copy(option4, (Option<Authority>)option3, pathSegments, seq, option5);
    }

    public Option<String> host() {
        return this.authority().map((Function1 & Serializable)_$5 -> _$5.hostSegment().v());
    }

    public Uri port(int p) {
        return this.port((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)p)));
    }

    public Uri port(Option<Object> p) {
        Option<Object> option = p;
        if (option instanceof Some) {
            int v = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            Some some = Some$.MODULE$.apply((Object)((Authority)this.authority().getOrElse(Uri::$anonfun$5)).port(v));
            Option<String> option2 = this.copy$default$1();
            PathSegments pathSegments = this.copy$default$3();
            scala.collection.immutable.Seq<QuerySegment> seq = this.copy$default$4();
            Option<Segment> option3 = this.copy$default$5();
            return this.copy(option2, (Option<Authority>)some, pathSegments, seq, option3);
        }
        if (None$.MODULE$.equals(option)) {
            Option option4 = this.authority().map((Function1 & Serializable)_$6 -> _$6.port((Option<Object>)None$.MODULE$));
            Option<String> option5 = this.copy$default$1();
            PathSegments pathSegments = this.copy$default$3();
            scala.collection.immutable.Seq<QuerySegment> seq = this.copy$default$4();
            Option<Segment> option6 = this.copy$default$5();
            return this.copy(option5, (Option<Authority>)option4, pathSegments, seq, option6);
        }
        throw new MatchError(option);
    }

    public Option<Object> port() {
        return this.authority().flatMap((Function1 & Serializable)_$7 -> _$7.port());
    }

    public Uri authority(Authority a) {
        Some some = Some$.MODULE$.apply((Object)a);
        Option<String> option = this.copy$default$1();
        PathSegments pathSegments = this.copy$default$3();
        scala.collection.immutable.Seq<QuerySegment> seq = this.copy$default$4();
        Option<Segment> option2 = this.copy$default$5();
        return this.copy(option, (Option<Authority>)some, pathSegments, seq, option2);
    }

    public Uri authority(Some<Authority> a) {
        return this.copy(this.copy$default$1(), (Option<Authority>)a, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public Uri path(String p) {
        return this.withWholePath(p);
    }

    public Uri path(String p1, String p2, scala.collection.immutable.Seq<String> ps) {
        return this.withPath((Seq<String>)ps.toList().$colon$colon((Object)p2).$colon$colon((Object)p1));
    }

    public Uri path(Seq<String> ps) {
        return this.withPath(ps);
    }

    public Uri pathSegment(Segment s) {
        return this.withPathSegment(s);
    }

    public Uri pathSegments(Segment s1, Segment s2, scala.collection.immutable.Seq<Segment> ss) {
        return this.withPathSegments(s1, s2, ss);
    }

    public Uri pathSegments(Seq<Segment> ss) {
        return this.withPathSegments((Seq<Segment>)ss.toList());
    }

    public Uri addPath(String p, scala.collection.immutable.Seq<String> ps) {
        return this.addPath((Seq<String>)ps.toList().$colon$colon((Object)p));
    }

    public Uri addPath(Seq<String> ps) {
        return this.addPathSegments((Seq<Segment>)ps.toList().map((Function1 & Serializable)_$8 -> Uri$PathSegment$.MODULE$.apply((String)_$8)));
    }

    public Uri addPathSegment(Segment s) {
        return this.addPathSegments((Seq<Segment>)((Seq)new .colon.colon((Object)s, (List)Nil$.MODULE$)));
    }

    public Uri addPathSegments(Segment s1, Segment s2, scala.collection.immutable.Seq<Segment> ss) {
        return this.addPathSegments((Seq<Segment>)ss.toList().$colon$colon((Object)s2).$colon$colon((Object)s1));
    }

    public Uri addPathSegments(Seq<Segment> ss) {
        PathSegments pathSegments = this.pathSegments().addSegments(ss);
        Option<String> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        scala.collection.immutable.Seq<QuerySegment> seq = this.copy$default$4();
        Option<Segment> option3 = this.copy$default$5();
        return this.copy(option, option2, pathSegments, seq, option3);
    }

    public Uri withPath(String p, scala.collection.immutable.Seq<String> ps) {
        return this.withPath((Seq<String>)ps.toList().$colon$colon((Object)p));
    }

    public Uri withPath(Seq<String> ps) {
        return this.withPathSegments((Seq<Segment>)ps.toList().map((Function1 & Serializable)_$9 -> Uri$PathSegment$.MODULE$.apply((String)_$9)));
    }

    public Uri withPathSegment(Segment s) {
        return this.withPathSegments((Seq<Segment>)((Seq)new .colon.colon((Object)s, (List)Nil$.MODULE$)));
    }

    public Uri withPathSegments(Segment s1, Segment s2, scala.collection.immutable.Seq<Segment> ss) {
        return this.withPathSegments((Seq<Segment>)ss.toList().$colon$colon((Object)s2).$colon$colon((Object)s1));
    }

    public Uri withPathSegments(Seq<Segment> ss) {
        PathSegments pathSegments = this.pathSegments().withSegments(ss);
        Option<String> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        scala.collection.immutable.Seq<QuerySegment> seq = this.copy$default$4();
        Option<Segment> option3 = this.copy$default$5();
        return this.copy(option, option2, pathSegments, seq, option3);
    }

    public Uri withWholePath(String p) {
        String pWithoutLeadingSlash = p.startsWith("/") ? p.substring(1) : p;
        List ps = Predef$.MODULE$.wrapRefArray((Object[])pWithoutLeadingSlash.split("/", -1)).toList();
        return this.withPath((Seq<String>)ps);
    }

    public scala.collection.immutable.Seq<String> path() {
        return ((IterableOnceOps)this.pathSegments().segments().map((Function1 & Serializable)_$10 -> _$10.v())).toList();
    }

    public Uri param(String k, String v) {
        return this.addParam(k, v);
    }

    public Uri param(String k, Option<String> v) {
        return this.addParam(k, v);
    }

    public Uri params(Map<String, String> ps) {
        return this.addParams(ps);
    }

    public Uri params(QueryParams mqp) {
        return this.addParams(mqp);
    }

    public Uri params(scala.collection.immutable.Seq<Tuple2<String, String>> ps) {
        return this.addParams(ps);
    }

    public Uri addParam(String k, String v) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v);
        return this.addParams((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Uri addParam(String k, Option<String> v) {
        return (Uri)v.map((Function1 & Serializable)_$11 -> this.addParam(k, (String)_$11)).getOrElse(this::addParam$$anonfun$2);
    }

    public Uri addParams(Map<String, String> ps) {
        return this.addParams((scala.collection.immutable.Seq<Tuple2<String, String>>)ps.toSeq());
    }

    public Uri addParams(QueryParams mqp) {
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.querySegments().$plus$plus(Uri$QuerySegment$.MODULE$.fromQueryParams(mqp));
        Option<String> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        PathSegments pathSegments = this.copy$default$3();
        Option<Segment> option3 = this.copy$default$5();
        return this.copy(option, option2, pathSegments, (scala.collection.immutable.Seq<QuerySegment>)seq, option3);
    }

    public Uri addParams(scala.collection.immutable.Seq<Tuple2<String, String>> ps) {
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.querySegments().$plus$plus((IterableOnce)ps.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Uri$QuerySegment$KeyValue$.MODULE$.apply(k, v, Uri$QuerySegment$KeyValue$.MODULE$.$lessinit$greater$default$3(), Uri$QuerySegment$KeyValue$.MODULE$.$lessinit$greater$default$4());
            }
            throw new MatchError((Object)tuple2);
        }));
        Option<String> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        PathSegments pathSegments = this.copy$default$3();
        Option<Segment> option3 = this.copy$default$5();
        return this.copy(option, option2, pathSegments, (scala.collection.immutable.Seq<QuerySegment>)seq, option3);
    }

    public Uri withParam(String k, String v) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v);
        return this.withParams((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Uri withParam(String k, Option<String> v) {
        return (Uri)v.map((Function1 & Serializable)_$12 -> this.withParam(k, (String)_$12)).getOrElse(this::withParam$$anonfun$2);
    }

    public Uri withParams(Map<String, String> ps) {
        return this.withParams((scala.collection.immutable.Seq<Tuple2<String, String>>)ps.toSeq());
    }

    public Uri withParams(QueryParams mqp) {
        List list = Uri$QuerySegment$.MODULE$.fromQueryParams(mqp).toList();
        Option<String> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        PathSegments pathSegments = this.copy$default$3();
        Option<Segment> option3 = this.copy$default$5();
        return this.copy(option, option2, pathSegments, (scala.collection.immutable.Seq<QuerySegment>)list, option3);
    }

    public Uri withParams(scala.collection.immutable.Seq<Tuple2<String, String>> ps) {
        List list = ((IterableOnceOps)ps.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Uri$QuerySegment$KeyValue$.MODULE$.apply(k, v, Uri$QuerySegment$KeyValue$.MODULE$.$lessinit$greater$default$3(), Uri$QuerySegment$KeyValue$.MODULE$.$lessinit$greater$default$4());
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        Option<String> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        PathSegments pathSegments = this.copy$default$3();
        Option<Segment> option3 = this.copy$default$5();
        return this.copy(option, option2, pathSegments, (scala.collection.immutable.Seq<QuerySegment>)list, option3);
    }

    public Map<String, String> paramsMap() {
        return this.params().toMap();
    }

    public QueryParams params() {
        LinkedHashMap m = new LinkedHashMap();
        this.querySegments().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            QuerySegment querySegment = x$1;
            if (querySegment instanceof QuerySegment.KeyValue) {
                QuerySegment.KeyValue keyValue = Uri$QuerySegment$KeyValue$.MODULE$.unapply((QuerySegment.KeyValue)querySegment);
                String string = keyValue._1();
                String string2 = keyValue._2();
                Function1<String, String> function1 = keyValue._3();
                Function1<String, String> function12 = keyValue._4();
                String k = string;
                String v = string2;
                m.update((Object)k, ((IterableOps)m.getOrElse((Object)k, Uri::params$$anonfun$1$$anonfun$1)).$plus$plus((IterableOnce)new .colon.colon((Object)v, (List)Nil$.MODULE$)));
                return;
            }
            if (querySegment instanceof QuerySegment.Value) {
                QuerySegment.Value value = Uri$QuerySegment$Value$.MODULE$.unapply((QuerySegment.Value)querySegment);
                String string = value._1();
                Function1<String, String> function1 = value._2();
                String v = string;
                m.update((Object)v, m.getOrElse((Object)v, Uri::params$$anonfun$1$$anonfun$2));
                return;
            }
            if (querySegment instanceof QuerySegment.Plain) {
                QuerySegment.Plain plain = Uri$QuerySegment$Plain$.MODULE$.unapply((QuerySegment.Plain)querySegment);
                String string = plain._1();
                Function1<String, String> function1 = plain._2();
                String v = string;
                m.update((Object)v, m.getOrElse((Object)v, Uri::params$$anonfun$1$$anonfun$3));
                return;
            }
            throw new MatchError((Object)querySegment);
        });
        return QueryParams$.MODULE$.fromMultiSeq((scala.collection.immutable.Seq<Tuple2<String, scala.collection.immutable.Seq<String>>>)m.toSeq());
    }

    public scala.collection.immutable.Seq<Tuple2<String, String>> paramsSeq() {
        return this.params().toSeq().toList();
    }

    public Uri querySegment(QuerySegment qs) {
        return this.addQuerySegment(qs);
    }

    public Uri addQuerySegment(QuerySegment qs) {
        return this.addQuerySegments((Seq<QuerySegment>)((Seq)new .colon.colon((Object)qs, (List)Nil$.MODULE$)));
    }

    public Uri addQuerySegments(QuerySegment qs1, QuerySegment qs2, scala.collection.immutable.Seq<QuerySegment> qss) {
        return this.addQuerySegments((Seq<QuerySegment>)qss.toList().$colon$colon((Object)qs2).$colon$colon((Object)qs1));
    }

    public Uri addQuerySegments(Seq<QuerySegment> qss) {
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.querySegments().$plus$plus(qss);
        Option<String> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        PathSegments pathSegments = this.copy$default$3();
        Option<Segment> option3 = this.copy$default$5();
        return this.copy(option, option2, pathSegments, (scala.collection.immutable.Seq<QuerySegment>)seq, option3);
    }

    public Uri fragment(String f) {
        return this.fragment((Option<String>)Some$.MODULE$.apply((Object)f));
    }

    public Uri fragment(Option<String> f) {
        return this.fragmentSegment((Option<Segment>)f.map((Function1 & Serializable)_$13 -> Uri$FragmentSegment$.MODULE$.apply((String)_$13)));
    }

    public Uri fragmentSegment(Option<Segment> s) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), s);
    }

    public Option<String> fragment() {
        return this.fragmentSegment().map((Function1 & Serializable)_$14 -> _$14.v());
    }

    public URI toJavaUri() {
        return new URI(this.toString());
    }

    public boolean isAbsolute() {
        return this.scheme().isDefined();
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public Uri resolve(Uri other) {
        return Uri$.MODULE$.apply(this.toJavaUri().resolve(other.toJavaUri()));
    }

    public Uri hostSegmentEncoding(Function1<String, String> encoding) {
        Option option = this.authority().map((Function1 & Serializable)a -> {
            Segment segment = a.hostSegment().encoding(encoding);
            Option<UserInfo> option = a.copy$default$1();
            Option<Object> option2 = a.copy$default$3();
            return a.copy(option, segment, option2);
        });
        Option<String> option2 = this.copy$default$1();
        PathSegments pathSegments = this.copy$default$3();
        scala.collection.immutable.Seq<QuerySegment> seq = this.copy$default$4();
        Option<Segment> option3 = this.copy$default$5();
        return this.copy(option2, (Option<Authority>)option, pathSegments, seq, option3);
    }

    public Uri pathSegmentsEncoding(Function1<String, String> encoding) {
        Product product;
        PathSegments pathSegments = this.pathSegments();
        if (Uri$EmptyPath$.MODULE$.equals(pathSegments)) {
            product = Uri$EmptyPath$.MODULE$;
        } else if (pathSegments instanceof AbsolutePath) {
            scala.collection.immutable.Seq<Segment> seq;
            AbsolutePath absolutePath = Uri$AbsolutePath$.MODULE$.unapply((AbsolutePath)pathSegments);
            scala.collection.immutable.Seq<Segment> segments = seq = absolutePath._1();
            product = Uri$AbsolutePath$.MODULE$.apply((scala.collection.immutable.Seq<Segment>)((scala.collection.immutable.Seq)segments.map((Function1 & Serializable)_$15 -> _$15.encoding(encoding))));
        } else if (pathSegments instanceof RelativePath) {
            scala.collection.immutable.Seq<Segment> seq;
            RelativePath relativePath = Uri$RelativePath$.MODULE$.unapply((RelativePath)pathSegments);
            scala.collection.immutable.Seq<Segment> segments = seq = relativePath._1();
            product = Uri$RelativePath$.MODULE$.apply((scala.collection.immutable.Seq<Segment>)((scala.collection.immutable.Seq)segments.map((Function1 & Serializable)_$16 -> _$16.encoding(encoding))));
        } else {
            throw new MatchError((Object)pathSegments);
        }
        Uri$EmptyPath$ uri$EmptyPath$ = product;
        Option<String> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        scala.collection.immutable.Seq<QuerySegment> seq = this.copy$default$4();
        Option<Segment> option3 = this.copy$default$5();
        return this.copy(option, option2, uri$EmptyPath$, seq, option3);
    }

    public Uri querySegmentsEncoding(Function1<String, String> encoding) {
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.querySegments().map((Function1 & Serializable)x$1 -> {
            Product product;
            QuerySegment querySegment = x$1;
            if (querySegment instanceof QuerySegment.KeyValue) {
                QuerySegment.KeyValue keyValue = Uri$QuerySegment$KeyValue$.MODULE$.unapply((QuerySegment.KeyValue)querySegment);
                String string = keyValue._1();
                String string2 = keyValue._2();
                Function1<String, String> function1 = keyValue._3();
                Function1<String, String> function12 = keyValue._4();
                String k = string;
                String v = string2;
                product = Uri$QuerySegment$KeyValue$.MODULE$.apply(k, v, encoding, encoding);
            } else if (querySegment instanceof QuerySegment.Value) {
                QuerySegment.Value value = Uri$QuerySegment$Value$.MODULE$.unapply((QuerySegment.Value)querySegment);
                String string = value._1();
                Function1<String, String> function1 = value._2();
                String v = string;
                product = Uri$QuerySegment$Value$.MODULE$.apply(v, encoding);
            } else if (querySegment instanceof QuerySegment.Plain) {
                QuerySegment.Plain plain = Uri$QuerySegment$Plain$.MODULE$.unapply((QuerySegment.Plain)querySegment);
                String string = plain._1();
                Function1<String, String> function1 = plain._2();
                String v = string;
                product = Uri$QuerySegment$Plain$.MODULE$.apply(v, encoding);
            } else {
                throw new MatchError((Object)querySegment);
            }
            return product;
        });
        Option<String> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        PathSegments pathSegments = this.copy$default$3();
        Option<Segment> option3 = this.copy$default$5();
        return this.copy(option, option2, pathSegments, (scala.collection.immutable.Seq<QuerySegment>)seq, option3);
    }

    public Uri queryValueSegmentsEncoding(Function1<String, String> valueEncoding) {
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.querySegments().map((Function1 & Serializable)x$1 -> {
            QuerySegment querySegment = x$1;
            if (querySegment instanceof QuerySegment.KeyValue) {
                QuerySegment.KeyValue keyValue = Uri$QuerySegment$KeyValue$.MODULE$.unapply((QuerySegment.KeyValue)querySegment);
                String string = keyValue._1();
                String string2 = keyValue._2();
                Function1<String, String> function1 = keyValue._3();
                Function1<String, String> function12 = keyValue._4();
                String k = string;
                String v = string2;
                Function1<String, String> keyEncoding = function1;
                return Uri$QuerySegment$KeyValue$.MODULE$.apply(k, v, keyEncoding, valueEncoding);
            }
            if (querySegment instanceof QuerySegment.Value) {
                QuerySegment.Value value = Uri$QuerySegment$Value$.MODULE$.unapply((QuerySegment.Value)querySegment);
                String string = value._1();
                Function1<String, String> function1 = value._2();
                String v = string;
                return Uri$QuerySegment$Value$.MODULE$.apply(v, valueEncoding);
            }
            QuerySegment s = querySegment;
            return s;
        });
        Option<String> option = this.copy$default$1();
        Option<Authority> option2 = this.copy$default$2();
        PathSegments pathSegments = this.copy$default$3();
        Option<Segment> option3 = this.copy$default$5();
        return this.copy(option, option2, pathSegments, (scala.collection.immutable.Seq<QuerySegment>)seq, option3);
    }

    public Uri fragmentSegmentEncoding(Function1<String, String> encoding) {
        Option option = this.fragmentSegment().map((Function1 & Serializable)f -> f.encoding(encoding));
        Option<String> option2 = this.copy$default$1();
        Option<Authority> option3 = this.copy$default$2();
        PathSegments pathSegments = this.copy$default$3();
        scala.collection.immutable.Seq<QuerySegment> seq = this.copy$default$4();
        return this.copy(option2, option3, pathSegments, seq, (Option<Segment>)option);
    }

    public String schemeToString() {
        return (String)this.scheme().map((Function1 & Serializable)s -> Rfc3986$.MODULE$.encode(Rfc3986$.MODULE$.Scheme(), Rfc3986$.MODULE$.encode$default$2(), Rfc3986$.MODULE$.encode$default$3(), (String)s)).getOrElse(Uri::schemeToString$$anonfun$2);
    }

    public String pathToString() {
        String string;
        PathSegments pathSegments = this.pathSegments();
        if (this.authority().isEmpty() && this.scheme().isDefined()) {
            string = "";
        } else if (Uri$EmptyPath$.MODULE$.equals(pathSegments)) {
            string = "";
        } else if (pathSegments instanceof AbsolutePath) {
            AbsolutePath absolutePath = Uri$AbsolutePath$.MODULE$.unapply((AbsolutePath)pathSegments);
            scala.collection.immutable.Seq<Segment> seq = absolutePath._1();
            string = "/";
        } else if (pathSegments instanceof RelativePath) {
            RelativePath relativePath = Uri$RelativePath$.MODULE$.unapply((RelativePath)pathSegments);
            scala.collection.immutable.Seq<Segment> seq = relativePath._1();
            string = "";
        } else {
            throw new MatchError((Object)pathSegments);
        }
        String pathPrefixS = string;
        String pathS = ((IterableOnceOps)this.pathSegments().segments().map((Function1 & Serializable)_$17 -> _$17.encoded())).mkString("/");
        return new java.lang.StringBuilder(0).append(pathPrefixS).append(pathS).toString();
    }

    public String queryToString() {
        return this.queryToStringSafe(this.queryToStringSafe$default$1());
    }

    private String queryToStringSafe(Set<String> sensitiveQueryParams) {
        return Uri.encodeQuerySegments$1(sensitiveQueryParams, this.querySegments().toList(), true, new StringBuilder());
    }

    private Set<String> queryToStringSafe$default$1() {
        return Predef$.MODULE$.Set().empty();
    }

    public String fragmentToString() {
        return (String)this.fragmentSegment().fold(Uri::fragmentToString$$anonfun$1, (Function1 & Serializable)s -> s.encoded());
    }

    public String toString() {
        return this.toStringSafe(this.toStringSafe$default$1());
    }

    public String toStringSafe(Set<String> sensitiveQueryParams) {
        String schemeS = (String)this.scheme().map((Function1 & Serializable)s -> new java.lang.StringBuilder(1).append(Rfc3986$.MODULE$.encode(Rfc3986$.MODULE$.Scheme(), Rfc3986$.MODULE$.encode$default$2(), Rfc3986$.MODULE$.encode$default$3(), (String)s)).append(":").toString()).getOrElse(Uri::$anonfun$17);
        String authorityS = (String)this.authority().fold(Uri::$anonfun$18, (Function1 & Serializable)_$18 -> _$18.toString());
        String pathS = this.pathToString();
        String queryPrefixS = this.querySegments().isEmpty() ? "" : "?";
        String queryS = this.queryToStringSafe(sensitiveQueryParams);
        String fragS = (String)this.fragmentSegment().fold(Uri::$anonfun$20, (Function1 & Serializable)s -> new java.lang.StringBuilder(1).append("#").append(s.encoded()).toString());
        return new java.lang.StringBuilder(0).append(schemeS).append(authorityS).append(pathS).append(queryPrefixS).append(queryS).append(fragS).toString();
    }

    public Set<String> toStringSafe$default$1() {
        return Predef$.MODULE$.Set().empty();
    }

    public Uri copy(Option<String> scheme, Option<Authority> authority, PathSegments pathSegments, scala.collection.immutable.Seq<QuerySegment> querySegments, Option<Segment> fragmentSegment) {
        return new Uri(scheme, authority, pathSegments, querySegments, fragmentSegment);
    }

    public Option<String> copy$default$1() {
        return this.scheme();
    }

    public Option<Authority> copy$default$2() {
        return this.authority();
    }

    public PathSegments copy$default$3() {
        return this.pathSegments();
    }

    public scala.collection.immutable.Seq<QuerySegment> copy$default$4() {
        return this.querySegments();
    }

    public Option<Segment> copy$default$5() {
        return this.fragmentSegment();
    }

    public Option<String> _1() {
        return this.scheme();
    }

    public Option<Authority> _2() {
        return this.authority();
    }

    public PathSegments _3() {
        return this.pathSegments();
    }

    public scala.collection.immutable.Seq<QuerySegment> _4() {
        return this.querySegments();
    }

    public Option<Segment> _5() {
        return this.fragmentSegment();
    }

    private static final Authority $anonfun$1() {
        return Uri$Authority$.MODULE$.Empty();
    }

    private static final Authority $anonfun$5() {
        return Uri$Authority$.MODULE$.Empty();
    }

    private final Uri addParam$$anonfun$2() {
        return this;
    }

    private final Uri withParam$$anonfun$2() {
        return this;
    }

    private static final List params$$anonfun$1$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final List params$$anonfun$1$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private static final List params$$anonfun$1$$anonfun$3() {
        return package$.MODULE$.Nil();
    }

    private static final String schemeToString$$anonfun$2() {
        return "";
    }

    private static final String encodeQuerySegments$1(Set sensitiveQueryParams$1, List qss, boolean previousWasPlain, StringBuilder sb) {
        List list;
        while (true) {
            list = qss;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return sb.toString();
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            QuerySegment querySegment = (QuerySegment)colon2.head();
            List list3 = colon2.next$access$1();
            if (querySegment instanceof QuerySegment.Plain) {
                List t;
                QuerySegment.Plain plain = Uri$QuerySegment$Plain$.MODULE$.unapply((QuerySegment.Plain)querySegment);
                String string = plain._1();
                Function1<String, String> function1 = plain._2();
                String v = string;
                Function1<String, String> enc = function1;
                List list4 = t = list3;
                boolean bl = true;
                StringBuilder stringBuilder = sb.append((String)enc.apply((Object)v));
                qss = list4;
                previousWasPlain = bl;
                sb = stringBuilder;
                continue;
            }
            if (querySegment instanceof QuerySegment.Value) {
                QuerySegment.Value value = Uri$QuerySegment$Value$.MODULE$.unapply((QuerySegment.Value)querySegment);
                String string = value._1();
                Function1<String, String> function1 = value._2();
                String v = string;
                Function1<String, String> enc = function1;
                List t = list3;
                if (!previousWasPlain) {
                    sb.append("&");
                }
                sb.append((String)enc.apply((Object)v));
                List list5 = t;
                boolean bl = false;
                qss = list5;
                previousWasPlain = bl;
                continue;
            }
            if (!(querySegment instanceof QuerySegment.KeyValue)) break;
            QuerySegment.KeyValue keyValue = Uri$QuerySegment$KeyValue$.MODULE$.unapply((QuerySegment.KeyValue)querySegment);
            String string = keyValue._1();
            String string2 = keyValue._2();
            Function1<String, String> function1 = keyValue._3();
            Function1<String, String> function12 = keyValue._4();
            String k = string;
            String v = string2;
            Function1<String, String> kEnc = function1;
            Function1<String, String> vEnc = function12;
            List t = list3;
            if (!previousWasPlain) {
                sb.append("&");
            }
            sb.append((String)kEnc.apply((Object)k)).append("=").append(sensitiveQueryParams$1.apply((Object)k) ? "***" : (String)vEnc.apply((Object)v));
            List list6 = t;
            boolean bl = false;
            qss = list6;
            previousWasPlain = bl;
        }
        throw new MatchError((Object)list);
    }

    private static final String fragmentToString$$anonfun$1() {
        return "";
    }

    private static final String $anonfun$17() {
        return "";
    }

    private static final String $anonfun$18() {
        return "";
    }

    private static final String $anonfun$20() {
        return "";
    }

    public static class AbsolutePath
    implements PathSegments,
    Product,
    Serializable {
        private final scala.collection.immutable.Seq segments;

        public static AbsolutePath apply(scala.collection.immutable.Seq<Segment> seq) {
            return Uri$AbsolutePath$.MODULE$.apply(seq);
        }

        public static AbsolutePath fromProduct(Product product) {
            return Uri$AbsolutePath$.MODULE$.fromProduct(product);
        }

        public static AbsolutePath unapply(AbsolutePath absolutePath) {
            return Uri$AbsolutePath$.MODULE$.unapply(absolutePath);
        }

        public AbsolutePath(scala.collection.immutable.Seq<Segment> segments) {
            this.segments = segments;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AbsolutePath)) return false;
            AbsolutePath absolutePath = (AbsolutePath)object;
            scala.collection.immutable.Seq<Segment> seq = this.segments();
            scala.collection.immutable.Seq<Segment> seq2 = absolutePath.segments();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!absolutePath.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof AbsolutePath;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "AbsolutePath";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "segments";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Seq<Segment> segments() {
            return this.segments;
        }

        @Override
        public AbsolutePath withSegments(Seq<Segment> ss) {
            return this.copy((scala.collection.immutable.Seq<Segment>)ss.toList());
        }

        public String toString() {
            return new java.lang.StringBuilder(1).append("/").append(((IterableOnceOps)this.segments().map(Uri$::sttp$model$Uri$AbsolutePath$$_$toString$$anonfun$1)).mkString("/")).toString();
        }

        public AbsolutePath copy(scala.collection.immutable.Seq<Segment> segments) {
            return new AbsolutePath(segments);
        }

        public scala.collection.immutable.Seq<Segment> copy$default$1() {
            return this.segments();
        }

        public scala.collection.immutable.Seq<Segment> _1() {
            return this.segments();
        }
    }

    public static class Authority
    implements Product,
    Serializable {
        private final Option userInfo;
        private final Segment hostSegment;
        private final Option port;

        public static Authority Empty() {
            return Uri$Authority$.MODULE$.Empty();
        }

        public static Authority apply(Option<UserInfo> option, Segment segment, Option<Object> option2) {
            return Uri$Authority$.MODULE$.apply(option, segment, option2);
        }

        public static Authority apply(String string) {
            return Uri$Authority$.MODULE$.apply(string);
        }

        public static Authority apply(String string, int n) {
            return Uri$Authority$.MODULE$.apply(string, n);
        }

        public static Authority fromProduct(Product product) {
            return Uri$Authority$.MODULE$.fromProduct(product);
        }

        public static Either<String, Authority> safeApply(String string) {
            return Uri$Authority$.MODULE$.safeApply(string);
        }

        public static Either<String, Authority> safeApply(String string, int n) {
            return Uri$Authority$.MODULE$.safeApply(string, n);
        }

        public static Authority unapply(Authority authority) {
            return Uri$Authority$.MODULE$.unapply(authority);
        }

        public static Authority unsafeApply(String string) {
            return Uri$Authority$.MODULE$.unsafeApply(string);
        }

        public static Authority unsafeApply(String string, int n) {
            return Uri$Authority$.MODULE$.unsafeApply(string, n);
        }

        public Authority(Option<UserInfo> userInfo, Segment hostSegment, Option<Object> port) {
            this.userInfo = userInfo;
            this.hostSegment = hostSegment;
            this.port = port;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Authority)) return false;
            Authority authority = (Authority)object;
            Option<UserInfo> option = this.userInfo();
            Option<UserInfo> option2 = authority.userInfo();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Segment segment = this.hostSegment();
            Segment segment2 = authority.hostSegment();
            if (segment == null) {
                if (segment2 != null) {
                    return false;
                }
            } else if (!((Object)segment).equals(segment2)) return false;
            Option<Object> option3 = this.port();
            Option<Object> option4 = authority.port();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!authority.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Authority;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Authority";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "userInfo";
                }
                case 1: {
                    return "hostSegment";
                }
                case 2: {
                    return "port";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<UserInfo> userInfo() {
            return this.userInfo;
        }

        public Segment hostSegment() {
            return this.hostSegment;
        }

        public Option<Object> port() {
            return this.port;
        }

        public Authority userInfo(String username) {
            return this.copy((Option<UserInfo>)Some$.MODULE$.apply((Object)Uri$UserInfo$.MODULE$.apply(username, (Option<String>)None$.MODULE$)), this.copy$default$2(), this.copy$default$3());
        }

        public Authority userInfo(String username, String password) {
            return this.copy((Option<UserInfo>)Some$.MODULE$.apply((Object)Uri$UserInfo$.MODULE$.apply(username, (Option<String>)Some$.MODULE$.apply((Object)password))), this.copy$default$2(), this.copy$default$3());
        }

        public Authority userInfo(Option<UserInfo> ui) {
            return this.copy(ui, this.copy$default$2(), this.copy$default$3());
        }

        public Authority host(String h) {
            return this.hostSegment(Uri$HostSegment$.MODULE$.apply(h));
        }

        public Authority hostSegment(Segment s) {
            return this.copy(this.copy$default$1(), s, this.copy$default$3());
        }

        public String host() {
            return this.hostSegment().v();
        }

        public Authority port(int p) {
            return this.port((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)p)));
        }

        public Authority port(Option<Object> p) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), p);
        }

        public String toString() {
            String userInfoS = (String)this.userInfo().fold(Uri$::sttp$model$Uri$Authority$$_$_$$anonfun$22, (Function1 & Serializable)_$42 -> new java.lang.StringBuilder(1).append(this.encodeUserInfo$1((UserInfo)_$42)).append("@").toString());
            String hostS = this.hostSegment().encoded();
            String portS = (String)this.port().fold(Uri$::sttp$model$Uri$Authority$$_$_$$anonfun$24, Uri$::sttp$model$Uri$Authority$$_$_$$anonfun$adapted$1);
            return new java.lang.StringBuilder(2).append("//").append(userInfoS).append(hostS).append(portS).toString();
        }

        public Authority copy(Option<UserInfo> userInfo, Segment hostSegment, Option<Object> port) {
            return new Authority(userInfo, hostSegment, port);
        }

        public Option<UserInfo> copy$default$1() {
            return this.userInfo();
        }

        public Segment copy$default$2() {
            return this.hostSegment();
        }

        public Option<Object> copy$default$3() {
            return this.port();
        }

        public Option<UserInfo> _1() {
            return this.userInfo();
        }

        public Segment _2() {
            return this.hostSegment();
        }

        public Option<Object> _3() {
            return this.port();
        }

        private final String encodeUserInfo$1(UserInfo ui) {
            return new java.lang.StringBuilder(0).append(Rfc3986$.MODULE$.encode(Rfc3986$.MODULE$.UserInfo(), Rfc3986$.MODULE$.encode$default$2(), Rfc3986$.MODULE$.encode$default$3(), ui.username())).append(ui.password().fold(Uri$::sttp$model$Uri$Authority$$_$encodeUserInfo$1$$anonfun$1, Uri$::sttp$model$Uri$Authority$$_$encodeUserInfo$1$$anonfun$2)).toString();
        }
    }

    public static interface PathSegments {
        public static PathSegments absoluteOrEmpty(scala.collection.immutable.Seq<Segment> seq) {
            return Uri$PathSegments$.MODULE$.absoluteOrEmpty(seq);
        }

        public static PathSegments absoluteOrEmptyS(scala.collection.immutable.Seq<String> seq) {
            return Uri$PathSegments$.MODULE$.absoluteOrEmptyS(seq);
        }

        public static int ordinal(PathSegments pathSegments) {
            return Uri$PathSegments$.MODULE$.ordinal(pathSegments);
        }

        public Seq<Segment> segments();

        public static PathSegments add$(PathSegments $this, String p, scala.collection.immutable.Seq ps) {
            return $this.add(p, (scala.collection.immutable.Seq<String>)ps);
        }

        default public PathSegments add(String p, scala.collection.immutable.Seq<String> ps) {
            return this.add((Seq<String>)ps.toList().$colon$colon((Object)p));
        }

        public static PathSegments add$(PathSegments $this, Seq ps) {
            return $this.add((Seq<String>)ps);
        }

        default public PathSegments add(Seq<String> ps) {
            return this.addSegments((Seq<Segment>)ps.toList().map(Uri$::sttp$model$Uri$PathSegments$$_$add$$anonfun$1));
        }

        public static PathSegments addSegment$(PathSegments $this, Segment s) {
            return $this.addSegment(s);
        }

        default public PathSegments addSegment(Segment s) {
            return this.addSegments((Seq<Segment>)((Seq)new .colon.colon((Object)s, (List)Nil$.MODULE$)));
        }

        public static PathSegments addSegments$(PathSegments $this, Segment s1, Segment s2, scala.collection.immutable.Seq ss) {
            return $this.addSegments(s1, s2, (scala.collection.immutable.Seq<Segment>)ss);
        }

        default public PathSegments addSegments(Segment s1, Segment s2, scala.collection.immutable.Seq<Segment> ss) {
            return this.addSegments((Seq<Segment>)ss.toList().$colon$colon((Object)s2).$colon$colon((Object)s1));
        }

        public static PathSegments addSegments$(PathSegments $this, Seq ss) {
            return $this.addSegments((Seq<Segment>)ss);
        }

        default public PathSegments addSegments(Seq<Segment> ss) {
            Seq base = this.segments().lastOption().exists(Uri$::sttp$model$Uri$PathSegments$$_$_$$anonfun$26) ? (Seq)this.segments().init() : this.segments();
            return this.withSegments((Seq<Segment>)((Seq)base.$plus$plus((IterableOnce)ss.toList())));
        }

        public static PathSegments withS$(PathSegments $this, String p, scala.collection.immutable.Seq ps) {
            return $this.withS(p, (scala.collection.immutable.Seq<String>)ps);
        }

        default public PathSegments withS(String p, scala.collection.immutable.Seq<String> ps) {
            return this.withS((Seq<String>)ps.toList().$colon$colon((Object)p));
        }

        public static PathSegments withS$(PathSegments $this, Seq ps) {
            return $this.withS((Seq<String>)ps);
        }

        default public PathSegments withS(Seq<String> ps) {
            return this.withSegments((Seq<Segment>)ps.toList().map(Uri$::sttp$model$Uri$PathSegments$$_$withS$$anonfun$1));
        }

        public static PathSegments withSegment$(PathSegments $this, Segment s) {
            return $this.withSegment(s);
        }

        default public PathSegments withSegment(Segment s) {
            return this.withSegments((Seq<Segment>)((Seq)new .colon.colon((Object)s, (List)Nil$.MODULE$)));
        }

        public static PathSegments withSegments$(PathSegments $this, Segment s1, Segment s2, scala.collection.immutable.Seq ss) {
            return $this.withSegments(s1, s2, (scala.collection.immutable.Seq<Segment>)ss);
        }

        default public PathSegments withSegments(Segment s1, Segment s2, scala.collection.immutable.Seq<Segment> ss) {
            return this.withSegments((Seq<Segment>)ss.toList().$colon$colon((Object)s2).$colon$colon((Object)s1));
        }

        public PathSegments withSegments(Seq<Segment> var1);
    }

    public static interface QuerySegment {
        public static Iterable<QuerySegment> fromQueryParams(QueryParams queryParams) {
            return Uri$QuerySegment$.MODULE$.fromQueryParams(queryParams);
        }

        public static int ordinal(QuerySegment querySegment) {
            return Uri$QuerySegment$.MODULE$.ordinal(querySegment);
        }
    }

    public static class RelativePath
    implements PathSegments,
    Product,
    Serializable {
        private final scala.collection.immutable.Seq segments;

        public static RelativePath apply(scala.collection.immutable.Seq<Segment> seq) {
            return Uri$RelativePath$.MODULE$.apply(seq);
        }

        public static RelativePath fromProduct(Product product) {
            return Uri$RelativePath$.MODULE$.fromProduct(product);
        }

        public static RelativePath unapply(RelativePath relativePath) {
            return Uri$RelativePath$.MODULE$.unapply(relativePath);
        }

        public RelativePath(scala.collection.immutable.Seq<Segment> segments) {
            this.segments = segments;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RelativePath)) return false;
            RelativePath relativePath = (RelativePath)object;
            scala.collection.immutable.Seq<Segment> seq = this.segments();
            scala.collection.immutable.Seq<Segment> seq2 = relativePath.segments();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!relativePath.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof RelativePath;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RelativePath";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "segments";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Seq<Segment> segments() {
            return this.segments;
        }

        @Override
        public RelativePath withSegments(Seq<Segment> ss) {
            return this.copy((scala.collection.immutable.Seq<Segment>)ss.toList());
        }

        public String toString() {
            return ((IterableOnceOps)this.segments().map(Uri$::sttp$model$Uri$RelativePath$$_$toString$$anonfun$2)).mkString("/");
        }

        public RelativePath copy(scala.collection.immutable.Seq<Segment> segments) {
            return new RelativePath(segments);
        }

        public scala.collection.immutable.Seq<Segment> copy$default$1() {
            return this.segments();
        }

        public scala.collection.immutable.Seq<Segment> _1() {
            return this.segments();
        }
    }

    public static class Segment
    implements Product,
    Serializable {
        private final String v;
        private final Function1 encoding;

        public static Segment apply(String string, Function1<String, String> function1) {
            return Uri$Segment$.MODULE$.apply(string, function1);
        }

        public static Segment fromProduct(Product product) {
            return Uri$Segment$.MODULE$.fromProduct(product);
        }

        public static Segment unapply(Segment segment) {
            return Uri$Segment$.MODULE$.unapply(segment);
        }

        public Segment(String v, Function1<String, String> encoding) {
            this.v = v;
            this.encoding = encoding;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Segment)) return false;
            Segment segment = (Segment)object;
            String string = this.v();
            String string2 = segment.v();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Function1<String, String> function1 = this.encoding();
            Function1<String, String> function12 = segment.encoding();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!segment.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Segment;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Segment";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "v";
            }
            if (1 == n2) {
                return "encoding";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String v() {
            return this.v;
        }

        public Function1<String, String> encoding() {
            return this.encoding;
        }

        public String encoded() {
            return (String)this.encoding().apply((Object)this.v());
        }

        public Segment encoding(Function1<String, String> e) {
            return this.copy(this.copy$default$1(), e);
        }

        public Segment copy(String v, Function1<String, String> encoding) {
            return new Segment(v, encoding);
        }

        public String copy$default$1() {
            return this.v();
        }

        public Function1<String, String> copy$default$2() {
            return this.encoding();
        }

        public String _1() {
            return this.v();
        }

        public Function1<String, String> _2() {
            return this.encoding();
        }
    }

    public static class UserInfo
    implements Product,
    Serializable {
        private final String username;
        private final Option password;

        public static UserInfo apply(String string, Option<String> option) {
            return Uri$UserInfo$.MODULE$.apply(string, option);
        }

        public static UserInfo fromProduct(Product product) {
            return Uri$UserInfo$.MODULE$.fromProduct(product);
        }

        public static UserInfo unapply(UserInfo userInfo) {
            return Uri$UserInfo$.MODULE$.unapply(userInfo);
        }

        public UserInfo(String username, Option<String> password) {
            this.username = username;
            this.password = password;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UserInfo)) return false;
            UserInfo userInfo = (UserInfo)object;
            String string = this.username();
            String string2 = userInfo.username();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.password();
            Option<String> option2 = userInfo.password();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!userInfo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UserInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "UserInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "username";
            }
            if (1 == n2) {
                return "password";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String username() {
            return this.username;
        }

        public Option<String> password() {
            return this.password;
        }

        public UserInfo copy(String username, Option<String> password) {
            return new UserInfo(username, password);
        }

        public String copy$default$1() {
            return this.username();
        }

        public Option<String> copy$default$2() {
            return this.password();
        }

        public String _1() {
            return this.username();
        }

        public Option<String> _2() {
            return this.password();
        }
    }
}

