/*
 * Decompiled with CFR 0.152.
 */
package sttp.model;

import java.io.Serializable;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import sttp.model.Uri;
import sttp.model.Uri$;
import sttp.model.Uri$EmptyPath$;
import sttp.model.Uri$QuerySegment$KeyValue$;
import sttp.model.Uri$QuerySegment$Value$;
import sttp.model.UriInterpolator;
import sttp.model.UriInterpolator$AmpInQuery$;
import sttp.model.UriInterpolator$AtInAuthority$;
import sttp.model.UriInterpolator$AuthorityEnd$;
import sttp.model.UriInterpolator$ColonInAuthority$;
import sttp.model.UriInterpolator$DotInAuthority$;
import sttp.model.UriInterpolator$EqInQuery$;
import sttp.model.UriInterpolator$ExpressionToken$;
import sttp.model.UriInterpolator$FragmentStart$;
import sttp.model.UriInterpolator$PathStart$;
import sttp.model.UriInterpolator$QueryStart$;
import sttp.model.UriInterpolator$SchemeEnd$;
import sttp.model.UriInterpolator$SlashInPath$;
import sttp.model.UriInterpolator$StringToken$;
import sttp.model.UriInterpolator$Tokenizer$;
import sttp.model.UriInterpolator$Tokenizer$Authority$;
import sttp.model.UriInterpolator$Tokenizer$Scheme$;
import sttp.model.UriInterpolator$UriBuilder$;
import sttp.model.UriInterpolator$UriBuilder$Fragment$;
import sttp.model.UriInterpolator$UriBuilder$HostPort$;
import sttp.model.UriInterpolator$UriBuilder$Path$;
import sttp.model.UriInterpolator$UriBuilder$Query$;
import sttp.model.UriInterpolator$UriBuilder$Scheme$;
import sttp.model.UriInterpolator$UriBuilder$UserInfo$;
import sttp.model.internal.ArrayView;
import sttp.model.internal.FastCharMap;
import sttp.model.internal.FastCharSet;
import sttp.model.internal.ParseUtils$;

public final class UriInterpolator$
implements Serializable {
    private static final Uri startingUri;
    public static final ClassTag<UriInterpolator.Token> sttp$model$UriInterpolator$$$tokenClassTag;
    private static final List<UriInterpolator.UriBuilder> builders;
    public static final UriInterpolator.StringToken sttp$model$UriInterpolator$$$emptyStringToken;
    public static final UriInterpolator$StringToken$ sttp$model$UriInterpolator$$$StringToken;
    public static final UriInterpolator$ExpressionToken$ sttp$model$UriInterpolator$$$ExpressionToken;
    public static final UriInterpolator$SchemeEnd$ sttp$model$UriInterpolator$$$SchemeEnd;
    public static final UriInterpolator$ColonInAuthority$ sttp$model$UriInterpolator$$$ColonInAuthority;
    public static final UriInterpolator$AtInAuthority$ sttp$model$UriInterpolator$$$AtInAuthority;
    public static final UriInterpolator$DotInAuthority$ sttp$model$UriInterpolator$$$DotInAuthority;
    public static final UriInterpolator$AuthorityEnd$ sttp$model$UriInterpolator$$$AuthorityEnd;
    public static final UriInterpolator$PathStart$ sttp$model$UriInterpolator$$$PathStart;
    public static final UriInterpolator$SlashInPath$ sttp$model$UriInterpolator$$$SlashInPath;
    public static final UriInterpolator$QueryStart$ sttp$model$UriInterpolator$$$QueryStart;
    public static final UriInterpolator$AmpInQuery$ sttp$model$UriInterpolator$$$AmpInQuery;
    public static final UriInterpolator$EqInQuery$ sttp$model$UriInterpolator$$$EqInQuery;
    public static final UriInterpolator$FragmentStart$ sttp$model$UriInterpolator$$$FragmentStart;
    private static final UriInterpolator$Tokenizer$ Tokenizer;
    private static final UriInterpolator$UriBuilder$ UriBuilder;
    public static final UriInterpolator$ MODULE$;

    private UriInterpolator$() {
    }

    static {
        MODULE$ = new UriInterpolator$();
        startingUri = Uri$.MODULE$.apply((Option<String>)None$.MODULE$, (Option<Uri.Authority>)None$.MODULE$, Uri$EmptyPath$.MODULE$, (Seq<Uri.QuerySegment>)package$.MODULE$.Nil(), (Option<Uri.Segment>)None$.MODULE$);
        sttp$model$UriInterpolator$$$tokenClassTag = ClassTag$.MODULE$.apply(UriInterpolator.Token.class);
        builders = (List)new .colon.colon((Object)UriInterpolator$UriBuilder$Scheme$.MODULE$, (List)new .colon.colon((Object)UriInterpolator$UriBuilder$UserInfo$.MODULE$, (List)new .colon.colon((Object)UriInterpolator$UriBuilder$HostPort$.MODULE$, (List)new .colon.colon((Object)UriInterpolator$UriBuilder$Path$.MODULE$, (List)new .colon.colon((Object)UriInterpolator$UriBuilder$Query$.MODULE$, (List)new .colon.colon((Object)UriInterpolator$UriBuilder$Fragment$.MODULE$, (List)Nil$.MODULE$))))));
        sttp$model$UriInterpolator$$$emptyStringToken = UriInterpolator$StringToken$.MODULE$.apply("");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UriInterpolator$.class);
    }

    public Uri interpolate(StringContext sc, Seq<Object> args) {
        boolean isScEmptyString = ((IterableOnceOps)sc.parts().map((Function1 & Serializable)_$1 -> _$1.trim())).forall((Function1 & Serializable)_$2 -> _$2.equals(""));
        boolean areArgsEmptyString = args.forall((Function1 & Serializable)_$3 -> _$3.equals(""));
        if (isScEmptyString && areArgsEmptyString) {
            throw new IllegalArgumentException("empty string is not valid uri");
        }
        ArrayBuffer<UriInterpolator.Token> tokens = this.tokenize(sc, args);
        Tuple2 tuple2 = (Tuple2)builders.foldLeft((Object)Tuple2$.MODULE$.apply((Object)startingUri, this.filterNulls(tokens)), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                Uri u = (Uri)tuple2._1();
                ArrayView t = (ArrayView)tuple2._2();
                UriInterpolator.UriBuilder builder = (UriInterpolator.UriBuilder)tuple22._2();
                return builder.fromTokens(u, t);
            }
            throw new MatchError((Object)tuple22);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Uri uri = (Uri)tuple2._1();
        ArrayView leftTokens = (ArrayView)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)uri, (Object)leftTokens);
        Uri uri2 = (Uri)tuple22._1();
        ArrayView leftTokens2 = (ArrayView)tuple22._2();
        if (leftTokens2.nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(59).append("Tokens left after building the whole uri: ").append(leftTokens2).append(", result so far: ").append(uri2).toString());
        }
        return uri2;
    }

    private ArrayBuffer<UriInterpolator.Token> tokenize(StringContext sc, Seq<Object> args) {
        Iterator strings = sc.parts().iterator();
        Iterator expressions = args.iterator();
        ArrayBuffer tokens = new ArrayBuffer(32);
        ObjectRef tokenizer = ObjectRef.create((Object)UriInterpolator$Tokenizer$Scheme$.MODULE$.tokenize((ArrayBuffer<UriInterpolator.Token>)tokens, (String)strings.next()));
        while (strings.hasNext()) {
            Object nextExpression = expressions.next();
            String nextExpressionStr = nextExpression.toString();
            String nextStr = (String)strings.next();
            if (tokens.size() == 1 && tokens.startsWith((IterableOnce)new .colon.colon((Object)sttp$model$UriInterpolator$$$emptyStringToken, (List)Nil$.MODULE$), tokens.startsWith$default$2()) && (nextExpressionStr.contains("://") || !nextStr.contains("://"))) {
                this.tokenizeExpressionAsString$1(tokenizer, tokens, nextExpression);
                this.tokenizeStringRemoveEmptyPrefix$1(tokens, tokenizer, nextStr);
                continue;
            }
            tokens.$plus$eq((Object)UriInterpolator$ExpressionToken$.MODULE$.apply(nextExpression));
            tokenizer.elem = ((UriInterpolator.Tokenizer)tokenizer.elem).tokenize((ArrayBuffer<UriInterpolator.Token>)tokens, nextStr);
        }
        ((UriInterpolator.Tokenizer)tokenizer.elem).endToken().foreach((Function1 & Serializable)_$6 -> (ArrayBuffer)tokens.$plus$eq(_$6));
        this.removeEmptyTokensAroundExp((ArrayBuffer<UriInterpolator.Token>)tokens);
        this.addPathStartAfterAuthorityOrSchemeEnd((ArrayBuffer<UriInterpolator.Token>)tokens);
        return tokens;
    }

    private void removeEmptyTokensAroundExp(ArrayBuffer<UriInterpolator.Token> tokens) {
        BooleanRef prevWasEmptyString = BooleanRef.create((boolean)false);
        BooleanRef prevWasExpression = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), tokens.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            UriInterpolator.Token token = (UriInterpolator.Token)tokens.apply(idx);
            UriInterpolator.StringToken stringToken = sttp$model$UriInterpolator$$$emptyStringToken;
            UriInterpolator.Token token2 = token;
            if (!(stringToken != null ? !((Object)stringToken).equals(token2) : token2 != null)) {
                if (prevWasExpression$1.elem) {
                    tokens.update(idx, null);
                    prevWasExpression$1.elem = false;
                    return;
                }
                prevWasEmptyString$1.elem = true;
                return;
            }
            if (token instanceof UriInterpolator.ExpressionToken) {
                UriInterpolator.ExpressionToken expressionToken = UriInterpolator$ExpressionToken$.MODULE$.unapply((UriInterpolator.ExpressionToken)token);
                Object object = expressionToken._1();
                if (prevWasEmptyString$1.elem) {
                    tokens.update(idx - 1, null);
                    prevWasEmptyString$1.elem = false;
                }
                prevWasExpression$1.elem = true;
                return;
            }
            if (token == null) {
                return;
            }
            prevWasExpression$1.elem = false;
            prevWasEmptyString$1.elem = false;
        });
    }

    private void addPathStartAfterAuthorityOrSchemeEnd(ArrayBuffer<UriInterpolator.Token> tokens) {
        int n;
        int n2 = tokens.indexOf((Object)UriInterpolator$AuthorityEnd$.MODULE$);
        int endIndex = -1 == n2 ? tokens.indexOf((Object)UriInterpolator$SchemeEnd$.MODULE$) : (n = n2);
        this.nextNonNull(tokens, endIndex + 1).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UriInterpolator.Token afterEndIndex;
                UriInterpolator.Token token = afterEndIndex = (UriInterpolator.Token)tuple2._2();
                UriInterpolator$PathStart$ uriInterpolator$PathStart$ = UriInterpolator$PathStart$.MODULE$;
                if (token == null ? uriInterpolator$PathStart$ != null : !token.equals(uriInterpolator$PathStart$)) {
                    UriInterpolator.Token token2 = afterEndIndex;
                    UriInterpolator$QueryStart$ uriInterpolator$QueryStart$ = UriInterpolator$QueryStart$.MODULE$;
                    if (token2 == null ? uriInterpolator$QueryStart$ != null : !token2.equals(uriInterpolator$QueryStart$)) {
                        UriInterpolator.Token token3 = afterEndIndex;
                        UriInterpolator$FragmentStart$ uriInterpolator$FragmentStart$ = UriInterpolator$FragmentStart$.MODULE$;
                        if (token3 == null ? uriInterpolator$FragmentStart$ != null : !token3.equals(uriInterpolator$FragmentStart$)) {
                            if (endIndex == -1) {
                                tokens.prepend((Object)UriInterpolator$PathStart$.MODULE$);
                                return;
                            }
                            tokens.insert(endIndex + 1, (Object)UriInterpolator$PathStart$.MODULE$);
                            return;
                        }
                    }
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private ArrayView<UriInterpolator.Token> filterNulls(ArrayBuffer<UriInterpolator.Token> tokens) {
        UriInterpolator.Token[] array = new UriInterpolator.Token[tokens.size()];
        IntRef i = IntRef.create((int)0);
        tokens.foreach((Function1)(JProcedure1 & Serializable)token -> {
            if (token != null) {
                array$1[i$1.elem] = token;
                ++i$1.elem;
                return;
            }
        });
        return new ArrayView<UriInterpolator.Token>(array, 0, i.elem);
    }

    private <T> Option<Tuple2<Object, T>> lastNonNull(ArrayBuffer<T> tokens, int from) {
        int idx = tokens.lastIndexWhere((Function1 & Serializable)_$18 -> _$18 != null, from);
        if (idx == -1) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)idx), tokens.apply(idx)));
    }

    private <T> Option<Tuple2<Object, T>> nextNonNull(ArrayBuffer<T> tokens, int from) {
        int idx = tokens.indexWhere((Function1 & Serializable)_$19 -> _$19 != null, from);
        if (idx == -1) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)idx), tokens.apply(idx)));
    }

    private final void tokenizeExpressionAsString$1(ObjectRef tokenizer$1, ArrayBuffer tokens$1, Object nextExpression$1) {
        tokenizer$1.elem = ((UriInterpolator.Tokenizer)tokenizer$1.elem).tokenize((ArrayBuffer<UriInterpolator.Token>)tokens$1, nextExpression$1.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSlash$1(UriInterpolator.Token t) {
        UriInterpolator.Token token = t;
        UriInterpolator$SlashInPath$ uriInterpolator$SlashInPath$ = UriInterpolator$SlashInPath$.MODULE$;
        if (token == null) {
            if (uriInterpolator$SlashInPath$ == null) return true;
        } else if (token.equals(uriInterpolator$SlashInPath$)) return true;
        UriInterpolator.Token token2 = t;
        UriInterpolator$PathStart$ uriInterpolator$PathStart$ = UriInterpolator$PathStart$.MODULE$;
        if (token2 != null) {
            if (!token2.equals(uriInterpolator$PathStart$)) return false;
            return true;
        }
        if (uriInterpolator$PathStart$ == null) return true;
        return false;
    }

    private final void tokenizeStringRemoveEmptyPrefix$1(ArrayBuffer tokens$2, ObjectRef tokenizer$2, String nextStr$1) {
        int initLength = tokens$2.size();
        tokenizer$2.elem = ((UriInterpolator.Tokenizer)tokenizer$2.elem).tokenize((ArrayBuffer<UriInterpolator.Token>)tokens$2, nextStr$1);
        if (initLength < tokens$2.size()) {
            Object object = tokens$2.apply(initLength);
            UriInterpolator.StringToken stringToken = sttp$model$UriInterpolator$$$emptyStringToken;
            if (!(object != null ? !object.equals(stringToken) : stringToken != null)) {
                tokens$2.update(initLength, null);
            }
        }
        this.nextNonNull(tokens$2, initLength).filter((Function1 & Serializable)_$4 -> {
            Object object = _$4._2();
            UriInterpolator$SlashInPath$ uriInterpolator$SlashInPath$ = UriInterpolator$SlashInPath$.MODULE$;
            return !(object != null ? !object.equals(uriInterpolator$SlashInPath$) : uriInterpolator$SlashInPath$ != null);
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int slashInPathIdx = BoxesRunTime.unboxToInt((Object)tuple2._1());
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$13 -> {
            Tuple2 tuple2 = x$13;
            if (tuple2 != null) {
                int slashInPathIdx = BoxesRunTime.unboxToInt((Object)tuple2._1());
                this.lastNonNull(tokens$2, initLength - 1).filter((Function1 & Serializable)_$5 -> {
                    Object object = _$5._2();
                    UriInterpolator.StringToken stringToken = sttp$model$UriInterpolator$$$emptyStringToken;
                    return !(object != null ? !object.equals(stringToken) : stringToken != null);
                }).withFilter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        int emptyStringTokenIdx = BoxesRunTime.unboxToInt((Object)tuple2._1());
                        return true;
                    }
                    return false;
                }).foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
                    Tuple2 tuple2 = x$12;
                    if (tuple2 != null) {
                        int emptyStringTokenIdx = BoxesRunTime.unboxToInt((Object)tuple2._1());
                        this.lastNonNull(tokens$2, emptyStringTokenIdx - 1).filter((Function1 & Serializable)tuple -> this.isSlash$1((UriInterpolator.Token)tuple._2())).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            tokens$2.update(slashInPathIdx, null);
                            tokens$2.update(emptyStringTokenIdx, null);
                        });
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ boolean sttp$model$UriInterpolator$Tokenizer$Authority$$$_$isIpV6Like$$anonfun$1(String str$1, int i) {
        return UriInterpolator$Tokenizer$Authority$.sttp$model$UriInterpolator$Tokenizer$Authority$$$HexChars.contains(str$1.charAt(i));
    }

    public static final /* synthetic */ void sttp$model$UriInterpolator$Tokenizer$Authority$$$_$tokenize$$anonfun$2(ArrayBuffer buffer$1, int idx) {
        UriInterpolator.StringToken stringToken;
        String string;
        String s;
        UriInterpolator.Token token = (UriInterpolator.Token)buffer$1.apply(idx);
        if (token instanceof UriInterpolator.StringToken && UriInterpolator$Tokenizer$Authority$.MODULE$.sttp$model$UriInterpolator$Tokenizer$Authority$$$isIpV6Like(s = (string = (stringToken = UriInterpolator$StringToken$.MODULE$.unapply((UriInterpolator.StringToken)token))._1()))) {
            buffer$1.update(idx, (Object)UriInterpolator$StringToken$.MODULE$.apply(s.substring(1, s.length() - 1)));
            return;
        }
    }

    public static final /* synthetic */ void sttp$model$UriInterpolator$Tokenizer$$$_$tokenizeFragment$1$$anonfun$1(ArrayBuffer buffer$3, FastCharMap separatorsToTokens$2, int idx) {
        UriInterpolator.Token token = (UriInterpolator.Token)buffer$3.apply(idx);
        if (token instanceof UriInterpolator.StringToken) {
            String string;
            UriInterpolator.StringToken stringToken = UriInterpolator$StringToken$.MODULE$.unapply((UriInterpolator.StringToken)token);
            String s = string = stringToken._1();
            StringOps$.MODULE$.headOption$extension(Predef$.MODULE$.augmentString(s)).flatMap((Function1 & Serializable)ch -> separatorsToTokens$2.get(BoxesRunTime.unboxToChar((Object)ch))).foreach((Function1)(JProcedure1 & Serializable)_$7 -> buffer$3.update(idx, _$7));
            return;
        }
    }

    public static final /* synthetic */ ArrayBuffer sttp$model$UriInterpolator$Tokenizer$$$_$tokenizeTerminatedFragment$$anonfun$1(ArrayBuffer buffer$5, UriInterpolator.Token _$8) {
        return (ArrayBuffer)buffer$5.$plus$eq((Object)_$8);
    }

    public static /* bridge */ /* synthetic */ boolean sttp$model$UriInterpolator$Tokenizer$$$_$_$$anonfun$adapted$1(FastCharSet sep$6, Object ch) {
        return sep$6.contains(BoxesRunTime.unboxToChar((Object)ch));
    }

    public static final /* synthetic */ UriInterpolator.Token sttp$model$UriInterpolator$UriBuilder$UserInfo$$$_$_$$anonfun$6(UriInterpolator.Token x$1) {
        UriInterpolator.Token token = x$1;
        if (UriInterpolator$DotInAuthority$.MODULE$.equals(token)) {
            return UriInterpolator$StringToken$.MODULE$.apply(".");
        }
        UriInterpolator.Token x = token;
        return x;
    }

    public static final /* synthetic */ List sttp$model$UriInterpolator$UriBuilder$HostPort$$$_$_$$anonfun$7(UriInterpolator.Token x$1) {
        UriInterpolator.Token token = x$1;
        if (token instanceof UriInterpolator.ExpressionToken) {
            Object object;
            UriInterpolator.ExpressionToken e = (UriInterpolator.ExpressionToken)token;
            String es = UriInterpolator$UriBuilder$.MODULE$.sttp$model$UriInterpolator$UriBuilder$$$anyToString(e.e());
            String[] stringArray = es.split(":", 2);
            if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String h = string;
                String p = string2;
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(p)) && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(p), (Function1 & Serializable)_$9 -> RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$9))))) {
                    UriInterpolator.StringToken stringToken = UriInterpolator$StringToken$.MODULE$.apply(h);
                    UriInterpolator.StringToken stringToken2 = UriInterpolator$StringToken$.MODULE$.apply(p);
                    return package$.MODULE$.Nil().$colon$colon((Object)stringToken2).$colon$colon((Object)UriInterpolator$ColonInAuthority$.MODULE$).$colon$colon((Object)stringToken);
                }
            }
            return package$.MODULE$.Nil().$colon$colon((Object)e);
        }
        UriInterpolator.Token t = token;
        return package$.MODULE$.Nil().$colon$colon((Object)t);
    }

    public static final /* synthetic */ boolean sttp$model$UriInterpolator$UriBuilder$HostPort$$$_$hostPortFromNonemptyTokens$$anonfun$1(UriInterpolator.Token _$10) {
        UriInterpolator.Token token = _$10;
        UriInterpolator$ColonInAuthority$ uriInterpolator$ColonInAuthority$ = UriInterpolator$ColonInAuthority$.MODULE$;
        return !(token != null ? !token.equals(uriInterpolator$ColonInAuthority$) : uriInterpolator$ColonInAuthority$ != null);
    }

    private static final int portFromTokens$$anonfun$1$$anonfun$1(String s$2) {
        throw new IllegalArgumentException(new StringBuilder(108).append("Invalid port: ").append(s$2).append(". Is the port a number? Is the path separated with a / (directly in the string, not embedded)?").toString());
    }

    public static final /* synthetic */ int sttp$model$UriInterpolator$UriBuilder$HostPort$$$_$portFromTokens$$anonfun$1(String s) {
        return BoxesRunTime.unboxToInt((Object)ParseUtils$.MODULE$.toIntOption(s).getOrElse(() -> UriInterpolator$.portFromTokens$$anonfun$1$$anonfun$1(s)));
    }

    public static final /* synthetic */ Uri sttp$model$UriInterpolator$UriBuilder$Path$$$_$fromTokens$$anonfun$1(Uri u, ArrayView tokens) {
        return UriInterpolator$UriBuilder$Path$.MODULE$.sttp$model$UriInterpolator$UriBuilder$Path$$$pathFromTokens(u, tokens);
    }

    public static final /* synthetic */ boolean sttp$model$UriInterpolator$UriBuilder$Path$$$_$_$$anonfun$8(UriInterpolator.Token _$11) {
        UriInterpolator.Token token = _$11;
        UriInterpolator.StringToken stringToken = sttp$model$UriInterpolator$$$emptyStringToken;
        return !(token != null ? !token.equals(stringToken) : stringToken != null);
    }

    public static final /* synthetic */ Uri sttp$model$UriInterpolator$UriBuilder$Query$$$_$fromTokens$$anonfun$2(Uri u, ArrayView tokens) {
        return UriInterpolator$UriBuilder$Query$.MODULE$.sttp$model$UriInterpolator$UriBuilder$Query$$$queryFromTokens(u, tokens);
    }

    public static final /* synthetic */ IterableOnce sttp$model$UriInterpolator$UriBuilder$Query$$$_$_$$anonfun$9(ArrayView tokens) {
        return UriInterpolator$UriBuilder$Query$.MODULE$.sttp$model$UriInterpolator$UriBuilder$Query$$$queryMappingsFromTokens(tokens);
    }

    public static final /* synthetic */ Option sttp$model$UriInterpolator$UriBuilder$Query$$$_$expressionPairToQueryFragment$1$$anonfun$1(Object ve$1, String k) {
        return UriInterpolator$UriBuilder$.MODULE$.sttp$model$UriInterpolator$UriBuilder$$$anyToStringOpt(ve$1).map((Function1 & Serializable)v -> Uri$QuerySegment$KeyValue$.MODULE$.apply(k, (String)v, Uri$QuerySegment$KeyValue$.MODULE$.$lessinit$greater$default$3(), Uri$QuerySegment$KeyValue$.MODULE$.$lessinit$greater$default$4()));
    }

    public static final /* synthetic */ Uri.QuerySegment.Value sttp$model$UriInterpolator$UriBuilder$Query$$$_$seqToQueryFragments$1$$anonfun$1$$anonfun$1(String _$12) {
        return Uri$QuerySegment$Value$.MODULE$.apply(_$12, Uri$QuerySegment$Value$.MODULE$.$lessinit$greater$default$2());
    }

    public static final /* synthetic */ Uri.QuerySegment.Value sttp$model$UriInterpolator$UriBuilder$Query$$$_$queryMappingsFromTokens$$anonfun$1(String _$13) {
        return Uri$QuerySegment$Value$.MODULE$.apply(_$13, Uri$QuerySegment$Value$.MODULE$.$lessinit$greater$default$2());
    }

    public static final /* synthetic */ Uri.QuerySegment.KeyValue sttp$model$UriInterpolator$UriBuilder$Query$$$_$queryMappingsFromTokens$$anonfun$2(String k$2, String _$14) {
        return Uri$QuerySegment$KeyValue$.MODULE$.apply(k$2, _$14, Uri$QuerySegment$KeyValue$.MODULE$.$lessinit$greater$default$3(), Uri$QuerySegment$KeyValue$.MODULE$.$lessinit$greater$default$4());
    }

    public static final String sttp$model$UriInterpolator$UriBuilder$$$_$anyToString$$anonfun$1() {
        return "";
    }

    public static final /* synthetic */ IterableOnce sttp$model$UriInterpolator$UriBuilder$$$_$doToSeq$1$$anonfun$1(Object a) {
        return UriInterpolator$UriBuilder$.MODULE$.sttp$model$UriInterpolator$UriBuilder$$$anyToStringOpt(a);
    }

    public static final /* synthetic */ Option sttp$model$UriInterpolator$UriBuilder$$$_$doToSeq$1$$anonfun$2(Object a) {
        return UriInterpolator$UriBuilder$.MODULE$.sttp$model$UriInterpolator$UriBuilder$$$anyToStringOpt(a);
    }

    public static final /* synthetic */ VectorBuilder sttp$model$UriInterpolator$UriBuilder$$$_$doToSeq$1$$anonfun$3(VectorBuilder b$2, String _$15) {
        return (VectorBuilder)b$2.$plus$eq((Object)_$15);
    }

    public static final /* synthetic */ Option sttp$model$UriInterpolator$UriBuilder$$$_$_$$anonfun$12(boolean decodePlusAsSpace$2, UriInterpolator.Token x$1) {
        UriInterpolator.Token token = x$1;
        if (token instanceof UriInterpolator.StringToken) {
            String string;
            UriInterpolator.StringToken stringToken = UriInterpolator$StringToken$.MODULE$.unapply((UriInterpolator.StringToken)token);
            String s = string = stringToken._1();
            return Some$.MODULE$.apply((Object)UriInterpolator$UriBuilder$.MODULE$.sttp$model$UriInterpolator$UriBuilder$$$decode(s, decodePlusAsSpace$2));
        }
        if (token instanceof UriInterpolator.ExpressionToken) {
            Object object;
            UriInterpolator.ExpressionToken expressionToken = UriInterpolator$ExpressionToken$.MODULE$.unapply((UriInterpolator.ExpressionToken)token);
            Object e = object = expressionToken._1();
            return UriInterpolator$UriBuilder$.MODULE$.sttp$model$UriInterpolator$UriBuilder$$$anyToStringOpt(e);
        }
        if (UriInterpolator$EqInQuery$.MODULE$.equals(token)) {
            return Some$.MODULE$.apply((Object)"=");
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ VectorBuilder sttp$model$UriInterpolator$UriBuilder$$$_$doToSeq$1$$anonfun$4(VectorBuilder b$3, String _$16) {
        return (VectorBuilder)b$3.$plus$eq((Object)_$16);
    }

    public static final /* synthetic */ String sttp$model$UriInterpolator$UriBuilder$$$_$tokensToString$$anonfun$1(boolean decodePlusAsSpace$3, UriInterpolator.Token x$1) {
        UriInterpolator.Token token = x$1;
        if (token instanceof UriInterpolator.StringToken) {
            String string;
            UriInterpolator.StringToken stringToken = UriInterpolator$StringToken$.MODULE$.unapply((UriInterpolator.StringToken)token);
            String s = string = stringToken._1();
            return UriInterpolator$UriBuilder$.MODULE$.sttp$model$UriInterpolator$UriBuilder$$$decode(s, decodePlusAsSpace$3);
        }
        if (token instanceof UriInterpolator.ExpressionToken) {
            Object object;
            UriInterpolator.ExpressionToken expressionToken = UriInterpolator$ExpressionToken$.MODULE$.unapply((UriInterpolator.ExpressionToken)token);
            Object e = object = expressionToken._1();
            return UriInterpolator$UriBuilder$.MODULE$.sttp$model$UriInterpolator$UriBuilder$$$anyToString(e);
        }
        return "";
    }

    public static final /* synthetic */ boolean sttp$model$UriInterpolator$UriBuilder$$$_$_$$anonfun$13(Object sep$4, Object _$17) {
        return BoxesRunTime.equals((Object)_$17, (Object)sep$4);
    }
}

