/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir;

import java.io.Serializable;
import scala.;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sttp.model.Method;
import sttp.model.headers.WWWAuthenticateChallenge;
import sttp.tapir.AttributeKey;
import sttp.tapir.AttributeMap;
import sttp.tapir.Codec;
import sttp.tapir.CodecFormat;
import sttp.tapir.DecodeResult;
import sttp.tapir.DecodeResult$Value$;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.EndpointInput$;
import sttp.tapir.EndpointInput$Auth$;
import sttp.tapir.EndpointInput$AuthInfo$;
import sttp.tapir.EndpointInput$AuthType$;
import sttp.tapir.EndpointInput$AuthType$ApiKey$;
import sttp.tapir.EndpointInput$AuthType$Http$;
import sttp.tapir.EndpointInput$AuthType$OAuth2$;
import sttp.tapir.EndpointInput$AuthType$ScopedOAuth2$;
import sttp.tapir.EndpointInput$Cookie$;
import sttp.tapir.EndpointInput$ExtractFromRequest$;
import sttp.tapir.EndpointInput$FixedMethod$;
import sttp.tapir.EndpointInput$FixedPath$;
import sttp.tapir.EndpointInput$MappedPair$;
import sttp.tapir.EndpointInput$Pair$;
import sttp.tapir.EndpointInput$PathCapture$;
import sttp.tapir.EndpointInput$PathsCapture$;
import sttp.tapir.EndpointInput$Query$;
import sttp.tapir.EndpointInput$QueryParams$;
import sttp.tapir.EndpointTransput;
import sttp.tapir.Mapping;
import sttp.tapir.internal.UrlencodedData$;
import sttp.tapir.internal.package;
import sttp.tapir.internal.package$;
import sttp.tapir.model.ServerRequest;
import sttp.tapir.typelevel.ParamConcat;

public interface EndpointInput<T>
extends EndpointTransput<T> {
    public static int ordinal(EndpointInput<?> endpointInput2) {
        return EndpointInput$.MODULE$.ordinal(endpointInput2);
    }

    public static EndpointInput and$(EndpointInput $this, EndpointInput other, ParamConcat concat) {
        return $this.and(other, concat);
    }

    default public <U, TU> EndpointInput<TU> and(EndpointInput<U> other, ParamConcat concat) {
        return EndpointInput$Pair$.MODULE$.apply(this, other, package$.MODULE$.mkCombine(concat), package$.MODULE$.mkSplit(concat));
    }

    public static EndpointInput $div$(EndpointInput $this, EndpointInput other, ParamConcat concat) {
        return $this.$div(other, concat);
    }

    default public <U, TU> EndpointInput<TU> $div(EndpointInput<U> other, ParamConcat concat) {
        return this.and(other, concat);
    }

    public static interface Atom<T>
    extends Basic<T>,
    EndpointTransput.Atom<T> {
    }

    public static class Auth<T, TYPE extends AuthType>
    implements Single<T>,
    Product,
    Serializable {
        private final Single input;
        private final WWWAuthenticateChallenge challenge;
        private final AuthType authType;
        private final AuthInfo info;

        public static <T, TYPE extends AuthType> Auth<T, TYPE> apply(Single<T> single, WWWAuthenticateChallenge wWWAuthenticateChallenge, TYPE TYPE, AuthInfo authInfo) {
            return EndpointInput$Auth$.MODULE$.apply(single, wWWAuthenticateChallenge, TYPE, authInfo);
        }

        public static Auth<?, ?> fromProduct(Product product) {
            return EndpointInput$Auth$.MODULE$.fromProduct(product);
        }

        public static <T, TYPE extends AuthType> Auth<T, TYPE> unapply(Auth<T, TYPE> auth) {
            return EndpointInput$Auth$.MODULE$.unapply(auth);
        }

        public Auth(Single<T> input, WWWAuthenticateChallenge challenge, TYPE authType, AuthInfo info) {
            this.input = input;
            this.challenge = challenge;
            this.authType = authType;
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Auth)) return false;
            Auth auth = (Auth)object;
            Single<T> single = this.input();
            Single<T> single2 = auth.input();
            if (single == null) {
                if (single2 != null) {
                    return false;
                }
            } else if (!single.equals(single2)) return false;
            WWWAuthenticateChallenge wWWAuthenticateChallenge = this.challenge();
            WWWAuthenticateChallenge wWWAuthenticateChallenge2 = auth.challenge();
            if (wWWAuthenticateChallenge == null) {
                if (wWWAuthenticateChallenge2 != null) {
                    return false;
                }
            } else if (!((Object)wWWAuthenticateChallenge).equals(wWWAuthenticateChallenge2)) return false;
            TYPE TYPE = this.authType();
            TYPE TYPE2 = auth.authType();
            if (TYPE == null) {
                if (TYPE2 != null) {
                    return false;
                }
            } else if (!TYPE.equals(TYPE2)) return false;
            AuthInfo authInfo = this.info();
            AuthInfo authInfo2 = auth.info();
            if (authInfo == null) {
                if (authInfo2 != null) {
                    return false;
                }
            } else if (!((Object)authInfo).equals(authInfo2)) return false;
            if (!auth.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Auth;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Auth";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "input";
                }
                case 1: {
                    return "challenge";
                }
                case 2: {
                    return "authType";
                }
                case 3: {
                    return "info";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Single<T> input() {
            return this.input;
        }

        public WWWAuthenticateChallenge challenge() {
            return this.challenge;
        }

        public TYPE authType() {
            return (TYPE)this.authType;
        }

        public AuthInfo info() {
            return this.info;
        }

        @Override
        public String show() {
            if (this.isInputEmpty()) {
                return "auth(-)";
            }
            TYPE TYPE = this.authType();
            if (TYPE instanceof AuthType.Http) {
                String string;
                AuthType.Http http = EndpointInput$AuthType$Http$.MODULE$.unapply((AuthType.Http)TYPE);
                String scheme = string = http._1();
                return new StringBuilder(17).append("auth(").append(scheme).append(" http, via ").append(this.input().show()).append(")").toString();
            }
            if (TYPE instanceof AuthType.ApiKey && EndpointInput$AuthType$ApiKey$.MODULE$.unapply((AuthType.ApiKey)TYPE)) {
                return new StringBuilder(19).append("auth(api key, via ").append(this.input().show()).append(")").toString();
            }
            if (TYPE instanceof AuthType.OAuth2) {
                AuthType.OAuth2 oAuth2 = EndpointInput$AuthType$OAuth2$.MODULE$.unapply((AuthType.OAuth2)TYPE);
                Option<String> option = oAuth2._1();
                Option<String> option2 = oAuth2._2();
                ListMap<String, String> listMap = oAuth2._3();
                Option<String> option3 = oAuth2._4();
                return new StringBuilder(18).append("auth(oauth2, via ").append(this.input().show()).append(")").toString();
            }
            if (TYPE instanceof AuthType.ScopedOAuth2) {
                AuthType.ScopedOAuth2 scopedOAuth2 = EndpointInput$AuthType$ScopedOAuth2$.MODULE$.unapply((AuthType.ScopedOAuth2)TYPE);
                AuthType.OAuth2 oAuth2 = scopedOAuth2._1();
                Seq<String> seq = scopedOAuth2._2();
                return new StringBuilder(25).append("auth(scoped oauth2, via ").append(this.input().show()).append(")").toString();
            }
            throw new RuntimeException("Impossible, but the compiler complains.");
        }

        @Override
        public <U> Auth<U, TYPE> map(Mapping<T, U> mapping) {
            return this.copy((Single)this.input().map(mapping), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
        }

        public Option<String> securitySchemeName() {
            return this.info().securitySchemeName();
        }

        public Auth<T, TYPE> securitySchemeName(String name) {
            AuthInfo authInfo = this.info().securitySchemeName(name);
            Single<T> single = this.copy$default$1();
            WWWAuthenticateChallenge wWWAuthenticateChallenge = this.copy$default$2();
            TYPE TYPE = this.copy$default$3();
            return this.copy(single, wWWAuthenticateChallenge, TYPE, authInfo);
        }

        public Auth<T, TYPE> challengeRealm(String realm) {
            WWWAuthenticateChallenge wWWAuthenticateChallenge = this.challenge().realm(realm);
            Single<T> single = this.copy$default$1();
            TYPE TYPE = this.copy$default$3();
            AuthInfo authInfo = this.copy$default$4();
            return this.copy(single, wWWAuthenticateChallenge, TYPE, authInfo);
        }

        public Auth<T, AuthType.ScopedOAuth2> requiredScopes(Seq<String> requiredScopes, .eq.colon.eq<TYPE, AuthType.OAuth2> ev) {
            AuthType.ScopedOAuth2 scopedOAuth2 = ((AuthType.OAuth2)ev.apply(this.authType())).requiredScopes(requiredScopes);
            Single<T> single = this.copy$default$1();
            WWWAuthenticateChallenge wWWAuthenticateChallenge = this.copy$default$2();
            AuthInfo authInfo = this.copy$default$4();
            return this.copy(single, wWWAuthenticateChallenge, scopedOAuth2, authInfo);
        }

        public Auth<T, TYPE> description(String d) {
            AuthInfo authInfo = this.info().description(d);
            Single<T> single = this.copy$default$1();
            WWWAuthenticateChallenge wWWAuthenticateChallenge = this.copy$default$2();
            TYPE TYPE = this.copy$default$3();
            return this.copy(single, wWWAuthenticateChallenge, TYPE, authInfo);
        }

        public Auth<T, AuthType.Http> bearerFormat(String f, .eq.colon.eq<TYPE, AuthType.Http> typeIsHttp) {
            AuthInfo authInfo = this.info().bearerFormat(f);
            Single<T> single = this.copy$default$1();
            WWWAuthenticateChallenge wWWAuthenticateChallenge = this.copy$default$2();
            AuthType.Http http = (AuthType.Http)typeIsHttp.apply(this.copy$default$3());
            return this.copy(single, wWWAuthenticateChallenge, http, authInfo);
        }

        public Auth<T, TYPE> group(String g) {
            AuthInfo authInfo = this.info().group(g);
            Single<T> single = this.copy$default$1();
            WWWAuthenticateChallenge wWWAuthenticateChallenge = this.copy$default$2();
            TYPE TYPE = this.copy$default$3();
            return this.copy(single, wWWAuthenticateChallenge, TYPE, authInfo);
        }

        public <A> Option<A> attribute(AttributeKey<A> k) {
            return this.info().attributes().get(k);
        }

        public <A> Auth<T, TYPE> attribute(AttributeKey<A> k, A v) {
            AuthInfo authInfo = this.info().attribute(k, v);
            Single<T> single = this.copy$default$1();
            WWWAuthenticateChallenge wWWAuthenticateChallenge = this.copy$default$2();
            TYPE TYPE = this.copy$default$3();
            return this.copy(single, wWWAuthenticateChallenge, TYPE, authInfo);
        }

        public boolean isInputEmpty() {
            return this.input() instanceof EndpointIO.Empty;
        }

        public <T, TYPE extends AuthType> Auth<T, TYPE> copy(Single<T> input, WWWAuthenticateChallenge challenge, TYPE authType, AuthInfo info) {
            return new Auth<T, TYPE>(input, challenge, authType, info);
        }

        public <T, TYPE extends AuthType> Single<T> copy$default$1() {
            return this.input();
        }

        public <T, TYPE extends AuthType> WWWAuthenticateChallenge copy$default$2() {
            return this.challenge();
        }

        public <T, TYPE extends AuthType> TYPE copy$default$3() {
            return this.authType();
        }

        public <T, TYPE extends AuthType> AuthInfo copy$default$4() {
            return this.info();
        }

        public Single<T> _1() {
            return this.input();
        }

        public WWWAuthenticateChallenge _2() {
            return this.challenge();
        }

        public TYPE _3() {
            return this.authType();
        }

        public AuthInfo _4() {
            return this.info();
        }
    }

    public static class AuthInfo
    implements Product,
    Serializable {
        private final Option securitySchemeName;
        private final Option description;
        private final AttributeMap attributes;
        private final Option group;
        private final Option bearerFormat;

        public static AuthInfo Empty() {
            return EndpointInput$AuthInfo$.MODULE$.Empty();
        }

        public static AuthInfo apply(Option<String> option, Option<String> option2, AttributeMap attributeMap, Option<String> option3, Option<String> option4) {
            return EndpointInput$AuthInfo$.MODULE$.apply(option, option2, attributeMap, option3, option4);
        }

        public static AuthInfo fromProduct(Product product) {
            return EndpointInput$AuthInfo$.MODULE$.fromProduct(product);
        }

        public static AuthInfo unapply(AuthInfo authInfo) {
            return EndpointInput$AuthInfo$.MODULE$.unapply(authInfo);
        }

        public AuthInfo(Option<String> securitySchemeName2, Option<String> description2, AttributeMap attributes, Option<String> group, Option<String> bearerFormat) {
            this.securitySchemeName = securitySchemeName2;
            this.description = description2;
            this.attributes = attributes;
            this.group = group;
            this.bearerFormat = bearerFormat;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AuthInfo)) return false;
            AuthInfo authInfo = (AuthInfo)object;
            Option<String> option = this.securitySchemeName();
            Option<String> option2 = authInfo.securitySchemeName();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.description();
            Option<String> option4 = authInfo.description();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            AttributeMap attributeMap = this.attributes();
            AttributeMap attributeMap2 = authInfo.attributes();
            if (attributeMap == null) {
                if (attributeMap2 != null) {
                    return false;
                }
            } else if (!((Object)attributeMap).equals(attributeMap2)) return false;
            Option<String> option5 = this.group();
            Option<String> option6 = authInfo.group();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<String> option7 = this.bearerFormat();
            Option<String> option8 = authInfo.bearerFormat();
            if (option7 == null) {
                if (option8 != null) {
                    return false;
                }
            } else if (!option7.equals(option8)) return false;
            if (!authInfo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AuthInfo;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "AuthInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "securitySchemeName";
                }
                case 1: {
                    return "description";
                }
                case 2: {
                    return "attributes";
                }
                case 3: {
                    return "group";
                }
                case 4: {
                    return "bearerFormat";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<String> securitySchemeName() {
            return this.securitySchemeName;
        }

        public Option<String> description() {
            return this.description;
        }

        public AttributeMap attributes() {
            return this.attributes;
        }

        public Option<String> group() {
            return this.group;
        }

        public Option<String> bearerFormat() {
            return this.bearerFormat;
        }

        public AuthInfo securitySchemeName(String name) {
            return this.copy((Option<String>)Some$.MODULE$.apply((Object)name), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public AuthInfo description(String d) {
            Some some = Some$.MODULE$.apply((Object)d);
            Option<String> option = this.copy$default$1();
            AttributeMap attributeMap = this.copy$default$3();
            Option<String> option2 = this.copy$default$4();
            Option<String> option3 = this.copy$default$5();
            return this.copy(option, (Option<String>)some, attributeMap, option2, option3);
        }

        public AuthInfo group(String g) {
            Some some = Some$.MODULE$.apply((Object)g);
            Option<String> option = this.copy$default$1();
            Option<String> option2 = this.copy$default$2();
            AttributeMap attributeMap = this.copy$default$3();
            Option<String> option3 = this.copy$default$5();
            return this.copy(option, option2, attributeMap, (Option<String>)some, option3);
        }

        public AuthInfo bearerFormat(String format2) {
            Some some = Some$.MODULE$.apply((Object)format2);
            Option<String> option = this.copy$default$1();
            Option<String> option2 = this.copy$default$2();
            AttributeMap attributeMap = this.copy$default$3();
            Option<String> option3 = this.copy$default$4();
            return this.copy(option, option2, attributeMap, option3, (Option<String>)some);
        }

        public <A> Option<A> attribute(AttributeKey<A> k) {
            return this.attributes().get(k);
        }

        public <A> AuthInfo attribute(AttributeKey<A> k, A v) {
            AttributeMap attributeMap = this.attributes().put(k, v);
            Option<String> option = this.copy$default$1();
            Option<String> option2 = this.copy$default$2();
            Option<String> option3 = this.copy$default$4();
            Option<String> option4 = this.copy$default$5();
            return this.copy(option, option2, attributeMap, option3, option4);
        }

        public AuthInfo copy(Option<String> securitySchemeName2, Option<String> description2, AttributeMap attributes, Option<String> group, Option<String> bearerFormat) {
            return new AuthInfo(securitySchemeName2, description2, attributes, group, bearerFormat);
        }

        public Option<String> copy$default$1() {
            return this.securitySchemeName();
        }

        public Option<String> copy$default$2() {
            return this.description();
        }

        public AttributeMap copy$default$3() {
            return this.attributes();
        }

        public Option<String> copy$default$4() {
            return this.group();
        }

        public Option<String> copy$default$5() {
            return this.bearerFormat();
        }

        public Option<String> _1() {
            return this.securitySchemeName();
        }

        public Option<String> _2() {
            return this.description();
        }

        public AttributeMap _3() {
            return this.attributes();
        }

        public Option<String> _4() {
            return this.group();
        }

        public Option<String> _5() {
            return this.bearerFormat();
        }
    }

    public static interface AuthType {
        public static int ordinal(AuthType authType) {
            return EndpointInput$AuthType$.MODULE$.ordinal(authType);
        }
    }

    public static interface Basic<T>
    extends Single<T>,
    EndpointTransput.Basic<T> {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Cookie<T>
    implements Atom<T>,
    Product,
    Serializable {
        private final String name;
        private final Codec codec;
        private final EndpointIO.Info info;

        public static <T> Cookie<T> apply(String string, Codec<Option<String>, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return EndpointInput$Cookie$.MODULE$.apply(string, codec2, info);
        }

        public static Cookie<?> fromProduct(Product product) {
            return EndpointInput$Cookie$.MODULE$.fromProduct(product);
        }

        public static <T> Cookie<T> unapply(Cookie<T> cookie2) {
            return EndpointInput$Cookie$.MODULE$.unapply(cookie2);
        }

        public Cookie(String name, Codec<Option<String>, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            this.name = name;
            this.codec = codec2;
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Cookie)) return false;
            Cookie cookie2 = (Cookie)object;
            String string = this.name();
            String string2 = cookie2.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Codec<Option<String>, T, CodecFormat.TextPlain> codec2 = this.codec();
            Codec<Option<String>, T, CodecFormat.TextPlain> codec3 = cookie2.codec();
            if (codec2 == null) {
                if (codec3 != null) {
                    return false;
                }
            } else if (!codec2.equals(codec3)) return false;
            EndpointIO.Info<T> info = this.info();
            EndpointIO.Info<T> info2 = cookie2.info();
            if (info == null) {
                if (info2 != null) {
                    return false;
                }
            } else if (!((Object)info).equals(info2)) return false;
            if (!cookie2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Cookie;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Cookie";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "codec";
                }
                case 2: {
                    return "info";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        @Override
        public Codec<Option<String>, T, CodecFormat.TextPlain> codec() {
            return this.codec;
        }

        @Override
        public EndpointIO.Info<T> info() {
            return this.info;
        }

        public <U> Cookie<U> copyWith(Codec<Option<String>, U, CodecFormat.TextPlain> c, EndpointIO.Info<U> i) {
            return this.copy(this.copy$default$1(), c, i);
        }

        @Override
        public String show() {
            return package$.MODULE$.addValidatorShow(new StringBuilder(9).append("{cookie ").append(this.name()).append("}").toString(), this.codec().schema());
        }

        public <T> Cookie<T> copy(String name, Codec<Option<String>, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return new Cookie<T>(name, codec2, info);
        }

        public <T> String copy$default$1() {
            return this.name();
        }

        public <T> Codec<Option<String>, T, CodecFormat.TextPlain> copy$default$2() {
            return this.codec();
        }

        public <T> EndpointIO.Info<T> copy$default$3() {
            return this.info();
        }

        public String _1() {
            return this.name();
        }

        public Codec<Option<String>, T, CodecFormat.TextPlain> _2() {
            return this.codec();
        }

        public EndpointIO.Info<T> _3() {
            return this.info();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ExtractFromRequest<T>
    implements Atom<T>,
    Product,
    Serializable {
        private final Codec codec;
        private final EndpointIO.Info info;

        public static <T> ExtractFromRequest<T> apply(Codec<ServerRequest, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return EndpointInput$ExtractFromRequest$.MODULE$.apply(codec2, info);
        }

        public static ExtractFromRequest<?> fromProduct(Product product) {
            return EndpointInput$ExtractFromRequest$.MODULE$.fromProduct(product);
        }

        public static <T> ExtractFromRequest<T> unapply(ExtractFromRequest<T> extractFromRequest) {
            return EndpointInput$ExtractFromRequest$.MODULE$.unapply(extractFromRequest);
        }

        public ExtractFromRequest(Codec<ServerRequest, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            this.codec = codec2;
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExtractFromRequest)) return false;
            ExtractFromRequest extractFromRequest = (ExtractFromRequest)object;
            Codec<ServerRequest, T, CodecFormat.TextPlain> codec2 = this.codec();
            Codec<ServerRequest, T, CodecFormat.TextPlain> codec3 = extractFromRequest.codec();
            if (codec2 == null) {
                if (codec3 != null) {
                    return false;
                }
            } else if (!codec2.equals(codec3)) return false;
            EndpointIO.Info<T> info = this.info();
            EndpointIO.Info<T> info2 = extractFromRequest.info();
            if (info == null) {
                if (info2 != null) {
                    return false;
                }
            } else if (!((Object)info).equals(info2)) return false;
            if (!extractFromRequest.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ExtractFromRequest;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ExtractFromRequest";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "codec";
            }
            if (1 == n2) {
                return "info";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Codec<ServerRequest, T, CodecFormat.TextPlain> codec() {
            return this.codec;
        }

        @Override
        public EndpointIO.Info<T> info() {
            return this.info;
        }

        public <U> ExtractFromRequest<U> copyWith(Codec<ServerRequest, U, CodecFormat.TextPlain> c, EndpointIO.Info<U> i) {
            return this.copy(c, i);
        }

        @Override
        public String show() {
            return "{data from request}";
        }

        public <T> ExtractFromRequest<T> copy(Codec<ServerRequest, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return new ExtractFromRequest<T>(codec2, info);
        }

        public <T> Codec<ServerRequest, T, CodecFormat.TextPlain> copy$default$1() {
            return this.codec();
        }

        public <T> EndpointIO.Info<T> copy$default$2() {
            return this.info();
        }

        public Codec<ServerRequest, T, CodecFormat.TextPlain> _1() {
            return this.codec();
        }

        public EndpointIO.Info<T> _2() {
            return this.info();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class FixedMethod<T>
    implements Atom<T>,
    Product,
    Serializable {
        private final String m;
        private final Codec codec;
        private final EndpointIO.Info info;

        public static <T> FixedMethod<T> apply(String string, Codec<BoxedUnit, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return EndpointInput$FixedMethod$.MODULE$.apply(string, codec2, info);
        }

        public static FixedMethod<?> fromProduct(Product product) {
            return EndpointInput$FixedMethod$.MODULE$.fromProduct(product);
        }

        public static <T> FixedMethod<T> unapply(FixedMethod<T> fixedMethod) {
            return EndpointInput$FixedMethod$.MODULE$.unapply(fixedMethod);
        }

        public FixedMethod(String m, Codec<BoxedUnit, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            this.m = m;
            this.codec = codec2;
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FixedMethod)) return false;
            FixedMethod fixedMethod = (FixedMethod)object;
            String string = this.m();
            String string2 = fixedMethod.m();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Codec<BoxedUnit, T, CodecFormat.TextPlain> codec2 = this.codec();
            Codec<BoxedUnit, T, CodecFormat.TextPlain> codec3 = fixedMethod.codec();
            if (codec2 == null) {
                if (codec3 != null) {
                    return false;
                }
            } else if (!codec2.equals(codec3)) return false;
            EndpointIO.Info<T> info = this.info();
            EndpointIO.Info<T> info2 = fixedMethod.info();
            if (info == null) {
                if (info2 != null) {
                    return false;
                }
            } else if (!((Object)info).equals(info2)) return false;
            if (!fixedMethod.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FixedMethod;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "FixedMethod";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return new Method(this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "m";
                }
                case 1: {
                    return "codec";
                }
                case 2: {
                    return "info";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String m() {
            return this.m;
        }

        @Override
        public Codec<BoxedUnit, T, CodecFormat.TextPlain> codec() {
            return this.codec;
        }

        @Override
        public EndpointIO.Info<T> info() {
            return this.info;
        }

        public <U> FixedMethod<U> copyWith(Codec<BoxedUnit, U, CodecFormat.TextPlain> c, EndpointIO.Info<U> i) {
            return this.copy(this.copy$default$1(), c, i);
        }

        @Override
        public String show() {
            return this.m();
        }

        public <T> FixedMethod<T> copy(String m, Codec<BoxedUnit, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return new FixedMethod<T>(m, codec2, info);
        }

        public <T> String copy$default$1() {
            return this.m();
        }

        public <T> Codec<BoxedUnit, T, CodecFormat.TextPlain> copy$default$2() {
            return this.codec();
        }

        public <T> EndpointIO.Info<T> copy$default$3() {
            return this.info();
        }

        public String _1() {
            return this.m();
        }

        public Codec<BoxedUnit, T, CodecFormat.TextPlain> _2() {
            return this.codec();
        }

        public EndpointIO.Info<T> _3() {
            return this.info();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class FixedPath<T>
    implements Atom<T>,
    Product,
    Serializable {
        private final String s;
        private final Codec codec;
        private final EndpointIO.Info info;

        public static <T> FixedPath<T> apply(String string, Codec<BoxedUnit, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return EndpointInput$FixedPath$.MODULE$.apply(string, codec2, info);
        }

        public static FixedPath<?> fromProduct(Product product) {
            return EndpointInput$FixedPath$.MODULE$.fromProduct(product);
        }

        public static <T> FixedPath<T> unapply(FixedPath<T> fixedPath) {
            return EndpointInput$FixedPath$.MODULE$.unapply(fixedPath);
        }

        public FixedPath(String s, Codec<BoxedUnit, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            this.s = s;
            this.codec = codec2;
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FixedPath)) return false;
            FixedPath fixedPath = (FixedPath)object;
            String string = this.s();
            String string2 = fixedPath.s();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Codec<BoxedUnit, T, CodecFormat.TextPlain> codec2 = this.codec();
            Codec<BoxedUnit, T, CodecFormat.TextPlain> codec3 = fixedPath.codec();
            if (codec2 == null) {
                if (codec3 != null) {
                    return false;
                }
            } else if (!codec2.equals(codec3)) return false;
            EndpointIO.Info<T> info = this.info();
            EndpointIO.Info<T> info2 = fixedPath.info();
            if (info == null) {
                if (info2 != null) {
                    return false;
                }
            } else if (!((Object)info).equals(info2)) return false;
            if (!fixedPath.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FixedPath;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "FixedPath";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "s";
                }
                case 1: {
                    return "codec";
                }
                case 2: {
                    return "info";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String s() {
            return this.s;
        }

        @Override
        public Codec<BoxedUnit, T, CodecFormat.TextPlain> codec() {
            return this.codec;
        }

        @Override
        public EndpointIO.Info<T> info() {
            return this.info;
        }

        public <U> FixedPath<U> copyWith(Codec<BoxedUnit, U, CodecFormat.TextPlain> c, EndpointIO.Info<U> i) {
            return this.copy(this.copy$default$1(), c, i);
        }

        @Override
        public String show() {
            return new StringBuilder(1).append("/").append(UrlencodedData$.MODULE$.encode(this.s())).toString();
        }

        public <T> FixedPath<T> copy(String s, Codec<BoxedUnit, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return new FixedPath<T>(s, codec2, info);
        }

        public <T> String copy$default$1() {
            return this.s();
        }

        public <T> Codec<BoxedUnit, T, CodecFormat.TextPlain> copy$default$2() {
            return this.codec();
        }

        public <T> EndpointIO.Info<T> copy$default$3() {
            return this.info();
        }

        public String _1() {
            return this.s();
        }

        public Codec<BoxedUnit, T, CodecFormat.TextPlain> _2() {
            return this.codec();
        }

        public EndpointIO.Info<T> _3() {
            return this.info();
        }
    }

    public static class MappedPair<T, U, TU, V>
    implements Single<V>,
    Product,
    Serializable {
        private final Pair input;
        private final Mapping mapping;

        public static <T, U, TU, V> MappedPair<T, U, TU, V> apply(Pair<T, U, TU> pair, Mapping<TU, V> mapping) {
            return EndpointInput$MappedPair$.MODULE$.apply(pair, mapping);
        }

        public static MappedPair<?, ?, ?, ?> fromProduct(Product product) {
            return EndpointInput$MappedPair$.MODULE$.fromProduct(product);
        }

        public static <T, U, TU, V> MappedPair<T, U, TU, V> unapply(MappedPair<T, U, TU, V> mappedPair) {
            return EndpointInput$MappedPair$.MODULE$.unapply(mappedPair);
        }

        public MappedPair(Pair<T, U, TU> input, Mapping<TU, V> mapping) {
            this.input = input;
            this.mapping = mapping;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MappedPair)) return false;
            MappedPair mappedPair = (MappedPair)object;
            Pair<T, U, TU> pair = this.input();
            Pair<T, U, TU> pair2 = mappedPair.input();
            if (pair == null) {
                if (pair2 != null) {
                    return false;
                }
            } else if (!((Object)pair).equals(pair2)) return false;
            Mapping<TU, V> mapping = this.mapping();
            Mapping<TU, V> mapping2 = mappedPair.mapping();
            if (mapping == null) {
                if (mapping2 != null) {
                    return false;
                }
            } else if (!mapping.equals(mapping2)) return false;
            if (!mappedPair.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MappedPair;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MappedPair";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "input";
            }
            if (1 == n2) {
                return "mapping";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Pair<T, U, TU> input() {
            return this.input;
        }

        public Mapping<TU, V> mapping() {
            return this.mapping;
        }

        @Override
        public String show() {
            return this.input().show();
        }

        public <W> MappedPair<T, U, TU, W> map(Mapping<V, W> m) {
            return this.copy(this.input(), this.mapping().map(m));
        }

        public <T, U, TU, V> MappedPair<T, U, TU, V> copy(Pair<T, U, TU> input, Mapping<TU, V> mapping) {
            return new MappedPair<T, U, TU, V>(input, mapping);
        }

        public <T, U, TU, V> Pair<T, U, TU> copy$default$1() {
            return this.input();
        }

        public <T, U, TU, V> Mapping<TU, V> copy$default$2() {
            return this.mapping();
        }

        public Pair<T, U, TU> _1() {
            return this.input();
        }

        public Mapping<TU, V> _2() {
            return this.mapping();
        }
    }

    public static class Pair<T, U, TU>
    implements EndpointInput<TU>,
    EndpointTransput.Pair<TU>,
    Product,
    Serializable {
        private final EndpointInput left;
        private final EndpointInput right;
        private final Function2 combine;
        private final Function1 split;

        public static <T, U, TU> Pair<T, U, TU> apply(EndpointInput<T> endpointInput2, EndpointInput<U> endpointInput3, Function2<package.Params, package.Params, package.Params> function2, Function1<package.Params, Tuple2<package.Params, package.Params>> function1) {
            return EndpointInput$Pair$.MODULE$.apply(endpointInput2, endpointInput3, function2, function1);
        }

        public static Pair<?, ?, ?> fromProduct(Product product) {
            return EndpointInput$Pair$.MODULE$.fromProduct(product);
        }

        public static <T, U, TU> Pair<T, U, TU> unapply(Pair<T, U, TU> pair) {
            return EndpointInput$Pair$.MODULE$.unapply(pair);
        }

        public Pair(EndpointInput<T> left, EndpointInput<U> right, Function2<package.Params, package.Params, package.Params> combine, Function1<package.Params, Tuple2<package.Params, package.Params>> split) {
            this.left = left;
            this.right = right;
            this.combine = combine;
            this.split = split;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Pair)) return false;
            Pair pair = (Pair)object;
            EndpointTransput endpointTransput = this.left();
            EndpointTransput endpointTransput2 = pair.left();
            if (endpointTransput == null) {
                if (endpointTransput2 != null) {
                    return false;
                }
            } else if (!endpointTransput.equals(endpointTransput2)) return false;
            EndpointTransput endpointTransput3 = this.right();
            EndpointTransput endpointTransput4 = pair.right();
            if (endpointTransput3 == null) {
                if (endpointTransput4 != null) {
                    return false;
                }
            } else if (!endpointTransput3.equals(endpointTransput4)) return false;
            Function2<package.Params, package.Params, package.Params> function2 = this.combine();
            Function2<package.Params, package.Params, package.Params> function22 = pair.combine();
            if (function2 == null) {
                if (function22 != null) {
                    return false;
                }
            } else if (!function2.equals(function22)) return false;
            Function1<package.Params, Tuple2<package.Params, package.Params>> function1 = this.split();
            Function1<package.Params, Tuple2<package.Params, package.Params>> function12 = pair.split();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!pair.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Pair;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Pair";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "left";
                }
                case 1: {
                    return "right";
                }
                case 2: {
                    return "combine";
                }
                case 3: {
                    return "split";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public EndpointInput<T> left() {
            return this.left;
        }

        @Override
        public EndpointInput<U> right() {
            return this.right;
        }

        @Override
        public Function2<package.Params, package.Params, package.Params> combine() {
            return this.combine;
        }

        @Override
        public Function1<package.Params, Tuple2<package.Params, package.Params>> split() {
            return this.split;
        }

        public <V> EndpointInput<V> map(Mapping<TU, V> m) {
            return EndpointInput$MappedPair$.MODULE$.apply(this, m);
        }

        public <T, U, TU> Pair<T, U, TU> copy(EndpointInput<T> left, EndpointInput<U> right, Function2<package.Params, package.Params, package.Params> combine, Function1<package.Params, Tuple2<package.Params, package.Params>> split) {
            return new Pair<T, U, TU>(left, right, combine, split);
        }

        public <T, U, TU> EndpointInput<T> copy$default$1() {
            return this.left();
        }

        public <T, U, TU> EndpointInput<U> copy$default$2() {
            return this.right();
        }

        public <T, U, TU> Function2<package.Params, package.Params, package.Params> copy$default$3() {
            return this.combine();
        }

        public <T, U, TU> Function1<package.Params, Tuple2<package.Params, package.Params>> copy$default$4() {
            return this.split();
        }

        public EndpointInput<T> _1() {
            return this.left();
        }

        public EndpointInput<U> _2() {
            return this.right();
        }

        public Function2<package.Params, package.Params, package.Params> _3() {
            return this.combine();
        }

        public Function1<package.Params, Tuple2<package.Params, package.Params>> _4() {
            return this.split();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class PathCapture<T>
    implements Atom<T>,
    Product,
    Serializable {
        private final Option name;
        private final Codec codec;
        private final EndpointIO.Info info;

        public static <T> PathCapture<T> apply(Option<String> option, Codec<String, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return EndpointInput$PathCapture$.MODULE$.apply(option, codec2, info);
        }

        public static PathCapture<?> fromProduct(Product product) {
            return EndpointInput$PathCapture$.MODULE$.fromProduct(product);
        }

        public static <T> PathCapture<T> unapply(PathCapture<T> pathCapture) {
            return EndpointInput$PathCapture$.MODULE$.unapply(pathCapture);
        }

        public PathCapture(Option<String> name, Codec<String, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            this.name = name;
            this.codec = codec2;
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PathCapture)) return false;
            PathCapture pathCapture = (PathCapture)object;
            Option<String> option = this.name();
            Option<String> option2 = pathCapture.name();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Codec<String, T, CodecFormat.TextPlain> codec2 = this.codec();
            Codec<String, T, CodecFormat.TextPlain> codec3 = pathCapture.codec();
            if (codec2 == null) {
                if (codec3 != null) {
                    return false;
                }
            } else if (!codec2.equals(codec3)) return false;
            EndpointIO.Info<T> info = this.info();
            EndpointIO.Info<T> info2 = pathCapture.info();
            if (info == null) {
                if (info2 != null) {
                    return false;
                }
            } else if (!((Object)info).equals(info2)) return false;
            if (!pathCapture.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PathCapture;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PathCapture";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "codec";
                }
                case 2: {
                    return "info";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<String> name() {
            return this.name;
        }

        @Override
        public Codec<String, T, CodecFormat.TextPlain> codec() {
            return this.codec;
        }

        @Override
        public EndpointIO.Info<T> info() {
            return this.info;
        }

        public <U> PathCapture<U> copyWith(Codec<String, U, CodecFormat.TextPlain> c, EndpointIO.Info<U> i) {
            return this.copy(this.copy$default$1(), c, i);
        }

        @Override
        public String show() {
            return package$.MODULE$.addValidatorShow(new StringBuilder(3).append("/[").append(this.name().getOrElse(EndpointInput$::sttp$tapir$EndpointInput$PathCapture$$_$show$$anonfun$1)).append("]").toString(), this.codec().schema());
        }

        public PathCapture<T> name(String n) {
            return this.copy((Option<String>)Some$.MODULE$.apply((Object)n), this.copy$default$2(), this.copy$default$3());
        }

        public <T> PathCapture<T> copy(Option<String> name, Codec<String, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return new PathCapture<T>(name, codec2, info);
        }

        public <T> Option<String> copy$default$1() {
            return this.name();
        }

        public <T> Codec<String, T, CodecFormat.TextPlain> copy$default$2() {
            return this.codec();
        }

        public <T> EndpointIO.Info<T> copy$default$3() {
            return this.info();
        }

        public Option<String> _1() {
            return this.name();
        }

        public Codec<String, T, CodecFormat.TextPlain> _2() {
            return this.codec();
        }

        public EndpointIO.Info<T> _3() {
            return this.info();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class PathsCapture<T>
    implements Atom<T>,
    Product,
    Serializable {
        private final Codec codec;
        private final EndpointIO.Info info;

        public static <T> PathsCapture<T> apply(Codec<List<String>, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return EndpointInput$PathsCapture$.MODULE$.apply(codec2, info);
        }

        public static PathsCapture<?> fromProduct(Product product) {
            return EndpointInput$PathsCapture$.MODULE$.fromProduct(product);
        }

        public static <T> PathsCapture<T> unapply(PathsCapture<T> pathsCapture) {
            return EndpointInput$PathsCapture$.MODULE$.unapply(pathsCapture);
        }

        public PathsCapture(Codec<List<String>, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            this.codec = codec2;
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PathsCapture)) return false;
            PathsCapture pathsCapture = (PathsCapture)object;
            Codec<List<String>, T, CodecFormat.TextPlain> codec2 = this.codec();
            Codec<List<String>, T, CodecFormat.TextPlain> codec3 = pathsCapture.codec();
            if (codec2 == null) {
                if (codec3 != null) {
                    return false;
                }
            } else if (!codec2.equals(codec3)) return false;
            EndpointIO.Info<T> info = this.info();
            EndpointIO.Info<T> info2 = pathsCapture.info();
            if (info == null) {
                if (info2 != null) {
                    return false;
                }
            } else if (!((Object)info).equals(info2)) return false;
            if (!pathsCapture.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PathsCapture;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "PathsCapture";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "codec";
            }
            if (1 == n2) {
                return "info";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Codec<List<String>, T, CodecFormat.TextPlain> codec() {
            return this.codec;
        }

        @Override
        public EndpointIO.Info<T> info() {
            return this.info;
        }

        public <U> PathsCapture<U> copyWith(Codec<List<String>, U, CodecFormat.TextPlain> c, EndpointIO.Info<U> i) {
            return this.copy(c, i);
        }

        @Override
        public String show() {
            return "/*";
        }

        public <T> PathsCapture<T> copy(Codec<List<String>, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return new PathsCapture<T>(codec2, info);
        }

        public <T> Codec<List<String>, T, CodecFormat.TextPlain> copy$default$1() {
            return this.codec();
        }

        public <T> EndpointIO.Info<T> copy$default$2() {
            return this.info();
        }

        public Codec<List<String>, T, CodecFormat.TextPlain> _1() {
            return this.codec();
        }

        public EndpointIO.Info<T> _2() {
            return this.info();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Query<T>
    implements Atom<T>,
    Product,
    Serializable {
        private final String name;
        private final Option flagValue;
        private final Codec codec;
        private final EndpointIO.Info info;

        public static <T> Query<T> apply(String string, Option<T> option, Codec<List<String>, T, CodecFormat> codec2, EndpointIO.Info<T> info) {
            return EndpointInput$Query$.MODULE$.apply(string, option, codec2, info);
        }

        public static Query<?> fromProduct(Product product) {
            return EndpointInput$Query$.MODULE$.fromProduct(product);
        }

        public static <T> Query<T> unapply(Query<T> query2) {
            return EndpointInput$Query$.MODULE$.unapply(query2);
        }

        public Query(String name, Option<T> flagValue, Codec<List<String>, T, CodecFormat> codec2, EndpointIO.Info<T> info) {
            this.name = name;
            this.flagValue = flagValue;
            this.codec = codec2;
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Query)) return false;
            Query query2 = (Query)object;
            String string = this.name();
            String string2 = query2.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<T> option = this.flagValue();
            Option<T> option2 = query2.flagValue();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Codec<List<String>, T, CodecFormat> codec2 = this.codec();
            Codec<List<String>, T, CodecFormat> codec3 = query2.codec();
            if (codec2 == null) {
                if (codec3 != null) {
                    return false;
                }
            } else if (!codec2.equals(codec3)) return false;
            EndpointIO.Info<T> info = this.info();
            EndpointIO.Info<T> info2 = query2.info();
            if (info == null) {
                if (info2 != null) {
                    return false;
                }
            } else if (!((Object)info).equals(info2)) return false;
            if (!query2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Query;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Query";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "flagValue";
                }
                case 2: {
                    return "codec";
                }
                case 3: {
                    return "info";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public Option<T> flagValue() {
            return this.flagValue;
        }

        @Override
        public Codec<List<String>, T, CodecFormat> codec() {
            return this.codec;
        }

        @Override
        public EndpointIO.Info<T> info() {
            return this.info;
        }

        public <U> Query<U> copyWith(Codec<List<String>, U, CodecFormat> c, EndpointIO.Info<U> i) {
            Option option = this.flagValue().map((Function1 & Serializable)t -> c.decode(this.codec().encode(t))).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(DecodeResult x) {
                    DecodeResult decodeResult = x;
                    if (decodeResult instanceof DecodeResult.Value) {
                        T t;
                        DecodeResult.Value<T> value = DecodeResult$Value$.MODULE$.unapply((DecodeResult.Value)decodeResult);
                        T u = t = value._1();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(DecodeResult x, Function1 function1) {
                    DecodeResult decodeResult = x;
                    if (decodeResult instanceof DecodeResult.Value) {
                        T t;
                        DecodeResult.Value<T> value = DecodeResult$Value$.MODULE$.unapply((DecodeResult.Value)decodeResult);
                        T u = t = value._1();
                        return u;
                    }
                    return function1.apply((Object)x);
                }
            });
            String string = this.copy$default$1();
            return this.copy(string, option, c, i);
        }

        @Override
        public String show() {
            return package$.MODULE$.addValidatorShow(new StringBuilder(1).append("?").append(this.name()).toString(), this.codec().schema());
        }

        public Query<T> flagValue(T v) {
            Some some = Some$.MODULE$.apply(v);
            String string = this.copy$default$1();
            Codec<List<String>, T, CodecFormat> codec2 = this.copy$default$3();
            EndpointIO.Info<T> info = this.copy$default$4();
            return this.copy(string, (Option<T>)some, codec2, info);
        }

        public <T> Query<T> copy(String name, Option<T> flagValue, Codec<List<String>, T, CodecFormat> codec2, EndpointIO.Info<T> info) {
            return new Query<T>(name, flagValue, codec2, info);
        }

        public <T> String copy$default$1() {
            return this.name();
        }

        public <T> Option<T> copy$default$2() {
            return this.flagValue();
        }

        public <T> Codec<List<String>, T, CodecFormat> copy$default$3() {
            return this.codec();
        }

        public <T> EndpointIO.Info<T> copy$default$4() {
            return this.info();
        }

        public String _1() {
            return this.name();
        }

        public Option<T> _2() {
            return this.flagValue();
        }

        public Codec<List<String>, T, CodecFormat> _3() {
            return this.codec();
        }

        public EndpointIO.Info<T> _4() {
            return this.info();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class QueryParams<T>
    implements Atom<T>,
    Product,
    Serializable {
        private final Codec codec;
        private final EndpointIO.Info info;

        public static <T> QueryParams<T> apply(Codec<sttp.model.QueryParams, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return EndpointInput$QueryParams$.MODULE$.apply(codec2, info);
        }

        public static QueryParams<?> fromProduct(Product product) {
            return EndpointInput$QueryParams$.MODULE$.fromProduct(product);
        }

        public static <T> QueryParams<T> unapply(QueryParams<T> queryParams) {
            return EndpointInput$QueryParams$.MODULE$.unapply(queryParams);
        }

        public QueryParams(Codec<sttp.model.QueryParams, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            this.codec = codec2;
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QueryParams)) return false;
            QueryParams queryParams = (QueryParams)object;
            Codec<sttp.model.QueryParams, T, CodecFormat.TextPlain> codec2 = this.codec();
            Codec<sttp.model.QueryParams, T, CodecFormat.TextPlain> codec3 = queryParams.codec();
            if (codec2 == null) {
                if (codec3 != null) {
                    return false;
                }
            } else if (!codec2.equals(codec3)) return false;
            EndpointIO.Info<T> info = this.info();
            EndpointIO.Info<T> info2 = queryParams.info();
            if (info == null) {
                if (info2 != null) {
                    return false;
                }
            } else if (!((Object)info).equals(info2)) return false;
            if (!queryParams.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof QueryParams;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "QueryParams";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "codec";
            }
            if (1 == n2) {
                return "info";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Codec<sttp.model.QueryParams, T, CodecFormat.TextPlain> codec() {
            return this.codec;
        }

        @Override
        public EndpointIO.Info<T> info() {
            return this.info;
        }

        public <U> QueryParams<U> copyWith(Codec<sttp.model.QueryParams, U, CodecFormat.TextPlain> c, EndpointIO.Info<U> i) {
            return this.copy(c, i);
        }

        @Override
        public String show() {
            return "?*";
        }

        public <T> QueryParams<T> copy(Codec<sttp.model.QueryParams, T, CodecFormat.TextPlain> codec2, EndpointIO.Info<T> info) {
            return new QueryParams<T>(codec2, info);
        }

        public <T> Codec<sttp.model.QueryParams, T, CodecFormat.TextPlain> copy$default$1() {
            return this.codec();
        }

        public <T> EndpointIO.Info<T> copy$default$2() {
            return this.info();
        }

        public Codec<sttp.model.QueryParams, T, CodecFormat.TextPlain> _1() {
            return this.codec();
        }

        public EndpointIO.Info<T> _2() {
            return this.info();
        }
    }

    public static interface Single<T>
    extends EndpointInput<T> {
    }
}

