/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import sttp.tapir.FieldName;
import sttp.tapir.Schema;
import sttp.tapir.Schema$;
import sttp.tapir.SchemaType$;
import sttp.tapir.SchemaType$SArray$;
import sttp.tapir.SchemaType$SBinary$;
import sttp.tapir.SchemaType$SBoolean$;
import sttp.tapir.SchemaType$SCoproduct$;
import sttp.tapir.SchemaType$SDate$;
import sttp.tapir.SchemaType$SDateTime$;
import sttp.tapir.SchemaType$SDiscriminator$;
import sttp.tapir.SchemaType$SInteger$;
import sttp.tapir.SchemaType$SNumber$;
import sttp.tapir.SchemaType$SOpenProduct$;
import sttp.tapir.SchemaType$SOption$;
import sttp.tapir.SchemaType$SProduct$;
import sttp.tapir.SchemaType$SProductField$;
import sttp.tapir.SchemaType$SRef$;
import sttp.tapir.SchemaType$SString$;
import sttp.tapir.SchemaType$SchemaWithValue$;

public interface SchemaType<T> {
    public String show();

    public <TT> SchemaType<TT> contramap(Function1<TT, T> var1);

    public <TT> SchemaType<TT> as();

    public static class SArray<T, E>
    implements SchemaType<T>,
    Product,
    Serializable {
        private final Schema element;
        private final Function1 toIterable;

        public static <T, E> SArray<T, E> apply(Schema<E> schema, Function1<T, Iterable<E>> function1) {
            return SchemaType$SArray$.MODULE$.apply(schema, function1);
        }

        public static <T, E> SArray<T, E> unapply(SArray<T, E> sArray) {
            return SchemaType$SArray$.MODULE$.unapply(sArray);
        }

        public SArray(Schema<E> element, Function1<T, Iterable<E>> toIterable) {
            this.element = element;
            this.toIterable = toIterable;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SArray)) return false;
            SArray sArray = (SArray)object;
            Schema<E> schema = this.element();
            Schema<E> schema2 = sArray.element();
            if (schema == null) {
                if (schema2 != null) {
                    return false;
                }
            } else if (!((Object)schema).equals(schema2)) return false;
            if (!sArray.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SArray;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SArray";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "element";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Schema<E> element() {
            return this.element;
        }

        public Function1<T, Iterable<E>> toIterable() {
            return this.toIterable;
        }

        @Override
        public String show() {
            return new StringBuilder(7).append("array(").append(this.element().show()).append(")").toString();
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SArray$.MODULE$.apply(this.element(), g.andThen(this.toIterable()));
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SArray$.MODULE$.apply(this.element(), SchemaType$::sttp$tapir$SchemaType$SArray$$_$as$$anonfun$2);
        }

        public <T, E> SArray<T, E> copy(Schema<E> element, Function1<T, Iterable<E>> toIterable) {
            return new SArray<T, E>(element, toIterable);
        }

        public <T, E> Schema<E> copy$default$1() {
            return this.element();
        }

        public Schema<E> _1() {
            return this.element();
        }
    }

    public static class SBinary<T>
    implements SchemaType<T>,
    Product,
    Serializable {
        public static <T> SBinary<T> apply() {
            return SchemaType$SBinary$.MODULE$.apply();
        }

        public static SBinary<?> fromProduct(Product product) {
            return SchemaType$SBinary$.MODULE$.fromProduct(product);
        }

        public static <T> boolean unapply(SBinary<T> sBinary) {
            return SchemaType$SBinary$.MODULE$.unapply(sBinary);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SBinary)) return false;
            SBinary sBinary = (SBinary)object;
            boolean bl = sBinary.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SBinary;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "SBinary";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String show() {
            return "binary";
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SBinary$.MODULE$.apply();
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SBinary$.MODULE$.apply();
        }

        public <T> SBinary<T> copy() {
            return new SBinary<T>();
        }
    }

    public static class SBoolean<T>
    implements SchemaType<T>,
    Product,
    Serializable {
        public static <T> SBoolean<T> apply() {
            return SchemaType$SBoolean$.MODULE$.apply();
        }

        public static SBoolean<?> fromProduct(Product product) {
            return SchemaType$SBoolean$.MODULE$.fromProduct(product);
        }

        public static <T> boolean unapply(SBoolean<T> sBoolean) {
            return SchemaType$SBoolean$.MODULE$.unapply(sBoolean);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SBoolean)) return false;
            SBoolean sBoolean = (SBoolean)object;
            boolean bl = sBoolean.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SBoolean;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "SBoolean";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String show() {
            return "boolean";
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SBoolean$.MODULE$.apply();
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SBoolean$.MODULE$.apply();
        }

        public <T> SBoolean<T> copy() {
            return new SBoolean<T>();
        }
    }

    public static class SCoproduct<T>
    implements SchemaType<T>,
    Product,
    Serializable {
        private final List subtypes;
        private final Option discriminator;
        private final Function1 subtypeSchema;

        public static <T> SCoproduct<T> apply(List<Schema<?>> list, Option<SDiscriminator> option, Function1<T, Option<SchemaWithValue<?>>> function1) {
            return SchemaType$SCoproduct$.MODULE$.apply(list, option, function1);
        }

        public static <T> SCoproduct<T> unapply(SCoproduct<T> sCoproduct) {
            return SchemaType$SCoproduct$.MODULE$.unapply(sCoproduct);
        }

        public SCoproduct(List<Schema<?>> subtypes, Option<SDiscriminator> discriminator, Function1<T, Option<SchemaWithValue<?>>> subtypeSchema) {
            this.subtypes = subtypes;
            this.discriminator = discriminator;
            this.subtypeSchema = subtypeSchema;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SCoproduct)) return false;
            SCoproduct sCoproduct = (SCoproduct)object;
            List<Schema<?>> list = this.subtypes();
            List<Schema<?>> list2 = sCoproduct.subtypes();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            Option<SDiscriminator> option = this.discriminator();
            Option<SDiscriminator> option2 = sCoproduct.discriminator();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!sCoproduct.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SCoproduct;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SCoproduct";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subtypes";
            }
            if (1 == n2) {
                return "discriminator";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Schema<?>> subtypes() {
            return this.subtypes;
        }

        public Option<SDiscriminator> discriminator() {
            return this.discriminator;
        }

        public Function1<T, Option<SchemaWithValue<?>>> subtypeSchema() {
            return this.subtypeSchema;
        }

        @Override
        public String show() {
            return new StringBuilder(6).append("oneOf:").append(this.subtypes().map(SchemaType$::sttp$tapir$SchemaType$SCoproduct$$_$show$$anonfun$2).mkString(",")).toString();
        }

        public <D> SCoproduct<T> addDiscriminatorField(FieldName discriminatorName, Schema<D> discriminatorSchema, Map<String, SRef<?>> discriminatorMapping) {
            Map reverseDiscriminatorByNameMapping = discriminatorMapping.toList().map(SchemaType$::sttp$tapir$SchemaType$SCoproduct$$_$_$$anonfun$1).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return SchemaType$SCoproduct$.MODULE$.apply(this.subtypes().map(arg_0 -> SchemaType$.sttp$tapir$SchemaType$SCoproduct$$_$addDiscriminatorField$$anonfun$1(discriminatorName, discriminatorSchema, reverseDiscriminatorByNameMapping, arg_0)), (Option<SDiscriminator>)Some$.MODULE$.apply((Object)SchemaType$SDiscriminator$.MODULE$.apply(discriminatorName, discriminatorMapping)), this.subtypeSchema());
        }

        public <D> Schema<Nothing$> addDiscriminatorField$default$2() {
            return Schema$.MODULE$.string();
        }

        public <D> Map<String, SRef<?>> addDiscriminatorField$default$3() {
            return Predef$.MODULE$.Map().empty();
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SCoproduct$.MODULE$.apply(this.subtypes(), this.discriminator(), g.andThen(this.subtypeSchema()));
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SCoproduct$.MODULE$.apply(this.subtypes(), this.discriminator(), SchemaType$::sttp$tapir$SchemaType$SCoproduct$$_$as$$anonfun$6);
        }

        public <T> SCoproduct<T> copy(List<Schema<?>> subtypes, Option<SDiscriminator> discriminator, Function1<T, Option<SchemaWithValue<?>>> subtypeSchema) {
            return new SCoproduct<T>(subtypes, discriminator, subtypeSchema);
        }

        public <T> List<Schema<?>> copy$default$1() {
            return this.subtypes();
        }

        public <T> Option<SDiscriminator> copy$default$2() {
            return this.discriminator();
        }

        public List<Schema<?>> _1() {
            return this.subtypes();
        }

        public Option<SDiscriminator> _2() {
            return this.discriminator();
        }
    }

    public static class SDate<T>
    implements SchemaType<T>,
    Product,
    Serializable {
        public static <T> SDate<T> apply() {
            return SchemaType$SDate$.MODULE$.apply();
        }

        public static SDate<?> fromProduct(Product product) {
            return SchemaType$SDate$.MODULE$.fromProduct(product);
        }

        public static <T> boolean unapply(SDate<T> sDate) {
            return SchemaType$SDate$.MODULE$.unapply(sDate);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SDate)) return false;
            SDate sDate = (SDate)object;
            boolean bl = sDate.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SDate;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "SDate";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String show() {
            return "date";
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SDate$.MODULE$.apply();
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SDate$.MODULE$.apply();
        }

        public <T> SDate<T> copy() {
            return new SDate<T>();
        }
    }

    public static class SDateTime<T>
    implements SchemaType<T>,
    Product,
    Serializable {
        public static <T> SDateTime<T> apply() {
            return SchemaType$SDateTime$.MODULE$.apply();
        }

        public static SDateTime<?> fromProduct(Product product) {
            return SchemaType$SDateTime$.MODULE$.fromProduct(product);
        }

        public static <T> boolean unapply(SDateTime<T> sDateTime) {
            return SchemaType$SDateTime$.MODULE$.unapply(sDateTime);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SDateTime)) return false;
            SDateTime sDateTime = (SDateTime)object;
            boolean bl = sDateTime.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SDateTime;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "SDateTime";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String show() {
            return "date-time";
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SDateTime$.MODULE$.apply();
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SDateTime$.MODULE$.apply();
        }

        public <T> SDateTime<T> copy() {
            return new SDateTime<T>();
        }
    }

    public static class SDiscriminator
    implements Product,
    Serializable {
        private final FieldName name;
        private final Map mapping;

        public static SDiscriminator apply(FieldName fieldName, Map<String, SRef<?>> map) {
            return SchemaType$SDiscriminator$.MODULE$.apply(fieldName, map);
        }

        public static SDiscriminator fromProduct(Product product) {
            return SchemaType$SDiscriminator$.MODULE$.fromProduct(product);
        }

        public static SDiscriminator unapply(SDiscriminator sDiscriminator) {
            return SchemaType$SDiscriminator$.MODULE$.unapply(sDiscriminator);
        }

        public SDiscriminator(FieldName name, Map<String, SRef<?>> mapping) {
            this.name = name;
            this.mapping = mapping;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SDiscriminator)) return false;
            SDiscriminator sDiscriminator = (SDiscriminator)object;
            FieldName fieldName = this.name();
            FieldName fieldName2 = sDiscriminator.name();
            if (fieldName == null) {
                if (fieldName2 != null) {
                    return false;
                }
            } else if (!((Object)fieldName).equals(fieldName2)) return false;
            Map<String, SRef<?>> map = this.mapping();
            Map<String, SRef<?>> map2 = sDiscriminator.mapping();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!sDiscriminator.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SDiscriminator;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SDiscriminator";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "mapping";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FieldName name() {
            return this.name;
        }

        public Map<String, SRef<?>> mapping() {
            return this.mapping;
        }

        public SDiscriminator copy(FieldName name, Map<String, SRef<?>> mapping) {
            return new SDiscriminator(name, mapping);
        }

        public FieldName copy$default$1() {
            return this.name();
        }

        public Map<String, SRef<?>> copy$default$2() {
            return this.mapping();
        }

        public FieldName _1() {
            return this.name();
        }

        public Map<String, SRef<?>> _2() {
            return this.mapping();
        }
    }

    public static class SInteger<T>
    implements SchemaType<T>,
    Product,
    Serializable {
        public static <T> SInteger<T> apply() {
            return SchemaType$SInteger$.MODULE$.apply();
        }

        public static SInteger<?> fromProduct(Product product) {
            return SchemaType$SInteger$.MODULE$.fromProduct(product);
        }

        public static <T> boolean unapply(SInteger<T> sInteger) {
            return SchemaType$SInteger$.MODULE$.unapply(sInteger);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SInteger)) return false;
            SInteger sInteger = (SInteger)object;
            boolean bl = sInteger.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SInteger;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "SInteger";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String show() {
            return "integer";
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SInteger$.MODULE$.apply();
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SInteger$.MODULE$.apply();
        }

        public <T> SInteger<T> copy() {
            return new SInteger<T>();
        }
    }

    public static class SNumber<T>
    implements SchemaType<T>,
    Product,
    Serializable {
        public static <T> SNumber<T> apply() {
            return SchemaType$SNumber$.MODULE$.apply();
        }

        public static SNumber<?> fromProduct(Product product) {
            return SchemaType$SNumber$.MODULE$.fromProduct(product);
        }

        public static <T> boolean unapply(SNumber<T> sNumber) {
            return SchemaType$SNumber$.MODULE$.unapply(sNumber);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SNumber)) return false;
            SNumber sNumber = (SNumber)object;
            boolean bl = sNumber.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SNumber;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "SNumber";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String show() {
            return "number";
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SNumber$.MODULE$.apply();
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SNumber$.MODULE$.apply();
        }

        public <T> SNumber<T> copy() {
            return new SNumber<T>();
        }
    }

    public static class SOpenProduct<T, V>
    implements SchemaType<T>,
    Product,
    Serializable {
        private final List fields;
        private final Schema valueSchema;
        private final Function1 mapFieldValues;
        private final List fieldsWithValidation;

        public static <T, V> SOpenProduct<T, V> apply(List<SProductField<T>> list, Schema<V> schema, Function1<T, Map<String, V>> function1) {
            return SchemaType$SOpenProduct$.MODULE$.apply(list, schema, function1);
        }

        public static <T, V> SOpenProduct<T, V> unapply(SOpenProduct<T, V> sOpenProduct) {
            return SchemaType$SOpenProduct$.MODULE$.unapply(sOpenProduct);
        }

        public SOpenProduct(List<SProductField<T>> fields, Schema<V> valueSchema, Function1<T, Map<String, V>> mapFieldValues) {
            this.fields = fields;
            this.valueSchema = valueSchema;
            this.mapFieldValues = mapFieldValues;
            this.fieldsWithValidation = fields.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(SProductField x) {
                    SProductField sProductField = x;
                    SProductField f = sProductField;
                    return f.schema().hasValidation();
                }

                public final Object applyOrElse(SProductField x, Function1 function1) {
                    SProductField sProductField = x;
                    SProductField f = sProductField;
                    if (f.schema().hasValidation()) {
                        return f;
                    }
                    return function1.apply((Object)x);
                }
            });
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SOpenProduct)) return false;
            SOpenProduct sOpenProduct = (SOpenProduct)object;
            List<SProductField<T>> list = this.fields();
            List<SProductField<T>> list2 = sOpenProduct.fields();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            Schema<V> schema = this.valueSchema();
            Schema<V> schema2 = sOpenProduct.valueSchema();
            if (schema == null) {
                if (schema2 != null) {
                    return false;
                }
            } else if (!((Object)schema).equals(schema2)) return false;
            if (!sOpenProduct.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SOpenProduct;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SOpenProduct";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "fields";
            }
            if (1 == n2) {
                return "valueSchema";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<SProductField<T>> fields() {
            return this.fields;
        }

        public Schema<V> valueSchema() {
            return this.valueSchema;
        }

        public Function1<T, Map<String, V>> mapFieldValues() {
            return this.mapFieldValues;
        }

        public List<FieldName> required() {
            return this.fields().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(SProductField x) {
                    SProductField sProductField = x;
                    SProductField f = sProductField;
                    return !f.schema().isOptional();
                }

                public final Object applyOrElse(SProductField x, Function1 function1) {
                    SProductField sProductField = x;
                    SProductField f = sProductField;
                    if (!f.schema().isOptional()) {
                        return f.name();
                    }
                    return function1.apply((Object)x);
                }
            });
        }

        @Override
        public String show() {
            return "map";
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SOpenProduct$.MODULE$.apply(this.fields().map(arg_0 -> SchemaType$.sttp$tapir$SchemaType$SOpenProduct$$_$contramap$$anonfun$2(g, arg_0)), this.valueSchema(), g.andThen(this.mapFieldValues()));
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SOpenProduct$.MODULE$.apply(this.fields().map(SchemaType$::sttp$tapir$SchemaType$SOpenProduct$$_$as$$anonfun$4), this.valueSchema(), SchemaType$::sttp$tapir$SchemaType$SOpenProduct$$_$as$$anonfun$5);
        }

        public List<SProductField<T>> fieldsWithValidation() {
            return this.fieldsWithValidation;
        }

        public <T, V> SOpenProduct<T, V> copy(List<SProductField<T>> fields, Schema<V> valueSchema, Function1<T, Map<String, V>> mapFieldValues) {
            return new SOpenProduct<T, V>(fields, valueSchema, mapFieldValues);
        }

        public <T, V> List<SProductField<T>> copy$default$1() {
            return this.fields();
        }

        public <T, V> Schema<V> copy$default$2() {
            return this.valueSchema();
        }

        public List<SProductField<T>> _1() {
            return this.fields();
        }

        public Schema<V> _2() {
            return this.valueSchema();
        }
    }

    public static class SOption<T, E>
    implements SchemaType<T>,
    Product,
    Serializable {
        private final Schema element;
        private final Function1 toOption;

        public static <T, E> SOption<T, E> apply(Schema<E> schema, Function1<T, Option<E>> function1) {
            return SchemaType$SOption$.MODULE$.apply(schema, function1);
        }

        public static <T, E> SOption<T, E> unapply(SOption<T, E> sOption) {
            return SchemaType$SOption$.MODULE$.unapply(sOption);
        }

        public SOption(Schema<E> element, Function1<T, Option<E>> toOption) {
            this.element = element;
            this.toOption = toOption;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SOption)) return false;
            SOption sOption = (SOption)object;
            Schema<E> schema = this.element();
            Schema<E> schema2 = sOption.element();
            if (schema == null) {
                if (schema2 != null) {
                    return false;
                }
            } else if (!((Object)schema).equals(schema2)) return false;
            if (!sOption.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SOption;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SOption";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "element";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Schema<E> element() {
            return this.element;
        }

        public Function1<T, Option<E>> toOption() {
            return this.toOption;
        }

        @Override
        public String show() {
            return new StringBuilder(8).append("option(").append(this.element().show()).append(")").toString();
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SOption$.MODULE$.apply(this.element(), g.andThen(this.toOption()));
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SOption$.MODULE$.apply(this.element(), SchemaType$::sttp$tapir$SchemaType$SOption$$_$as$$anonfun$1);
        }

        public <T, E> SOption<T, E> copy(Schema<E> element, Function1<T, Option<E>> toOption) {
            return new SOption<T, E>(element, toOption);
        }

        public <T, E> Schema<E> copy$default$1() {
            return this.element();
        }

        public Schema<E> _1() {
            return this.element();
        }
    }

    public static class SProduct<T>
    implements SchemaType<T>,
    Product,
    Serializable {
        private final List fields;
        private final List fieldsWithValidation;

        public static <T> SProduct<T> apply(List<SProductField<T>> list) {
            return SchemaType$SProduct$.MODULE$.apply(list);
        }

        public static <T> SProduct<T> empty() {
            return SchemaType$SProduct$.MODULE$.empty();
        }

        public static SProduct<?> fromProduct(Product product) {
            return SchemaType$SProduct$.MODULE$.fromProduct(product);
        }

        public static <T> SProduct<T> unapply(SProduct<T> sProduct) {
            return SchemaType$SProduct$.MODULE$.unapply(sProduct);
        }

        public SProduct(List<SProductField<T>> fields) {
            this.fields = fields;
            this.fieldsWithValidation = fields.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(SProductField x) {
                    SProductField sProductField = x;
                    SProductField f = sProductField;
                    return f.schema().hasValidation();
                }

                public final Object applyOrElse(SProductField x, Function1 function1) {
                    SProductField sProductField = x;
                    SProductField f = sProductField;
                    if (f.schema().hasValidation()) {
                        return f;
                    }
                    return function1.apply((Object)x);
                }
            });
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SProduct)) return false;
            SProduct sProduct = (SProduct)object;
            List<SProductField<T>> list = this.fields();
            List<SProductField<T>> list2 = sProduct.fields();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!sProduct.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SProduct;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SProduct";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "fields";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<SProductField<T>> fields() {
            return this.fields;
        }

        public List<FieldName> required() {
            return this.fields().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(SProductField x) {
                    SProductField sProductField = x;
                    SProductField f = sProductField;
                    return !f.schema().isOptional();
                }

                public final Object applyOrElse(SProductField x, Function1 function1) {
                    SProductField sProductField = x;
                    SProductField f = sProductField;
                    if (!f.schema().isOptional()) {
                        return f.name();
                    }
                    return function1.apply((Object)x);
                }
            });
        }

        @Override
        public String show() {
            return new StringBuilder(7).append("object(").append(this.fields().map(SchemaType$::sttp$tapir$SchemaType$SProduct$$_$show$$anonfun$1).mkString(",")).toString();
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SProduct$.MODULE$.apply(this.fields().map(arg_0 -> SchemaType$.sttp$tapir$SchemaType$SProduct$$_$contramap$$anonfun$1(g, arg_0)));
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SProduct$.MODULE$.apply(this.fields().map(SchemaType$::sttp$tapir$SchemaType$SProduct$$_$as$$anonfun$3));
        }

        public List<SProductField<T>> fieldsWithValidation() {
            return this.fieldsWithValidation;
        }

        public <T> SProduct<T> copy(List<SProductField<T>> fields) {
            return new SProduct<T>(fields);
        }

        public <T> List<SProductField<T>> copy$default$1() {
            return this.fields();
        }

        public List<SProductField<T>> _1() {
            return this.fields();
        }
    }

    public static interface SProductField<T>
    extends Serializable {
        public static <T, F> SProductField<T> apply(FieldName fieldName, Schema<F> schema, Function1<T, Option<F>> function1) {
            return SchemaType$SProductField$.MODULE$.apply(fieldName, schema, function1);
        }

        public FieldName name();

        public Schema<Object> schema();

        public Function1<T, Option<Object>> get();

        public static boolean equals$(SProductField $this, Object other) {
            return $this.equals(other);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        default public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof SProductField)) return false;
            SProductField p = (SProductField)object;
            FieldName fieldName = p.name();
            FieldName fieldName2 = this.name();
            if (fieldName == null) {
                if (fieldName2 != null) {
                    return false;
                }
            } else if (!((Object)fieldName).equals(fieldName2)) return false;
            Schema<Object> schema = p.schema();
            Schema<Object> schema2 = this.schema();
            if (schema == null) {
                if (schema2 == null) return true;
                return false;
            } else {
                if (!((Object)schema).equals(schema2)) return false;
                return true;
            }
        }

        public static String show$(SProductField $this) {
            return $this.show();
        }

        default public String show() {
            return new StringBuilder(8).append("field(").append(this.name()).append(",").append(this.schema().show()).append(")").toString();
        }

        public static String toString$(SProductField $this) {
            return $this.toString();
        }

        default public String toString() {
            return new StringBuilder(16).append("SProductField(").append(this.name()).append(",").append(this.schema()).append(")").toString();
        }
    }

    public static class SRef<T>
    implements SchemaType<T>,
    Product,
    Serializable {
        private final Schema.SName name;

        public static <T> SRef<T> apply(Schema.SName sName) {
            return SchemaType$SRef$.MODULE$.apply(sName);
        }

        public static SRef<?> fromProduct(Product product) {
            return SchemaType$SRef$.MODULE$.fromProduct(product);
        }

        public static <T> SRef<T> unapply(SRef<T> sRef) {
            return SchemaType$SRef$.MODULE$.unapply(sRef);
        }

        public SRef(Schema.SName name) {
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SRef)) return false;
            SRef sRef = (SRef)object;
            Schema.SName sName = this.name();
            Schema.SName sName2 = sRef.name();
            if (sName == null) {
                if (sName2 != null) {
                    return false;
                }
            } else if (!((Object)sName).equals(sName2)) return false;
            if (!sRef.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SRef;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SRef";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Schema.SName name() {
            return this.name;
        }

        @Override
        public String show() {
            return new StringBuilder(5).append("ref(").append(this.name()).append(")").toString();
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SRef$.MODULE$.apply(this.name());
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SRef$.MODULE$.apply(this.name());
        }

        public <T> SRef<T> copy(Schema.SName name) {
            return new SRef<T>(name);
        }

        public <T> Schema.SName copy$default$1() {
            return this.name();
        }

        public Schema.SName _1() {
            return this.name();
        }
    }

    public static class SString<T>
    implements SchemaType<T>,
    Product,
    Serializable {
        public static <T> SString<T> apply() {
            return SchemaType$SString$.MODULE$.apply();
        }

        public static SString<?> fromProduct(Product product) {
            return SchemaType$SString$.MODULE$.fromProduct(product);
        }

        public static <T> boolean unapply(SString<T> sString) {
            return SchemaType$SString$.MODULE$.unapply(sString);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SString)) return false;
            SString sString = (SString)object;
            boolean bl = sString.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SString;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "SString";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String show() {
            return "string";
        }

        @Override
        public <TT> SchemaType<TT> contramap(Function1<TT, T> g) {
            return SchemaType$SString$.MODULE$.apply();
        }

        @Override
        public <TT> SchemaType<TT> as() {
            return SchemaType$SString$.MODULE$.apply();
        }

        public <T> SString<T> copy() {
            return new SString<T>();
        }
    }

    public static class SchemaWithValue<T>
    implements Product,
    Serializable {
        private final Schema schema;
        private final Object value;

        public static <T> SchemaWithValue<T> apply(Schema<T> schema, T t) {
            return SchemaType$SchemaWithValue$.MODULE$.apply(schema, t);
        }

        public static SchemaWithValue<?> fromProduct(Product product) {
            return SchemaType$SchemaWithValue$.MODULE$.fromProduct(product);
        }

        public static <T> SchemaWithValue<T> unapply(SchemaWithValue<T> schemaWithValue) {
            return SchemaType$SchemaWithValue$.MODULE$.unapply(schemaWithValue);
        }

        public SchemaWithValue(Schema<T> schema, T value) {
            this.schema = schema;
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SchemaWithValue)) return false;
            SchemaWithValue schemaWithValue = (SchemaWithValue)object;
            Schema<T> schema = this.schema();
            Schema<T> schema2 = schemaWithValue.schema();
            if (schema == null) {
                if (schema2 != null) {
                    return false;
                }
            } else if (!((Object)schema).equals(schema2)) return false;
            if (!BoxesRunTime.equals(this.value(), schemaWithValue.value())) return false;
            if (!schemaWithValue.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SchemaWithValue;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SchemaWithValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "schema";
            }
            if (1 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Schema<T> schema() {
            return this.schema;
        }

        public T value() {
            return (T)this.value;
        }

        public <T> SchemaWithValue<T> copy(Schema<T> schema, T value) {
            return new SchemaWithValue<T>(schema, value);
        }

        public <T> Schema<T> copy$default$1() {
            return this.schema();
        }

        public <T> T copy$default$2() {
            return this.value();
        }

        public Schema<T> _1() {
            return this.schema();
        }

        public T _2() {
            return this.value();
        }
    }
}

