/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.files;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.model.ContentRangeUnits$;
import sttp.model.MediaType;
import sttp.model.headers.ETag;
import sttp.model.headers.Range;
import sttp.monad.MonadError;
import sttp.monad.MonadError$;
import sttp.monad.syntax$;
import sttp.monad.syntax$MonadErrorValueOps$;
import sttp.tapir.FileRange;
import sttp.tapir.FileRange$;
import sttp.tapir.RangeValue;
import sttp.tapir.RangeValue$;
import sttp.tapir.files.FilesOptions;
import sttp.tapir.files.FilesOptions$;
import sttp.tapir.files.ResolvedUrl;
import sttp.tapir.files.ResolvedUrl$;
import sttp.tapir.files.StaticErrorOutput;
import sttp.tapir.files.StaticErrorOutput$NotFound$;
import sttp.tapir.files.StaticErrorOutput$RangeNotSatisfiable$;
import sttp.tapir.files.StaticInput;
import sttp.tapir.files.StaticOutput;
import sttp.tapir.files.StaticOutput$Found$;
import sttp.tapir.files.StaticOutput$FoundPartial$;
import sttp.tapir.files.StaticOutput$NotModified$;
import sttp.tapir.files.package$;

public final class Files$
implements Serializable {
    public static final Files$ MODULE$ = new Files$();

    private Files$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Files$.class);
    }

    public <F> Function1<MonadError<F>, Function1<StaticInput, Object>> head(String systemPath, FilesOptions<F> options) {
        return (Function1 & Serializable)monad -> (Function1 & Serializable)filesInput -> syntax$.MODULE$.MonadErrorOps((Function0<Object>)((Function0 & Serializable)() -> Files$.head$$anonfun$1$$anonfun$1$$anonfun$1(systemPath, options, monad, filesInput))).map((Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)_$3 -> _$3.withoutBody()), monad);
    }

    public <F> FilesOptions<F> head$default$2() {
        return FilesOptions$.MODULE$.default();
    }

    public <F> Function1<MonadError<F>, Function1<StaticInput, Object>> get(String systemPath, FilesOptions<F> options) {
        return (Function1 & Serializable)monad -> (Function1 & Serializable)filesInput -> syntax$.MODULE$.MonadErrorOps((Function0<Object>)((Function0 & Serializable)() -> Files$.get$$anonfun$1$$anonfun$1$$anonfun$1(monad, systemPath))).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Path path2 = (Path)((Some)option).value();
                Function2<List<String>, Option<List<String>>, Either<StaticErrorOutput, ResolvedUrl>> resolveUrlFn = MODULE$.resolveSystemPathUrl((StaticInput)filesInput, options, path2);
                return MODULE$.files((StaticInput)filesInput, options, resolveUrlFn, (Function2 & Serializable)(url, range) -> MODULE$.fileRangeFromUrl((URL)url, (Option<RangeValue>)range), (MonadError)monad);
            }
            if (None$.MODULE$.equals(option)) {
                return MonadError$.MODULE$.apply(monad).unit(scala.package$.MODULE$.Left().apply((Object)StaticErrorOutput$NotFound$.MODULE$));
            }
            throw new MatchError((Object)option);
        }, monad);
    }

    public <F> FilesOptions<F> get$default$2() {
        return FilesOptions$.MODULE$.default();
    }

    public <F> Function1<MonadError<F>, Function1<Option<RangeValue>, Function1<URL, Object>>> defaultEtag() {
        return (Function1 & Serializable)monad -> (Function1 & Serializable)range -> (Function1 & Serializable)url -> monad.blocking(() -> Files$.defaultEtag$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(url, range));
    }

    private FileRange fileRangeFromUrl(URL url, Option<RangeValue> range) {
        return FileRange$.MODULE$.apply(new File(url.toURI()), range);
    }

    private <F> Function2<List<String>, Option<List<String>>, Either<StaticErrorOutput, ResolvedUrl>> resolveSystemPathUrl(StaticInput input, FilesOptions<F> options, Path systemPath) {
        if (!BoxesRunTime.unboxToBoolean((Object)options.fileFilter().apply(input.path()))) {
            return (Function2 & Serializable)(_$9, _$10) -> package$.MODULE$.LeftUrlNotFound();
        }
        return (Function2 & Serializable)(path2, option) -> this.resolveRec$1(systemPath, input, options, (List)path2, (Option)option);
    }

    public <F, R> Object files(StaticInput input, FilesOptions<F> options, Function2<List<String>, Option<List<String>>, Either<StaticErrorOutput, ResolvedUrl>> resolveUrlFn, Function2<URL, Option<RangeValue>, R> urlToResultFn, MonadError<F> m) {
        return m.flatten(m.blocking(() -> Files$.files$$anonfun$1(resolveUrlFn, input, options, m, urlToResultFn)));
    }

    private Path resolveGzipSibling(Path path2) {
        return path2.resolveSibling(new StringBuilder(3).append(path2.getFileName().toString()).append(".gz").toString());
    }

    private <F, R> Object rangeFileOutput(StaticInput filesInput, URL url, Function1<URL, Object> calculateETag, RangeValue range, MediaType contentType, Function2<URL, Option<RangeValue>, R> urlToResult, MonadError<F> m) {
        return this.fileOutput(filesInput, url, calculateETag, (Function3 & Serializable)(lastModified, _$15, etag) -> StaticOutput$FoundPartial$.MODULE$.apply(urlToResult.apply((Object)url, (Object)Some$.MODULE$.apply((Object)range)), (Option<Instant>)Some$.MODULE$.apply((Object)Instant.ofEpochMilli(BoxesRunTime.unboxToLong((Object)lastModified))), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)range.contentLength())), (Option<MediaType>)Some$.MODULE$.apply((Object)contentType), (Option<ETag>)((Option)etag), (Option<String>)Some$.MODULE$.apply((Object)ContentRangeUnits$.MODULE$.Bytes()), (Option<String>)Some$.MODULE$.apply((Object)range.toContentRange().toString())), m);
    }

    private <F, R> Object wholeFileOutput(StaticInput filesInput, URL url, Function1<URL, Object> calculateETag, MediaType contentType, Option<String> contentEncoding, Function2<URL, Option<RangeValue>, R> urlToResult, MonadError<F> m) {
        return this.fileOutput(filesInput, url, calculateETag, (Function3 & Serializable)(lastModified, fileLength, etag) -> StaticOutput$Found$.MODULE$.apply(urlToResult.apply((Object)url, (Object)None$.MODULE$), (Option<Instant>)Some$.MODULE$.apply((Object)Instant.ofEpochMilli(BoxesRunTime.unboxToLong((Object)lastModified))), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fileLength))), (Option<MediaType>)Some$.MODULE$.apply((Object)contentType), (Option<ETag>)((Option)etag), (Option<String>)Some$.MODULE$.apply((Object)ContentRangeUnits$.MODULE$.Bytes()), (Option<String>)contentEncoding), m);
    }

    private <F, R> Object fileOutput(StaticInput filesInput, URL url, Function1<URL, Object> calculateETag, Function3<Object, Object, Option<ETag>, StaticOutput<R>> result, MonadError<F> m) {
        return syntax$.MODULE$.MonadErrorOps((Function0<Object>)((Function0 & Serializable)() -> Files$.fileOutput$$anonfun$1(calculateETag, url))).flatMap((Function1 & Serializable)etagOpt -> syntax$.MODULE$.MonadErrorOps((Function0<Object>)((Function0 & Serializable)() -> Files$.fileOutput$$anonfun$2$$anonfun$1(m, url))).flatMap((Function1 & Serializable)urlConnection -> syntax$.MODULE$.MonadErrorOps((Function0<Object>)((Function0 & Serializable)() -> Files$.fileOutput$$anonfun$2$$anonfun$2$$anonfun$1(m, urlConnection))).flatMap((Function1 & Serializable)lastModified -> Files$.fileOutput$$anonfun$2$$anonfun$2$$anonfun$2(filesInput, etagOpt, m, urlConnection, result, BoxesRunTime.unboxToLong((Object)lastModified)), m), m), m);
    }

    private static final Object head$$anonfun$1$$anonfun$1$$anonfun$1(String systemPath$3, FilesOptions options$3, MonadError monad$2, StaticInput filesInput$1) {
        return ((Function1)MODULE$.get(systemPath$3, options$3).apply((Object)monad$2)).apply((Object)filesInput$1);
    }

    private static final Option get$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String systemPath$7) {
        Path systemPathAsPath = Paths.get(systemPath$7, new String[0]);
        if (Files.exists(systemPathAsPath, LinkOption.NOFOLLOW_LINKS)) {
            return Some$.MODULE$.apply((Object)systemPathAsPath.toRealPath(new LinkOption[0]));
        }
        return None$.MODULE$;
    }

    private static final Object get$$anonfun$1$$anonfun$1$$anonfun$1(MonadError monad$4, String systemPath$5) {
        return MonadError$.MODULE$.apply(monad$4).blocking(() -> Files$.get$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(systemPath$5));
    }

    private static final Option defaultEtag$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(URL url$1, Option range$2) {
        URLConnection connection = url$1.openConnection();
        long lastModified = connection.getLastModified();
        long length = connection.getContentLengthLong();
        return Some$.MODULE$.apply((Object)package$.MODULE$.defaultETag(lastModified, (Option<RangeValue>)range$2, length));
    }

    private final Either resolveRec$1(Path systemPath$8, StaticInput input$1, FilesOptions options$7, List path2, Option option) {
        Path realRequestedPath;
        while (true) {
            Path resolved = (Path)path2.foldLeft((Object)systemPath$8, (Function2 & Serializable)(_$7, _$8) -> _$7.resolve((String)_$8));
            Path resolvedGzipped = this.resolveGzipSibling(resolved);
            if (package$.MODULE$.useGzippedIfAvailable(input$1, options$7) && Files.exists(resolvedGzipped, LinkOption.NOFOLLOW_LINKS)) {
                Path realRequestedPath2 = resolvedGzipped.toRealPath(LinkOption.NOFOLLOW_LINKS);
                if (!realRequestedPath2.startsWith(resolvedGzipped)) {
                    return package$.MODULE$.LeftUrlNotFound();
                }
                return scala.package$.MODULE$.Right().apply((Object)ResolvedUrl$.MODULE$.apply(realRequestedPath2.toUri().toURL(), package$.MODULE$.contentTypeFromName(resolved.getFileName().toString()), (Option<String>)Some$.MODULE$.apply((Object)"gzip")));
            }
            if (!Files.exists(resolved, LinkOption.NOFOLLOW_LINKS)) {
                Option option2 = option;
                if (option2 instanceof Some) {
                    List defaultPath;
                    List list = defaultPath = (List)((Some)option2).value();
                    None$ none$ = None$.MODULE$;
                    path2 = list;
                    option = none$;
                    continue;
                }
                if (None$.MODULE$.equals(option2)) {
                    return package$.MODULE$.LeftUrlNotFound();
                }
                throw new MatchError((Object)option2);
            }
            realRequestedPath = resolved.toRealPath(LinkOption.NOFOLLOW_LINKS);
            if (!realRequestedPath.startsWith(systemPath$8)) {
                return package$.MODULE$.LeftUrlNotFound();
            }
            if (!realRequestedPath.toFile().isDirectory()) break;
            path2 = (List)path2.$colon$plus((Object)"index.html");
        }
        return scala.package$.MODULE$.Right().apply((Object)ResolvedUrl$.MODULE$.apply(realRequestedPath.toUri().toURL(), package$.MODULE$.contentTypeFromName(realRequestedPath.getFileName().toString()), (Option<String>)None$.MODULE$));
    }

    private static final Object files$$anonfun$1$$anonfun$1(StaticInput input$3, URL url$2, FilesOptions options$9, MonadError m$2, RangeValue rangeValue$1, MediaType contentType$1, Function2 urlToResultFn$2) {
        return MODULE$.rangeFileOutput(input$3, url$2, (Function1<URL, Object>)((Function1)((Function1)options$9.calculateETag().apply((Object)m$2)).apply((Object)Some$.MODULE$.apply((Object)rangeValue$1))), rangeValue$1, contentType$1, urlToResultFn$2, m$2);
    }

    private static final Object files$$anonfun$1$$anonfun$3(StaticInput input$4, URL url$3, FilesOptions options$10, MonadError m$3, MediaType contentType$2, Option contentEncoding$1, Function2 urlToResultFn$3) {
        return MODULE$.wholeFileOutput(input$4, url$3, (Function1<URL, Object>)((Function1)((Function1)options$10.calculateETag().apply((Object)m$3)).apply((Object)None$.MODULE$)), contentType$2, (Option<String>)contentEncoding$1, urlToResultFn$3, m$3);
    }

    private static final Object files$$anonfun$1(Function2 resolveUrlFn$1, StaticInput input$2, FilesOptions options$8, MonadError m$1, Function2 urlToResultFn$1) {
        ResolvedUrl resolvedUrl;
        Either either = (Either)resolveUrlFn$1.apply(input$2.path(), options$8.defaultFile());
        if (either instanceof Left) {
            StaticErrorOutput error = (StaticErrorOutput)((Left)either).value();
            Either either2 = (Either)syntax$.MODULE$.MonadErrorValueOps(scala.package$.MODULE$.Left().apply((Object)error));
            return syntax$MonadErrorValueOps$.MODULE$.unit$extension(either2, m$1);
        }
        if (either instanceof Right && (resolvedUrl = (ResolvedUrl)((Right)either).value()) != null) {
            ResolvedUrl resolvedUrl2 = ResolvedUrl$.MODULE$.unapply(resolvedUrl);
            URL uRL = resolvedUrl2._1();
            MediaType mediaType = resolvedUrl2._2();
            Option<String> option = resolvedUrl2._3();
            URL url = uRL;
            MediaType contentType = mediaType;
            Option<String> contentEncoding = option;
            Option<Range> option2 = input$2.range();
            if (option2 instanceof Some) {
                long fileSize;
                Range range = (Range)((Some)option2).value();
                if (range.isValid(fileSize = url.openConnection().getContentLengthLong())) {
                    RangeValue rangeValue = RangeValue$.MODULE$.apply(range.start(), range.end(), fileSize);
                    return syntax$.MODULE$.MonadErrorOps((Function0<Object>)((Function0 & Serializable)() -> Files$.files$$anonfun$1$$anonfun$1(input$2, url, options$8, m$1, rangeValue, contentType, urlToResultFn$1))).map((Function1 & Serializable)_$12 -> scala.package$.MODULE$.Right().apply(_$12), m$1);
                }
                Either either3 = (Either)syntax$.MODULE$.MonadErrorValueOps(scala.package$.MODULE$.Left().apply((Object)StaticErrorOutput$RangeNotSatisfiable$.MODULE$));
                return syntax$MonadErrorValueOps$.MODULE$.unit$extension(either3, m$1);
            }
            if (None$.MODULE$.equals(option2)) {
                return syntax$.MODULE$.MonadErrorOps((Function0<Object>)((Function0 & Serializable)() -> Files$.files$$anonfun$1$$anonfun$3(input$2, url, options$8, m$1, contentType, contentEncoding, urlToResultFn$1))).map((Function1 & Serializable)_$13 -> scala.package$.MODULE$.Right().apply(_$13), m$1);
            }
            throw new MatchError(option2);
        }
        throw new MatchError((Object)either);
    }

    private static final Object fileOutput$$anonfun$1(Function1 calculateETag$2, URL url$6) {
        return calculateETag$2.apply((Object)url$6);
    }

    private static final URLConnection fileOutput$$anonfun$2$$anonfun$1$$anonfun$1(URL url$9) {
        return url$9.openConnection();
    }

    private static final Object fileOutput$$anonfun$2$$anonfun$1(MonadError m$5, URL url$8) {
        return m$5.blocking(() -> Files$.fileOutput$$anonfun$2$$anonfun$1$$anonfun$1(url$8));
    }

    private static final long fileOutput$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(URLConnection urlConnection$2) {
        return urlConnection$2.getLastModified();
    }

    private static final Object fileOutput$$anonfun$2$$anonfun$2$$anonfun$1(MonadError m$7, URLConnection urlConnection$1) {
        return m$7.blocking(() -> Files$.fileOutput$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(urlConnection$1));
    }

    private static final long fileOutput$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(URLConnection urlConnection$6) {
        return urlConnection$6.getContentLengthLong();
    }

    private static final Object fileOutput$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(MonadError m$10, URLConnection urlConnection$5) {
        return m$10.blocking(() -> Files$.fileOutput$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(urlConnection$5));
    }

    private static final /* synthetic */ StaticOutput fileOutput$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2(Function3 result$5, long lastModified$2, Option etagOpt$4, long fileLength) {
        return (StaticOutput)result$5.apply((Object)BoxesRunTime.boxToLong((long)lastModified$2), (Object)BoxesRunTime.boxToLong((long)fileLength), (Object)etagOpt$4);
    }

    private static final Object fileOutput$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(StaticInput filesInput$6, Option etagOpt$3, long lastModified$1, MonadError m$9, URLConnection urlConnection$4, Function3 result$4) {
        if (package$.MODULE$.isModified(filesInput$6, (Option<ETag>)etagOpt$3, lastModified$1)) {
            return syntax$.MODULE$.MonadErrorOps((Function0<Object>)((Function0 & Serializable)() -> Files$.fileOutput$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(m$9, urlConnection$4))).map((Function1 & Serializable)fileLength -> Files$.fileOutput$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2(result$4, lastModified$1, etagOpt$3, BoxesRunTime.unboxToLong((Object)fileLength)), m$9);
        }
        StaticOutput staticOutput = (StaticOutput)syntax$.MODULE$.MonadErrorValueOps(StaticOutput$NotModified$.MODULE$);
        return syntax$MonadErrorValueOps$.MODULE$.unit$extension(staticOutput, m$9);
    }

    private static final /* synthetic */ Object fileOutput$$anonfun$2$$anonfun$2$$anonfun$2(StaticInput filesInput$5, Option etagOpt$2, MonadError m$8, URLConnection urlConnection$3, Function3 result$3, long lastModified) {
        return syntax$.MODULE$.MonadErrorOps((Function0<Object>)((Function0 & Serializable)() -> Files$.fileOutput$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(filesInput$5, etagOpt$2, lastModified, m$8, urlConnection$3, result$3))).map((Function1 & Serializable)resourceResult -> resourceResult, m$8);
    }
}

