/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.interpreter;

import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sttp.model.ContentTypeRange;
import sttp.model.ContentTypeRange$;
import sttp.tapir.DecodeResult;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.package$;
import sttp.tapir.server.interpreter.DecodeBasicInputsResult$;
import sttp.tapir.server.interpreter.DecodeBasicInputsResult$Failure$;
import sttp.tapir.server.interpreter.DecodeBasicInputsResult$Values$;

public interface DecodeBasicInputsResult {
    public static Option<Failure> higherPriorityFailure(DecodeBasicInputsResult decodeBasicInputsResult, DecodeBasicInputsResult decodeBasicInputsResult2) {
        return DecodeBasicInputsResult$.MODULE$.higherPriorityFailure(decodeBasicInputsResult, decodeBasicInputsResult2);
    }

    public static int ordinal(DecodeBasicInputsResult decodeBasicInputsResult) {
        return DecodeBasicInputsResult$.MODULE$.ordinal(decodeBasicInputsResult);
    }

    public static class Failure
    implements DecodeBasicInputsResult,
    Product,
    Serializable {
        private final EndpointInput.Basic input;
        private final DecodeResult.Failure failure;

        public static Failure apply(EndpointInput.Basic<?> basic2, DecodeResult.Failure failure) {
            return DecodeBasicInputsResult$Failure$.MODULE$.apply(basic2, failure);
        }

        public static Failure fromProduct(Product product) {
            return DecodeBasicInputsResult$Failure$.MODULE$.fromProduct(product);
        }

        public static Failure unapply(Failure failure) {
            return DecodeBasicInputsResult$Failure$.MODULE$.unapply(failure);
        }

        public Failure(EndpointInput.Basic<?> input, DecodeResult.Failure failure) {
            this.input = input;
            this.failure = failure;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Failure)) return false;
            Failure failure = (Failure)object;
            EndpointInput.Basic<?> basic2 = this.input();
            EndpointInput.Basic<?> basic3 = failure.input();
            if (basic2 == null) {
                if (basic3 != null) {
                    return false;
                }
            } else if (!basic2.equals(basic3)) return false;
            DecodeResult.Failure failure2 = this.failure();
            DecodeResult.Failure failure3 = failure.failure();
            if (failure2 == null) {
                if (failure3 != null) {
                    return false;
                }
            } else if (!failure2.equals(failure3)) return false;
            if (!failure.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Failure;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Failure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "input";
            }
            if (1 == n2) {
                return "failure";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public EndpointInput.Basic<?> input() {
            return this.input;
        }

        public DecodeResult.Failure failure() {
            return this.failure;
        }

        public Failure copy(EndpointInput.Basic<?> input, DecodeResult.Failure failure) {
            return new Failure(input, failure);
        }

        public EndpointInput.Basic<?> copy$default$1() {
            return this.input();
        }

        public DecodeResult.Failure copy$default$2() {
            return this.failure();
        }

        public EndpointInput.Basic<?> _1() {
            return this.input();
        }

        public DecodeResult.Failure _2() {
            return this.failure();
        }
    }

    public static class Values
    implements DecodeBasicInputsResult,
    Product,
    Serializable {
        private final Vector basicInputsValues;
        private final Option bodyInputWithIndex;

        public static Values apply(Vector<Object> vector, Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>> option) {
            return DecodeBasicInputsResult$Values$.MODULE$.apply(vector, option);
        }

        public static Values fromProduct(Product product) {
            return DecodeBasicInputsResult$Values$.MODULE$.fromProduct(product);
        }

        public static Values unapply(Values values) {
            return DecodeBasicInputsResult$Values$.MODULE$.unapply(values);
        }

        public Values(Vector<Object> basicInputsValues, Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>> bodyInputWithIndex) {
            this.basicInputsValues = basicInputsValues;
            this.bodyInputWithIndex = bodyInputWithIndex;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Values)) return false;
            Values values = (Values)object;
            Vector<Object> vector = this.basicInputsValues();
            Vector<Object> vector2 = values.basicInputsValues();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>> option = this.bodyInputWithIndex();
            Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>> option2 = values.bodyInputWithIndex();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!values.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Values;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Values";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "basicInputsValues";
            }
            if (1 == n2) {
                return "bodyInputWithIndex";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Vector<Object> basicInputsValues() {
            return this.basicInputsValues;
        }

        public Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>> bodyInputWithIndex() {
            return this.bodyInputWithIndex;
        }

        private void verifyNoBody(EndpointInput<?> input) {
            if (this.bodyInputWithIndex().isDefined()) {
                throw new IllegalStateException(new StringBuilder(24).append("Double body definition: ").append(input).toString());
            }
        }

        public <O> Values addBodyInput(EndpointIO.Body<?, O> input, int bodyIndex) {
            this.verifyNoBody(input);
            ContentTypeRange contentTypeRange = (ContentTypeRange)Predef$.MODULE$.ArrowAssoc((Object)ContentTypeRange$.MODULE$.AnyRange());
            Some some = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.Left().apply((Object)package$.MODULE$.oneOfBody(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)contentTypeRange, input), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))), (Object)BoxesRunTime.boxToInteger((int)bodyIndex)));
            Vector<Object> vector = this.copy$default$1();
            return this.copy(vector, (Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>>)some);
        }

        public Values addOneOfBodyInput(EndpointIO.OneOfBody<?, ?> input, int bodyIndex) {
            this.verifyNoBody(input);
            Some some = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.Left().apply(input), (Object)BoxesRunTime.boxToInteger((int)bodyIndex)));
            Vector<Object> vector = this.copy$default$1();
            return this.copy(vector, (Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>>)some);
        }

        public Values addStreamingBodyInput(EndpointIO.StreamBodyWrapper<?, ?> input, int bodyIndex) {
            this.verifyNoBody(input);
            Some some = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.Right().apply(input), (Object)BoxesRunTime.boxToInteger((int)bodyIndex)));
            Vector<Object> vector = this.copy$default$1();
            return this.copy(vector, (Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>>)some);
        }

        public Values setBodyInputValue(Object v) {
            Tuple2 tuple2;
            Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>> option = this.bodyInputWithIndex();
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return this.copy((Vector<Object>)this.basicInputsValues().updated(i, v), this.copy$default$2());
            }
            if (None$.MODULE$.equals(option)) {
                return this;
            }
            throw new MatchError(option);
        }

        public Values setBasicInputValue(Object v, int i) {
            return this.copy((Vector<Object>)this.basicInputsValues().updated(i, v), this.copy$default$2());
        }

        public Values copy(Vector<Object> basicInputsValues, Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>> bodyInputWithIndex) {
            return new Values(basicInputsValues, bodyInputWithIndex);
        }

        public Vector<Object> copy$default$1() {
            return this.basicInputsValues();
        }

        public Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>> copy$default$2() {
            return this.bodyInputWithIndex();
        }

        public Vector<Object> _1() {
            return this.basicInputsValues();
        }

        public Option<Tuple2<Either<EndpointIO.OneOfBody<?, ?>, EndpointIO.StreamBodyWrapper<?, ?>>, Object>> _2() {
            return this.bodyInputWithIndex();
        }
    }
}

