/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jdisasm.protocol.zip;

import de.unkrig.commons.nullanalysis.Nullable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Handler
extends URLStreamHandler {
    private static final String SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";

    public static void registerMe() {
    }

    @Override
    protected URLConnection openConnection(@Nullable URL url) {
        assert (url != null);
        return new URLConnection(url){
            @Nullable
            private URL zipContainer;
            @Nullable
            private String entryName;

            @Override
            public void connect() throws IOException {
                if (this.connected) {
                    return;
                }
                String authority = this.url.getAuthority();
                String host = this.url.getHost();
                String path = this.url.getPath();
                int port = this.url.getPort();
                String query = this.url.getQuery();
                String ref = this.url.getRef();
                String userInfo = this.url.getUserInfo();
                if (authority != null) {
                    throw new IllegalArgumentException("'Authority' not allowed in 'zip' scheme");
                }
                if (host.length() > 0) {
                    throw new IllegalArgumentException("'Host' not allowed in 'zip' scheme");
                }
                if (port != -1) {
                    throw new IllegalArgumentException("'Port' not allowed in 'zip' scheme");
                }
                if (query != null) {
                    throw new IllegalArgumentException("'Query' not allowed in 'zip' scheme");
                }
                if (ref != null) {
                    throw new IllegalArgumentException("'Fragment' not allowed in 'zip' scheme");
                }
                if (userInfo != null) {
                    throw new IllegalArgumentException("'User info' not allowed in 'zip' scheme");
                }
                int excl = path.lastIndexOf(33);
                if (excl == -1) {
                    throw new IllegalArgumentException("'!' missing in 'zip' url");
                }
                this.zipContainer = new URL(path.substring(0, excl));
                this.entryName = path.substring(excl + 1);
                this.connected = true;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                ZipEntry ze;
                this.connect();
                URL zipContainer = this.zipContainer;
                String entryName = this.entryName;
                assert (zipContainer != null);
                assert (entryName != null);
                ZipInputStream zis = new ZipInputStream(zipContainer.openStream());
                do {
                    if ((ze = zis.getNextEntry()) != null) continue;
                    try {
                        zis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new FileNotFoundException(zipContainer.toString() + '!' + entryName);
                } while (!ze.getName().equals(entryName));
                return zis;
            }
        };
    }

    static {
        String packagE = Handler.class.getPackage().getName();
        if (!packagE.endsWith(".zip")) {
            throw new ExceptionInInitializerError();
        }
        packagE = packagE.substring(0, packagE.length() - 4);
        String phps = System.getProperty(SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS);
        if (phps == null) {
            System.setProperty(SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS, packagE);
        } else if (!Arrays.asList(phps.split("\\|")).contains(packagE)) {
            System.setProperty(SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS, phps + '|' + packagE);
        }
    }
}

