/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.builder;

import java.util.Collections;
import org.apache.fory.Fory;
import org.apache.fory.builder.BaseObjectCodecBuilder;
import org.apache.fory.builder.CompatibleCodecBuilder;
import org.apache.fory.builder.Generated;
import org.apache.fory.builder.MetaSharedCodecBuilder;
import org.apache.fory.builder.ObjectCodecBuilder;
import org.apache.fory.codegen.CodeGenerator;
import org.apache.fory.codegen.CompileUnit;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.FieldResolver;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.util.ClassLoaderUtils;
import org.apache.fory.util.Preconditions;

public class CodecUtils {
    public static <T> Class<? extends Serializer<T>> loadOrGenObjectCodecClass(Class<T> cls, Fory fory) {
        Preconditions.checkNotNull(fory);
        ObjectCodecBuilder codecBuilder = new ObjectCodecBuilder(cls, fory);
        return CodecUtils.loadOrGenCodecClass(cls, fory, codecBuilder);
    }

    public static <T> Class<? extends Serializer<T>> loadOrGenMetaSharedCodecClass(Fory fory, Class<T> cls, ClassDef classDef) {
        Preconditions.checkNotNull(fory);
        MetaSharedCodecBuilder codecBuilder = new MetaSharedCodecBuilder(TypeRef.of(cls), fory, classDef);
        return CodecUtils.loadOrGenCodecClass(cls, fory, codecBuilder);
    }

    public static <T> Class<? extends Serializer<T>> loadOrGenCompatibleCodecClass(Class<T> cls, Fory fory) {
        FieldResolver resolver = FieldResolver.of(fory, cls, true, false);
        return CodecUtils.loadOrGenCompatibleCodecClass(cls, fory, resolver, Generated.GeneratedSerializer.class);
    }

    public static <T> Class<? extends Serializer<T>> loadOrGenCompatibleCodecClass(Class<T> cls, Fory fory, FieldResolver fieldResolver, Class<?> parentSerializerClass) {
        Preconditions.checkNotNull(fory);
        CompatibleCodecBuilder codecBuilder = new CompatibleCodecBuilder(TypeRef.of(cls), fory, fieldResolver, parentSerializerClass);
        return CodecUtils.loadOrGenCodecClass(cls, fory, codecBuilder);
    }

    static <T> Class<? extends Serializer<T>> loadOrGenCodecClass(Class<T> beanClass, Fory fory, BaseObjectCodecBuilder codecBuilder) {
        ClassLoader beanClassClassLoader;
        CompileUnit compileUnit = new CompileUnit(CodeGenerator.getPackage(beanClass), codecBuilder.codecClassName(beanClass), codecBuilder::genCode);
        ClassLoader classLoader = beanClassClassLoader = beanClass.getClassLoader() == null ? Thread.currentThread().getContextClassLoader() : beanClass.getClassLoader();
        if (beanClassClassLoader == null) {
            beanClassClassLoader = fory.getClass().getClassLoader();
        }
        ClassResolver classResolver = fory.getClassResolver();
        CodeGenerator codeGenerator = CodecUtils.getCodeGenerator(fory, beanClassClassLoader, classResolver);
        ClassLoader classLoader2 = codeGenerator.compile(Collections.singletonList(compileUnit), compileState -> compileState.lock.lock());
        String className = codecBuilder.codecQualifiedClassName(beanClass);
        try {
            return classLoader2.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible because we just compiled class", e);
        }
    }

    private static CodeGenerator getCodeGenerator(Fory fory, ClassLoader beanClassClassLoader, ClassResolver classResolver) {
        CodeGenerator codeGenerator;
        block4: {
            try {
                if (beanClassClassLoader.loadClass(Fory.class.getName()) != Fory.class) {
                    throw new ClassNotFoundException();
                }
                codeGenerator = classResolver.getCodeGenerator(beanClassClassLoader);
                if (codeGenerator == null) {
                    codeGenerator = CodeGenerator.getSharedCodeGenerator(beanClassClassLoader);
                    classResolver.setCodeGenerator(beanClassClassLoader, codeGenerator);
                }
            }
            catch (ClassNotFoundException e) {
                codeGenerator = classResolver.getCodeGenerator(beanClassClassLoader, fory.getClass().getClassLoader());
                ClassLoader[] loaders = new ClassLoader[]{beanClassClassLoader, fory.getClass().getClassLoader()};
                if (codeGenerator != null) break block4;
                codeGenerator = CodeGenerator.getSharedCodeGenerator(ClassLoaderUtils.ForyJarClassLoader.getInstance(), beanClassClassLoader);
                classResolver.setCodeGenerator(loaders, codeGenerator);
            }
        }
        return codeGenerator;
    }
}

