/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Collections {
    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).stream() : StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> ArrayList<T> ofArrayList(T e) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(e);
        return list;
    }

    public static <T> ArrayList<T> ofArrayList(T e1, T e2) {
        ArrayList<T> list = new ArrayList<T>(2);
        list.add(e1);
        list.add(e2);
        return list;
    }

    public static <T> ArrayList<T> ofArrayList(T e1, T e2, T e3) {
        ArrayList<T> list = new ArrayList<T>(3);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        return list;
    }

    public static <T> ArrayList<T> ofArrayList(T e1, T e2, T e3, T e4) {
        ArrayList<T> list = new ArrayList<T>(4);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        return list;
    }

    public static <T> ArrayList<T> ofArrayList(T e1, T e2, T e3, T e4, T e5) {
        ArrayList<T> list = new ArrayList<T>(5);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        return list;
    }

    public static <T> ArrayList<T> ofArrayList(T e1, List<T> items) {
        ArrayList<T> list = new ArrayList<T>(1 + items.size());
        list.add(e1);
        list.addAll(items);
        return list;
    }

    public static <T> ArrayList<T> ofArrayList(T e1, T ... items) {
        ArrayList<T> list = new ArrayList<T>(1 + items.length);
        list.add(e1);
        java.util.Collections.addAll(list, items);
        return list;
    }

    public static <T> ArrayList<T> ofArrayList(T e1, T e2, T ... items) {
        ArrayList<T> list = new ArrayList<T>(2 + items.length);
        list.add(e1);
        list.add(e2);
        java.util.Collections.addAll(list, items);
        return list;
    }

    public static <E> HashSet<E> ofHashSet(E e) {
        HashSet<E> set = new HashSet<E>(1);
        set.add(e);
        return set;
    }

    public static <E> HashSet<E> ofHashSet(E e1, E e2) {
        HashSet<E> set = new HashSet<E>(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    public static <E> HashSet<E> ofHashSet(E e1, E e2, E e3) {
        HashSet<E> set = new HashSet<E>(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    public static <E> HashSet<E> ofHashSet(E e1, E e2, E e3, E e4) {
        HashSet<E> set = new HashSet<E>(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    public static <E> HashSet<E> ofHashSet(E e1, E e2, E e3, E e4, E e5) {
        HashSet<E> set = new HashSet<E>(5);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        return set;
    }

    public static <E> HashSet<E> ofHashSet(E[] elements) {
        HashSet set = new HashSet(elements.length);
        java.util.Collections.addAll(set, elements);
        return set;
    }

    public static <E> boolean hasIntersection(Set<E> set1, Set<E> set2) {
        Set<E> small = set1;
        Set<E> large = set2;
        if (set1.size() > set2.size()) {
            small = set2;
            large = set1;
        }
        for (E e : small) {
            if (!large.contains(e)) continue;
            return true;
        }
        return false;
    }

    public static <K, V> HashMap<K, V> ofHashMap(Object ... kv) {
        if (kv == null || kv.length == 0) {
            throw new IllegalArgumentException("entries got no objects, which aren't pairs");
        }
        if ((kv.length & 1) != 0) {
            throw new IllegalArgumentException(String.format("entries got %d objects, which aren't pairs", kv.length));
        }
        int size = kv.length >> 1;
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        for (int i = 0; i < kv.length; i += 2) {
            map.put(kv[i], kv[i + 1]);
        }
        return map;
    }
}

