/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.meta;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.fory.Fory;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.MemoryUtils;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.meta.Encoders;
import org.apache.fory.meta.MetaString;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.type.DescriptorGrouper;
import org.apache.fory.util.MurmurHash3;

class ClassDefEncoder {
    static final int NUM_CLASS_THRESHOLD = 15;
    static final int BIG_NAME_THRESHOLD = 63;

    ClassDefEncoder() {
    }

    static List<Field> buildFields(Fory fory, Class<?> cls, boolean resolveParent) {
        DescriptorGrouper descriptorGrouper = fory.getClassResolver().createDescriptorGrouper(fory.getClassResolver().getFieldDescriptors(cls, resolveParent), false, Function.identity());
        ArrayList<Field> fields = new ArrayList<Field>();
        descriptorGrouper.getPrimitiveDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getBoxedDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getFinalDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getOtherDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getCollectionDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getMapDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        return fields;
    }

    static List<ClassDef.FieldInfo> buildFieldsInfo(ClassResolver resolver, Class<?> cls) {
        return ClassDefEncoder.buildFieldsInfo((TypeResolver)resolver, ClassDefEncoder.buildFields(resolver.getFory(), cls, true));
    }

    static List<ClassDef.FieldInfo> buildFieldsInfo(TypeResolver resolver, List<Field> fields) {
        ArrayList<ClassDef.FieldInfo> fieldInfos = new ArrayList<ClassDef.FieldInfo>();
        for (Field field : fields) {
            ClassDef.FieldInfo fieldInfo = new ClassDef.FieldInfo(field.getDeclaringClass().getName(), field.getName(), ClassDef.buildFieldType(resolver, field));
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    static ClassDef buildClassDef(ClassResolver classResolver, Class<?> type, List<Field> fields, boolean hasFieldsMeta) {
        return ClassDefEncoder.buildClassDefWithFieldInfos(classResolver, type, ClassDefEncoder.buildFieldsInfo((TypeResolver)classResolver, fields), hasFieldsMeta);
    }

    static ClassDef buildClassDefWithFieldInfos(ClassResolver classResolver, Class<?> type, List<ClassDef.FieldInfo> fieldInfos, boolean hasFieldsMeta) {
        Map<String, List<ClassDef.FieldInfo>> classLayers = ClassDefEncoder.getClassFields(type, fieldInfos);
        fieldInfos = new ArrayList<ClassDef.FieldInfo>(fieldInfos.size());
        classLayers.values().forEach(fieldInfos::addAll);
        MemoryBuffer encodeClassDef = ClassDefEncoder.encodeClassDef(classResolver, type, classLayers, hasFieldsMeta);
        byte[] classDefBytes = encodeClassDef.getBytes(0, encodeClassDef.writerIndex());
        return new ClassDef(Encoders.buildClassSpec(type), fieldInfos, hasFieldsMeta, encodeClassDef.getInt64(0), classDefBytes);
    }

    static MemoryBuffer encodeClassDef(ClassResolver classResolver, Class<?> type, Map<String, List<ClassDef.FieldInfo>> classLayers, boolean hasFieldsMeta) {
        MemoryBuffer classDefBuf = MemoryBuffer.newHeapBuffer(128);
        int numClasses = classLayers.size() - 1;
        if (numClasses >= 15) {
            classDefBuf.writeByte(15);
            classDefBuf.writeVarUint32Small7(numClasses - 15);
        } else {
            classDefBuf.writeByte(numClasses);
        }
        for (Map.Entry<String, List<ClassDef.FieldInfo>> entry : classLayers.entrySet()) {
            String className = entry.getKey();
            Class<?> currentType = ClassDefEncoder.getType(type, className);
            List<ClassDef.FieldInfo> fields = entry.getValue();
            int currentClassHeader = fields.size() << 1;
            if (classResolver.isRegisteredById(currentType)) {
                classDefBuf.writeVarUint32Small7(currentClassHeader |= 1);
                classDefBuf.writeVarUint32Small7(classResolver.getRegisteredClassId(currentType).shortValue());
            } else {
                String typename;
                String ns;
                classDefBuf.writeVarUint32Small7(currentClassHeader);
                if (classResolver.isRegisteredByName(currentType)) {
                    Tuple2<String, String> nameTuple = classResolver.getRegisteredNameTuple(currentType);
                    ns = (String)nameTuple.f0;
                    typename = (String)nameTuple.f1;
                } else {
                    Tuple2<String, String> encoded = Encoders.encodePkgAndClass(currentType);
                    ns = (String)encoded.f0;
                    typename = (String)encoded.f1;
                }
                ClassDefEncoder.writePkgName(classDefBuf, ns);
                ClassDefEncoder.writeTypeName(classDefBuf, typename);
            }
            ClassDefEncoder.writeFieldsInfo(classDefBuf, fields);
        }
        byte[] compressed = classResolver.getFory().getConfig().getMetaCompressor().compress(classDefBuf.getHeapMemory(), 0, classDefBuf.writerIndex());
        boolean isCompressed = false;
        if (compressed.length < classDefBuf.writerIndex()) {
            isCompressed = true;
            classDefBuf = MemoryBuffer.fromByteArray(compressed);
            classDefBuf.writerIndex(compressed.length);
        }
        return ClassDefEncoder.prependHeader(classDefBuf, isCompressed, hasFieldsMeta);
    }

    static MemoryBuffer prependHeader(MemoryBuffer buffer, boolean isCompressed, boolean hasFieldsMeta) {
        int metaSize = buffer.writerIndex();
        long hash = MurmurHash3.murmurhash3_x64_128(buffer.getHeapMemory(), 0, metaSize, 47)[0];
        long header = Math.abs(hash <<= 14);
        if (isCompressed) {
            header |= 0x2000L;
        }
        if (hasFieldsMeta) {
            header |= 0x1000L;
        }
        if (metaSize > 2047) {
            header |= 0x7FFL;
        }
        MemoryBuffer result = MemoryUtils.buffer(metaSize + 8);
        result.writeInt64(header |= (long)metaSize);
        if (metaSize > 2047) {
            result.writeVarUint32(metaSize - 2047);
        }
        result.writeBytes(buffer.getHeapMemory(), 0, metaSize);
        return result;
    }

    private static Class<?> getType(Class<?> cls, String type) {
        Class<?> c = cls;
        while (cls != null) {
            if (type.equals(cls.getName())) {
                return cls;
            }
            cls = cls.getSuperclass();
        }
        throw new IllegalStateException(String.format("Class %s doesn't have %s as super class", c, type));
    }

    static Map<String, List<ClassDef.FieldInfo>> getClassFields(Class<?> type, List<ClassDef.FieldInfo> fieldsInfo) {
        LinkedHashMap<String, List<ClassDef.FieldInfo>> sortedClassFields = new LinkedHashMap<String, List<ClassDef.FieldInfo>>();
        if (fieldsInfo.isEmpty()) {
            sortedClassFields.put(type.getName(), new ArrayList());
            return sortedClassFields;
        }
        Map<String, List<ClassDef.FieldInfo>> classFields = ClassDefEncoder.groupClassFields(fieldsInfo);
        for (Class<?> clz : ReflectionUtils.getAllClasses(type, true)) {
            List<ClassDef.FieldInfo> fieldInfos = classFields.get(clz.getName());
            if (fieldInfos != null) {
                sortedClassFields.put(clz.getName(), fieldInfos);
                continue;
            }
            if (!type.getName().equals(clz.getName())) continue;
            sortedClassFields.put(clz.getName(), new ArrayList());
        }
        classFields = sortedClassFields;
        return classFields;
    }

    static Map<String, List<ClassDef.FieldInfo>> groupClassFields(List<ClassDef.FieldInfo> fieldsInfo) {
        HashMap<String, List<ClassDef.FieldInfo>> classFields = new HashMap<String, List<ClassDef.FieldInfo>>();
        for (ClassDef.FieldInfo fieldInfo : fieldsInfo) {
            String definedClass = fieldInfo.getDefinedClass();
            classFields.computeIfAbsent(definedClass, k -> new ArrayList()).add(fieldInfo);
        }
        return classFields;
    }

    static void writeFieldsInfo(MemoryBuffer buffer, List<ClassDef.FieldInfo> fields) {
        for (ClassDef.FieldInfo fieldInfo : fields) {
            boolean bigSize;
            ClassDef.FieldType fieldType = fieldInfo.getFieldType();
            int header = (fieldType.isMonomorphic() ? 1 : 0) << 2;
            header |= fieldType.trackingRef() ? 1 : 0;
            MetaString metaString = Encoders.encodeFieldName(fieldInfo.getFieldName());
            int encodingFlags = Encoders.fieldNameEncodingsList.indexOf((Object)metaString.getEncoding());
            byte[] encoded = metaString.getBytes();
            int size = encoded.length - 1;
            if (fieldInfo.hasTag()) {
                size = fieldInfo.getTag();
                encodingFlags = 3;
            }
            header |= (byte)(encodingFlags << 3);
            boolean bl = bigSize = size >= 7;
            if (bigSize) {
                buffer.writeByte(header |= 0xE0);
                buffer.writeVarUint32Small7(size - 7);
            } else {
                buffer.writeByte(header |= size << 5);
            }
            if (!fieldInfo.hasTag()) {
                buffer.writeBytes(encoded);
            }
            fieldType.write(buffer, false);
        }
    }

    static void writePkgName(MemoryBuffer buffer, String pkg) {
        MetaString pkgMetaString = Encoders.encodePackage(pkg);
        byte[] encoded = pkgMetaString.getBytes();
        ClassDefEncoder.writeName(buffer, encoded, Encoders.pkgEncodingsList.indexOf((Object)pkgMetaString.getEncoding()));
    }

    static void writeTypeName(MemoryBuffer buffer, String typeName) {
        MetaString metaString = Encoders.encodeTypeName(typeName);
        byte[] encoded = metaString.getBytes();
        ClassDefEncoder.writeName(buffer, encoded, Encoders.typeNameEncodingsList.indexOf((Object)metaString.getEncoding()));
    }

    private static void writeName(MemoryBuffer buffer, byte[] encoded, int encoding) {
        boolean bigSize;
        boolean bl = bigSize = encoded.length >= 63;
        if (bigSize) {
            int header = 0xFC | encoding;
            buffer.writeByte(header);
            buffer.writeVarUint32Small7(encoded.length - 63);
        } else {
            int header = encoded.length << 2 | encoding;
            buffer.writeByte(header);
        }
        buffer.writeBytes(encoded);
    }
}

