/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.lang.reflect.Modifier;
import org.apache.fory.Fory;
import org.apache.fory.builder.CodecUtils;
import org.apache.fory.builder.Generated;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.AbstractObjectSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.util.Preconditions;

public final class CodegenSerializer {
    public static boolean supportCodegenForJavaSerialization(Class<?> cls) {
        try {
            return cls.getEnclosingClass() == null || Modifier.isStatic(cls.getModifiers());
        }
        catch (Throwable t2) {
            throw new RuntimeException(t2);
        }
    }

    public static <T> Class<Serializer<T>> loadCodegenSerializer(Fory fory, Class<T> cls) {
        try {
            return CodecUtils.loadOrGenObjectCodecClass(cls, fory);
        }
        catch (Exception e) {
            String msg = String.format("Create sequential serializer failed, \nclass: %s", cls);
            throw new RuntimeException(msg, e);
        }
    }

    public static <T> Class<Serializer<T>> loadCompatibleCodegenSerializer(Fory fory, Class<T> cls) {
        try {
            return CodecUtils.loadOrGenCompatibleCodecClass(cls, fory);
        }
        catch (Exception e) {
            String msg = String.format("Create compatible serializer failed, \nclass: %s", cls);
            throw new RuntimeException(msg, e);
        }
    }

    public static final class LazyInitBeanSerializer<T>
    extends AbstractObjectSerializer<T> {
        private Serializer<T> serializer;
        private Serializer<T> interpreterSerializer;

        public LazyInitBeanSerializer(Fory fory, Class<T> cls) {
            super(fory, cls);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.getOrCreateGeneratedSerializer().write(buffer, value);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return this.getOrCreateGeneratedSerializer().read(buffer);
        }

        private Serializer<T> getOrCreateGeneratedSerializer() {
            if (this.serializer == null) {
                Serializer jitSerializer = this.fory.getClassResolver().getSerializer(this.type);
                if (jitSerializer instanceof LazyInitBeanSerializer) {
                    if (this.interpreterSerializer != null) {
                        return this.interpreterSerializer;
                    }
                    this.fory.getClassResolver().getClassInfo(this.type).setSerializer(null);
                    if (this.fory.getConfig().isAsyncCompilationEnabled()) {
                        Class<? extends Serializer> sc = this.fory.getClassResolver().getSerializerClass(this.type, false);
                        this.fory.getClassResolver().getClassInfo(this.type).setSerializer(this);
                        this.interpreterSerializer = Serializers.newSerializer(this.fory, this.type, sc);
                        return this.interpreterSerializer;
                    }
                    Class<? extends Serializer> sc = this.fory.getClassResolver().getSerializerClass(this.type);
                    this.fory.getClassResolver().getClassInfo(this.type).setSerializer(this);
                    Preconditions.checkArgument(Generated.GeneratedSerializer.class.isAssignableFrom(sc), "Expect jit serializer but got %s for class %s", sc, this.type);
                    this.serializer = Serializers.newSerializer(this.fory, this.type, sc);
                    this.fory.getClassResolver().setSerializer(this.type, this.serializer);
                    return this.serializer;
                }
                this.serializer = jitSerializer;
            }
            return this.serializer;
        }
    }
}

