/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.io.Externalizable;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import org.apache.fory.Fory;
import org.apache.fory.io.MemoryBufferObjectInput;
import org.apache.fory.io.MemoryBufferObjectOutput;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.serializer.AbstractObjectSerializer;

public class ExternalizableSerializer<T extends Externalizable>
extends AbstractObjectSerializer<T> {
    private final MethodHandle constructor;
    private final MemoryBufferObjectInput objectInput;
    private final MemoryBufferObjectOutput objectOutput;

    public ExternalizableSerializer(Fory fory, Class<T> cls) {
        super(fory, cls);
        this.constructor = ReflectionUtils.getCtrHandle(cls, false);
        this.objectInput = new MemoryBufferObjectInput(fory, null);
        this.objectOutput = new MemoryBufferObjectOutput(fory, null);
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        this.objectOutput.setBuffer(buffer);
        try {
            value.writeExternal(this.objectOutput);
        }
        catch (IOException e) {
            Platform.throwException(e);
        }
    }

    @Override
    public void xwrite(MemoryBuffer buffer, T value) {
        throw new UnsupportedOperationException("Externalizable can only be used in java");
    }

    @Override
    public T read(MemoryBuffer buffer) {
        Externalizable t2;
        if (this.constructor != null) {
            try {
                t2 = this.constructor.invoke();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else {
            t2 = (Externalizable)Platform.newInstance(this.type);
        }
        this.objectInput.setBuffer(buffer);
        try {
            t2.readExternal(this.objectInput);
        }
        catch (IOException | ClassNotFoundException e) {
            Platform.throwException(e);
        }
        return (T)t2;
    }
}

