/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.scala;

import java.util.Collection;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.collection.AbstractCollectionSerializer;
import org.apache.fory.serializer.scala.JavaCollectionBuilder;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.mutable.Builder;

public abstract class AbstractScalaCollectionSerializer<A, T extends Iterable<A>>
extends AbstractCollectionSerializer<T> {
    private final Fory fory;

    public AbstractScalaCollectionSerializer(Fory fory, Class<T> cls) {
        this.fory = fory;
        super(fory, cls);
    }

    @Override
    public abstract Collection<?> onCollectionWrite(MemoryBuffer var1, T var2);

    @Override
    public T read(MemoryBuffer buffer) {
        Collection<?> collection = this.newCollection(buffer);
        int numElements = this.getAndClearNumElements();
        if (numElements != 0) {
            this.readElements(this.fory, buffer, collection, numElements);
        }
        return this.onCollectionRead(collection);
    }

    @Override
    public Collection<?> newCollection(MemoryBuffer buffer) {
        int numElements = buffer.readVarUint32();
        this.setNumElements(numElements);
        Factory factory = (Factory)this.fory.readRef(buffer);
        Builder builder = factory.newBuilder();
        builder.sizeHint(numElements);
        return new JavaCollectionBuilder(builder);
    }

    @Override
    public T onCollectionRead(Collection<?> collection) {
        return (T)((Iterable)((JavaCollectionBuilder)collection).builder().result());
    }
}

