/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.scala;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.apache.fory.Fory;
import org.apache.fory.serializer.JavaSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.SerializerFactory;
import org.apache.fory.serializer.scala.ScalaCollectionSerializer;
import org.apache.fory.serializer.scala.ScalaMapSerializer;
import org.apache.fory.serializer.scala.ScalaSeqSerializer;
import org.apache.fory.serializer.scala.ScalaSortedMapSerializer;
import org.apache.fory.serializer.scala.ScalaSortedSetSerializer;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SortedMap;
import scala.collection.SortedSet;
import scala.collection.generic.DefaultSerializable;

public class ScalaDispatcher
implements SerializerFactory {
    @Override
    public Serializer createSerializer(Fory fory, Class<?> clazz) {
        if (SortedMap.class.isAssignableFrom(clazz)) {
            return new ScalaSortedMapSerializer(fory, clazz);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new ScalaMapSerializer(fory, clazz);
        }
        if (SortedSet.class.isAssignableFrom(clazz)) {
            return new ScalaSortedSetSerializer(fory, clazz);
        }
        if (Seq.class.isAssignableFrom(clazz)) {
            return new ScalaSeqSerializer(fory, clazz);
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return new ScalaCollectionSerializer(fory, clazz);
        }
        if (DefaultSerializable.class.isAssignableFrom(clazz)) {
            Method method = JavaSerializer.getWriteReplaceMethod(clazz);
            Preconditions.checkNotNull((Object)method);
            return new ScalaCollectionSerializer(fory, clazz);
        }
        return null;
    }
}

