/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.scala;

import org.apache.fory.AbstractThreadSafeFory;
import org.apache.fory.Fory;
import org.apache.fory.ThreadSafeFory;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.SerializerFactory;
import org.apache.fory.serializer.scala.NumericRangeSerializer;
import org.apache.fory.serializer.scala.RangeSerializer;
import org.apache.fory.serializer.scala.ScalaDispatcher;
import org.apache.fory.serializer.scala.ToFactorySerializers;
import scala.collection.generic.DefaultSerializationProxy;
import scala.collection.generic.SerializeEnd$;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.IntMap;
import scala.collection.immutable.IntMap$;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.LazyList$;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.LongMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.collection.immutable.TreeSeqMap;
import scala.collection.immutable.TreeSeqMap$;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.ArrayDeque$;
import scala.collection.mutable.ArraySeq$;
import scala.collection.mutable.BitSet;
import scala.collection.mutable.BitSet$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.TreeSet$;
import scala.runtime.ModuleSerializationProxy;

public class ScalaSerializers {
    public static void registerSerializers(ThreadSafeFory threadSafeFory) {
        AbstractThreadSafeFory abstractThreadSafeFory = (AbstractThreadSafeFory)threadSafeFory;
        abstractThreadSafeFory.registerCallback(ScalaSerializers::registerSerializers);
    }

    public static void registerSerializers(Fory fory) {
        ClassResolver classResolver = ScalaSerializers.setSerializerFactory(fory);
        classResolver.registerSerializer(ToFactorySerializers.IterableToFactoryClass, new ToFactorySerializers.IterableToFactorySerializer(fory));
        classResolver.registerSerializer(ToFactorySerializers.MapToFactoryClass, new ToFactorySerializers.MapToFactorySerializer(fory));
        classResolver.register((Class<?>)Seq.class);
        classResolver.register((Class<?>)Nil$.class);
        classResolver.register((Class<?>)List$.class);
        classResolver.register((Class<?>).colon.colon.class);
        classResolver.register((Class<?>)Vector$.class);
        classResolver.register("scala.collection.immutable.VectorImpl");
        classResolver.register("scala.collection.immutable.Vector0");
        classResolver.register("scala.collection.immutable.Vector1");
        classResolver.register("scala.collection.immutable.Vector2");
        classResolver.register("scala.collection.immutable.Vector3");
        classResolver.register("scala.collection.immutable.Vector4");
        classResolver.register("scala.collection.immutable.Vector5");
        classResolver.register("scala.collection.immutable.Vector6");
        classResolver.register((Class<?>)Queue.class);
        classResolver.register((Class<?>)scala.collection.immutable.Queue$.class);
        classResolver.register((Class<?>)LazyList.class);
        classResolver.register((Class<?>)LazyList$.class);
        classResolver.register((Class<?>)ArraySeq.class);
        classResolver.register((Class<?>)scala.collection.immutable.ArraySeq$.class);
        classResolver.register((Class<?>)Set.class);
        classResolver.register((Class<?>)Set$.class);
        classResolver.register((Class<?>)Set.Set1.class);
        classResolver.register((Class<?>)Set.Set2.class);
        classResolver.register((Class<?>)Set.Set3.class);
        classResolver.register((Class<?>)Set.Set4.class);
        classResolver.register((Class<?>)scala.collection.immutable.HashSet.class);
        classResolver.register((Class<?>)TreeSet.class);
        classResolver.register((Class<?>)scala.collection.immutable.TreeSet$.class);
        classResolver.register((Class<?>)scala.collection.immutable.HashSet$.class);
        classResolver.register((Class<?>)ListSet.class);
        classResolver.register((Class<?>)ListSet$.class);
        classResolver.register("scala.collection.immutable.Set$EmptySet$");
        classResolver.register("scala.collection.immutable.SetBuilderImpl");
        classResolver.register("scala.collection.immutable.SortedMapOps$ImmutableKeySortedSet");
        classResolver.register((Class<?>)Map.class);
        classResolver.register((Class<?>)Map$.class);
        classResolver.register((Class<?>)Map.Map1.class);
        classResolver.register((Class<?>)Map.Map2.class);
        classResolver.register((Class<?>)Map.Map3.class);
        classResolver.register((Class<?>)Map.Map4.class);
        classResolver.register((Class<?>)Map.WithDefault.class);
        classResolver.register("scala.collection.immutable.MapBuilderImpl");
        classResolver.register("scala.collection.immutable.Map$EmptyMap$");
        classResolver.register("scala.collection.immutable.SeqMap$EmptySeqMap$");
        classResolver.register((Class<?>)HashMap.class);
        classResolver.register((Class<?>)scala.collection.immutable.HashMap$.class);
        classResolver.register((Class<?>)TreeMap.class);
        classResolver.register((Class<?>)TreeMap$.class);
        classResolver.register((Class<?>)SortedMap$.class);
        classResolver.register((Class<?>)TreeSeqMap.class);
        classResolver.register((Class<?>)TreeSeqMap$.class);
        classResolver.register((Class<?>)ListMap.class);
        classResolver.register((Class<?>)ListMap$.class);
        classResolver.register((Class<?>)IntMap.class);
        classResolver.register((Class<?>)IntMap$.class);
        classResolver.register((Class<?>)LongMap.class);
        classResolver.register((Class<?>)scala.collection.immutable.LongMap$.class);
        classResolver.register("scala.math.Numeric$IntIsIntegral$");
        classResolver.register("scala.math.Numeric$LongIsIntegral$");
        classResolver.registerSerializer(Range.Inclusive.class, new RangeSerializer<Range.Inclusive>(fory, Range.Inclusive.class));
        classResolver.registerSerializer(Range.Exclusive.class, new RangeSerializer<Range.Exclusive>(fory, Range.Exclusive.class));
        classResolver.registerSerializer(NumericRange.class, new NumericRangeSerializer(fory, NumericRange.class));
        classResolver.registerSerializer(NumericRange.Exclusive.class, new NumericRangeSerializer(fory, NumericRange.Exclusive.class));
        classResolver.registerSerializer(NumericRange.Inclusive.class, new NumericRangeSerializer(fory, NumericRange.Inclusive.class));
        classResolver.register((Class<?>)SerializeEnd$.class);
        classResolver.register((Class<?>)DefaultSerializationProxy.class);
        classResolver.register((Class<?>)ModuleSerializationProxy.class);
        classResolver.register((Class<?>)StringBuilder.class);
        classResolver.register((Class<?>)ArrayBuffer.class);
        classResolver.register((Class<?>)ArrayBuffer$.class);
        classResolver.register((Class<?>)scala.collection.mutable.ArraySeq.class);
        classResolver.register((Class<?>)ArraySeq$.class);
        classResolver.register((Class<?>)ListBuffer.class);
        classResolver.register((Class<?>)ListBuffer$.class);
        classResolver.register((Class<?>)Buffer$.class);
        classResolver.register((Class<?>)ArrayDeque.class);
        classResolver.register((Class<?>)ArrayDeque$.class);
        classResolver.register((Class<?>)HashSet.class);
        classResolver.register((Class<?>)HashSet$.class);
        classResolver.register((Class<?>)scala.collection.mutable.TreeSet.class);
        classResolver.register((Class<?>)TreeSet$.class);
        classResolver.register((Class<?>)scala.collection.mutable.HashMap.class);
        classResolver.register((Class<?>)HashMap$.class);
        classResolver.register((Class<?>)scala.collection.mutable.TreeMap.class);
        classResolver.register((Class<?>)scala.collection.mutable.TreeMap$.class);
        classResolver.register((Class<?>)LinkedHashMap.class);
        classResolver.register((Class<?>)LinkedHashMap$.class);
        classResolver.register((Class<?>)LinkedHashSet.class);
        classResolver.register((Class<?>)LinkedHashSet$.class);
        classResolver.register((Class<?>)scala.collection.mutable.LongMap.class);
        classResolver.register((Class<?>)LongMap$.class);
        classResolver.register((Class<?>)scala.collection.mutable.Queue.class);
        classResolver.register((Class<?>)Queue$.class);
        classResolver.register((Class<?>)Stack.class);
        classResolver.register((Class<?>)Stack$.class);
        classResolver.register((Class<?>)BitSet.class);
        classResolver.register((Class<?>)BitSet$.class);
    }

    private static ClassResolver setSerializerFactory(Fory fory2) {
        ClassResolver classResolver = fory2.getClassResolver();
        ScalaDispatcher scalaDispatcher = new ScalaDispatcher();
        SerializerFactory serializerFactory = classResolver.getSerializerFactory();
        if (serializerFactory != null) {
            SerializerFactory serializerFactory2 = (fory, clazz) -> {
                Serializer serializer = serializerFactory.createSerializer(fory, clazz);
                if (serializer == null) {
                    serializer = scalaDispatcher.createSerializer(fory, clazz);
                }
                return serializer;
            };
            classResolver.setSerializerFactory(serializerFactory2);
        } else {
            classResolver.setSerializerFactory(scalaDispatcher);
        }
        return classResolver;
    }
}

