/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.scala;

import java.lang.reflect.Field;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.serializer.Serializer;

public class ToFactorySerializers {
    static final Class<?> IterableToFactoryClass = ReflectionUtils.loadClass("scala.collection.IterableFactory$ToFactory");
    static final Class<?> MapToFactoryClass = ReflectionUtils.loadClass("scala.collection.MapFactory$ToFactory");

    public static class MapToFactorySerializer
    extends Serializer {
        private static final long fieldOffset;

        public MapToFactorySerializer(Fory fory) {
            super(fory, MapToFactoryClass);
        }

        public void write(MemoryBuffer memoryBuffer, Object object) {
            this.fory.writeRef(memoryBuffer, Platform.getObject(object, fieldOffset));
        }

        public Object read(MemoryBuffer memoryBuffer) {
            Object t2 = Platform.newInstance(this.type);
            Platform.putObject(t2, fieldOffset, this.fory.readRef(memoryBuffer));
            return t2;
        }

        static {
            try {
                Field field = Class.forName("scala.collection.MapFactory$ToFactory").getDeclaredField("factory");
                fieldOffset = Platform.objectFieldOffset(field);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static class IterableToFactorySerializer
    extends Serializer {
        private static final long fieldOffset;

        public IterableToFactorySerializer(Fory fory) {
            super(fory, IterableToFactoryClass);
        }

        public void write(MemoryBuffer memoryBuffer, Object object) {
            this.fory.writeRef(memoryBuffer, Platform.getObject(object, fieldOffset));
        }

        public Object read(MemoryBuffer memoryBuffer) {
            Object t2 = Platform.newInstance(this.type);
            Platform.putObject(t2, fieldOffset, this.fory.readRef(memoryBuffer));
            return t2;
        }

        static {
            try {
                Field field = Class.forName("scala.collection.IterableFactory$ToFactory").getDeclaredField("factory");
                fieldOffset = Platform.objectFieldOffset(field);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

