/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.type;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.type.TypeUtils;

public class GenericType {
    private static final Predicate<Type> defaultFinalPredicate = type -> {
        if (type.getClass() == Class.class) {
            return ReflectionUtils.isMonomorphic((Class)type);
        }
        return ReflectionUtils.isMonomorphic(TypeUtils.getRawType(type));
    };
    final TypeRef<?> typeRef;
    final Class<?> cls;
    final GenericType[] typeParameters;
    final int typeParametersCount;
    final GenericType typeParameter0;
    final GenericType typeParameter1;
    final boolean hasGenericParameters;
    final boolean isMonomorphic;
    Serializer<?> serializer;
    private Boolean trackingRef;

    public GenericType(TypeRef<?> typeRef, boolean isMonomorphic, GenericType ... typeParameters) {
        this.typeRef = typeRef;
        this.cls = TypeUtils.getRawType(typeRef);
        this.typeParameters = typeParameters;
        this.typeParametersCount = typeParameters.length;
        this.hasGenericParameters = typeParameters.length > 0;
        this.isMonomorphic = isMonomorphic;
        this.typeParameter0 = typeParameters.length > 0 ? typeParameters[0] : null;
        this.typeParameter1 = typeParameters.length > 1 ? typeParameters[1] : null;
    }

    public static GenericType build(TypeRef<?> type) {
        return GenericType.build(type.getType());
    }

    public static GenericType build(Type type) {
        return GenericType.build(type, defaultFinalPredicate);
    }

    public static GenericType build(TypeRef<?> context, Type type) {
        return GenericType.build(context, type, defaultFinalPredicate);
    }

    public static GenericType build(Class<?> context, Type type) {
        return GenericType.build(context, type, defaultFinalPredicate);
    }

    public static GenericType build(Class<?> context, Type type, Predicate<Type> finalPredicate) {
        return GenericType.build(TypeRef.of(context), type, finalPredicate);
    }

    public static GenericType build(TypeRef<?> context, Type type, Predicate<Type> finalPredicate) {
        return GenericType.build(context.resolveType(type), finalPredicate);
    }

    public static GenericType build(Type type, Predicate<Type> finalPredicate) {
        return GenericType.build(TypeRef.of(type), finalPredicate);
    }

    public static GenericType build(TypeRef<?> typeRef, Predicate<Type> finalPredicate) {
        Type type = typeRef.getType();
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            ArrayList<GenericType> list = new ArrayList<GenericType>();
            for (Type t2 : actualTypeArguments) {
                GenericType build = GenericType.build(t2, finalPredicate);
                list.add(build);
            }
            GenericType[] genericTypes = list.toArray(new GenericType[0]);
            return new GenericType(typeRef, finalPredicate.test(type), genericTypes);
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return new GenericType(typeRef, finalPredicate.test(type), GenericType.build(componentType));
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type typeVariableBound = typeVariable.getBounds()[0];
            return new GenericType(TypeRef.of(typeVariableBound), finalPredicate.test(type), new GenericType[0]);
        }
        if (type instanceof WildcardType) {
            Type upperBound = ((WildcardType)type).getUpperBounds()[0];
            if (upperBound instanceof ParameterizedType) {
                return GenericType.build(upperBound);
            }
            return new GenericType(TypeRef.of(upperBound), finalPredicate.test(type), new GenericType[0]);
        }
        return new GenericType(typeRef, finalPredicate.test(type), new GenericType[0]);
    }

    public TypeRef<?> getTypeRef() {
        return this.typeRef;
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public GenericType[] getTypeParameters() {
        return this.typeParameters;
    }

    public int getTypeParametersCount() {
        return this.typeParametersCount;
    }

    public GenericType getTypeParameter0() {
        return this.typeParameter0;
    }

    public GenericType getTypeParameter1() {
        return this.typeParameter1;
    }

    public void setSerializer(Serializer<?> serializer) {
        this.serializer = serializer;
    }

    public Serializer<?> getSerializer(TypeResolver classResolver) {
        Serializer<?> serializer = this.serializer;
        if (serializer == null) {
            this.serializer = serializer = classResolver.getSerializer(this.cls);
        }
        return serializer;
    }

    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    public boolean isMonomorphic() {
        return this.isMonomorphic;
    }

    public boolean trackingRef(TypeResolver classResolver) {
        Boolean trackingRef = this.trackingRef;
        if (trackingRef == null) {
            trackingRef = this.trackingRef = Boolean.valueOf(classResolver.needToWriteRef(this.typeRef));
        }
        return trackingRef;
    }

    public boolean hasGenericParameters() {
        return this.hasGenericParameters;
    }

    public String toString() {
        return "GenericType{" + this.typeRef.toString() + '}';
    }
}

