// Generated by delombok at Fri Apr 19 18:23:12 UTC 2024
package org.matomo.java.tracking;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import lombok.NonNull;

final class BulkRequest {
  @NonNull
  private final Collection<String> queries;
  @Nullable
  private final String authToken;

  byte[] toBytes() {
    if (queries.isEmpty()) {
      throw new IllegalArgumentException("Queries must not be empty");
    }
    StringBuilder payload = new StringBuilder("{\"requests\":[");
    Iterator<String> iterator = queries.iterator();
    while (iterator.hasNext()) {
      String query = iterator.next();
      payload.append("\"?").append(query).append('\"');
      if (iterator.hasNext()) {
        payload.append(',');
      }
    }
    payload.append(']');
    if (authToken != null) {
      payload.append(",\"token_auth\":\"").append(authToken).append('\"');
    }
    return payload.append('}').toString().getBytes(StandardCharsets.UTF_8);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  BulkRequest(@NonNull final Collection<String> queries, @Nullable final String authToken) {
    if (queries == null) {
      throw new java.lang.NullPointerException("queries is marked non-null but is null");
    }
    this.queries = queries;
    this.authToken = authToken;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class BulkRequestBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Collection<String> queries;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String authToken;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    BulkRequestBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BulkRequest.BulkRequestBuilder queries(@NonNull final Collection<String> queries) {
      if (queries == null) {
        throw new java.lang.NullPointerException("queries is marked non-null but is null");
      }
      this.queries = queries;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BulkRequest.BulkRequestBuilder authToken(@Nullable final String authToken) {
      this.authToken = authToken;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BulkRequest build() {
      return new BulkRequest(this.queries, this.authToken);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "BulkRequest.BulkRequestBuilder(queries=" + this.queries + ", authToken=" + this.authToken + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static BulkRequest.BulkRequestBuilder builder() {
    return new BulkRequest.BulkRequestBuilder();
  }

  @NonNull
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Collection<String> getQueries() {
    return this.queries;
  }

  @Nullable
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAuthToken() {
    return this.authToken;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof BulkRequest)) return false;
    final BulkRequest other = (BulkRequest) o;
    final java.lang.Object this$queries = this.getQueries();
    final java.lang.Object other$queries = other.getQueries();
    if (this$queries == null ? other$queries != null : !this$queries.equals(other$queries)) return false;
    final java.lang.Object this$authToken = this.getAuthToken();
    final java.lang.Object other$authToken = other.getAuthToken();
    if (this$authToken == null ? other$authToken != null : !this$authToken.equals(other$authToken)) return false;
    return true;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $queries = this.getQueries();
    result = result * PRIME + ($queries == null ? 43 : $queries.hashCode());
    final java.lang.Object $authToken = this.getAuthToken();
    result = result * PRIME + ($authToken == null ? 43 : $authToken.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "BulkRequest(queries=" + this.getQueries() + ", authToken=" + this.getAuthToken() + ")";
  }
}
