// Generated by delombok at Fri Apr 19 18:23:12 UTC 2024
/*
 * Matomo Java Tracker
 *
 * @link https://github.com/matomo/matomo-java-tracker
 * @license https://github.com/matomo/matomo-java-tracker/blob/master/LICENSE BSD-3 Clause
 */
package org.matomo.java.tracking;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Builder.Default;
import lombok.NonNull;
import lombok.experimental.Tolerate;
import org.matomo.java.tracking.parameters.AcceptLanguage;
import org.matomo.java.tracking.parameters.Country;
import org.matomo.java.tracking.parameters.CustomVariable;
import org.matomo.java.tracking.parameters.CustomVariables;
import org.matomo.java.tracking.parameters.DeviceResolution;
import org.matomo.java.tracking.parameters.EcommerceItem;
import org.matomo.java.tracking.parameters.EcommerceItems;
import org.matomo.java.tracking.parameters.RandomValue;
import org.matomo.java.tracking.parameters.UniqueId;
import org.matomo.java.tracking.parameters.VisitorId;

/**
 * A class that implements the <a href="https://developer.matomo.org/api-reference/tracking-api">
 * Matomo Tracking HTTP API</a>. These requests can be sent using {@link MatomoTracker}.
 *
 * @author brettcsorba
 */
public class MatomoRequest {
  /**
   * The ID of the website we're tracking a visit/action for. Only needed, if no default site id is
   * configured.
   */
  @TrackingParameter(name = "rec")
  private Boolean required;
  /**
   * The ID of the website we're tracking a visit/action for. Only needed, if no default site id is
   * configured.
   */
  @TrackingParameter(name = "idsite", min = 1)
  private Integer siteId;
  /**
   * The title of the action being tracked. For page tracks this is used as page title. If enabled
   * in your installation you may use the category tree structure in this field. For example, "game
   * / register new user" would then create a group "game" and add the item "register new user" in
   * it.
   */
  @TrackingParameter(name = "action_name")
  private String actionName;
  /**
   * The full URL for the current action.
   */
  @TrackingParameter(name = "url")
  private String actionUrl;
  /**
   * Defines the API version to use (default: 1).
   */
  @TrackingParameter(name = "apiv")
  private String apiVersion;
  /**
   * The unique visitor ID. See {@link VisitorId}. Default is {@link VisitorId#random()}
   *
   * <p>Since version 3.0.0 this parameter is of type {@link VisitorId} and not a String anymore.
   * Use {@link VisitorId#fromHex(String)} to create a VisitorId from a hex string,
   * {@link VisitorId#fromUUID(UUID)} to create it from a UUID or {@link VisitorId#fromHash(long)}
   * to create it from a long value.
   */
  @TrackingParameter(name = "_id")
  private VisitorId visitorId;
  /**
   * Tracks if the visitor is a returning visitor.
   *
   * <p>This is done by storing a visitor ID in a 1st party cookie.
   */
  @TrackingParameter(name = "_idn")
  private Boolean newVisitor;
  /**
   * The full HTTP Referrer URL. This value is used to determine how someone got to your website
   * (ie, through a website, search engine or campaign)
   */
  @TrackingParameter(name = "urlref")
  private String referrerUrl;
  /**
   * Custom variables are custom name-value pairs that you can assign to your visitors (or page
   * views).
   */
  @TrackingParameter(name = "_cvar")
  private CustomVariables visitCustomVariables;
  /**
   * The current count of visits for this visitor. To set this value correctly, it would be required
   * to store the value for each visitor in your application (using sessions or persisting in a
   * database). Then you would manually increment the counts by one on each new visit or "session",
   * depending on how you choose to define a visit.
   */
  @TrackingParameter(name = "_idvc", min = 0)
  private Integer visitorVisitCount;
  /**
   * The UNIX timestamp of this visitor's previous visit. This parameter is used to populate the
   * report Visitors > Engagement > Visits by days since last visit.
   */
  @TrackingParameter(name = "_viewts")
  private Instant visitorPreviousVisitTimestamp;
  /**
   * The UNIX timestamp of this visitor's first visit. This could be set to the date where the user
   * first started using your software/app, or when he/she created an account.
   */
  @TrackingParameter(name = "_idts")
  private Instant visitorFirstVisitTimestamp;
  /**
   * The campaign name. This parameter will only be used for the first pageview of a visit.
   */
  @TrackingParameter(name = "_rcn")
  private String campaignName;
  /**
   * The campaign keyword (see
   * <a href="https://matomo.org/docs/tracking-campaigns/">Tracking Campaigns</a>). Used to
   * populate the <em>Referrers &gt; Campaigns</em> report (clicking on a campaign loads all
   * keywords for this campaign). This parameter will only be used for the first pageview of a
   * visit.
   */
  @TrackingParameter(name = "_rck")
  private String campaignKeyword;
  /**
   * The resolution of the device the visitor is using.
   */
  @TrackingParameter(name = "res")
  private DeviceResolution deviceResolution;
  /**
   * The current hour (local time).
   */
  @TrackingParameter(name = "h", min = 0, max = 23)
  private Integer currentHour;
  /**
   * The current minute (local time).
   */
  @TrackingParameter(name = "m", min = 0, max = 59)
  private Integer currentMinute;
  /**
   * The current second (local time).
   */
  @TrackingParameter(name = "s", min = 0, max = 59)
  private Integer currentSecond;
  /**
   * Does the visitor use the Adobe Flash Plugin.
   */
  @TrackingParameter(name = "fla")
  private Boolean pluginFlash;
  /**
   * Does the visitor use the Java plugin.
   */
  @TrackingParameter(name = "java")
  private Boolean pluginJava;
  /**
   * Does the visitor use Director plugin.
   */
  @TrackingParameter(name = "dir")
  private Boolean pluginDirector;
  /**
   * Does the visitor use Quicktime plugin.
   */
  @TrackingParameter(name = "qt")
  private Boolean pluginQuicktime;
  /**
   * Does the visitor use Realplayer plugin.
   */
  @TrackingParameter(name = "realp")
  private Boolean pluginRealPlayer;
  /**
   * Does the visitor use a PDF plugin.
   */
  @TrackingParameter(name = "pdf")
  private Boolean pluginPDF;
  /**
   * Does the visitor use a Windows Media plugin.
   */
  @TrackingParameter(name = "wma")
  private Boolean pluginWindowsMedia;
  /**
   * Does the visitor use a Gears plugin.
   */
  @TrackingParameter(name = "gears")
  private Boolean pluginGears;
  /**
   * Does the visitor use a Silverlight plugin.
   */
  @TrackingParameter(name = "ag")
  private Boolean pluginSilverlight;
  /**
   * Does the visitor's client is known to support cookies.
   */
  @TrackingParameter(name = "cookie")
  private Boolean supportsCookies;
  /**
   * An override value for the User-Agent HTTP header field.
   */
  @TrackingParameter(name = "ua")
  private String headerUserAgent;
  /**
   * An override value for the Accept-Language HTTP header field. This value is used to detect the
   * visitor's country if GeoIP is not enabled.
   */
  @TrackingParameter(name = "lang")
  private AcceptLanguage headerAcceptLanguage;
  /**
   * Defines the User ID for this request. User ID is any non-empty unique string identifying the
   * user (such as an email address or a username). When specified, the User ID will be "enforced".
   * This means that if there is no recent visit with this User ID, a new one will be created. If a
   * visit is found in the last 30 minutes with your specified User ID, then the new action will be
   * recorded to this existing visit.
   */
  @TrackingParameter(name = "uid")
  private String userId;
  /**
   * defines the visitor ID for this request.
   */
  @TrackingParameter(name = "cid")
  private VisitorId visitorCustomId;
  /**
   * will force a new visit to be created for this action.
   */
  @TrackingParameter(name = "new_visit")
  private Boolean newVisit;
  /**
   * Custom variables are custom name-value pairs that you can assign to your visitors (or page
   * views).
   */
  @TrackingParameter(name = "cvar")
  private CustomVariables pageCustomVariables;
  /**
   * An external URL the user has opened. Used for tracking outlink clicks. We recommend to also set
   * the url parameter to this same value.
   */
  @TrackingParameter(name = "link")
  private String outlinkUrl;
  /**
   * URL of a file the user has downloaded. Used for tracking downloads. We recommend to also set
   * the url parameter to this same value.
   */
  @TrackingParameter(name = "download")
  private String downloadUrl;
  /**
   * The Site Search keyword. When specified, the request will not be tracked as a normal pageview
   * but will instead be tracked as a Site Search request
   */
  @TrackingParameter(name = "search")
  private String searchQuery;
  /**
   * When search is specified, you can optionally specify a search category with this parameter.
   */
  @TrackingParameter(name = "search_cat")
  private String searchCategory;
  /**
   * When search is specified, we also recommend setting the search_count to the number of search
   * results displayed on the results page. When keywords are tracked with &search_count=0 they will
   * appear in the "No Result Search Keyword" report.
   */
  @TrackingParameter(name = "search_count", min = 0)
  private Long searchResultsCount;
  /**
   * Accepts a six character unique ID that identifies which actions were performed on a specific
   * page view. When a page was viewed, all following tracking requests (such as events) during that
   * page view should use the same pageview ID. Once another page was viewed a new unique ID should
   * be generated. Use [0-9a-Z] as possible characters for the unique ID.
   */
  @TrackingParameter(name = "pv_id")
  private UniqueId pageViewId;
  /**
   * If specified, the tracking request will trigger a conversion for the goal of the website being
   * tracked with this ID. The value 0 tracks an ecommerce interaction.
   */
  @TrackingParameter(name = "idgoal", min = 0)
  private Integer goalId;
  /**
   * The grand total for the ecommerce order (required when tracking an ecommerce order).
   */
  @TrackingParameter(name = "revenue")
  private Double ecommerceRevenue;
  /**
   * The charset of the page being tracked. Specify the charset if the data you send to Matomo is
   * encoded in a different character set than the default utf-8
   */
  @TrackingParameter(name = "cs")
  private Charset characterSet;
  /**
   * can be optionally sent along any tracking request that isn't a page view. For example, it can
   * be sent together with an event tracking request. The advantage being that should you ever
   * disable the event plugin, then the event tracking requests will be ignored vs if the parameter
   * is not set, a page view would be tracked even though it isn't a page view.
   */
  @TrackingParameter(name = "ca")
  private Boolean customAction;
  /**
   * How long it took to connect to server.
   */
  @TrackingParameter(name = "pf_net", min = 0)
  private Long networkTime;
  /**
   * How long it took the server to generate page.
   */
  @TrackingParameter(name = "pf_srv", min = 0)
  private Long serverTime;
  /**
   * How long it takes the browser to download the response from the server.
   */
  @TrackingParameter(name = "pf_tfr", min = 0)
  private Long transferTime;
  /**
   * How long the browser spends loading the webpage after the response was fully received until the
   * user can start interacting with it.
   */
  @TrackingParameter(name = "pf_dm1", min = 0)
  private Long domProcessingTime;
  /**
   * How long it takes for the browser to load media and execute any Javascript code listening for
   * the DOMContentLoaded event.
   */
  @TrackingParameter(name = "pf_dm2", min = 0)
  private Long domCompletionTime;
  /**
   * How long it takes the browser to execute Javascript code waiting for the window.load event.
   */
  @TrackingParameter(name = "pf_onl", min = 0)
  private Long onloadTime;
  /**
   * eg. Videos, Music, Games...
   */
  @TrackingParameter(name = "e_c")
  private String eventCategory;
  /**
   * An event action like Play, Pause, Duration, Add Playlist, Downloaded, Clicked...
   */
  @TrackingParameter(name = "e_a")
  private String eventAction;
  /**
   * The event name for example a Movie name, or Song name, or File name...
   */
  @TrackingParameter(name = "e_n")
  private String eventName;
  /**
   * Some numeric value that represents the event value.
   */
  @TrackingParameter(name = "e_v")
  private Double eventValue;
  /**
   * The name of the content. For instance 'Ad Foo Bar'
   */
  @TrackingParameter(name = "c_n")
  private String contentName;
  /**
   * The actual content piece. For instance the path to an image, video, audio, any text
   */
  @TrackingParameter(name = "c_p")
  private String contentPiece;
  /**
   * The target of the content. For instance the URL of a landing page
   */
  @TrackingParameter(name = "c_t")
  private String contentTarget;
  /**
   * The name of the interaction with the content. For instance a 'click'
   */
  @TrackingParameter(name = "c_i")
  private String contentInteraction;
  /**
   * The unique string identifier for the ecommerce order (required when tracking an ecommerce
   * order).
   */
  @TrackingParameter(name = "ec_id")
  private String ecommerceId;
  /**
   * Items in the Ecommerce order.
   */
  @TrackingParameter(name = "ec_items")
  private EcommerceItems ecommerceItems;
  /**
   * The subtotal of the order; excludes shipping.
   */
  @TrackingParameter(name = "ec_st")
  private Double ecommerceSubtotal;
  /**
   * Tax amount of the order.
   */
  @TrackingParameter(name = "ec_tx")
  private Double ecommerceTax;
  /**
   * Shipping cost of the order.
   */
  @TrackingParameter(name = "ec_sh")
  private Double ecommerceShippingCost;
  /**
   * Discount offered.
   */
  @TrackingParameter(name = "ec_dt")
  private Double ecommerceDiscount;
  /**
   * The UNIX timestamp of this customer's last ecommerce order. This value is used to process the
   * "Days since last order" report.
   */
  @TrackingParameter(name = "_ects")
  private Instant ecommerceLastOrderTimestamp;
  /**
   * 32 character authorization key used to authenticate the API request. We recommend to create a
   * user specifically for accessing the Tracking API, and give the user only write permission on
   * the website(s).
   */
  @TrackingParameter(name = "token_auth", regex = "[a-z0-9]{32}")
  private String authToken;
  /**
   * Override value for the visitor IP (both IPv4 and IPv6 notations supported).
   */
  @TrackingParameter(name = "cip")
  private String visitorIp;
  /**
   * Override for the datetime of the request (normally the current time is used). This can be used
   * to record visits and page views in the past.
   */
  @TrackingParameter(name = "cdt")
  private Instant requestTimestamp;
  /**
   * An override value for the country. Must be a two-letter ISO 3166 Alpha-2 country code.
   */
  @TrackingParameter(name = "country", maxLength = 2)
  private Country visitorCountry;
  /**
   * An override value for the region. Should be set to a ISO 3166-2 region code, which are used by
   * MaxMind's and DB-IP's GeoIP2 databases. See here for a list of them for every country.
   */
  @TrackingParameter(name = "region", maxLength = 2)
  private String visitorRegion;
  /**
   * An override value for the city. The name of the city the visitor is located in, eg, Tokyo.
   */
  @TrackingParameter(name = "city")
  private String visitorCity;
  /**
   * An override value for the visitor's latitude, eg 22.456.
   */
  @TrackingParameter(name = "lat", min = -90, max = 90)
  private Double visitorLatitude;
  /**
   * An override value for the visitor's longitude, eg 22.456.
   */
  @TrackingParameter(name = "long", min = -180, max = 180)
  private Double visitorLongitude;
  /**
   * When set to false, the queued tracking handler won't be used and instead the tracking request
   * will be executed directly. This can be useful when you need to debug a tracking problem or want
   * to test that the tracking works in general.
   */
  @TrackingParameter(name = "queuedtracking")
  private Boolean queuedTracking;
  /**
   * If set to 0 (send_image=0) Matomo will respond with an HTTP 204 response code instead of a GIF
   * image. This improves performance and can fix errors if images are not allowed to be obtained
   * directly (like Chrome Apps). Available since Matomo 2.10.0
   *
   * <p>Default is {@code false}
   */
  @TrackingParameter(name = "send_image")
  private Boolean responseAsImage;
  /**
   * If set to true, the request will be a Heartbeat request which will not track any new activity
   * (such as a new visit, new action or new goal). The heartbeat request will only update the
   * visit's total time to provide accurate "Visit duration" metric when this parameter is set. It
   * won't record any other data. This means by sending an additional tracking request when the user
   * leaves your site or app with &ping=1, you fix the issue where the time spent of the last page
   * visited is reported as 0 seconds.
   */
  @TrackingParameter(name = "ping")
  private Boolean ping;
  /**
   * By default, Matomo does not track bots. If you use the Tracking HTTP API directly, you may be
   * interested in tracking bot requests.
   */
  @TrackingParameter(name = "bots")
  private Boolean trackBotRequests;
  /**
   * Meant to hold a random value that is generated before each request. Using it helps avoid the
   * tracking request being cached by the browser or a proxy.
   */
  @TrackingParameter(name = "rand")
  private RandomValue randomValue;
  /**
   * Meant to hold a random value that is generated before each request. Using it helps avoid the
   * tracking request being cached by the browser or a proxy.
   */
  @TrackingParameter(name = "debug")
  private Boolean debug;
  /**
   * Contains an error message describing the error that occurred during the last tracking request.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Required for crash analytics
   */
  @TrackingParameter(name = "cra")
  private String crashMessage;
  /**
   * The type of exception that occurred during the last tracking request.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Typically a fully qualified class name of the exception, e.g.
   * {@code java.lang.NullPointerException}.
   *
   * <p>Optional for crash analytics
   */
  @TrackingParameter(name = "cra_tp")
  private String crashType;
  /**
   * Category of a crash to group crashes by.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @TrackingParameter(name = "cra_ct")
  private String crashCategory;
  /**
   * A stack trace of the exception that occurred during the last tracking request.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @TrackingParameter(name = "cra_st")
  private String crashStackTrace;
  /**
   * The originating source of the crash.
   *
   * <p>Could be a source file URI or something similar
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @TrackingParameter(name = "cra_ru")
  private String crashLocation;
  /**
   * The line number of the crash source, where the crash occurred.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @TrackingParameter(name = "cra_rl", min = 0)
  private Integer crashLine;
  /**
   * The column within the line where the crash occurred.
   *
   * <p>Optional for crash analytics
   */
  @TrackingParameter(name = "cra_rc", min = 0)
  private Integer crashColumn;
  /**
   * The Matomo session ID sent as a cookie {@code MATOMO_SESSID}.
   *
   * <p>If not null a cookie with the name {@code MATOMO_SESSID} will be sent with the value of
   * this parameter.
   */
  private String sessionId;
  /**
   * Custom Dimension values for specific Custom Dimension IDs.
   *
   * <p><a href="https://plugins.matomo.org/CustomDimensions">Custom Dimensions plugin</a> must be
   * installed. See the
   * <a href="https://matomo.org/docs/custom-dimensions/">Custom Dimensions guide</a>. Requires
   * Matomo at least 2.15.1
   */
  private Map<Long, Object> dimensions;
  /**
   * Allows you to specify additional HTTP request parameters that will be sent to Matomo.
   *
   * <p>For example, you can use this to set the <em>Accept-Language</em> header, or to set the
   * <em>Content-Type</em>.
   */
  private Map<String, Object> additionalParameters;
  /**
   * You can set additional HTTP headers for the request sent to Matomo.
   *
   * <p>For example, you can use this to set the <em>Accept-Language</em> header, or to set the
   * <em>Content-Type</em>.
   */
  private Map<String, String> headers;
  /**
   * Appends additional cookies to the request.
   *
   * <p>This allows you to add Matomo specific cookies, like {@code _pk_id} or {@code _pk_sess}
   * coming from Matomo responses to the request.
   */
  private Map<String, String> cookies;

  /**
   * Create a new request from the id of the site being tracked and the full url for the current
   * action.  This constructor also sets:
   * <pre>
   * {@code
   * Required = true
   * Visior Id = random 16 character hex string
   * Random Value = random 20 character hex string
   * API version = 1
   * Response as Image = false
   * }
   * </pre>
   * Overwrite these values yourself as desired.
   *
   * @param siteId    the id of the website we're tracking a visit/action for
   * @param actionUrl the full URL for the current action
   *
   * @deprecated Please use {@link MatomoRequest#request()}
   */
  @Deprecated
  public MatomoRequest(int siteId, String actionUrl) {
    this.siteId = siteId;
    this.actionUrl = actionUrl;
    required = true;
    visitorId = VisitorId.random();
    randomValue = RandomValue.random();
    apiVersion = "1";
    responseAsImage = false;
  }

  /**
   * Gets the list of objects currently stored at the specified custom tracking parameter.  An empty
   * list will be returned if there are no objects set at that key.
   *
   * @param key the key of the parameter whose list of objects to get.  Cannot be null
   *
   * @return the parameter at the specified key, null if nothing at this key
   */
  @Nullable
  public Object getCustomTrackingParameter(@NonNull String key) {
    if (key == null) {
      throw new java.lang.NullPointerException("key is marked non-null but is null");
    }
    if (additionalParameters == null || additionalParameters.isEmpty()) {
      return null;
    }
    return additionalParameters.get(key);
  }

  /**
   * Set a custom tracking parameter whose toString() value will be sent to the Matomo server. These
   * parameters are stored separately from named Matomo parameters, meaning it is not possible to
   * overwrite or clear named Matomo parameters with this method. A custom parameter that has the
   * same name as a named Matomo parameter will be sent in addition to that named parameter.
   *
   * @param key   the parameter's key.  Cannot be null
   * @param value the parameter's value.  Removes the parameter if null
   *
   * @deprecated Use {@link MatomoRequest.MatomoRequestBuilder#additionalParameters(Map)} instead.
   */
  @Deprecated
  public void setCustomTrackingParameter(@NonNull String key, @Nullable Object value) {
    if (key == null) {
      throw new java.lang.NullPointerException("key is marked non-null but is null");
    }
    if (value == null) {
      if (additionalParameters != null) {
        additionalParameters.remove(key);
      }
    } else {
      if (additionalParameters == null) {
        additionalParameters = new LinkedHashMap<>();
      }
      additionalParameters.put(key, value);
    }
  }

  /**
   * Add a custom tracking parameter to the specified key.  If there is already a parameter at this
   * key, the new value replaces the old value.
   *
   * @param key   the parameter's key.  Cannot be null
   * @param value the parameter's value.  May be null
   *
   * @deprecated Use {@link MatomoRequest.MatomoRequestBuilder#additionalParameters(Map)} instead.
   */
  @Deprecated
  public void addCustomTrackingParameter(@NonNull String key, @Nullable Object value) {
    if (key == null) {
      throw new java.lang.NullPointerException("key is marked non-null but is null");
    }
    if (additionalParameters == null) {
      additionalParameters = new LinkedHashMap<>();
    }
    additionalParameters.put(key, value);
  }

  /**
   * Removes all custom tracking parameters.
   *
   * @deprecated Please use {@link MatomoRequest.MatomoRequestBuilder#additionalParameters(Map)}
   * instead so that you can manage the map yourself.
   */
  @Deprecated
  public void clearCustomTrackingParameter() {
    additionalParameters.clear();
  }

  /**
   * Sets <em>idgoal&#61;0</em> in the request to track an ecommerce interaction: cart update or an
   * ecommerce order.
   *
   * @deprecated Please use {@link MatomoRequest#setGoalId(Integer)} instead
   */
  @Deprecated
  public void enableEcommerce() {
    setGoalId(0);
  }

  /**
   * Get the {@link EcommerceItem} at the specified index.
   *
   * @param index the index of the {@link EcommerceItem} to return
   *
   * @return the {@link EcommerceItem} at the specified index
   * @deprecated Use @link {@link MatomoRequest.MatomoRequestBuilder#ecommerceItems(EcommerceItems)}
   * instead
   */
  @Nullable
  @Deprecated
  public EcommerceItem getEcommerceItem(int index) {
    if (ecommerceItems == null || ecommerceItems.isEmpty()) {
      return null;
    }
    return ecommerceItems.get(index);
  }

  /**
   * Add an {@link EcommerceItem} to this order.  Ecommerce must be enabled, and EcommerceId and
   * EcommerceRevenue must first be set.
   *
   * @param item the {@link EcommerceItem} to add.  Cannot be null
   *
   * @deprecated Use @link {@link MatomoRequest.MatomoRequestBuilder#ecommerceItems(EcommerceItems)}
   * instead
   */
  @Deprecated
  public void addEcommerceItem(@NonNull EcommerceItem item) {
    if (item == null) {
      throw new java.lang.NullPointerException("item is marked non-null but is null");
    }
    if (ecommerceItems == null) {
      ecommerceItems = new EcommerceItems();
    }
    ecommerceItems.add(item);
  }

  /**
   * Clears all {@link EcommerceItem} from this order.
   *
   * @deprecated Use @link {@link MatomoRequest.MatomoRequestBuilder#ecommerceItems(EcommerceItems)}
   * instead
   */
  @Deprecated
  public void clearEcommerceItems() {
    ecommerceItems.clear();
  }

  /**
   * Get the page custom variable at the specified key.
   *
   * @param key the key of the variable to get
   *
   * @return the variable at the specified key, null if key is not present
   * @deprecated Use the {@link #getPageCustomVariables()} method instead.
   */
  @Nullable
  @Deprecated
  public String getPageCustomVariable(String key) {
    if (pageCustomVariables == null) {
      return null;
    }
    return pageCustomVariables.get(key);
  }

  /**
   * Get the page custom variable at the specified index.
   *
   * @param index the index of the variable to get.  Must be greater than 0
   *
   * @return the variable at the specified key, null if nothing at this index
   * @deprecated Use {@link MatomoRequest#getPageCustomVariables()} instead
   */
  @Deprecated
  @Nullable
  public CustomVariable getPageCustomVariable(int index) {
    return getCustomVariable(pageCustomVariables, index);
  }

  @Nullable
  @Deprecated
  private static CustomVariable getCustomVariable(CustomVariables customVariables, int index) {
    if (customVariables == null) {
      return null;
    }
    return customVariables.get(index);
  }

  /**
   * Set a page custom variable with the specified key and value at the first available index. All
   * page custom variables with this key will be overwritten or deleted
   *
   * @param key   the key of the variable to set
   * @param value the value of the variable to set at the specified key.  A null value will remove
   *              this custom variable
   *
   * @deprecated Use {@link MatomoRequest#getPageCustomVariables()} instead
   */
  @Deprecated
  public void setPageCustomVariable(@NonNull String key, @Nullable String value) {
    if (key == null) {
      throw new java.lang.NullPointerException("key is marked non-null but is null");
    }
    if (value == null) {
      if (pageCustomVariables == null) {
        return;
      }
      pageCustomVariables.remove(key);
    } else {
      CustomVariable variable = new CustomVariable(key, value);
      if (pageCustomVariables == null) {
        pageCustomVariables = new CustomVariables();
      }
      pageCustomVariables.add(variable);
    }
  }

  /**
   * Set a page custom variable at the specified index.
   *
   * @param customVariable the CustomVariable to set.  A null value will remove the CustomVariable
   *                       at the specified index
   * @param index          the index of he CustomVariable to set
   *
   * @deprecated Use {@link #getPageCustomVariables()} instead
   */
  @Deprecated
  public void setPageCustomVariable(@Nullable CustomVariable customVariable, int index) {
    if (pageCustomVariables == null) {
      if (customVariable == null) {
        return;
      }
      pageCustomVariables = new CustomVariables();
    }
    setCustomVariable(pageCustomVariables, customVariable, index);
  }

  @Deprecated
  private static void setCustomVariable(CustomVariables customVariables, @Nullable CustomVariable customVariable, int index) {
    if (customVariable == null) {
      customVariables.remove(index);
    } else {
      customVariables.add(customVariable, index);
    }
  }

  /**
   * Get the datetime of the request.
   *
   * @return the datetime of the request
   * @deprecated Use {@link #getRequestTimestamp()} instead
   */
  @Deprecated
  @Nullable
  public MatomoDate getRequestDatetime() {
    return requestTimestamp == null ? null : new MatomoDate(requestTimestamp.toEpochMilli());
  }

  /**
   * Set the datetime of the request (normally the current time is used). This can be used to record
   * visits and page views in the past. The datetime must be sent in UTC timezone. <em>Note: if you
   * record data in the past, you will need to <a href="https://matomo.org/faq/how-to/faq_59">force
   * Matomo to re-process reports for the past dates</a>.</em> If you set the <em>Request
   * Datetime</em> to a datetime older than four hours then <em>Auth Token</em> must be set. If you
   * set
   * <em>Request Datetime</em> with a datetime in the last four hours then you
   * don't need to pass <em>Auth Token</em>.
   *
   * @param matomoDate the datetime of the request to set.  A null value will remove this parameter
   *
   * @deprecated Use {@link #setRequestTimestamp(Instant)} instead
   */
  @Deprecated
  public void setRequestDatetime(MatomoDate matomoDate) {
    if (matomoDate == null) {
      requestTimestamp = null;
    } else {
      setRequestTimestamp(matomoDate.getZonedDateTime().toInstant());
    }
  }

  /**
   * Get the visit custom variable at the specified key.
   *
   * @param key the key of the variable to get
   *
   * @return the variable at the specified key, null if key is not present
   * @deprecated Use the {@link #getVisitCustomVariables()} method instead.
   */
  @Nullable
  @Deprecated
  public String getUserCustomVariable(String key) {
    if (visitCustomVariables == null) {
      return null;
    }
    return visitCustomVariables.get(key);
  }

  /**
   * Get the visit custom variable at the specified index.
   *
   * @param index the index of the variable to get
   *
   * @return the variable at the specified index, null if nothing at this index
   * @deprecated Use {@link #getVisitCustomVariables()} instead
   */
  @Nullable
  @Deprecated
  public CustomVariable getVisitCustomVariable(int index) {
    return getCustomVariable(visitCustomVariables, index);
  }

  /**
   * Set a visit custom variable with the specified key and value at the first available index. All
   * visit custom variables with this key will be overwritten or deleted
   *
   * @param key   the key of the variable to set
   * @param value the value of the variable to set at the specified key.  A null value will remove
   *              this parameter
   *
   * @deprecated Use {@link #setVisitCustomVariables(CustomVariables)} instead
   */
  @Deprecated
  public void setUserCustomVariable(@NonNull String key, @Nullable String value) {
    if (key == null) {
      throw new java.lang.NullPointerException("key is marked non-null but is null");
    }
    if (value == null) {
      if (visitCustomVariables == null) {
        return;
      }
      visitCustomVariables.remove(key);
    } else {
      CustomVariable variable = new CustomVariable(key, value);
      if (visitCustomVariables == null) {
        visitCustomVariables = new CustomVariables();
      }
      visitCustomVariables.add(variable);
    }
  }

  /**
   * Set a user custom variable at the specified key.
   *
   * @param customVariable the CustomVariable to set.  A null value will remove the custom variable
   *                       at the specified index
   * @param index          the index to set the customVariable at.
   *
   * @deprecated Use {@link #setVisitCustomVariables(CustomVariables)} instead
   */
  @Deprecated
  public void setVisitCustomVariable(@Nullable CustomVariable customVariable, int index) {
    if (visitCustomVariables == null) {
      if (customVariable == null) {
        return;
      }
      visitCustomVariables = new CustomVariables();
    }
    setCustomVariable(visitCustomVariables, customVariable, index);
  }

  /**
   * Sets a custom parameter to append to the Matomo tracking parameters.
   *
   * <p>Attention: If a parameter with the same name already exists, it will be appended twice!
   *
   * @param parameterName The name of the query parameter to append. Must not be null or empty.
   * @param value         The value of the query parameter to append. To remove the parameter, pass
   *                      null.
   *
   * @deprecated Use @link {@link MatomoRequest.MatomoRequestBuilder#additionalParameters(Map)}
   * instead
   */
  @Deprecated
  public void setParameter(@NonNull String parameterName, Object value) {
    if (parameterName == null) {
      throw new java.lang.NullPointerException("parameterName is marked non-null but is null");
    }
    if (parameterName.trim().isEmpty()) {
      throw new IllegalArgumentException("Parameter name must not be empty");
    }
    if (additionalParameters == null) {
      if (value == null) {
        return;
      }
      additionalParameters = new LinkedHashMap<>();
    }
    if (value == null) {
      additionalParameters.remove(parameterName);
    } else {
      additionalParameters.put(parameterName, value);
    }
  }

  /**
   * Creates a new {@link MatomoRequestBuilder} instance. Only here for backwards compatibility.
   *
   * @deprecated Use {@link MatomoRequest#request()} instead.
   */
  @Deprecated
  public static org.matomo.java.tracking.MatomoRequestBuilder builder() {
    return new org.matomo.java.tracking.MatomoRequestBuilder();
  }

  /**
   * Parses the given device resolution string and sets the {@link #deviceResolution} field.
   *
   * @param deviceResolution the device resolution string to parse. Format: "WIDTHxHEIGHT"
   *
   * @deprecated Use {@link #setDeviceResolution(DeviceResolution)} instead.
   */
  @Tolerate
  @Deprecated
  public void setDeviceResolution(@Nullable String deviceResolution) {
    if (deviceResolution == null || deviceResolution.trim().isEmpty()) {
      this.deviceResolution = null;
    } else {
      this.deviceResolution = DeviceResolution.fromString(deviceResolution);
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static Boolean $default$required() {
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static String $default$apiVersion() {
    return "1";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static VisitorId $default$visitorId() {
    return VisitorId.random();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static Boolean $default$responseAsImage() {
    return false;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static RandomValue $default$randomValue() {
    return RandomValue.random();
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class MatomoRequestBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean required$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean required$value;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer siteId;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String actionName;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String actionUrl;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean apiVersion$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String apiVersion$value;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean visitorId$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private VisitorId visitorId$value;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean newVisitor;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String referrerUrl;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private CustomVariables visitCustomVariables;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer visitorVisitCount;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Instant visitorPreviousVisitTimestamp;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Instant visitorFirstVisitTimestamp;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String campaignName;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String campaignKeyword;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private DeviceResolution deviceResolution;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer currentHour;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer currentMinute;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer currentSecond;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean pluginFlash;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean pluginJava;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean pluginDirector;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean pluginQuicktime;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean pluginRealPlayer;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean pluginPDF;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean pluginWindowsMedia;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean pluginGears;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean pluginSilverlight;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean supportsCookies;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String headerUserAgent;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private AcceptLanguage headerAcceptLanguage;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String userId;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private VisitorId visitorCustomId;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean newVisit;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private CustomVariables pageCustomVariables;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String outlinkUrl;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String downloadUrl;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String searchQuery;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String searchCategory;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Long searchResultsCount;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private UniqueId pageViewId;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer goalId;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Double ecommerceRevenue;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Charset characterSet;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean customAction;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Long networkTime;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Long serverTime;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Long transferTime;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Long domProcessingTime;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Long domCompletionTime;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Long onloadTime;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String eventCategory;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String eventAction;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String eventName;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Double eventValue;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String contentName;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String contentPiece;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String contentTarget;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String contentInteraction;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String ecommerceId;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private EcommerceItems ecommerceItems;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Double ecommerceSubtotal;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Double ecommerceTax;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Double ecommerceShippingCost;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Double ecommerceDiscount;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Instant ecommerceLastOrderTimestamp;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String authToken;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String visitorIp;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Instant requestTimestamp;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Country visitorCountry;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String visitorRegion;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String visitorCity;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Double visitorLatitude;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Double visitorLongitude;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean queuedTracking;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean responseAsImage$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean responseAsImage$value;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean ping;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean trackBotRequests;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean randomValue$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private RandomValue randomValue$value;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean debug;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String crashMessage;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String crashType;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String crashCategory;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String crashStackTrace;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String crashLocation;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer crashLine;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer crashColumn;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String sessionId;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<Long, Object> dimensions;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, Object> additionalParameters;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, String> headers;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, String> cookies;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    MatomoRequestBuilder() {
    }

    /**
     * The ID of the website we're tracking a visit/action for. Only needed, if no default site id is
     * configured.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder required(final Boolean required) {
      this.required$value = required;
      required$set = true;
      return this;
    }

    /**
     * The ID of the website we're tracking a visit/action for. Only needed, if no default site id is
     * configured.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder siteId(final Integer siteId) {
      this.siteId = siteId;
      return this;
    }

    /**
     * The title of the action being tracked. For page tracks this is used as page title. If enabled
     * in your installation you may use the category tree structure in this field. For example, "game
     * / register new user" would then create a group "game" and add the item "register new user" in
     * it.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder actionName(final String actionName) {
      this.actionName = actionName;
      return this;
    }

    /**
     * The full URL for the current action.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder actionUrl(final String actionUrl) {
      this.actionUrl = actionUrl;
      return this;
    }

    /**
     * Defines the API version to use (default: 1).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder apiVersion(final String apiVersion) {
      this.apiVersion$value = apiVersion;
      apiVersion$set = true;
      return this;
    }

    /**
     * The unique visitor ID. See {@link VisitorId}. Default is {@link VisitorId#random()}
     *
     * <p>Since version 3.0.0 this parameter is of type {@link VisitorId} and not a String anymore.
     * Use {@link VisitorId#fromHex(String)} to create a VisitorId from a hex string,
     * {@link VisitorId#fromUUID(UUID)} to create it from a UUID or {@link VisitorId#fromHash(long)}
     * to create it from a long value.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitorId(final VisitorId visitorId) {
      this.visitorId$value = visitorId;
      visitorId$set = true;
      return this;
    }

    /**
     * Tracks if the visitor is a returning visitor.
     *
     * <p>This is done by storing a visitor ID in a 1st party cookie.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder newVisitor(final Boolean newVisitor) {
      this.newVisitor = newVisitor;
      return this;
    }

    /**
     * The full HTTP Referrer URL. This value is used to determine how someone got to your website
     * (ie, through a website, search engine or campaign)
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder referrerUrl(final String referrerUrl) {
      this.referrerUrl = referrerUrl;
      return this;
    }

    /**
     * Custom variables are custom name-value pairs that you can assign to your visitors (or page
     * views).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitCustomVariables(final CustomVariables visitCustomVariables) {
      this.visitCustomVariables = visitCustomVariables;
      return this;
    }

    /**
     * The current count of visits for this visitor. To set this value correctly, it would be required
     * to store the value for each visitor in your application (using sessions or persisting in a
     * database). Then you would manually increment the counts by one on each new visit or "session",
     * depending on how you choose to define a visit.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitorVisitCount(final Integer visitorVisitCount) {
      this.visitorVisitCount = visitorVisitCount;
      return this;
    }

    /**
     * The UNIX timestamp of this visitor's previous visit. This parameter is used to populate the
     * report Visitors > Engagement > Visits by days since last visit.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitorPreviousVisitTimestamp(final Instant visitorPreviousVisitTimestamp) {
      this.visitorPreviousVisitTimestamp = visitorPreviousVisitTimestamp;
      return this;
    }

    /**
     * The UNIX timestamp of this visitor's first visit. This could be set to the date where the user
     * first started using your software/app, or when he/she created an account.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitorFirstVisitTimestamp(final Instant visitorFirstVisitTimestamp) {
      this.visitorFirstVisitTimestamp = visitorFirstVisitTimestamp;
      return this;
    }

    /**
     * The campaign name. This parameter will only be used for the first pageview of a visit.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder campaignName(final String campaignName) {
      this.campaignName = campaignName;
      return this;
    }

    /**
     * The campaign keyword (see
     * <a href="https://matomo.org/docs/tracking-campaigns/">Tracking Campaigns</a>). Used to
     * populate the <em>Referrers &gt; Campaigns</em> report (clicking on a campaign loads all
     * keywords for this campaign). This parameter will only be used for the first pageview of a
     * visit.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder campaignKeyword(final String campaignKeyword) {
      this.campaignKeyword = campaignKeyword;
      return this;
    }

    /**
     * The resolution of the device the visitor is using.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder deviceResolution(final DeviceResolution deviceResolution) {
      this.deviceResolution = deviceResolution;
      return this;
    }

    /**
     * The current hour (local time).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder currentHour(final Integer currentHour) {
      this.currentHour = currentHour;
      return this;
    }

    /**
     * The current minute (local time).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder currentMinute(final Integer currentMinute) {
      this.currentMinute = currentMinute;
      return this;
    }

    /**
     * The current second (local time).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder currentSecond(final Integer currentSecond) {
      this.currentSecond = currentSecond;
      return this;
    }

    /**
     * Does the visitor use the Adobe Flash Plugin.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder pluginFlash(final Boolean pluginFlash) {
      this.pluginFlash = pluginFlash;
      return this;
    }

    /**
     * Does the visitor use the Java plugin.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder pluginJava(final Boolean pluginJava) {
      this.pluginJava = pluginJava;
      return this;
    }

    /**
     * Does the visitor use Director plugin.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder pluginDirector(final Boolean pluginDirector) {
      this.pluginDirector = pluginDirector;
      return this;
    }

    /**
     * Does the visitor use Quicktime plugin.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder pluginQuicktime(final Boolean pluginQuicktime) {
      this.pluginQuicktime = pluginQuicktime;
      return this;
    }

    /**
     * Does the visitor use Realplayer plugin.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder pluginRealPlayer(final Boolean pluginRealPlayer) {
      this.pluginRealPlayer = pluginRealPlayer;
      return this;
    }

    /**
     * Does the visitor use a PDF plugin.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder pluginPDF(final Boolean pluginPDF) {
      this.pluginPDF = pluginPDF;
      return this;
    }

    /**
     * Does the visitor use a Windows Media plugin.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder pluginWindowsMedia(final Boolean pluginWindowsMedia) {
      this.pluginWindowsMedia = pluginWindowsMedia;
      return this;
    }

    /**
     * Does the visitor use a Gears plugin.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder pluginGears(final Boolean pluginGears) {
      this.pluginGears = pluginGears;
      return this;
    }

    /**
     * Does the visitor use a Silverlight plugin.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder pluginSilverlight(final Boolean pluginSilverlight) {
      this.pluginSilverlight = pluginSilverlight;
      return this;
    }

    /**
     * Does the visitor's client is known to support cookies.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder supportsCookies(final Boolean supportsCookies) {
      this.supportsCookies = supportsCookies;
      return this;
    }

    /**
     * An override value for the User-Agent HTTP header field.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder headerUserAgent(final String headerUserAgent) {
      this.headerUserAgent = headerUserAgent;
      return this;
    }

    /**
     * An override value for the Accept-Language HTTP header field. This value is used to detect the
     * visitor's country if GeoIP is not enabled.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder headerAcceptLanguage(final AcceptLanguage headerAcceptLanguage) {
      this.headerAcceptLanguage = headerAcceptLanguage;
      return this;
    }

    /**
     * Defines the User ID for this request. User ID is any non-empty unique string identifying the
     * user (such as an email address or a username). When specified, the User ID will be "enforced".
     * This means that if there is no recent visit with this User ID, a new one will be created. If a
     * visit is found in the last 30 minutes with your specified User ID, then the new action will be
     * recorded to this existing visit.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder userId(final String userId) {
      this.userId = userId;
      return this;
    }

    /**
     * defines the visitor ID for this request.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitorCustomId(final VisitorId visitorCustomId) {
      this.visitorCustomId = visitorCustomId;
      return this;
    }

    /**
     * will force a new visit to be created for this action.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder newVisit(final Boolean newVisit) {
      this.newVisit = newVisit;
      return this;
    }

    /**
     * Custom variables are custom name-value pairs that you can assign to your visitors (or page
     * views).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder pageCustomVariables(final CustomVariables pageCustomVariables) {
      this.pageCustomVariables = pageCustomVariables;
      return this;
    }

    /**
     * An external URL the user has opened. Used for tracking outlink clicks. We recommend to also set
     * the url parameter to this same value.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder outlinkUrl(final String outlinkUrl) {
      this.outlinkUrl = outlinkUrl;
      return this;
    }

    /**
     * URL of a file the user has downloaded. Used for tracking downloads. We recommend to also set
     * the url parameter to this same value.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder downloadUrl(final String downloadUrl) {
      this.downloadUrl = downloadUrl;
      return this;
    }

    /**
     * The Site Search keyword. When specified, the request will not be tracked as a normal pageview
     * but will instead be tracked as a Site Search request
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder searchQuery(final String searchQuery) {
      this.searchQuery = searchQuery;
      return this;
    }

    /**
     * When search is specified, you can optionally specify a search category with this parameter.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder searchCategory(final String searchCategory) {
      this.searchCategory = searchCategory;
      return this;
    }

    /**
     * When search is specified, we also recommend setting the search_count to the number of search
     * results displayed on the results page. When keywords are tracked with &search_count=0 they will
     * appear in the "No Result Search Keyword" report.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder searchResultsCount(final Long searchResultsCount) {
      this.searchResultsCount = searchResultsCount;
      return this;
    }

    /**
     * Accepts a six character unique ID that identifies which actions were performed on a specific
     * page view. When a page was viewed, all following tracking requests (such as events) during that
     * page view should use the same pageview ID. Once another page was viewed a new unique ID should
     * be generated. Use [0-9a-Z] as possible characters for the unique ID.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder pageViewId(final UniqueId pageViewId) {
      this.pageViewId = pageViewId;
      return this;
    }

    /**
     * If specified, the tracking request will trigger a conversion for the goal of the website being
     * tracked with this ID. The value 0 tracks an ecommerce interaction.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder goalId(final Integer goalId) {
      this.goalId = goalId;
      return this;
    }

    /**
     * The grand total for the ecommerce order (required when tracking an ecommerce order).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder ecommerceRevenue(final Double ecommerceRevenue) {
      this.ecommerceRevenue = ecommerceRevenue;
      return this;
    }

    /**
     * The charset of the page being tracked. Specify the charset if the data you send to Matomo is
     * encoded in a different character set than the default utf-8
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder characterSet(final Charset characterSet) {
      this.characterSet = characterSet;
      return this;
    }

    /**
     * can be optionally sent along any tracking request that isn't a page view. For example, it can
     * be sent together with an event tracking request. The advantage being that should you ever
     * disable the event plugin, then the event tracking requests will be ignored vs if the parameter
     * is not set, a page view would be tracked even though it isn't a page view.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder customAction(final Boolean customAction) {
      this.customAction = customAction;
      return this;
    }

    /**
     * How long it took to connect to server.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder networkTime(final Long networkTime) {
      this.networkTime = networkTime;
      return this;
    }

    /**
     * How long it took the server to generate page.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder serverTime(final Long serverTime) {
      this.serverTime = serverTime;
      return this;
    }

    /**
     * How long it takes the browser to download the response from the server.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder transferTime(final Long transferTime) {
      this.transferTime = transferTime;
      return this;
    }

    /**
     * How long the browser spends loading the webpage after the response was fully received until the
     * user can start interacting with it.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder domProcessingTime(final Long domProcessingTime) {
      this.domProcessingTime = domProcessingTime;
      return this;
    }

    /**
     * How long it takes for the browser to load media and execute any Javascript code listening for
     * the DOMContentLoaded event.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder domCompletionTime(final Long domCompletionTime) {
      this.domCompletionTime = domCompletionTime;
      return this;
    }

    /**
     * How long it takes the browser to execute Javascript code waiting for the window.load event.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder onloadTime(final Long onloadTime) {
      this.onloadTime = onloadTime;
      return this;
    }

    /**
     * eg. Videos, Music, Games...
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder eventCategory(final String eventCategory) {
      this.eventCategory = eventCategory;
      return this;
    }

    /**
     * An event action like Play, Pause, Duration, Add Playlist, Downloaded, Clicked...
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder eventAction(final String eventAction) {
      this.eventAction = eventAction;
      return this;
    }

    /**
     * The event name for example a Movie name, or Song name, or File name...
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder eventName(final String eventName) {
      this.eventName = eventName;
      return this;
    }

    /**
     * Some numeric value that represents the event value.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder eventValue(final Double eventValue) {
      this.eventValue = eventValue;
      return this;
    }

    /**
     * The name of the content. For instance 'Ad Foo Bar'
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder contentName(final String contentName) {
      this.contentName = contentName;
      return this;
    }

    /**
     * The actual content piece. For instance the path to an image, video, audio, any text
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder contentPiece(final String contentPiece) {
      this.contentPiece = contentPiece;
      return this;
    }

    /**
     * The target of the content. For instance the URL of a landing page
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder contentTarget(final String contentTarget) {
      this.contentTarget = contentTarget;
      return this;
    }

    /**
     * The name of the interaction with the content. For instance a 'click'
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder contentInteraction(final String contentInteraction) {
      this.contentInteraction = contentInteraction;
      return this;
    }

    /**
     * The unique string identifier for the ecommerce order (required when tracking an ecommerce
     * order).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder ecommerceId(final String ecommerceId) {
      this.ecommerceId = ecommerceId;
      return this;
    }

    /**
     * Items in the Ecommerce order.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder ecommerceItems(final EcommerceItems ecommerceItems) {
      this.ecommerceItems = ecommerceItems;
      return this;
    }

    /**
     * The subtotal of the order; excludes shipping.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder ecommerceSubtotal(final Double ecommerceSubtotal) {
      this.ecommerceSubtotal = ecommerceSubtotal;
      return this;
    }

    /**
     * Tax amount of the order.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder ecommerceTax(final Double ecommerceTax) {
      this.ecommerceTax = ecommerceTax;
      return this;
    }

    /**
     * Shipping cost of the order.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder ecommerceShippingCost(final Double ecommerceShippingCost) {
      this.ecommerceShippingCost = ecommerceShippingCost;
      return this;
    }

    /**
     * Discount offered.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder ecommerceDiscount(final Double ecommerceDiscount) {
      this.ecommerceDiscount = ecommerceDiscount;
      return this;
    }

    /**
     * The UNIX timestamp of this customer's last ecommerce order. This value is used to process the
     * "Days since last order" report.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder ecommerceLastOrderTimestamp(final Instant ecommerceLastOrderTimestamp) {
      this.ecommerceLastOrderTimestamp = ecommerceLastOrderTimestamp;
      return this;
    }

    /**
     * 32 character authorization key used to authenticate the API request. We recommend to create a
     * user specifically for accessing the Tracking API, and give the user only write permission on
     * the website(s).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder authToken(final String authToken) {
      this.authToken = authToken;
      return this;
    }

    /**
     * Override value for the visitor IP (both IPv4 and IPv6 notations supported).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitorIp(final String visitorIp) {
      this.visitorIp = visitorIp;
      return this;
    }

    /**
     * Override for the datetime of the request (normally the current time is used). This can be used
     * to record visits and page views in the past.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder requestTimestamp(final Instant requestTimestamp) {
      this.requestTimestamp = requestTimestamp;
      return this;
    }

    /**
     * An override value for the country. Must be a two-letter ISO 3166 Alpha-2 country code.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitorCountry(final Country visitorCountry) {
      this.visitorCountry = visitorCountry;
      return this;
    }

    /**
     * An override value for the region. Should be set to a ISO 3166-2 region code, which are used by
     * MaxMind's and DB-IP's GeoIP2 databases. See here for a list of them for every country.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitorRegion(final String visitorRegion) {
      this.visitorRegion = visitorRegion;
      return this;
    }

    /**
     * An override value for the city. The name of the city the visitor is located in, eg, Tokyo.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitorCity(final String visitorCity) {
      this.visitorCity = visitorCity;
      return this;
    }

    /**
     * An override value for the visitor's latitude, eg 22.456.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitorLatitude(final Double visitorLatitude) {
      this.visitorLatitude = visitorLatitude;
      return this;
    }

    /**
     * An override value for the visitor's longitude, eg 22.456.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder visitorLongitude(final Double visitorLongitude) {
      this.visitorLongitude = visitorLongitude;
      return this;
    }

    /**
     * When set to false, the queued tracking handler won't be used and instead the tracking request
     * will be executed directly. This can be useful when you need to debug a tracking problem or want
     * to test that the tracking works in general.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder queuedTracking(final Boolean queuedTracking) {
      this.queuedTracking = queuedTracking;
      return this;
    }

    /**
     * If set to 0 (send_image=0) Matomo will respond with an HTTP 204 response code instead of a GIF
     * image. This improves performance and can fix errors if images are not allowed to be obtained
     * directly (like Chrome Apps). Available since Matomo 2.10.0
     *
     * <p>Default is {@code false}
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder responseAsImage(final Boolean responseAsImage) {
      this.responseAsImage$value = responseAsImage;
      responseAsImage$set = true;
      return this;
    }

    /**
     * If set to true, the request will be a Heartbeat request which will not track any new activity
     * (such as a new visit, new action or new goal). The heartbeat request will only update the
     * visit's total time to provide accurate "Visit duration" metric when this parameter is set. It
     * won't record any other data. This means by sending an additional tracking request when the user
     * leaves your site or app with &ping=1, you fix the issue where the time spent of the last page
     * visited is reported as 0 seconds.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder ping(final Boolean ping) {
      this.ping = ping;
      return this;
    }

    /**
     * By default, Matomo does not track bots. If you use the Tracking HTTP API directly, you may be
     * interested in tracking bot requests.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder trackBotRequests(final Boolean trackBotRequests) {
      this.trackBotRequests = trackBotRequests;
      return this;
    }

    /**
     * Meant to hold a random value that is generated before each request. Using it helps avoid the
     * tracking request being cached by the browser or a proxy.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder randomValue(final RandomValue randomValue) {
      this.randomValue$value = randomValue;
      randomValue$set = true;
      return this;
    }

    /**
     * Meant to hold a random value that is generated before each request. Using it helps avoid the
     * tracking request being cached by the browser or a proxy.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder debug(final Boolean debug) {
      this.debug = debug;
      return this;
    }

    /**
     * Contains an error message describing the error that occurred during the last tracking request.
     *
     * <p>Custom action must be enabled for this.
     *
     * <p>Required for crash analytics
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder crashMessage(final String crashMessage) {
      this.crashMessage = crashMessage;
      return this;
    }

    /**
     * The type of exception that occurred during the last tracking request.
     *
     * <p>Custom action must be enabled for this.
     *
     * <p>Typically a fully qualified class name of the exception, e.g.
     * {@code java.lang.NullPointerException}.
     *
     * <p>Optional for crash analytics
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder crashType(final String crashType) {
      this.crashType = crashType;
      return this;
    }

    /**
     * Category of a crash to group crashes by.
     *
     * <p>Custom action must be enabled for this.
     *
     * <p>Optional for crash analytics
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder crashCategory(final String crashCategory) {
      this.crashCategory = crashCategory;
      return this;
    }

    /**
     * A stack trace of the exception that occurred during the last tracking request.
     *
     * <p>Custom action must be enabled for this.
     *
     * <p>Optional for crash analytics
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder crashStackTrace(final String crashStackTrace) {
      this.crashStackTrace = crashStackTrace;
      return this;
    }

    /**
     * The originating source of the crash.
     *
     * <p>Could be a source file URI or something similar
     *
     * <p>Custom action must be enabled for this.
     *
     * <p>Optional for crash analytics
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder crashLocation(final String crashLocation) {
      this.crashLocation = crashLocation;
      return this;
    }

    /**
     * The line number of the crash source, where the crash occurred.
     *
     * <p>Custom action must be enabled for this.
     *
     * <p>Optional for crash analytics
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder crashLine(final Integer crashLine) {
      this.crashLine = crashLine;
      return this;
    }

    /**
     * The column within the line where the crash occurred.
     *
     * <p>Optional for crash analytics
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder crashColumn(final Integer crashColumn) {
      this.crashColumn = crashColumn;
      return this;
    }

    /**
     * The Matomo session ID sent as a cookie {@code MATOMO_SESSID}.
     *
     * <p>If not null a cookie with the name {@code MATOMO_SESSID} will be sent with the value of
     * this parameter.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder sessionId(final String sessionId) {
      this.sessionId = sessionId;
      return this;
    }

    /**
     * Custom Dimension values for specific Custom Dimension IDs.
     *
     * <p><a href="https://plugins.matomo.org/CustomDimensions">Custom Dimensions plugin</a> must be
     * installed. See the
     * <a href="https://matomo.org/docs/custom-dimensions/">Custom Dimensions guide</a>. Requires
     * Matomo at least 2.15.1
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder dimensions(final Map<Long, Object> dimensions) {
      this.dimensions = dimensions;
      return this;
    }

    /**
     * Allows you to specify additional HTTP request parameters that will be sent to Matomo.
     *
     * <p>For example, you can use this to set the <em>Accept-Language</em> header, or to set the
     * <em>Content-Type</em>.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder additionalParameters(final Map<String, Object> additionalParameters) {
      this.additionalParameters = additionalParameters;
      return this;
    }

    /**
     * You can set additional HTTP headers for the request sent to Matomo.
     *
     * <p>For example, you can use this to set the <em>Accept-Language</em> header, or to set the
     * <em>Content-Type</em>.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder headers(final Map<String, String> headers) {
      this.headers = headers;
      return this;
    }

    /**
     * Appends additional cookies to the request.
     *
     * <p>This allows you to add Matomo specific cookies, like {@code _pk_id} or {@code _pk_sess}
     * coming from Matomo responses to the request.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest.MatomoRequestBuilder cookies(final Map<String, String> cookies) {
      this.cookies = cookies;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatomoRequest build() {
      Boolean required$value = this.required$value;
      if (!this.required$set) required$value = MatomoRequest.$default$required();
      String apiVersion$value = this.apiVersion$value;
      if (!this.apiVersion$set) apiVersion$value = MatomoRequest.$default$apiVersion();
      VisitorId visitorId$value = this.visitorId$value;
      if (!this.visitorId$set) visitorId$value = MatomoRequest.$default$visitorId();
      Boolean responseAsImage$value = this.responseAsImage$value;
      if (!this.responseAsImage$set) responseAsImage$value = MatomoRequest.$default$responseAsImage();
      RandomValue randomValue$value = this.randomValue$value;
      if (!this.randomValue$set) randomValue$value = MatomoRequest.$default$randomValue();
      return new MatomoRequest(required$value, this.siteId, this.actionName, this.actionUrl, apiVersion$value, visitorId$value, this.newVisitor, this.referrerUrl, this.visitCustomVariables, this.visitorVisitCount, this.visitorPreviousVisitTimestamp, this.visitorFirstVisitTimestamp, this.campaignName, this.campaignKeyword, this.deviceResolution, this.currentHour, this.currentMinute, this.currentSecond, this.pluginFlash, this.pluginJava, this.pluginDirector, this.pluginQuicktime, this.pluginRealPlayer, this.pluginPDF, this.pluginWindowsMedia, this.pluginGears, this.pluginSilverlight, this.supportsCookies, this.headerUserAgent, this.headerAcceptLanguage, this.userId, this.visitorCustomId, this.newVisit, this.pageCustomVariables, this.outlinkUrl, this.downloadUrl, this.searchQuery, this.searchCategory, this.searchResultsCount, this.pageViewId, this.goalId, this.ecommerceRevenue, this.characterSet, this.customAction, this.networkTime, this.serverTime, this.transferTime, this.domProcessingTime, this.domCompletionTime, this.onloadTime, this.eventCategory, this.eventAction, this.eventName, this.eventValue, this.contentName, this.contentPiece, this.contentTarget, this.contentInteraction, this.ecommerceId, this.ecommerceItems, this.ecommerceSubtotal, this.ecommerceTax, this.ecommerceShippingCost, this.ecommerceDiscount, this.ecommerceLastOrderTimestamp, this.authToken, this.visitorIp, this.requestTimestamp, this.visitorCountry, this.visitorRegion, this.visitorCity, this.visitorLatitude, this.visitorLongitude, this.queuedTracking, responseAsImage$value, this.ping, this.trackBotRequests, randomValue$value, this.debug, this.crashMessage, this.crashType, this.crashCategory, this.crashStackTrace, this.crashLocation, this.crashLine, this.crashColumn, this.sessionId, this.dimensions, this.additionalParameters, this.headers, this.cookies);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "MatomoRequest.MatomoRequestBuilder(required$value=" + this.required$value + ", siteId=" + this.siteId + ", actionName=" + this.actionName + ", actionUrl=" + this.actionUrl + ", apiVersion$value=" + this.apiVersion$value + ", visitorId$value=" + this.visitorId$value + ", newVisitor=" + this.newVisitor + ", referrerUrl=" + this.referrerUrl + ", visitCustomVariables=" + this.visitCustomVariables + ", visitorVisitCount=" + this.visitorVisitCount + ", visitorPreviousVisitTimestamp=" + this.visitorPreviousVisitTimestamp + ", visitorFirstVisitTimestamp=" + this.visitorFirstVisitTimestamp + ", campaignName=" + this.campaignName + ", campaignKeyword=" + this.campaignKeyword + ", deviceResolution=" + this.deviceResolution + ", currentHour=" + this.currentHour + ", currentMinute=" + this.currentMinute + ", currentSecond=" + this.currentSecond + ", pluginFlash=" + this.pluginFlash + ", pluginJava=" + this.pluginJava + ", pluginDirector=" + this.pluginDirector + ", pluginQuicktime=" + this.pluginQuicktime + ", pluginRealPlayer=" + this.pluginRealPlayer + ", pluginPDF=" + this.pluginPDF + ", pluginWindowsMedia=" + this.pluginWindowsMedia + ", pluginGears=" + this.pluginGears + ", pluginSilverlight=" + this.pluginSilverlight + ", supportsCookies=" + this.supportsCookies + ", headerUserAgent=" + this.headerUserAgent + ", headerAcceptLanguage=" + this.headerAcceptLanguage + ", userId=" + this.userId + ", visitorCustomId=" + this.visitorCustomId + ", newVisit=" + this.newVisit + ", pageCustomVariables=" + this.pageCustomVariables + ", outlinkUrl=" + this.outlinkUrl + ", downloadUrl=" + this.downloadUrl + ", searchQuery=" + this.searchQuery + ", searchCategory=" + this.searchCategory + ", searchResultsCount=" + this.searchResultsCount + ", pageViewId=" + this.pageViewId + ", goalId=" + this.goalId + ", ecommerceRevenue=" + this.ecommerceRevenue + ", characterSet=" + this.characterSet + ", customAction=" + this.customAction + ", networkTime=" + this.networkTime + ", serverTime=" + this.serverTime + ", transferTime=" + this.transferTime + ", domProcessingTime=" + this.domProcessingTime + ", domCompletionTime=" + this.domCompletionTime + ", onloadTime=" + this.onloadTime + ", eventCategory=" + this.eventCategory + ", eventAction=" + this.eventAction + ", eventName=" + this.eventName + ", eventValue=" + this.eventValue + ", contentName=" + this.contentName + ", contentPiece=" + this.contentPiece + ", contentTarget=" + this.contentTarget + ", contentInteraction=" + this.contentInteraction + ", ecommerceId=" + this.ecommerceId + ", ecommerceItems=" + this.ecommerceItems + ", ecommerceSubtotal=" + this.ecommerceSubtotal + ", ecommerceTax=" + this.ecommerceTax + ", ecommerceShippingCost=" + this.ecommerceShippingCost + ", ecommerceDiscount=" + this.ecommerceDiscount + ", ecommerceLastOrderTimestamp=" + this.ecommerceLastOrderTimestamp + ", authToken=" + this.authToken + ", visitorIp=" + this.visitorIp + ", requestTimestamp=" + this.requestTimestamp + ", visitorCountry=" + this.visitorCountry + ", visitorRegion=" + this.visitorRegion + ", visitorCity=" + this.visitorCity + ", visitorLatitude=" + this.visitorLatitude + ", visitorLongitude=" + this.visitorLongitude + ", queuedTracking=" + this.queuedTracking + ", responseAsImage$value=" + this.responseAsImage$value + ", ping=" + this.ping + ", trackBotRequests=" + this.trackBotRequests + ", randomValue$value=" + this.randomValue$value + ", debug=" + this.debug + ", crashMessage=" + this.crashMessage + ", crashType=" + this.crashType + ", crashCategory=" + this.crashCategory + ", crashStackTrace=" + this.crashStackTrace + ", crashLocation=" + this.crashLocation + ", crashLine=" + this.crashLine + ", crashColumn=" + this.crashColumn + ", sessionId=" + this.sessionId + ", dimensions=" + this.dimensions + ", additionalParameters=" + this.additionalParameters + ", headers=" + this.headers + ", cookies=" + this.cookies + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static MatomoRequest.MatomoRequestBuilder request() {
    return new MatomoRequest.MatomoRequestBuilder();
  }

  /**
   * The ID of the website we're tracking a visit/action for. Only needed, if no default site id is
   * configured.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getRequired() {
    return this.required;
  }

  /**
   * The ID of the website we're tracking a visit/action for. Only needed, if no default site id is
   * configured.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getSiteId() {
    return this.siteId;
  }

  /**
   * The title of the action being tracked. For page tracks this is used as page title. If enabled
   * in your installation you may use the category tree structure in this field. For example, "game
   * / register new user" would then create a group "game" and add the item "register new user" in
   * it.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getActionName() {
    return this.actionName;
  }

  /**
   * The full URL for the current action.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getActionUrl() {
    return this.actionUrl;
  }

  /**
   * Defines the API version to use (default: 1).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getApiVersion() {
    return this.apiVersion;
  }

  /**
   * The unique visitor ID. See {@link VisitorId}. Default is {@link VisitorId#random()}
   *
   * <p>Since version 3.0.0 this parameter is of type {@link VisitorId} and not a String anymore.
   * Use {@link VisitorId#fromHex(String)} to create a VisitorId from a hex string,
   * {@link VisitorId#fromUUID(UUID)} to create it from a UUID or {@link VisitorId#fromHash(long)}
   * to create it from a long value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public VisitorId getVisitorId() {
    return this.visitorId;
  }

  /**
   * Tracks if the visitor is a returning visitor.
   *
   * <p>This is done by storing a visitor ID in a 1st party cookie.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getNewVisitor() {
    return this.newVisitor;
  }

  /**
   * The full HTTP Referrer URL. This value is used to determine how someone got to your website
   * (ie, through a website, search engine or campaign)
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReferrerUrl() {
    return this.referrerUrl;
  }

  /**
   * Custom variables are custom name-value pairs that you can assign to your visitors (or page
   * views).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CustomVariables getVisitCustomVariables() {
    return this.visitCustomVariables;
  }

  /**
   * The current count of visits for this visitor. To set this value correctly, it would be required
   * to store the value for each visitor in your application (using sessions or persisting in a
   * database). Then you would manually increment the counts by one on each new visit or "session",
   * depending on how you choose to define a visit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getVisitorVisitCount() {
    return this.visitorVisitCount;
  }

  /**
   * The UNIX timestamp of this visitor's previous visit. This parameter is used to populate the
   * report Visitors > Engagement > Visits by days since last visit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Instant getVisitorPreviousVisitTimestamp() {
    return this.visitorPreviousVisitTimestamp;
  }

  /**
   * The UNIX timestamp of this visitor's first visit. This could be set to the date where the user
   * first started using your software/app, or when he/she created an account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Instant getVisitorFirstVisitTimestamp() {
    return this.visitorFirstVisitTimestamp;
  }

  /**
   * The campaign name. This parameter will only be used for the first pageview of a visit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCampaignName() {
    return this.campaignName;
  }

  /**
   * The campaign keyword (see
   * <a href="https://matomo.org/docs/tracking-campaigns/">Tracking Campaigns</a>). Used to
   * populate the <em>Referrers &gt; Campaigns</em> report (clicking on a campaign loads all
   * keywords for this campaign). This parameter will only be used for the first pageview of a
   * visit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCampaignKeyword() {
    return this.campaignKeyword;
  }

  /**
   * The resolution of the device the visitor is using.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DeviceResolution getDeviceResolution() {
    return this.deviceResolution;
  }

  /**
   * The current hour (local time).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getCurrentHour() {
    return this.currentHour;
  }

  /**
   * The current minute (local time).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getCurrentMinute() {
    return this.currentMinute;
  }

  /**
   * The current second (local time).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getCurrentSecond() {
    return this.currentSecond;
  }

  /**
   * Does the visitor use the Adobe Flash Plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPluginFlash() {
    return this.pluginFlash;
  }

  /**
   * Does the visitor use the Java plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPluginJava() {
    return this.pluginJava;
  }

  /**
   * Does the visitor use Director plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPluginDirector() {
    return this.pluginDirector;
  }

  /**
   * Does the visitor use Quicktime plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPluginQuicktime() {
    return this.pluginQuicktime;
  }

  /**
   * Does the visitor use Realplayer plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPluginRealPlayer() {
    return this.pluginRealPlayer;
  }

  /**
   * Does the visitor use a PDF plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPluginPDF() {
    return this.pluginPDF;
  }

  /**
   * Does the visitor use a Windows Media plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPluginWindowsMedia() {
    return this.pluginWindowsMedia;
  }

  /**
   * Does the visitor use a Gears plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPluginGears() {
    return this.pluginGears;
  }

  /**
   * Does the visitor use a Silverlight plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPluginSilverlight() {
    return this.pluginSilverlight;
  }

  /**
   * Does the visitor's client is known to support cookies.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getSupportsCookies() {
    return this.supportsCookies;
  }

  /**
   * An override value for the User-Agent HTTP header field.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHeaderUserAgent() {
    return this.headerUserAgent;
  }

  /**
   * An override value for the Accept-Language HTTP header field. This value is used to detect the
   * visitor's country if GeoIP is not enabled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AcceptLanguage getHeaderAcceptLanguage() {
    return this.headerAcceptLanguage;
  }

  /**
   * Defines the User ID for this request. User ID is any non-empty unique string identifying the
   * user (such as an email address or a username). When specified, the User ID will be "enforced".
   * This means that if there is no recent visit with this User ID, a new one will be created. If a
   * visit is found in the last 30 minutes with your specified User ID, then the new action will be
   * recorded to this existing visit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUserId() {
    return this.userId;
  }

  /**
   * defines the visitor ID for this request.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public VisitorId getVisitorCustomId() {
    return this.visitorCustomId;
  }

  /**
   * will force a new visit to be created for this action.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getNewVisit() {
    return this.newVisit;
  }

  /**
   * Custom variables are custom name-value pairs that you can assign to your visitors (or page
   * views).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CustomVariables getPageCustomVariables() {
    return this.pageCustomVariables;
  }

  /**
   * An external URL the user has opened. Used for tracking outlink clicks. We recommend to also set
   * the url parameter to this same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getOutlinkUrl() {
    return this.outlinkUrl;
  }

  /**
   * URL of a file the user has downloaded. Used for tracking downloads. We recommend to also set
   * the url parameter to this same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDownloadUrl() {
    return this.downloadUrl;
  }

  /**
   * The Site Search keyword. When specified, the request will not be tracked as a normal pageview
   * but will instead be tracked as a Site Search request
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSearchQuery() {
    return this.searchQuery;
  }

  /**
   * When search is specified, you can optionally specify a search category with this parameter.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSearchCategory() {
    return this.searchCategory;
  }

  /**
   * When search is specified, we also recommend setting the search_count to the number of search
   * results displayed on the results page. When keywords are tracked with &search_count=0 they will
   * appear in the "No Result Search Keyword" report.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getSearchResultsCount() {
    return this.searchResultsCount;
  }

  /**
   * Accepts a six character unique ID that identifies which actions were performed on a specific
   * page view. When a page was viewed, all following tracking requests (such as events) during that
   * page view should use the same pageview ID. Once another page was viewed a new unique ID should
   * be generated. Use [0-9a-Z] as possible characters for the unique ID.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public UniqueId getPageViewId() {
    return this.pageViewId;
  }

  /**
   * If specified, the tracking request will trigger a conversion for the goal of the website being
   * tracked with this ID. The value 0 tracks an ecommerce interaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getGoalId() {
    return this.goalId;
  }

  /**
   * The grand total for the ecommerce order (required when tracking an ecommerce order).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Double getEcommerceRevenue() {
    return this.ecommerceRevenue;
  }

  /**
   * The charset of the page being tracked. Specify the charset if the data you send to Matomo is
   * encoded in a different character set than the default utf-8
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Charset getCharacterSet() {
    return this.characterSet;
  }

  /**
   * can be optionally sent along any tracking request that isn't a page view. For example, it can
   * be sent together with an event tracking request. The advantage being that should you ever
   * disable the event plugin, then the event tracking requests will be ignored vs if the parameter
   * is not set, a page view would be tracked even though it isn't a page view.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getCustomAction() {
    return this.customAction;
  }

  /**
   * How long it took to connect to server.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getNetworkTime() {
    return this.networkTime;
  }

  /**
   * How long it took the server to generate page.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getServerTime() {
    return this.serverTime;
  }

  /**
   * How long it takes the browser to download the response from the server.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTransferTime() {
    return this.transferTime;
  }

  /**
   * How long the browser spends loading the webpage after the response was fully received until the
   * user can start interacting with it.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getDomProcessingTime() {
    return this.domProcessingTime;
  }

  /**
   * How long it takes for the browser to load media and execute any Javascript code listening for
   * the DOMContentLoaded event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getDomCompletionTime() {
    return this.domCompletionTime;
  }

  /**
   * How long it takes the browser to execute Javascript code waiting for the window.load event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getOnloadTime() {
    return this.onloadTime;
  }

  /**
   * eg. Videos, Music, Games...
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEventCategory() {
    return this.eventCategory;
  }

  /**
   * An event action like Play, Pause, Duration, Add Playlist, Downloaded, Clicked...
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEventAction() {
    return this.eventAction;
  }

  /**
   * The event name for example a Movie name, or Song name, or File name...
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEventName() {
    return this.eventName;
  }

  /**
   * Some numeric value that represents the event value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Double getEventValue() {
    return this.eventValue;
  }

  /**
   * The name of the content. For instance 'Ad Foo Bar'
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getContentName() {
    return this.contentName;
  }

  /**
   * The actual content piece. For instance the path to an image, video, audio, any text
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getContentPiece() {
    return this.contentPiece;
  }

  /**
   * The target of the content. For instance the URL of a landing page
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getContentTarget() {
    return this.contentTarget;
  }

  /**
   * The name of the interaction with the content. For instance a 'click'
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getContentInteraction() {
    return this.contentInteraction;
  }

  /**
   * The unique string identifier for the ecommerce order (required when tracking an ecommerce
   * order).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEcommerceId() {
    return this.ecommerceId;
  }

  /**
   * Items in the Ecommerce order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EcommerceItems getEcommerceItems() {
    return this.ecommerceItems;
  }

  /**
   * The subtotal of the order; excludes shipping.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Double getEcommerceSubtotal() {
    return this.ecommerceSubtotal;
  }

  /**
   * Tax amount of the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Double getEcommerceTax() {
    return this.ecommerceTax;
  }

  /**
   * Shipping cost of the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Double getEcommerceShippingCost() {
    return this.ecommerceShippingCost;
  }

  /**
   * Discount offered.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Double getEcommerceDiscount() {
    return this.ecommerceDiscount;
  }

  /**
   * The UNIX timestamp of this customer's last ecommerce order. This value is used to process the
   * "Days since last order" report.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Instant getEcommerceLastOrderTimestamp() {
    return this.ecommerceLastOrderTimestamp;
  }

  /**
   * 32 character authorization key used to authenticate the API request. We recommend to create a
   * user specifically for accessing the Tracking API, and give the user only write permission on
   * the website(s).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAuthToken() {
    return this.authToken;
  }

  /**
   * Override value for the visitor IP (both IPv4 and IPv6 notations supported).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getVisitorIp() {
    return this.visitorIp;
  }

  /**
   * Override for the datetime of the request (normally the current time is used). This can be used
   * to record visits and page views in the past.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Instant getRequestTimestamp() {
    return this.requestTimestamp;
  }

  /**
   * An override value for the country. Must be a two-letter ISO 3166 Alpha-2 country code.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Country getVisitorCountry() {
    return this.visitorCountry;
  }

  /**
   * An override value for the region. Should be set to a ISO 3166-2 region code, which are used by
   * MaxMind's and DB-IP's GeoIP2 databases. See here for a list of them for every country.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getVisitorRegion() {
    return this.visitorRegion;
  }

  /**
   * An override value for the city. The name of the city the visitor is located in, eg, Tokyo.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getVisitorCity() {
    return this.visitorCity;
  }

  /**
   * An override value for the visitor's latitude, eg 22.456.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Double getVisitorLatitude() {
    return this.visitorLatitude;
  }

  /**
   * An override value for the visitor's longitude, eg 22.456.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Double getVisitorLongitude() {
    return this.visitorLongitude;
  }

  /**
   * When set to false, the queued tracking handler won't be used and instead the tracking request
   * will be executed directly. This can be useful when you need to debug a tracking problem or want
   * to test that the tracking works in general.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getQueuedTracking() {
    return this.queuedTracking;
  }

  /**
   * If set to 0 (send_image=0) Matomo will respond with an HTTP 204 response code instead of a GIF
   * image. This improves performance and can fix errors if images are not allowed to be obtained
   * directly (like Chrome Apps). Available since Matomo 2.10.0
   *
   * <p>Default is {@code false}
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getResponseAsImage() {
    return this.responseAsImage;
  }

  /**
   * If set to true, the request will be a Heartbeat request which will not track any new activity
   * (such as a new visit, new action or new goal). The heartbeat request will only update the
   * visit's total time to provide accurate "Visit duration" metric when this parameter is set. It
   * won't record any other data. This means by sending an additional tracking request when the user
   * leaves your site or app with &ping=1, you fix the issue where the time spent of the last page
   * visited is reported as 0 seconds.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPing() {
    return this.ping;
  }

  /**
   * By default, Matomo does not track bots. If you use the Tracking HTTP API directly, you may be
   * interested in tracking bot requests.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getTrackBotRequests() {
    return this.trackBotRequests;
  }

  /**
   * Meant to hold a random value that is generated before each request. Using it helps avoid the
   * tracking request being cached by the browser or a proxy.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public RandomValue getRandomValue() {
    return this.randomValue;
  }

  /**
   * Meant to hold a random value that is generated before each request. Using it helps avoid the
   * tracking request being cached by the browser or a proxy.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDebug() {
    return this.debug;
  }

  /**
   * Contains an error message describing the error that occurred during the last tracking request.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Required for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCrashMessage() {
    return this.crashMessage;
  }

  /**
   * The type of exception that occurred during the last tracking request.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Typically a fully qualified class name of the exception, e.g.
   * {@code java.lang.NullPointerException}.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCrashType() {
    return this.crashType;
  }

  /**
   * Category of a crash to group crashes by.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCrashCategory() {
    return this.crashCategory;
  }

  /**
   * A stack trace of the exception that occurred during the last tracking request.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCrashStackTrace() {
    return this.crashStackTrace;
  }

  /**
   * The originating source of the crash.
   *
   * <p>Could be a source file URI or something similar
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCrashLocation() {
    return this.crashLocation;
  }

  /**
   * The line number of the crash source, where the crash occurred.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getCrashLine() {
    return this.crashLine;
  }

  /**
   * The column within the line where the crash occurred.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getCrashColumn() {
    return this.crashColumn;
  }

  /**
   * The Matomo session ID sent as a cookie {@code MATOMO_SESSID}.
   *
   * <p>If not null a cookie with the name {@code MATOMO_SESSID} will be sent with the value of
   * this parameter.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSessionId() {
    return this.sessionId;
  }

  /**
   * Custom Dimension values for specific Custom Dimension IDs.
   *
   * <p><a href="https://plugins.matomo.org/CustomDimensions">Custom Dimensions plugin</a> must be
   * installed. See the
   * <a href="https://matomo.org/docs/custom-dimensions/">Custom Dimensions guide</a>. Requires
   * Matomo at least 2.15.1
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<Long, Object> getDimensions() {
    return this.dimensions;
  }

  /**
   * Allows you to specify additional HTTP request parameters that will be sent to Matomo.
   *
   * <p>For example, you can use this to set the <em>Accept-Language</em> header, or to set the
   * <em>Content-Type</em>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Object> getAdditionalParameters() {
    return this.additionalParameters;
  }

  /**
   * You can set additional HTTP headers for the request sent to Matomo.
   *
   * <p>For example, you can use this to set the <em>Accept-Language</em> header, or to set the
   * <em>Content-Type</em>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getHeaders() {
    return this.headers;
  }

  /**
   * Appends additional cookies to the request.
   *
   * <p>This allows you to add Matomo specific cookies, like {@code _pk_id} or {@code _pk_sess}
   * coming from Matomo responses to the request.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getCookies() {
    return this.cookies;
  }

  /**
   * The ID of the website we're tracking a visit/action for. Only needed, if no default site id is
   * configured.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequired(final Boolean required) {
    this.required = required;
  }

  /**
   * The ID of the website we're tracking a visit/action for. Only needed, if no default site id is
   * configured.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSiteId(final Integer siteId) {
    this.siteId = siteId;
  }

  /**
   * The title of the action being tracked. For page tracks this is used as page title. If enabled
   * in your installation you may use the category tree structure in this field. For example, "game
   * / register new user" would then create a group "game" and add the item "register new user" in
   * it.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActionName(final String actionName) {
    this.actionName = actionName;
  }

  /**
   * The full URL for the current action.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActionUrl(final String actionUrl) {
    this.actionUrl = actionUrl;
  }

  /**
   * Defines the API version to use (default: 1).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApiVersion(final String apiVersion) {
    this.apiVersion = apiVersion;
  }

  /**
   * The unique visitor ID. See {@link VisitorId}. Default is {@link VisitorId#random()}
   *
   * <p>Since version 3.0.0 this parameter is of type {@link VisitorId} and not a String anymore.
   * Use {@link VisitorId#fromHex(String)} to create a VisitorId from a hex string,
   * {@link VisitorId#fromUUID(UUID)} to create it from a UUID or {@link VisitorId#fromHash(long)}
   * to create it from a long value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitorId(final VisitorId visitorId) {
    this.visitorId = visitorId;
  }

  /**
   * Tracks if the visitor is a returning visitor.
   *
   * <p>This is done by storing a visitor ID in a 1st party cookie.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNewVisitor(final Boolean newVisitor) {
    this.newVisitor = newVisitor;
  }

  /**
   * The full HTTP Referrer URL. This value is used to determine how someone got to your website
   * (ie, through a website, search engine or campaign)
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReferrerUrl(final String referrerUrl) {
    this.referrerUrl = referrerUrl;
  }

  /**
   * Custom variables are custom name-value pairs that you can assign to your visitors (or page
   * views).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitCustomVariables(final CustomVariables visitCustomVariables) {
    this.visitCustomVariables = visitCustomVariables;
  }

  /**
   * The current count of visits for this visitor. To set this value correctly, it would be required
   * to store the value for each visitor in your application (using sessions or persisting in a
   * database). Then you would manually increment the counts by one on each new visit or "session",
   * depending on how you choose to define a visit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitorVisitCount(final Integer visitorVisitCount) {
    this.visitorVisitCount = visitorVisitCount;
  }

  /**
   * The UNIX timestamp of this visitor's previous visit. This parameter is used to populate the
   * report Visitors > Engagement > Visits by days since last visit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitorPreviousVisitTimestamp(final Instant visitorPreviousVisitTimestamp) {
    this.visitorPreviousVisitTimestamp = visitorPreviousVisitTimestamp;
  }

  /**
   * The UNIX timestamp of this visitor's first visit. This could be set to the date where the user
   * first started using your software/app, or when he/she created an account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitorFirstVisitTimestamp(final Instant visitorFirstVisitTimestamp) {
    this.visitorFirstVisitTimestamp = visitorFirstVisitTimestamp;
  }

  /**
   * The campaign name. This parameter will only be used for the first pageview of a visit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCampaignName(final String campaignName) {
    this.campaignName = campaignName;
  }

  /**
   * The campaign keyword (see
   * <a href="https://matomo.org/docs/tracking-campaigns/">Tracking Campaigns</a>). Used to
   * populate the <em>Referrers &gt; Campaigns</em> report (clicking on a campaign loads all
   * keywords for this campaign). This parameter will only be used for the first pageview of a
   * visit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCampaignKeyword(final String campaignKeyword) {
    this.campaignKeyword = campaignKeyword;
  }

  /**
   * The resolution of the device the visitor is using.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeviceResolution(final DeviceResolution deviceResolution) {
    this.deviceResolution = deviceResolution;
  }

  /**
   * The current hour (local time).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrentHour(final Integer currentHour) {
    this.currentHour = currentHour;
  }

  /**
   * The current minute (local time).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrentMinute(final Integer currentMinute) {
    this.currentMinute = currentMinute;
  }

  /**
   * The current second (local time).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrentSecond(final Integer currentSecond) {
    this.currentSecond = currentSecond;
  }

  /**
   * Does the visitor use the Adobe Flash Plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPluginFlash(final Boolean pluginFlash) {
    this.pluginFlash = pluginFlash;
  }

  /**
   * Does the visitor use the Java plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPluginJava(final Boolean pluginJava) {
    this.pluginJava = pluginJava;
  }

  /**
   * Does the visitor use Director plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPluginDirector(final Boolean pluginDirector) {
    this.pluginDirector = pluginDirector;
  }

  /**
   * Does the visitor use Quicktime plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPluginQuicktime(final Boolean pluginQuicktime) {
    this.pluginQuicktime = pluginQuicktime;
  }

  /**
   * Does the visitor use Realplayer plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPluginRealPlayer(final Boolean pluginRealPlayer) {
    this.pluginRealPlayer = pluginRealPlayer;
  }

  /**
   * Does the visitor use a PDF plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPluginPDF(final Boolean pluginPDF) {
    this.pluginPDF = pluginPDF;
  }

  /**
   * Does the visitor use a Windows Media plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPluginWindowsMedia(final Boolean pluginWindowsMedia) {
    this.pluginWindowsMedia = pluginWindowsMedia;
  }

  /**
   * Does the visitor use a Gears plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPluginGears(final Boolean pluginGears) {
    this.pluginGears = pluginGears;
  }

  /**
   * Does the visitor use a Silverlight plugin.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPluginSilverlight(final Boolean pluginSilverlight) {
    this.pluginSilverlight = pluginSilverlight;
  }

  /**
   * Does the visitor's client is known to support cookies.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportsCookies(final Boolean supportsCookies) {
    this.supportsCookies = supportsCookies;
  }

  /**
   * An override value for the User-Agent HTTP header field.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHeaderUserAgent(final String headerUserAgent) {
    this.headerUserAgent = headerUserAgent;
  }

  /**
   * An override value for the Accept-Language HTTP header field. This value is used to detect the
   * visitor's country if GeoIP is not enabled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHeaderAcceptLanguage(final AcceptLanguage headerAcceptLanguage) {
    this.headerAcceptLanguage = headerAcceptLanguage;
  }

  /**
   * Defines the User ID for this request. User ID is any non-empty unique string identifying the
   * user (such as an email address or a username). When specified, the User ID will be "enforced".
   * This means that if there is no recent visit with this User ID, a new one will be created. If a
   * visit is found in the last 30 minutes with your specified User ID, then the new action will be
   * recorded to this existing visit.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUserId(final String userId) {
    this.userId = userId;
  }

  /**
   * defines the visitor ID for this request.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitorCustomId(final VisitorId visitorCustomId) {
    this.visitorCustomId = visitorCustomId;
  }

  /**
   * will force a new visit to be created for this action.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNewVisit(final Boolean newVisit) {
    this.newVisit = newVisit;
  }

  /**
   * Custom variables are custom name-value pairs that you can assign to your visitors (or page
   * views).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPageCustomVariables(final CustomVariables pageCustomVariables) {
    this.pageCustomVariables = pageCustomVariables;
  }

  /**
   * An external URL the user has opened. Used for tracking outlink clicks. We recommend to also set
   * the url parameter to this same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlinkUrl(final String outlinkUrl) {
    this.outlinkUrl = outlinkUrl;
  }

  /**
   * URL of a file the user has downloaded. Used for tracking downloads. We recommend to also set
   * the url parameter to this same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDownloadUrl(final String downloadUrl) {
    this.downloadUrl = downloadUrl;
  }

  /**
   * The Site Search keyword. When specified, the request will not be tracked as a normal pageview
   * but will instead be tracked as a Site Search request
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSearchQuery(final String searchQuery) {
    this.searchQuery = searchQuery;
  }

  /**
   * When search is specified, you can optionally specify a search category with this parameter.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSearchCategory(final String searchCategory) {
    this.searchCategory = searchCategory;
  }

  /**
   * When search is specified, we also recommend setting the search_count to the number of search
   * results displayed on the results page. When keywords are tracked with &search_count=0 they will
   * appear in the "No Result Search Keyword" report.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSearchResultsCount(final Long searchResultsCount) {
    this.searchResultsCount = searchResultsCount;
  }

  /**
   * Accepts a six character unique ID that identifies which actions were performed on a specific
   * page view. When a page was viewed, all following tracking requests (such as events) during that
   * page view should use the same pageview ID. Once another page was viewed a new unique ID should
   * be generated. Use [0-9a-Z] as possible characters for the unique ID.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPageViewId(final UniqueId pageViewId) {
    this.pageViewId = pageViewId;
  }

  /**
   * If specified, the tracking request will trigger a conversion for the goal of the website being
   * tracked with this ID. The value 0 tracks an ecommerce interaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setGoalId(final Integer goalId) {
    this.goalId = goalId;
  }

  /**
   * The grand total for the ecommerce order (required when tracking an ecommerce order).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEcommerceRevenue(final Double ecommerceRevenue) {
    this.ecommerceRevenue = ecommerceRevenue;
  }

  /**
   * The charset of the page being tracked. Specify the charset if the data you send to Matomo is
   * encoded in a different character set than the default utf-8
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCharacterSet(final Charset characterSet) {
    this.characterSet = characterSet;
  }

  /**
   * can be optionally sent along any tracking request that isn't a page view. For example, it can
   * be sent together with an event tracking request. The advantage being that should you ever
   * disable the event plugin, then the event tracking requests will be ignored vs if the parameter
   * is not set, a page view would be tracked even though it isn't a page view.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomAction(final Boolean customAction) {
    this.customAction = customAction;
  }

  /**
   * How long it took to connect to server.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNetworkTime(final Long networkTime) {
    this.networkTime = networkTime;
  }

  /**
   * How long it took the server to generate page.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServerTime(final Long serverTime) {
    this.serverTime = serverTime;
  }

  /**
   * How long it takes the browser to download the response from the server.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferTime(final Long transferTime) {
    this.transferTime = transferTime;
  }

  /**
   * How long the browser spends loading the webpage after the response was fully received until the
   * user can start interacting with it.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDomProcessingTime(final Long domProcessingTime) {
    this.domProcessingTime = domProcessingTime;
  }

  /**
   * How long it takes for the browser to load media and execute any Javascript code listening for
   * the DOMContentLoaded event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDomCompletionTime(final Long domCompletionTime) {
    this.domCompletionTime = domCompletionTime;
  }

  /**
   * How long it takes the browser to execute Javascript code waiting for the window.load event.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOnloadTime(final Long onloadTime) {
    this.onloadTime = onloadTime;
  }

  /**
   * eg. Videos, Music, Games...
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEventCategory(final String eventCategory) {
    this.eventCategory = eventCategory;
  }

  /**
   * An event action like Play, Pause, Duration, Add Playlist, Downloaded, Clicked...
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEventAction(final String eventAction) {
    this.eventAction = eventAction;
  }

  /**
   * The event name for example a Movie name, or Song name, or File name...
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEventName(final String eventName) {
    this.eventName = eventName;
  }

  /**
   * Some numeric value that represents the event value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEventValue(final Double eventValue) {
    this.eventValue = eventValue;
  }

  /**
   * The name of the content. For instance 'Ad Foo Bar'
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setContentName(final String contentName) {
    this.contentName = contentName;
  }

  /**
   * The actual content piece. For instance the path to an image, video, audio, any text
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setContentPiece(final String contentPiece) {
    this.contentPiece = contentPiece;
  }

  /**
   * The target of the content. For instance the URL of a landing page
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setContentTarget(final String contentTarget) {
    this.contentTarget = contentTarget;
  }

  /**
   * The name of the interaction with the content. For instance a 'click'
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setContentInteraction(final String contentInteraction) {
    this.contentInteraction = contentInteraction;
  }

  /**
   * The unique string identifier for the ecommerce order (required when tracking an ecommerce
   * order).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEcommerceId(final String ecommerceId) {
    this.ecommerceId = ecommerceId;
  }

  /**
   * Items in the Ecommerce order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEcommerceItems(final EcommerceItems ecommerceItems) {
    this.ecommerceItems = ecommerceItems;
  }

  /**
   * The subtotal of the order; excludes shipping.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEcommerceSubtotal(final Double ecommerceSubtotal) {
    this.ecommerceSubtotal = ecommerceSubtotal;
  }

  /**
   * Tax amount of the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEcommerceTax(final Double ecommerceTax) {
    this.ecommerceTax = ecommerceTax;
  }

  /**
   * Shipping cost of the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEcommerceShippingCost(final Double ecommerceShippingCost) {
    this.ecommerceShippingCost = ecommerceShippingCost;
  }

  /**
   * Discount offered.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEcommerceDiscount(final Double ecommerceDiscount) {
    this.ecommerceDiscount = ecommerceDiscount;
  }

  /**
   * The UNIX timestamp of this customer's last ecommerce order. This value is used to process the
   * "Days since last order" report.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEcommerceLastOrderTimestamp(final Instant ecommerceLastOrderTimestamp) {
    this.ecommerceLastOrderTimestamp = ecommerceLastOrderTimestamp;
  }

  /**
   * 32 character authorization key used to authenticate the API request. We recommend to create a
   * user specifically for accessing the Tracking API, and give the user only write permission on
   * the website(s).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAuthToken(final String authToken) {
    this.authToken = authToken;
  }

  /**
   * Override value for the visitor IP (both IPv4 and IPv6 notations supported).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitorIp(final String visitorIp) {
    this.visitorIp = visitorIp;
  }

  /**
   * Override for the datetime of the request (normally the current time is used). This can be used
   * to record visits and page views in the past.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequestTimestamp(final Instant requestTimestamp) {
    this.requestTimestamp = requestTimestamp;
  }

  /**
   * An override value for the country. Must be a two-letter ISO 3166 Alpha-2 country code.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitorCountry(final Country visitorCountry) {
    this.visitorCountry = visitorCountry;
  }

  /**
   * An override value for the region. Should be set to a ISO 3166-2 region code, which are used by
   * MaxMind's and DB-IP's GeoIP2 databases. See here for a list of them for every country.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitorRegion(final String visitorRegion) {
    this.visitorRegion = visitorRegion;
  }

  /**
   * An override value for the city. The name of the city the visitor is located in, eg, Tokyo.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitorCity(final String visitorCity) {
    this.visitorCity = visitorCity;
  }

  /**
   * An override value for the visitor's latitude, eg 22.456.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitorLatitude(final Double visitorLatitude) {
    this.visitorLatitude = visitorLatitude;
  }

  /**
   * An override value for the visitor's longitude, eg 22.456.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVisitorLongitude(final Double visitorLongitude) {
    this.visitorLongitude = visitorLongitude;
  }

  /**
   * When set to false, the queued tracking handler won't be used and instead the tracking request
   * will be executed directly. This can be useful when you need to debug a tracking problem or want
   * to test that the tracking works in general.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setQueuedTracking(final Boolean queuedTracking) {
    this.queuedTracking = queuedTracking;
  }

  /**
   * If set to 0 (send_image=0) Matomo will respond with an HTTP 204 response code instead of a GIF
   * image. This improves performance and can fix errors if images are not allowed to be obtained
   * directly (like Chrome Apps). Available since Matomo 2.10.0
   *
   * <p>Default is {@code false}
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setResponseAsImage(final Boolean responseAsImage) {
    this.responseAsImage = responseAsImage;
  }

  /**
   * If set to true, the request will be a Heartbeat request which will not track any new activity
   * (such as a new visit, new action or new goal). The heartbeat request will only update the
   * visit's total time to provide accurate "Visit duration" metric when this parameter is set. It
   * won't record any other data. This means by sending an additional tracking request when the user
   * leaves your site or app with &ping=1, you fix the issue where the time spent of the last page
   * visited is reported as 0 seconds.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPing(final Boolean ping) {
    this.ping = ping;
  }

  /**
   * By default, Matomo does not track bots. If you use the Tracking HTTP API directly, you may be
   * interested in tracking bot requests.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTrackBotRequests(final Boolean trackBotRequests) {
    this.trackBotRequests = trackBotRequests;
  }

  /**
   * Meant to hold a random value that is generated before each request. Using it helps avoid the
   * tracking request being cached by the browser or a proxy.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRandomValue(final RandomValue randomValue) {
    this.randomValue = randomValue;
  }

  /**
   * Meant to hold a random value that is generated before each request. Using it helps avoid the
   * tracking request being cached by the browser or a proxy.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDebug(final Boolean debug) {
    this.debug = debug;
  }

  /**
   * Contains an error message describing the error that occurred during the last tracking request.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Required for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCrashMessage(final String crashMessage) {
    this.crashMessage = crashMessage;
  }

  /**
   * The type of exception that occurred during the last tracking request.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Typically a fully qualified class name of the exception, e.g.
   * {@code java.lang.NullPointerException}.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCrashType(final String crashType) {
    this.crashType = crashType;
  }

  /**
   * Category of a crash to group crashes by.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCrashCategory(final String crashCategory) {
    this.crashCategory = crashCategory;
  }

  /**
   * A stack trace of the exception that occurred during the last tracking request.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCrashStackTrace(final String crashStackTrace) {
    this.crashStackTrace = crashStackTrace;
  }

  /**
   * The originating source of the crash.
   *
   * <p>Could be a source file URI or something similar
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCrashLocation(final String crashLocation) {
    this.crashLocation = crashLocation;
  }

  /**
   * The line number of the crash source, where the crash occurred.
   *
   * <p>Custom action must be enabled for this.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCrashLine(final Integer crashLine) {
    this.crashLine = crashLine;
  }

  /**
   * The column within the line where the crash occurred.
   *
   * <p>Optional for crash analytics
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCrashColumn(final Integer crashColumn) {
    this.crashColumn = crashColumn;
  }

  /**
   * The Matomo session ID sent as a cookie {@code MATOMO_SESSID}.
   *
   * <p>If not null a cookie with the name {@code MATOMO_SESSID} will be sent with the value of
   * this parameter.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSessionId(final String sessionId) {
    this.sessionId = sessionId;
  }

  /**
   * Custom Dimension values for specific Custom Dimension IDs.
   *
   * <p><a href="https://plugins.matomo.org/CustomDimensions">Custom Dimensions plugin</a> must be
   * installed. See the
   * <a href="https://matomo.org/docs/custom-dimensions/">Custom Dimensions guide</a>. Requires
   * Matomo at least 2.15.1
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDimensions(final Map<Long, Object> dimensions) {
    this.dimensions = dimensions;
  }

  /**
   * Allows you to specify additional HTTP request parameters that will be sent to Matomo.
   *
   * <p>For example, you can use this to set the <em>Accept-Language</em> header, or to set the
   * <em>Content-Type</em>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdditionalParameters(final Map<String, Object> additionalParameters) {
    this.additionalParameters = additionalParameters;
  }

  /**
   * You can set additional HTTP headers for the request sent to Matomo.
   *
   * <p>For example, you can use this to set the <em>Accept-Language</em> header, or to set the
   * <em>Content-Type</em>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHeaders(final Map<String, String> headers) {
    this.headers = headers;
  }

  /**
   * Appends additional cookies to the request.
   *
   * <p>This allows you to add Matomo specific cookies, like {@code _pk_id} or {@code _pk_sess}
   * coming from Matomo responses to the request.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCookies(final Map<String, String> cookies) {
    this.cookies = cookies;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public MatomoRequest() {
    this.required = MatomoRequest.$default$required();
    this.apiVersion = MatomoRequest.$default$apiVersion();
    this.visitorId = MatomoRequest.$default$visitorId();
    this.responseAsImage = MatomoRequest.$default$responseAsImage();
    this.randomValue = MatomoRequest.$default$randomValue();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public MatomoRequest(final Boolean required, final Integer siteId, final String actionName, final String actionUrl, final String apiVersion, final VisitorId visitorId, final Boolean newVisitor, final String referrerUrl, final CustomVariables visitCustomVariables, final Integer visitorVisitCount, final Instant visitorPreviousVisitTimestamp, final Instant visitorFirstVisitTimestamp, final String campaignName, final String campaignKeyword, final DeviceResolution deviceResolution, final Integer currentHour, final Integer currentMinute, final Integer currentSecond, final Boolean pluginFlash, final Boolean pluginJava, final Boolean pluginDirector, final Boolean pluginQuicktime, final Boolean pluginRealPlayer, final Boolean pluginPDF, final Boolean pluginWindowsMedia, final Boolean pluginGears, final Boolean pluginSilverlight, final Boolean supportsCookies, final String headerUserAgent, final AcceptLanguage headerAcceptLanguage, final String userId, final VisitorId visitorCustomId, final Boolean newVisit, final CustomVariables pageCustomVariables, final String outlinkUrl, final String downloadUrl, final String searchQuery, final String searchCategory, final Long searchResultsCount, final UniqueId pageViewId, final Integer goalId, final Double ecommerceRevenue, final Charset characterSet, final Boolean customAction, final Long networkTime, final Long serverTime, final Long transferTime, final Long domProcessingTime, final Long domCompletionTime, final Long onloadTime, final String eventCategory, final String eventAction, final String eventName, final Double eventValue, final String contentName, final String contentPiece, final String contentTarget, final String contentInteraction, final String ecommerceId, final EcommerceItems ecommerceItems, final Double ecommerceSubtotal, final Double ecommerceTax, final Double ecommerceShippingCost, final Double ecommerceDiscount, final Instant ecommerceLastOrderTimestamp, final String authToken, final String visitorIp, final Instant requestTimestamp, final Country visitorCountry, final String visitorRegion, final String visitorCity, final Double visitorLatitude, final Double visitorLongitude, final Boolean queuedTracking, final Boolean responseAsImage, final Boolean ping, final Boolean trackBotRequests, final RandomValue randomValue, final Boolean debug, final String crashMessage, final String crashType, final String crashCategory, final String crashStackTrace, final String crashLocation, final Integer crashLine, final Integer crashColumn, final String sessionId, final Map<Long, Object> dimensions, final Map<String, Object> additionalParameters, final Map<String, String> headers, final Map<String, String> cookies) {
    this.required = required;
    this.siteId = siteId;
    this.actionName = actionName;
    this.actionUrl = actionUrl;
    this.apiVersion = apiVersion;
    this.visitorId = visitorId;
    this.newVisitor = newVisitor;
    this.referrerUrl = referrerUrl;
    this.visitCustomVariables = visitCustomVariables;
    this.visitorVisitCount = visitorVisitCount;
    this.visitorPreviousVisitTimestamp = visitorPreviousVisitTimestamp;
    this.visitorFirstVisitTimestamp = visitorFirstVisitTimestamp;
    this.campaignName = campaignName;
    this.campaignKeyword = campaignKeyword;
    this.deviceResolution = deviceResolution;
    this.currentHour = currentHour;
    this.currentMinute = currentMinute;
    this.currentSecond = currentSecond;
    this.pluginFlash = pluginFlash;
    this.pluginJava = pluginJava;
    this.pluginDirector = pluginDirector;
    this.pluginQuicktime = pluginQuicktime;
    this.pluginRealPlayer = pluginRealPlayer;
    this.pluginPDF = pluginPDF;
    this.pluginWindowsMedia = pluginWindowsMedia;
    this.pluginGears = pluginGears;
    this.pluginSilverlight = pluginSilverlight;
    this.supportsCookies = supportsCookies;
    this.headerUserAgent = headerUserAgent;
    this.headerAcceptLanguage = headerAcceptLanguage;
    this.userId = userId;
    this.visitorCustomId = visitorCustomId;
    this.newVisit = newVisit;
    this.pageCustomVariables = pageCustomVariables;
    this.outlinkUrl = outlinkUrl;
    this.downloadUrl = downloadUrl;
    this.searchQuery = searchQuery;
    this.searchCategory = searchCategory;
    this.searchResultsCount = searchResultsCount;
    this.pageViewId = pageViewId;
    this.goalId = goalId;
    this.ecommerceRevenue = ecommerceRevenue;
    this.characterSet = characterSet;
    this.customAction = customAction;
    this.networkTime = networkTime;
    this.serverTime = serverTime;
    this.transferTime = transferTime;
    this.domProcessingTime = domProcessingTime;
    this.domCompletionTime = domCompletionTime;
    this.onloadTime = onloadTime;
    this.eventCategory = eventCategory;
    this.eventAction = eventAction;
    this.eventName = eventName;
    this.eventValue = eventValue;
    this.contentName = contentName;
    this.contentPiece = contentPiece;
    this.contentTarget = contentTarget;
    this.contentInteraction = contentInteraction;
    this.ecommerceId = ecommerceId;
    this.ecommerceItems = ecommerceItems;
    this.ecommerceSubtotal = ecommerceSubtotal;
    this.ecommerceTax = ecommerceTax;
    this.ecommerceShippingCost = ecommerceShippingCost;
    this.ecommerceDiscount = ecommerceDiscount;
    this.ecommerceLastOrderTimestamp = ecommerceLastOrderTimestamp;
    this.authToken = authToken;
    this.visitorIp = visitorIp;
    this.requestTimestamp = requestTimestamp;
    this.visitorCountry = visitorCountry;
    this.visitorRegion = visitorRegion;
    this.visitorCity = visitorCity;
    this.visitorLatitude = visitorLatitude;
    this.visitorLongitude = visitorLongitude;
    this.queuedTracking = queuedTracking;
    this.responseAsImage = responseAsImage;
    this.ping = ping;
    this.trackBotRequests = trackBotRequests;
    this.randomValue = randomValue;
    this.debug = debug;
    this.crashMessage = crashMessage;
    this.crashType = crashType;
    this.crashCategory = crashCategory;
    this.crashStackTrace = crashStackTrace;
    this.crashLocation = crashLocation;
    this.crashLine = crashLine;
    this.crashColumn = crashColumn;
    this.sessionId = sessionId;
    this.dimensions = dimensions;
    this.additionalParameters = additionalParameters;
    this.headers = headers;
    this.cookies = cookies;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "MatomoRequest(required=" + this.getRequired() + ", siteId=" + this.getSiteId() + ", actionName=" + this.getActionName() + ", actionUrl=" + this.getActionUrl() + ", apiVersion=" + this.getApiVersion() + ", visitorId=" + this.getVisitorId() + ", newVisitor=" + this.getNewVisitor() + ", referrerUrl=" + this.getReferrerUrl() + ", visitCustomVariables=" + this.getVisitCustomVariables() + ", visitorVisitCount=" + this.getVisitorVisitCount() + ", visitorPreviousVisitTimestamp=" + this.getVisitorPreviousVisitTimestamp() + ", visitorFirstVisitTimestamp=" + this.getVisitorFirstVisitTimestamp() + ", campaignName=" + this.getCampaignName() + ", campaignKeyword=" + this.getCampaignKeyword() + ", deviceResolution=" + this.getDeviceResolution() + ", currentHour=" + this.getCurrentHour() + ", currentMinute=" + this.getCurrentMinute() + ", currentSecond=" + this.getCurrentSecond() + ", pluginFlash=" + this.getPluginFlash() + ", pluginJava=" + this.getPluginJava() + ", pluginDirector=" + this.getPluginDirector() + ", pluginQuicktime=" + this.getPluginQuicktime() + ", pluginRealPlayer=" + this.getPluginRealPlayer() + ", pluginPDF=" + this.getPluginPDF() + ", pluginWindowsMedia=" + this.getPluginWindowsMedia() + ", pluginGears=" + this.getPluginGears() + ", pluginSilverlight=" + this.getPluginSilverlight() + ", supportsCookies=" + this.getSupportsCookies() + ", headerUserAgent=" + this.getHeaderUserAgent() + ", headerAcceptLanguage=" + this.getHeaderAcceptLanguage() + ", userId=" + this.getUserId() + ", visitorCustomId=" + this.getVisitorCustomId() + ", newVisit=" + this.getNewVisit() + ", pageCustomVariables=" + this.getPageCustomVariables() + ", outlinkUrl=" + this.getOutlinkUrl() + ", downloadUrl=" + this.getDownloadUrl() + ", searchQuery=" + this.getSearchQuery() + ", searchCategory=" + this.getSearchCategory() + ", searchResultsCount=" + this.getSearchResultsCount() + ", pageViewId=" + this.getPageViewId() + ", goalId=" + this.getGoalId() + ", ecommerceRevenue=" + this.getEcommerceRevenue() + ", characterSet=" + this.getCharacterSet() + ", customAction=" + this.getCustomAction() + ", networkTime=" + this.getNetworkTime() + ", serverTime=" + this.getServerTime() + ", transferTime=" + this.getTransferTime() + ", domProcessingTime=" + this.getDomProcessingTime() + ", domCompletionTime=" + this.getDomCompletionTime() + ", onloadTime=" + this.getOnloadTime() + ", eventCategory=" + this.getEventCategory() + ", eventAction=" + this.getEventAction() + ", eventName=" + this.getEventName() + ", eventValue=" + this.getEventValue() + ", contentName=" + this.getContentName() + ", contentPiece=" + this.getContentPiece() + ", contentTarget=" + this.getContentTarget() + ", contentInteraction=" + this.getContentInteraction() + ", ecommerceId=" + this.getEcommerceId() + ", ecommerceItems=" + this.getEcommerceItems() + ", ecommerceSubtotal=" + this.getEcommerceSubtotal() + ", ecommerceTax=" + this.getEcommerceTax() + ", ecommerceShippingCost=" + this.getEcommerceShippingCost() + ", ecommerceDiscount=" + this.getEcommerceDiscount() + ", ecommerceLastOrderTimestamp=" + this.getEcommerceLastOrderTimestamp() + ", authToken=" + this.getAuthToken() + ", visitorIp=" + this.getVisitorIp() + ", requestTimestamp=" + this.getRequestTimestamp() + ", visitorCountry=" + this.getVisitorCountry() + ", visitorRegion=" + this.getVisitorRegion() + ", visitorCity=" + this.getVisitorCity() + ", visitorLatitude=" + this.getVisitorLatitude() + ", visitorLongitude=" + this.getVisitorLongitude() + ", queuedTracking=" + this.getQueuedTracking() + ", responseAsImage=" + this.getResponseAsImage() + ", ping=" + this.getPing() + ", trackBotRequests=" + this.getTrackBotRequests() + ", randomValue=" + this.getRandomValue() + ", debug=" + this.getDebug() + ", crashMessage=" + this.getCrashMessage() + ", crashType=" + this.getCrashType() + ", crashCategory=" + this.getCrashCategory() + ", crashStackTrace=" + this.getCrashStackTrace() + ", crashLocation=" + this.getCrashLocation() + ", crashLine=" + this.getCrashLine() + ", crashColumn=" + this.getCrashColumn() + ", sessionId=" + this.getSessionId() + ", dimensions=" + this.getDimensions() + ", additionalParameters=" + this.getAdditionalParameters() + ", headers=" + this.getHeaders() + ", cookies=" + this.getCookies() + ")";
  }
}
