// Generated by delombok at Fri Apr 19 18:23:11 UTC 2024
/*
 * Matomo Java Tracker
 *
 * @link https://github.com/matomo/matomo-java-tracker
 * @license https://github.com/matomo/matomo-java-tracker/blob/master/LICENSE BSD-3 Clause
 */
package org.matomo.java.tracking;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.time.Duration;
import java.util.regex.Pattern;

/**
 * Defines configuration settings for the Matomo tracking.
 */
public final class TrackerConfiguration {
  private static final Pattern AUTH_TOKEN_PATTERN = Pattern.compile("[a-z0-9]+");
  /**
   * The Matomo Tracking HTTP API endpoint, for example https://your-matomo-domain.example/matomo.php
   */
  private final URI apiEndpoint;
  /**
   * The default ID of the website that will be used if not specified explicitly.
   */
  private final Integer defaultSiteId;
  /**
   * The authorization token (parameter token_auth) to use if not specified explicitly.
   */
  private final String defaultAuthToken;
  /**
   * Allows to stop the tracker to send requests to the Matomo endpoint.
   */
  private final boolean enabled;
  /**
   * The timeout until a connection is established.
   *
   * <p>A timeout value of zero is interpreted as an infinite timeout.
   * A `null` value is interpreted as undefined (system default if applicable).</p>
   *
   * <p>Default: 5 seconds</p>
   */
  private final Duration connectTimeout;
  /**
   * The socket timeout ({@code SO_TIMEOUT}), which is the timeout for waiting for data or, put differently, a maximum
   * period inactivity between two consecutive data packets.
   *
   * <p>A timeout value of zero is interpreted as an infinite timeout.
   * A `null value is interpreted as undefined (system default if applicable).</p>
   *
   * <p>Default: 5 seconds</p>
   */
  private final Duration socketTimeout;
  /**
   * The hostname or IP address of an optional HTTP proxy. {@code proxyPort} must be configured as well
   */
  @Nullable
  private final String proxyHost;
  /**
   * The port of an HTTP proxy. {@code proxyHost} must be configured as well.
   */
  private final int proxyPort;
  /**
   * If the HTTP proxy requires a username for basic authentication, it can be configured here. Proxy host, port and
   * password must also be set.
   */
  @Nullable
  private final String proxyUsername;
  /**
   * The corresponding password for the basic auth proxy user. The proxy host, port and username must be set as well.
   */
  @Nullable
  private final String proxyPassword;
  /**
   * A custom user agent to be set. Defaults to "MatomoJavaClient"
   */
  private final String userAgent;
  /**
   * Logs if the Matomo Tracking API endpoint responds with an erroneous HTTP code. Defaults to
   * false.
   */
  private final boolean logFailedTracking;
  /**
   * Disables SSL certificate validation. This is useful for testing with self-signed certificates.
   * Do not use in production environments. Defaults to false.
   *
   * <p>Attention: This slows down performance
   * @see #disableSslHostVerification
   */
  private final boolean disableSslCertValidation;
  /**
   * Disables SSL host verification. This is useful for testing with self-signed certificates. Do
   * not use in production environments. Defaults to false.
   *
   * <p>If you use the Java 11 of the Matomo Java Tracker, this setting is ignored. Instead, you
   * have to set the system property {@code jdk.internal.httpclient.disableHostnameVerification} as
   * described in the
   * <a href="https://download.java.net/java/early_access/jdk22/docs/api/java.net.http/module-summary.html">Module
   * java.net.http</a>.
   *
   * @see #disableSslCertValidation
   */
  private final boolean disableSslHostVerification;
  /**
   * The thread pool size for the async sender. Defaults to 2.
   *
   * <p>Attention: If you use this library in a web application, make sure that this thread pool
   * does not exceed the thread pool of the web application. Otherwise, you might run into
   * problems.
   */
  private final int threadPoolSize;

  /**
   * Validates the auth token. The auth token must be exactly 32 characters long.
   */
  public void validate() {
    if (apiEndpoint == null) {
      throw new IllegalArgumentException("API endpoint must not be null");
    }
    if (defaultAuthToken != null) {
      if (defaultAuthToken.trim().length() != 32) {
        throw new IllegalArgumentException("Auth token must be exactly 32 characters long");
      }
      if (!AUTH_TOKEN_PATTERN.matcher(defaultAuthToken).matches()) {
        throw new IllegalArgumentException("Auth token must contain only lowercase letters and numbers");
      }
    }
    if (defaultSiteId != null && defaultSiteId < 0) {
      throw new IllegalArgumentException("Default site ID must not be negative");
    }
    if (proxyHost != null && proxyPort < 1) {
      throw new IllegalArgumentException("Proxy port must be greater than 0");
    }
    if (proxyPort > 0 && proxyHost == null) {
      throw new IllegalArgumentException("Proxy host must be set if port is set");
    }
    if (proxyUsername != null && proxyHost == null) {
      throw new IllegalArgumentException("Proxy host must be set if username is set");
    }
    if (proxyPassword != null && proxyHost == null) {
      throw new IllegalArgumentException("Proxy host must be set if password is set");
    }
    if (proxyUsername != null && proxyPassword == null) {
      throw new IllegalArgumentException("Proxy password must be set if username is set");
    }
    if (proxyPassword != null && proxyUsername == null) {
      throw new IllegalArgumentException("Proxy username must be set if password is set");
    }
    if (socketTimeout != null && socketTimeout.isNegative()) {
      throw new IllegalArgumentException("Socket timeout must not be negative");
    }
    if (connectTimeout != null && connectTimeout.isNegative()) {
      throw new IllegalArgumentException("Connect timeout must not be negative");
    }
    if (threadPoolSize < 1) {
      throw new IllegalArgumentException("Thread pool size must be greater than 0");
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static boolean $default$enabled() {
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static Duration $default$connectTimeout() {
    return Duration.ofSeconds(5L);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static Duration $default$socketTimeout() {
    return Duration.ofSeconds(5L);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static String $default$userAgent() {
    return "MatomoJavaClient";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static int $default$threadPoolSize() {
    return 2;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  TrackerConfiguration(final URI apiEndpoint, final Integer defaultSiteId, final String defaultAuthToken, final boolean enabled, final Duration connectTimeout, final Duration socketTimeout, @Nullable final String proxyHost, final int proxyPort, @Nullable final String proxyUsername, @Nullable final String proxyPassword, final String userAgent, final boolean logFailedTracking, final boolean disableSslCertValidation, final boolean disableSslHostVerification, final int threadPoolSize) {
    this.apiEndpoint = apiEndpoint;
    this.defaultSiteId = defaultSiteId;
    this.defaultAuthToken = defaultAuthToken;
    this.enabled = enabled;
    this.connectTimeout = connectTimeout;
    this.socketTimeout = socketTimeout;
    this.proxyHost = proxyHost;
    this.proxyPort = proxyPort;
    this.proxyUsername = proxyUsername;
    this.proxyPassword = proxyPassword;
    this.userAgent = userAgent;
    this.logFailedTracking = logFailedTracking;
    this.disableSslCertValidation = disableSslCertValidation;
    this.disableSslHostVerification = disableSslHostVerification;
    this.threadPoolSize = threadPoolSize;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class TrackerConfigurationBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private URI apiEndpoint;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer defaultSiteId;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String defaultAuthToken;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean enabled$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean enabled$value;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean connectTimeout$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Duration connectTimeout$value;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean socketTimeout$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Duration socketTimeout$value;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String proxyHost;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private int proxyPort;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String proxyUsername;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String proxyPassword;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean userAgent$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String userAgent$value;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean logFailedTracking;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean disableSslCertValidation;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean disableSslHostVerification;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean threadPoolSize$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private int threadPoolSize$value;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    TrackerConfigurationBuilder() {
    }

    /**
     * The Matomo Tracking HTTP API endpoint, for example https://your-matomo-domain.example/matomo.php
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder apiEndpoint(final URI apiEndpoint) {
      this.apiEndpoint = apiEndpoint;
      return this;
    }

    /**
     * The default ID of the website that will be used if not specified explicitly.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder defaultSiteId(final Integer defaultSiteId) {
      this.defaultSiteId = defaultSiteId;
      return this;
    }

    /**
     * The authorization token (parameter token_auth) to use if not specified explicitly.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder defaultAuthToken(final String defaultAuthToken) {
      this.defaultAuthToken = defaultAuthToken;
      return this;
    }

    /**
     * Allows to stop the tracker to send requests to the Matomo endpoint.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder enabled(final boolean enabled) {
      this.enabled$value = enabled;
      enabled$set = true;
      return this;
    }

    /**
     * The timeout until a connection is established.
     *
     * <p>A timeout value of zero is interpreted as an infinite timeout.
     * A `null` value is interpreted as undefined (system default if applicable).</p>
     *
     * <p>Default: 5 seconds</p>
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder connectTimeout(final Duration connectTimeout) {
      this.connectTimeout$value = connectTimeout;
      connectTimeout$set = true;
      return this;
    }

    /**
     * The socket timeout ({@code SO_TIMEOUT}), which is the timeout for waiting for data or, put differently, a maximum
     * period inactivity between two consecutive data packets.
     *
     * <p>A timeout value of zero is interpreted as an infinite timeout.
     * A `null value is interpreted as undefined (system default if applicable).</p>
     *
     * <p>Default: 5 seconds</p>
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder socketTimeout(final Duration socketTimeout) {
      this.socketTimeout$value = socketTimeout;
      socketTimeout$set = true;
      return this;
    }

    /**
     * The hostname or IP address of an optional HTTP proxy. {@code proxyPort} must be configured as well
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder proxyHost(@Nullable final String proxyHost) {
      this.proxyHost = proxyHost;
      return this;
    }

    /**
     * The port of an HTTP proxy. {@code proxyHost} must be configured as well.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder proxyPort(final int proxyPort) {
      this.proxyPort = proxyPort;
      return this;
    }

    /**
     * If the HTTP proxy requires a username for basic authentication, it can be configured here. Proxy host, port and
     * password must also be set.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder proxyUsername(@Nullable final String proxyUsername) {
      this.proxyUsername = proxyUsername;
      return this;
    }

    /**
     * The corresponding password for the basic auth proxy user. The proxy host, port and username must be set as well.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder proxyPassword(@Nullable final String proxyPassword) {
      this.proxyPassword = proxyPassword;
      return this;
    }

    /**
     * A custom user agent to be set. Defaults to "MatomoJavaClient"
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder userAgent(final String userAgent) {
      this.userAgent$value = userAgent;
      userAgent$set = true;
      return this;
    }

    /**
     * Logs if the Matomo Tracking API endpoint responds with an erroneous HTTP code. Defaults to
     * false.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder logFailedTracking(final boolean logFailedTracking) {
      this.logFailedTracking = logFailedTracking;
      return this;
    }

    /**
     * Disables SSL certificate validation. This is useful for testing with self-signed certificates.
     * Do not use in production environments. Defaults to false.
     *
     * <p>Attention: This slows down performance
     * @see #disableSslHostVerification
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder disableSslCertValidation(final boolean disableSslCertValidation) {
      this.disableSslCertValidation = disableSslCertValidation;
      return this;
    }

    /**
     * Disables SSL host verification. This is useful for testing with self-signed certificates. Do
     * not use in production environments. Defaults to false.
     *
     * <p>If you use the Java 11 of the Matomo Java Tracker, this setting is ignored. Instead, you
     * have to set the system property {@code jdk.internal.httpclient.disableHostnameVerification} as
     * described in the
     * <a href="https://download.java.net/java/early_access/jdk22/docs/api/java.net.http/module-summary.html">Module
     * java.net.http</a>.
     *
     * @see #disableSslCertValidation
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder disableSslHostVerification(final boolean disableSslHostVerification) {
      this.disableSslHostVerification = disableSslHostVerification;
      return this;
    }

    /**
     * The thread pool size for the async sender. Defaults to 2.
     *
     * <p>Attention: If you use this library in a web application, make sure that this thread pool
     * does not exceed the thread pool of the web application. Otherwise, you might run into
     * problems.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration.TrackerConfigurationBuilder threadPoolSize(final int threadPoolSize) {
      this.threadPoolSize$value = threadPoolSize;
      threadPoolSize$set = true;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackerConfiguration build() {
      boolean enabled$value = this.enabled$value;
      if (!this.enabled$set) enabled$value = TrackerConfiguration.$default$enabled();
      Duration connectTimeout$value = this.connectTimeout$value;
      if (!this.connectTimeout$set) connectTimeout$value = TrackerConfiguration.$default$connectTimeout();
      Duration socketTimeout$value = this.socketTimeout$value;
      if (!this.socketTimeout$set) socketTimeout$value = TrackerConfiguration.$default$socketTimeout();
      String userAgent$value = this.userAgent$value;
      if (!this.userAgent$set) userAgent$value = TrackerConfiguration.$default$userAgent();
      int threadPoolSize$value = this.threadPoolSize$value;
      if (!this.threadPoolSize$set) threadPoolSize$value = TrackerConfiguration.$default$threadPoolSize();
      return new TrackerConfiguration(this.apiEndpoint, this.defaultSiteId, this.defaultAuthToken, enabled$value, connectTimeout$value, socketTimeout$value, this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword, userAgent$value, this.logFailedTracking, this.disableSslCertValidation, this.disableSslHostVerification, threadPoolSize$value);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "TrackerConfiguration.TrackerConfigurationBuilder(apiEndpoint=" + this.apiEndpoint + ", defaultSiteId=" + this.defaultSiteId + ", defaultAuthToken=" + this.defaultAuthToken + ", enabled$value=" + this.enabled$value + ", connectTimeout$value=" + this.connectTimeout$value + ", socketTimeout$value=" + this.socketTimeout$value + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyUsername=" + this.proxyUsername + ", proxyPassword=" + this.proxyPassword + ", userAgent$value=" + this.userAgent$value + ", logFailedTracking=" + this.logFailedTracking + ", disableSslCertValidation=" + this.disableSslCertValidation + ", disableSslHostVerification=" + this.disableSslHostVerification + ", threadPoolSize$value=" + this.threadPoolSize$value + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static TrackerConfiguration.TrackerConfigurationBuilder builder() {
    return new TrackerConfiguration.TrackerConfigurationBuilder();
  }

  /**
   * The Matomo Tracking HTTP API endpoint, for example https://your-matomo-domain.example/matomo.php
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public URI getApiEndpoint() {
    return this.apiEndpoint;
  }

  /**
   * The default ID of the website that will be used if not specified explicitly.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getDefaultSiteId() {
    return this.defaultSiteId;
  }

  /**
   * The authorization token (parameter token_auth) to use if not specified explicitly.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDefaultAuthToken() {
    return this.defaultAuthToken;
  }

  /**
   * Allows to stop the tracker to send requests to the Matomo endpoint.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isEnabled() {
    return this.enabled;
  }

  /**
   * The timeout until a connection is established.
   *
   * <p>A timeout value of zero is interpreted as an infinite timeout.
   * A `null` value is interpreted as undefined (system default if applicable).</p>
   *
   * <p>Default: 5 seconds</p>
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Duration getConnectTimeout() {
    return this.connectTimeout;
  }

  /**
   * The socket timeout ({@code SO_TIMEOUT}), which is the timeout for waiting for data or, put differently, a maximum
   * period inactivity between two consecutive data packets.
   *
   * <p>A timeout value of zero is interpreted as an infinite timeout.
   * A `null value is interpreted as undefined (system default if applicable).</p>
   *
   * <p>Default: 5 seconds</p>
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Duration getSocketTimeout() {
    return this.socketTimeout;
  }

  /**
   * The hostname or IP address of an optional HTTP proxy. {@code proxyPort} must be configured as well
   */
  @Nullable
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getProxyHost() {
    return this.proxyHost;
  }

  /**
   * The port of an HTTP proxy. {@code proxyHost} must be configured as well.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getProxyPort() {
    return this.proxyPort;
  }

  /**
   * If the HTTP proxy requires a username for basic authentication, it can be configured here. Proxy host, port and
   * password must also be set.
   */
  @Nullable
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getProxyUsername() {
    return this.proxyUsername;
  }

  /**
   * The corresponding password for the basic auth proxy user. The proxy host, port and username must be set as well.
   */
  @Nullable
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getProxyPassword() {
    return this.proxyPassword;
  }

  /**
   * A custom user agent to be set. Defaults to "MatomoJavaClient"
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUserAgent() {
    return this.userAgent;
  }

  /**
   * Logs if the Matomo Tracking API endpoint responds with an erroneous HTTP code. Defaults to
   * false.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isLogFailedTracking() {
    return this.logFailedTracking;
  }

  /**
   * Disables SSL certificate validation. This is useful for testing with self-signed certificates.
   * Do not use in production environments. Defaults to false.
   *
   * <p>Attention: This slows down performance
   * @see #disableSslHostVerification
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isDisableSslCertValidation() {
    return this.disableSslCertValidation;
  }

  /**
   * Disables SSL host verification. This is useful for testing with self-signed certificates. Do
   * not use in production environments. Defaults to false.
   *
   * <p>If you use the Java 11 of the Matomo Java Tracker, this setting is ignored. Instead, you
   * have to set the system property {@code jdk.internal.httpclient.disableHostnameVerification} as
   * described in the
   * <a href="https://download.java.net/java/early_access/jdk22/docs/api/java.net.http/module-summary.html">Module
   * java.net.http</a>.
   *
   * @see #disableSslCertValidation
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isDisableSslHostVerification() {
    return this.disableSslHostVerification;
  }

  /**
   * The thread pool size for the async sender. Defaults to 2.
   *
   * <p>Attention: If you use this library in a web application, make sure that this thread pool
   * does not exceed the thread pool of the web application. Otherwise, you might run into
   * problems.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getThreadPoolSize() {
    return this.threadPoolSize;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof TrackerConfiguration)) return false;
    final TrackerConfiguration other = (TrackerConfiguration) o;
    if (this.isEnabled() != other.isEnabled()) return false;
    if (this.getProxyPort() != other.getProxyPort()) return false;
    if (this.isLogFailedTracking() != other.isLogFailedTracking()) return false;
    if (this.isDisableSslCertValidation() != other.isDisableSslCertValidation()) return false;
    if (this.isDisableSslHostVerification() != other.isDisableSslHostVerification()) return false;
    if (this.getThreadPoolSize() != other.getThreadPoolSize()) return false;
    final java.lang.Object this$defaultSiteId = this.getDefaultSiteId();
    final java.lang.Object other$defaultSiteId = other.getDefaultSiteId();
    if (this$defaultSiteId == null ? other$defaultSiteId != null : !this$defaultSiteId.equals(other$defaultSiteId)) return false;
    final java.lang.Object this$apiEndpoint = this.getApiEndpoint();
    final java.lang.Object other$apiEndpoint = other.getApiEndpoint();
    if (this$apiEndpoint == null ? other$apiEndpoint != null : !this$apiEndpoint.equals(other$apiEndpoint)) return false;
    final java.lang.Object this$defaultAuthToken = this.getDefaultAuthToken();
    final java.lang.Object other$defaultAuthToken = other.getDefaultAuthToken();
    if (this$defaultAuthToken == null ? other$defaultAuthToken != null : !this$defaultAuthToken.equals(other$defaultAuthToken)) return false;
    final java.lang.Object this$connectTimeout = this.getConnectTimeout();
    final java.lang.Object other$connectTimeout = other.getConnectTimeout();
    if (this$connectTimeout == null ? other$connectTimeout != null : !this$connectTimeout.equals(other$connectTimeout)) return false;
    final java.lang.Object this$socketTimeout = this.getSocketTimeout();
    final java.lang.Object other$socketTimeout = other.getSocketTimeout();
    if (this$socketTimeout == null ? other$socketTimeout != null : !this$socketTimeout.equals(other$socketTimeout)) return false;
    final java.lang.Object this$proxyHost = this.getProxyHost();
    final java.lang.Object other$proxyHost = other.getProxyHost();
    if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) return false;
    final java.lang.Object this$proxyUsername = this.getProxyUsername();
    final java.lang.Object other$proxyUsername = other.getProxyUsername();
    if (this$proxyUsername == null ? other$proxyUsername != null : !this$proxyUsername.equals(other$proxyUsername)) return false;
    final java.lang.Object this$proxyPassword = this.getProxyPassword();
    final java.lang.Object other$proxyPassword = other.getProxyPassword();
    if (this$proxyPassword == null ? other$proxyPassword != null : !this$proxyPassword.equals(other$proxyPassword)) return false;
    final java.lang.Object this$userAgent = this.getUserAgent();
    final java.lang.Object other$userAgent = other.getUserAgent();
    if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) return false;
    return true;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    result = result * PRIME + (this.isEnabled() ? 79 : 97);
    result = result * PRIME + this.getProxyPort();
    result = result * PRIME + (this.isLogFailedTracking() ? 79 : 97);
    result = result * PRIME + (this.isDisableSslCertValidation() ? 79 : 97);
    result = result * PRIME + (this.isDisableSslHostVerification() ? 79 : 97);
    result = result * PRIME + this.getThreadPoolSize();
    final java.lang.Object $defaultSiteId = this.getDefaultSiteId();
    result = result * PRIME + ($defaultSiteId == null ? 43 : $defaultSiteId.hashCode());
    final java.lang.Object $apiEndpoint = this.getApiEndpoint();
    result = result * PRIME + ($apiEndpoint == null ? 43 : $apiEndpoint.hashCode());
    final java.lang.Object $defaultAuthToken = this.getDefaultAuthToken();
    result = result * PRIME + ($defaultAuthToken == null ? 43 : $defaultAuthToken.hashCode());
    final java.lang.Object $connectTimeout = this.getConnectTimeout();
    result = result * PRIME + ($connectTimeout == null ? 43 : $connectTimeout.hashCode());
    final java.lang.Object $socketTimeout = this.getSocketTimeout();
    result = result * PRIME + ($socketTimeout == null ? 43 : $socketTimeout.hashCode());
    final java.lang.Object $proxyHost = this.getProxyHost();
    result = result * PRIME + ($proxyHost == null ? 43 : $proxyHost.hashCode());
    final java.lang.Object $proxyUsername = this.getProxyUsername();
    result = result * PRIME + ($proxyUsername == null ? 43 : $proxyUsername.hashCode());
    final java.lang.Object $proxyPassword = this.getProxyPassword();
    result = result * PRIME + ($proxyPassword == null ? 43 : $proxyPassword.hashCode());
    final java.lang.Object $userAgent = this.getUserAgent();
    result = result * PRIME + ($userAgent == null ? 43 : $userAgent.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "TrackerConfiguration(apiEndpoint=" + this.getApiEndpoint() + ", defaultSiteId=" + this.getDefaultSiteId() + ", defaultAuthToken=" + this.getDefaultAuthToken() + ", enabled=" + this.isEnabled() + ", connectTimeout=" + this.getConnectTimeout() + ", socketTimeout=" + this.getSocketTimeout() + ", proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", proxyUsername=" + this.getProxyUsername() + ", proxyPassword=" + this.getProxyPassword() + ", userAgent=" + this.getUserAgent() + ", logFailedTracking=" + this.isLogFailedTracking() + ", disableSslCertValidation=" + this.isDisableSslCertValidation() + ", disableSslHostVerification=" + this.isDisableSslHostVerification() + ", threadPoolSize=" + this.getThreadPoolSize() + ")";
  }
}
